/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.PsiReferenceListImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JavaClassReferenceListElementType
extends JavaStubElementType<PsiClassReferenceListStub, PsiReferenceList> {
    public JavaClassReferenceListElementType(@NotNull String id, @NotNull IElementType parentElementType) {
        if (id == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(0);
        }
        if (parentElementType == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(1);
        }
        super(id, true, parentElementType);
    }

    @Override
    public PsiReferenceList createPsi(@NotNull PsiClassReferenceListStub stub2) {
        if (stub2 == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(2);
        }
        return this.getPsiFactory(stub2).createClassReferenceList(stub2);
    }

    @Override
    public PsiReferenceList createPsi(@NotNull ASTNode node) {
        if (node == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(3);
        }
        return new PsiReferenceListImpl(node);
    }

    @Override
    @NotNull
    public PsiClassReferenceListStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement<?> parentStub) {
        if (tree == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(4);
        }
        if (node == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(5);
        }
        if (parentStub == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(6);
        }
        JavaClassReferenceListElementType type2 = (JavaClassReferenceListElementType)node.getTokenType();
        return new PsiClassReferenceListStubImpl(type2, parentStub, JavaClassReferenceListElementType.getTexts(tree, node));
    }

    private static String @NotNull [] getTexts(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        if (tree == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(7);
        }
        if (node == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(8);
        }
        List<LighterASTNode> refs = LightTreeUtil.getChildrenOfType(tree, node, JavaElementType.JAVA_CODE_REFERENCE);
        String[] texts = ArrayUtil.newStringArray(refs.size());
        for (int i2 = 0; i2 < refs.size(); ++i2) {
            texts[i2] = LightTreeUtil.toFilteredString(tree, refs.get(i2), null);
        }
        if (texts == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(9);
        }
        return texts;
    }

    @Override
    public void serialize(@NotNull PsiClassReferenceListStub stub2, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub2 == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(10);
        }
        if (dataStream == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(11);
        }
        TypeInfo[] types2 = stub2.getTypes();
        dataStream.writeVarInt(types2.length);
        for (TypeInfo info : types2) {
            TypeInfo.writeTYPE(dataStream, info);
        }
    }

    @Override
    @NotNull
    public PsiClassReferenceListStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        int len;
        if (dataStream == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(12);
        }
        TypeInfo[] infos = (len = dataStream.readVarInt()) == 0 ? TypeInfo.EMPTY_ARRAY : new TypeInfo[len];
        for (int i2 = 0; i2 < infos.length; ++i2) {
            infos[i2] = TypeInfo.readTYPE(dataStream);
        }
        return new PsiClassReferenceListStubImpl(this, parentStub, infos);
    }

    @Override
    public void indexStub(@NotNull PsiClassReferenceListStub stub2, @NotNull IndexSink sink) {
        PsiReferenceList.Role role;
        if (stub2 == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(13);
        }
        if (sink == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(14);
        }
        if ((role = stub2.getRole()) == PsiReferenceList.Role.EXTENDS_LIST || role == PsiReferenceList.Role.IMPLEMENTS_LIST) {
            StubElement parentStub;
            String[] names;
            for (String name2 : names = stub2.getReferencedNames()) {
                String shortName2 = PsiNameHelper.getShortClassName(name2);
                if (StringUtil.isEmptyOrSpaces(shortName2)) continue;
                sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, shortName2);
            }
            if (role == PsiReferenceList.Role.EXTENDS_LIST && (parentStub = stub2.getParentStub()) instanceof PsiClassStub) {
                PsiClassStub psiClassStub = (PsiClassStub)parentStub;
                if (psiClassStub.isEnum()) {
                    sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, "Enum");
                }
                if (psiClassStub.isAnnotationType()) {
                    sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, "Annotation");
                }
            }
        }
    }

    @NotNull
    public static PsiReferenceList.Role elementTypeToRole(@NotNull IElementType type2) {
        if (type2 == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(15);
        }
        if (type2 == JavaStubElementTypes.EXTENDS_BOUND_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.EXTENDS_BOUNDS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(16);
            }
            return role;
        }
        if (type2 == JavaStubElementTypes.EXTENDS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.EXTENDS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(17);
            }
            return role;
        }
        if (type2 == JavaStubElementTypes.IMPLEMENTS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.IMPLEMENTS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(18);
            }
            return role;
        }
        if (type2 == JavaStubElementTypes.THROWS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.THROWS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(19);
            }
            return role;
        }
        if (type2 == JavaStubElementTypes.PROVIDES_WITH_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.PROVIDES_WITH_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(20);
            }
            return role;
        }
        if (type2 == JavaStubElementTypes.PERMITS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.PERMITS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(21);
            }
            return role;
        }
        throw new RuntimeException("Unknown element type: " + type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElementType";
                break;
            }
            case 2: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTexts";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "elementTypeToRole";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTexts";
                break;
            }
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "elementTypeToRole";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

