/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.LocalTimeCounter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class VFileContentChangeEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final long myOldModificationStamp;
    private final long myNewModificationStamp;
    private final long myOldTimestamp;
    private final long myNewTimestamp;
    private final long myOldLength;
    private final long myNewLength;
    private static final int UNDEFINED_TIMESTAMP_OR_LENGTH = -1;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public VFileContentChangeEvent(Object requestor, @NotNull VirtualFile file2, long oldModificationStamp, long newModificationStamp, boolean bl2) {
        if (file2 == null) {
            VFileContentChangeEvent.$$$reportNull$$$0(0);
        }
        this(requestor, file2, oldModificationStamp, newModificationStamp);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public VFileContentChangeEvent(Object requestor, @NotNull VirtualFile file2, long oldModificationStamp, long l2) {
        void newModificationStamp;
        if (file2 == null) {
            VFileContentChangeEvent.$$$reportNull$$$0(1);
        }
        this(requestor, file2, oldModificationStamp, (long)newModificationStamp, -1L, -1L, -1L, -1L);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public VFileContentChangeEvent(Object requestor, @NotNull VirtualFile file2, long oldModificationStamp, long newModificationStamp, long oldTimestamp, long l2, long l3, long l4) {
        void newLength;
        void oldLength;
        void newTimestamp;
        if (file2 == null) {
            VFileContentChangeEvent.$$$reportNull$$$0(2);
        }
        super(requestor);
        this.myFile = file2;
        this.myOldModificationStamp = oldModificationStamp;
        this.myNewModificationStamp = newModificationStamp == -1L ? LocalTimeCounter.currentTime() : newModificationStamp;
        this.myOldTimestamp = oldTimestamp;
        this.myNewTimestamp = newTimestamp;
        this.myOldLength = oldLength;
        this.myNewLength = newLength;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            VFileContentChangeEvent.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    public long getModificationStamp() {
        return this.myNewModificationStamp;
    }

    public long getOldModificationStamp() {
        return this.myOldModificationStamp;
    }

    public long getOldTimestamp() {
        return this.myOldTimestamp;
    }

    public long getNewTimestamp() {
        return this.myNewTimestamp;
    }

    public long getOldLength() {
        return this.myOldLength;
    }

    public long getNewLength() {
        return this.myNewLength;
    }

    public boolean isLengthAndTimestampDiffProvided() {
        return this.myOldTimestamp != -1L || this.myNewTimestamp != -1L || this.myOldLength != -1L || this.myNewLength != -1L;
    }

    public String toString() {
        return "VfsEvent[update: " + this.myFile.getPresentableUrl() + ", oldTimestamp:" + this.myOldTimestamp + ", newTimestamp:" + this.myNewTimestamp + ", oldModificationStamp:" + this.myOldModificationStamp + ", newModificationStamp:" + this.myNewModificationStamp + ", oldLength:" + this.myOldLength + ", newLength:" + this.myNewLength + "]";
    }

    @Override
    @NotNull
    protected String computePath() {
        String string2 = this.myFile.getPath();
        if (string2 == null) {
            VFileContentChangeEvent.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            VFileContentChangeEvent.$$$reportNull$$$0(5);
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid() && this.myFile.getModificationStamp() == this.myOldModificationStamp;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        VFileContentChangeEvent event = (VFileContentChangeEvent)o2;
        if (this.myNewModificationStamp != event.myNewModificationStamp) {
            return false;
        }
        if (this.myOldModificationStamp != event.myOldModificationStamp) {
            return false;
        }
        return this.myFile.equals(event.myFile);
    }

    @Override
    public int hashCode() {
        int result2 = this.myFile.hashCode();
        result2 = 31 * result2 + Long.hashCode(this.myOldModificationStamp);
        result2 = 31 * result2 + Long.hashCode(this.myNewModificationStamp);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

