/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.SmallCharMatcher;
import java.util.Arrays;
import java.util.BitSet;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public abstract class CharMatcher
implements Predicate<Character> {
    private static final int DISTINCT_CHARS = 65536;

    public static CharMatcher any() {
        return Any.INSTANCE;
    }

    public static CharMatcher none() {
        return None.INSTANCE;
    }

    public static CharMatcher whitespace() {
        return Whitespace.INSTANCE;
    }

    public static CharMatcher breakingWhitespace() {
        return BreakingWhitespace.INSTANCE;
    }

    public static CharMatcher ascii() {
        return Ascii.INSTANCE;
    }

    @Deprecated
    public static CharMatcher digit() {
        return Digit.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaDigit() {
        return JavaDigit.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaLetter() {
        return JavaLetter.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaLetterOrDigit() {
        return JavaLetterOrDigit.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaUpperCase() {
        return JavaUpperCase.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaLowerCase() {
        return JavaLowerCase.INSTANCE;
    }

    public static CharMatcher javaIsoControl() {
        return JavaIsoControl.INSTANCE;
    }

    @Deprecated
    public static CharMatcher invisible() {
        return Invisible.INSTANCE;
    }

    @Deprecated
    public static CharMatcher singleWidth() {
        return SingleWidth.INSTANCE;
    }

    public static CharMatcher is(char match) {
        return new Is(match);
    }

    public static CharMatcher isNot(char match) {
        return new IsNot(match);
    }

    public static CharMatcher anyOf(CharSequence sequence2) {
        switch (sequence2.length()) {
            case 0: {
                return CharMatcher.none();
            }
            case 1: {
                return CharMatcher.is(sequence2.charAt(0));
            }
            case 2: {
                return CharMatcher.isEither(sequence2.charAt(0), sequence2.charAt(1));
            }
        }
        return new AnyOf(sequence2);
    }

    public static CharMatcher noneOf(CharSequence sequence2) {
        return CharMatcher.anyOf(sequence2).negate();
    }

    public static CharMatcher inRange(char startInclusive, char endInclusive) {
        return new InRange(startInclusive, endInclusive);
    }

    public static CharMatcher forPredicate(Predicate<? super Character> predicate) {
        return predicate instanceof CharMatcher ? (CharMatcher)predicate : new ForPredicate(predicate);
    }

    protected CharMatcher() {
    }

    public abstract boolean matches(char var1);

    public CharMatcher negate() {
        return new Negated(this);
    }

    public CharMatcher and(CharMatcher other) {
        return new And(this, other);
    }

    public CharMatcher or(CharMatcher other) {
        return new Or(this, other);
    }

    public CharMatcher precomputed() {
        return Platform.precomputeCharMatcher(this);
    }

    @GwtIncompatible
    CharMatcher precomputedInternal() {
        BitSet table = new BitSet();
        this.setBits(table);
        int totalCharacters = table.cardinality();
        if (totalCharacters * 2 <= 65536) {
            return CharMatcher.precomputedPositive(totalCharacters, table, this.toString());
        }
        table.flip(0, 65536);
        int negatedCharacters = 65536 - totalCharacters;
        String suffix = ".negate()";
        final String description = this.toString();
        String negatedDescription = description.endsWith(suffix) ? description.substring(0, description.length() - suffix.length()) : description + suffix;
        return new NegatedFastMatcher(this, CharMatcher.precomputedPositive(negatedCharacters, table, negatedDescription)){

            @Override
            public String toString() {
                return description;
            }
        };
    }

    @GwtIncompatible
    private static CharMatcher precomputedPositive(int totalCharacters, BitSet table, String description) {
        switch (totalCharacters) {
            case 0: {
                return CharMatcher.none();
            }
            case 1: {
                return CharMatcher.is((char)table.nextSetBit(0));
            }
            case 2: {
                char c1 = (char)table.nextSetBit(0);
                char c2 = (char)table.nextSetBit(c1 + '\u0001');
                return CharMatcher.isEither(c1, c2);
            }
        }
        return CharMatcher.isSmall(totalCharacters, table.length()) ? SmallCharMatcher.from(table, description) : new BitSetMatcher(table, description);
    }

    @GwtIncompatible
    private static boolean isSmall(int totalCharacters, int tableLength) {
        return totalCharacters <= 1023 && tableLength > totalCharacters * 4 * 16;
    }

    @GwtIncompatible
    void setBits(BitSet table) {
        for (int c2 = 65535; c2 >= 0; --c2) {
            if (!this.matches((char)c2)) continue;
            table.set(c2);
        }
    }

    public boolean matchesAnyOf(CharSequence sequence2) {
        return !this.matchesNoneOf(sequence2);
    }

    public boolean matchesAllOf(CharSequence sequence2) {
        for (int i2 = sequence2.length() - 1; i2 >= 0; --i2) {
            if (this.matches(sequence2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesNoneOf(CharSequence sequence2) {
        return this.indexIn(sequence2) == -1;
    }

    public int indexIn(CharSequence sequence2) {
        return this.indexIn(sequence2, 0);
    }

    public int indexIn(CharSequence sequence2, int start) {
        int length = sequence2.length();
        Preconditions.checkPositionIndex(start, length);
        for (int i2 = start; i2 < length; ++i2) {
            if (!this.matches(sequence2.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexIn(CharSequence sequence2) {
        for (int i2 = sequence2.length() - 1; i2 >= 0; --i2) {
            if (!this.matches(sequence2.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int countIn(CharSequence sequence2) {
        int count = 0;
        for (int i2 = 0; i2 < sequence2.length(); ++i2) {
            if (!this.matches(sequence2.charAt(i2))) continue;
            ++count;
        }
        return count;
    }

    public String removeFrom(CharSequence sequence2) {
        String string2 = sequence2.toString();
        int pos = this.indexIn(string2);
        if (pos == -1) {
            return string2;
        }
        char[] chars = string2.toCharArray();
        int spread = 1;
        block0: while (true) {
            ++pos;
            while (pos != chars.length) {
                if (!this.matches(chars[pos])) {
                    chars[pos - spread] = chars[pos];
                    ++pos;
                    continue;
                }
                ++spread;
                continue block0;
            }
            break;
        }
        return new String(chars, 0, pos - spread);
    }

    public String retainFrom(CharSequence sequence2) {
        return this.negate().removeFrom(sequence2);
    }

    public String replaceFrom(CharSequence sequence2, char replacement) {
        String string2 = sequence2.toString();
        int pos = this.indexIn(string2);
        if (pos == -1) {
            return string2;
        }
        char[] chars = string2.toCharArray();
        chars[pos] = replacement;
        for (int i2 = pos + 1; i2 < chars.length; ++i2) {
            if (!this.matches(chars[i2])) continue;
            chars[i2] = replacement;
        }
        return new String(chars);
    }

    public String replaceFrom(CharSequence sequence2, CharSequence replacement) {
        int replacementLen = replacement.length();
        if (replacementLen == 0) {
            return this.removeFrom(sequence2);
        }
        if (replacementLen == 1) {
            return this.replaceFrom(sequence2, replacement.charAt(0));
        }
        String string2 = sequence2.toString();
        int pos = this.indexIn(string2);
        if (pos == -1) {
            return string2;
        }
        int len = string2.length();
        StringBuilder buf = new StringBuilder(len * 3 / 2 + 16);
        int oldpos = 0;
        do {
            buf.append(string2, oldpos, pos);
            buf.append(replacement);
        } while ((pos = this.indexIn(string2, oldpos = pos + 1)) != -1);
        buf.append(string2, oldpos, len);
        return buf.toString();
    }

    public String trimFrom(CharSequence sequence2) {
        int last;
        int first;
        int len = sequence2.length();
        for (first = 0; first < len && this.matches(sequence2.charAt(first)); ++first) {
        }
        for (last = len - 1; last > first && this.matches(sequence2.charAt(last)); --last) {
        }
        return sequence2.subSequence(first, last + 1).toString();
    }

    public String trimLeadingFrom(CharSequence sequence2) {
        int len = sequence2.length();
        for (int first = 0; first < len; ++first) {
            if (this.matches(sequence2.charAt(first))) continue;
            return sequence2.subSequence(first, len).toString();
        }
        return "";
    }

    public String trimTrailingFrom(CharSequence sequence2) {
        int len = sequence2.length();
        for (int last = len - 1; last >= 0; --last) {
            if (this.matches(sequence2.charAt(last))) continue;
            return sequence2.subSequence(0, last + 1).toString();
        }
        return "";
    }

    public String collapseFrom(CharSequence sequence2, char replacement) {
        int len = sequence2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = sequence2.charAt(i2);
            if (!this.matches(c2)) continue;
            if (!(c2 != replacement || i2 != len - 1 && this.matches(sequence2.charAt(i2 + 1)))) {
                ++i2;
                continue;
            }
            StringBuilder builder2 = new StringBuilder(len).append(sequence2, 0, i2).append(replacement);
            return this.finishCollapseFrom(sequence2, i2 + 1, len, replacement, builder2, true);
        }
        return sequence2.toString();
    }

    public String trimAndCollapseFrom(CharSequence sequence2, char replacement) {
        int first;
        int len = sequence2.length();
        int last = len - 1;
        for (first = 0; first < len && this.matches(sequence2.charAt(first)); ++first) {
        }
        while (last > first && this.matches(sequence2.charAt(last))) {
            --last;
        }
        return first == 0 && last == len - 1 ? this.collapseFrom(sequence2, replacement) : this.finishCollapseFrom(sequence2, first, last + 1, replacement, new StringBuilder(last + 1 - first), false);
    }

    private String finishCollapseFrom(CharSequence sequence2, int start, int end, char replacement, StringBuilder builder2, boolean inMatchingGroup) {
        for (int i2 = start; i2 < end; ++i2) {
            char c2 = sequence2.charAt(i2);
            if (this.matches(c2)) {
                if (inMatchingGroup) continue;
                builder2.append(replacement);
                inMatchingGroup = true;
                continue;
            }
            builder2.append(c2);
            inMatchingGroup = false;
        }
        return builder2.toString();
    }

    @Override
    @Deprecated
    public boolean apply(Character character) {
        return this.matches(character.charValue());
    }

    public String toString() {
        return super.toString();
    }

    private static String showCharacter(char c2) {
        String hex = "0123456789ABCDEF";
        char[] tmp = new char[]{'\\', 'u', '\u0000', '\u0000', '\u0000', '\u0000'};
        for (int i2 = 0; i2 < 4; ++i2) {
            tmp[5 - i2] = hex.charAt(c2 & 0xF);
            c2 = (char)(c2 >> 4);
        }
        return String.copyValueOf(tmp);
    }

    private static IsEither isEither(char c1, char c2) {
        return new IsEither(c1, c2);
    }

    private static final class ForPredicate
    extends CharMatcher {
        private final Predicate<? super Character> predicate;

        ForPredicate(Predicate<? super Character> predicate) {
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean matches(char c2) {
            return this.predicate.apply(Character.valueOf(c2));
        }

        @Override
        public boolean apply(Character character) {
            return this.predicate.apply(Preconditions.checkNotNull(character));
        }

        @Override
        public String toString() {
            return "CharMatcher.forPredicate(" + this.predicate + ")";
        }
    }

    private static final class InRange
    extends FastMatcher {
        private final char startInclusive;
        private final char endInclusive;

        InRange(char startInclusive, char endInclusive) {
            Preconditions.checkArgument(endInclusive >= startInclusive);
            this.startInclusive = startInclusive;
            this.endInclusive = endInclusive;
        }

        @Override
        public boolean matches(char c2) {
            return this.startInclusive <= c2 && c2 <= this.endInclusive;
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet table) {
            table.set((int)this.startInclusive, this.endInclusive + '\u0001');
        }

        @Override
        public String toString() {
            return "CharMatcher.inRange('" + CharMatcher.showCharacter(this.startInclusive) + "', '" + CharMatcher.showCharacter(this.endInclusive) + "')";
        }
    }

    private static final class AnyOf
    extends CharMatcher {
        private final char[] chars;

        public AnyOf(CharSequence chars) {
            this.chars = chars.toString().toCharArray();
            Arrays.sort(this.chars);
        }

        @Override
        public boolean matches(char c2) {
            return Arrays.binarySearch(this.chars, c2) >= 0;
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet table) {
            for (char c2 : this.chars) {
                table.set(c2);
            }
        }

        @Override
        public String toString() {
            StringBuilder description = new StringBuilder("CharMatcher.anyOf(\"");
            for (char c2 : this.chars) {
                description.append(CharMatcher.showCharacter(c2));
            }
            description.append("\")");
            return description.toString();
        }
    }

    private static final class IsEither
    extends FastMatcher {
        private final char match1;
        private final char match2;

        IsEither(char match1, char match2) {
            this.match1 = match1;
            this.match2 = match2;
        }

        @Override
        public boolean matches(char c2) {
            return c2 == this.match1 || c2 == this.match2;
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet table) {
            table.set(this.match1);
            table.set(this.match2);
        }

        @Override
        public String toString() {
            return "CharMatcher.anyOf(\"" + CharMatcher.showCharacter(this.match1) + CharMatcher.showCharacter(this.match2) + "\")";
        }
    }

    private static final class IsNot
    extends FastMatcher {
        private final char match;

        IsNot(char match) {
            this.match = match;
        }

        @Override
        public boolean matches(char c2) {
            return c2 != this.match;
        }

        @Override
        public CharMatcher and(CharMatcher other) {
            return other.matches(this.match) ? super.and(other) : other;
        }

        @Override
        public CharMatcher or(CharMatcher other) {
            return other.matches(this.match) ? IsNot.any() : this;
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet table) {
            table.set(0, this.match);
            table.set(this.match + '\u0001', 65536);
        }

        @Override
        public CharMatcher negate() {
            return IsNot.is(this.match);
        }

        @Override
        public String toString() {
            return "CharMatcher.isNot('" + CharMatcher.showCharacter(this.match) + "')";
        }
    }

    private static final class Is
    extends FastMatcher {
        private final char match;

        Is(char match) {
            this.match = match;
        }

        @Override
        public boolean matches(char c2) {
            return c2 == this.match;
        }

        @Override
        public String replaceFrom(CharSequence sequence2, char replacement) {
            return sequence2.toString().replace(this.match, replacement);
        }

        @Override
        public CharMatcher and(CharMatcher other) {
            return other.matches(this.match) ? this : Is.none();
        }

        @Override
        public CharMatcher or(CharMatcher other) {
            return other.matches(this.match) ? other : super.or(other);
        }

        @Override
        public CharMatcher negate() {
            return Is.isNot(this.match);
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet table) {
            table.set(this.match);
        }

        @Override
        public String toString() {
            return "CharMatcher.is('" + CharMatcher.showCharacter(this.match) + "')";
        }
    }

    private static final class Or
    extends CharMatcher {
        final CharMatcher first;
        final CharMatcher second;

        Or(CharMatcher a2, CharMatcher b2) {
            this.first = Preconditions.checkNotNull(a2);
            this.second = Preconditions.checkNotNull(b2);
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet table) {
            this.first.setBits(table);
            this.second.setBits(table);
        }

        @Override
        public boolean matches(char c2) {
            return this.first.matches(c2) || this.second.matches(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.or(" + this.first + ", " + this.second + ")";
        }
    }

    private static final class And
    extends CharMatcher {
        final CharMatcher first;
        final CharMatcher second;

        And(CharMatcher a2, CharMatcher b2) {
            this.first = Preconditions.checkNotNull(a2);
            this.second = Preconditions.checkNotNull(b2);
        }

        @Override
        public boolean matches(char c2) {
            return this.first.matches(c2) && this.second.matches(c2);
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet table) {
            BitSet tmp1 = new BitSet();
            this.first.setBits(tmp1);
            BitSet tmp2 = new BitSet();
            this.second.setBits(tmp2);
            tmp1.and(tmp2);
            table.or(tmp1);
        }

        @Override
        public String toString() {
            return "CharMatcher.and(" + this.first + ", " + this.second + ")";
        }
    }

    private static class Negated
    extends CharMatcher {
        final CharMatcher original;

        Negated(CharMatcher original) {
            this.original = Preconditions.checkNotNull(original);
        }

        @Override
        public boolean matches(char c2) {
            return !this.original.matches(c2);
        }

        @Override
        public boolean matchesAllOf(CharSequence sequence2) {
            return this.original.matchesNoneOf(sequence2);
        }

        @Override
        public boolean matchesNoneOf(CharSequence sequence2) {
            return this.original.matchesAllOf(sequence2);
        }

        @Override
        public int countIn(CharSequence sequence2) {
            return sequence2.length() - this.original.countIn(sequence2);
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet table) {
            BitSet tmp = new BitSet();
            this.original.setBits(tmp);
            tmp.flip(0, 65536);
            table.or(tmp);
        }

        @Override
        public CharMatcher negate() {
            return this.original;
        }

        @Override
        public String toString() {
            return this.original + ".negate()";
        }
    }

    private static final class SingleWidth
    extends RangesMatcher {
        static final CharMatcher INSTANCE = new SingleWidth();

        private SingleWidth() {
            super("CharMatcher.singleWidth()", "\u0000\u05be\u05d0\u05f3\u0600\u0750\u0e00\u1e00\u2100\ufb50\ufe70\uff61".toCharArray(), "\u04f9\u05be\u05ea\u05f4\u06ff\u077f\u0e7f\u20af\u213a\ufdff\ufeff\uffdc".toCharArray());
        }
    }

    private static final class Invisible
    extends RangesMatcher {
        private static final String RANGE_STARTS = "\u0000\u007f\u00ad\u0600\u061c\u06dd\u070f\u0890\u08e2\u1680\u180e\u2000\u2028\u205f\u2066\u3000\ud800\ufeff\ufff9";
        private static final String RANGE_ENDS = " \u00a0\u00ad\u0605\u061c\u06dd\u070f\u0891\u08e2\u1680\u180e\u200f\u202f\u2064\u206f\u3000\uf8ff\ufeff\ufffb";
        static final CharMatcher INSTANCE = new Invisible();

        private Invisible() {
            super("CharMatcher.invisible()", RANGE_STARTS.toCharArray(), RANGE_ENDS.toCharArray());
        }
    }

    private static final class JavaIsoControl
    extends NamedFastMatcher {
        static final CharMatcher INSTANCE = new JavaIsoControl();

        private JavaIsoControl() {
            super("CharMatcher.javaIsoControl()");
        }

        @Override
        public boolean matches(char c2) {
            return c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f';
        }
    }

    private static final class JavaLowerCase
    extends CharMatcher {
        static final CharMatcher INSTANCE = new JavaLowerCase();

        private JavaLowerCase() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isLowerCase(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaLowerCase()";
        }
    }

    private static final class JavaUpperCase
    extends CharMatcher {
        static final CharMatcher INSTANCE = new JavaUpperCase();

        private JavaUpperCase() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isUpperCase(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaUpperCase()";
        }
    }

    private static final class JavaLetterOrDigit
    extends CharMatcher {
        static final CharMatcher INSTANCE = new JavaLetterOrDigit();

        private JavaLetterOrDigit() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isLetterOrDigit(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaLetterOrDigit()";
        }
    }

    private static final class JavaLetter
    extends CharMatcher {
        static final CharMatcher INSTANCE = new JavaLetter();

        private JavaLetter() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isLetter(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaLetter()";
        }
    }

    private static final class JavaDigit
    extends CharMatcher {
        static final CharMatcher INSTANCE = new JavaDigit();

        private JavaDigit() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isDigit(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaDigit()";
        }
    }

    private static final class Digit
    extends RangesMatcher {
        private static final String ZEROES = "0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0de6\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1a80\u1a90\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\ua9d0\ua9f0\uaa50\uabf0\uff10";
        static final CharMatcher INSTANCE = new Digit();

        private static char[] zeroes() {
            return ZEROES.toCharArray();
        }

        private static char[] nines() {
            char[] nines = new char[ZEROES.length()];
            for (int i2 = 0; i2 < ZEROES.length(); ++i2) {
                nines[i2] = (char)(ZEROES.charAt(i2) + 9);
            }
            return nines;
        }

        private Digit() {
            super("CharMatcher.digit()", Digit.zeroes(), Digit.nines());
        }
    }

    private static class RangesMatcher
    extends CharMatcher {
        private final String description;
        private final char[] rangeStarts;
        private final char[] rangeEnds;

        RangesMatcher(String description, char[] rangeStarts, char[] rangeEnds) {
            this.description = description;
            this.rangeStarts = rangeStarts;
            this.rangeEnds = rangeEnds;
            Preconditions.checkArgument(rangeStarts.length == rangeEnds.length);
            for (int i2 = 0; i2 < rangeStarts.length; ++i2) {
                Preconditions.checkArgument(rangeStarts[i2] <= rangeEnds[i2]);
                if (i2 + 1 >= rangeStarts.length) continue;
                Preconditions.checkArgument(rangeEnds[i2] < rangeStarts[i2 + 1]);
            }
        }

        @Override
        public boolean matches(char c2) {
            int index2 = Arrays.binarySearch(this.rangeStarts, c2);
            if (index2 >= 0) {
                return true;
            }
            return (index2 = ~index2 - 1) >= 0 && c2 <= this.rangeEnds[index2];
        }

        @Override
        public String toString() {
            return this.description;
        }
    }

    private static final class Ascii
    extends NamedFastMatcher {
        static final CharMatcher INSTANCE = new Ascii();

        Ascii() {
            super("CharMatcher.ascii()");
        }

        @Override
        public boolean matches(char c2) {
            return c2 <= '\u007f';
        }
    }

    private static final class BreakingWhitespace
    extends CharMatcher {
        static final CharMatcher INSTANCE = new BreakingWhitespace();

        private BreakingWhitespace() {
        }

        @Override
        public boolean matches(char c2) {
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\u0085': 
                case '\u1680': 
                case '\u2028': 
                case '\u2029': 
                case '\u205f': 
                case '\u3000': {
                    return true;
                }
                case '\u2007': {
                    return false;
                }
            }
            return c2 >= '\u2000' && c2 <= '\u200a';
        }

        @Override
        public String toString() {
            return "CharMatcher.breakingWhitespace()";
        }
    }

    @VisibleForTesting
    static final class Whitespace
    extends NamedFastMatcher {
        static final String TABLE = "\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000";
        static final int MULTIPLIER = 1682554634;
        static final int SHIFT = Integer.numberOfLeadingZeros("\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".length() - 1);
        static final CharMatcher INSTANCE = new Whitespace();

        Whitespace() {
            super("CharMatcher.whitespace()");
        }

        @Override
        public boolean matches(char c2) {
            return TABLE.charAt(1682554634 * c2 >>> SHIFT) == c2;
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet table) {
            for (int i2 = 0; i2 < TABLE.length(); ++i2) {
                table.set(TABLE.charAt(i2));
            }
        }
    }

    private static final class None
    extends NamedFastMatcher {
        static final CharMatcher INSTANCE = new None();

        private None() {
            super("CharMatcher.none()");
        }

        @Override
        public boolean matches(char c2) {
            return false;
        }

        @Override
        public int indexIn(CharSequence sequence2) {
            Preconditions.checkNotNull(sequence2);
            return -1;
        }

        @Override
        public int indexIn(CharSequence sequence2, int start) {
            int length = sequence2.length();
            Preconditions.checkPositionIndex(start, length);
            return -1;
        }

        @Override
        public int lastIndexIn(CharSequence sequence2) {
            Preconditions.checkNotNull(sequence2);
            return -1;
        }

        @Override
        public boolean matchesAllOf(CharSequence sequence2) {
            return sequence2.length() == 0;
        }

        @Override
        public boolean matchesNoneOf(CharSequence sequence2) {
            Preconditions.checkNotNull(sequence2);
            return true;
        }

        @Override
        public String removeFrom(CharSequence sequence2) {
            return sequence2.toString();
        }

        @Override
        public String replaceFrom(CharSequence sequence2, char replacement) {
            return sequence2.toString();
        }

        @Override
        public String replaceFrom(CharSequence sequence2, CharSequence replacement) {
            Preconditions.checkNotNull(replacement);
            return sequence2.toString();
        }

        @Override
        public String collapseFrom(CharSequence sequence2, char replacement) {
            return sequence2.toString();
        }

        @Override
        public String trimFrom(CharSequence sequence2) {
            return sequence2.toString();
        }

        @Override
        public String trimLeadingFrom(CharSequence sequence2) {
            return sequence2.toString();
        }

        @Override
        public String trimTrailingFrom(CharSequence sequence2) {
            return sequence2.toString();
        }

        @Override
        public int countIn(CharSequence sequence2) {
            Preconditions.checkNotNull(sequence2);
            return 0;
        }

        @Override
        public CharMatcher and(CharMatcher other) {
            Preconditions.checkNotNull(other);
            return this;
        }

        @Override
        public CharMatcher or(CharMatcher other) {
            return Preconditions.checkNotNull(other);
        }

        @Override
        public CharMatcher negate() {
            return None.any();
        }
    }

    private static final class Any
    extends NamedFastMatcher {
        static final CharMatcher INSTANCE = new Any();

        private Any() {
            super("CharMatcher.any()");
        }

        @Override
        public boolean matches(char c2) {
            return true;
        }

        @Override
        public int indexIn(CharSequence sequence2) {
            return sequence2.length() == 0 ? -1 : 0;
        }

        @Override
        public int indexIn(CharSequence sequence2, int start) {
            int length = sequence2.length();
            Preconditions.checkPositionIndex(start, length);
            return start == length ? -1 : start;
        }

        @Override
        public int lastIndexIn(CharSequence sequence2) {
            return sequence2.length() - 1;
        }

        @Override
        public boolean matchesAllOf(CharSequence sequence2) {
            Preconditions.checkNotNull(sequence2);
            return true;
        }

        @Override
        public boolean matchesNoneOf(CharSequence sequence2) {
            return sequence2.length() == 0;
        }

        @Override
        public String removeFrom(CharSequence sequence2) {
            Preconditions.checkNotNull(sequence2);
            return "";
        }

        @Override
        public String replaceFrom(CharSequence sequence2, char replacement) {
            char[] array = new char[sequence2.length()];
            Arrays.fill(array, replacement);
            return new String(array);
        }

        @Override
        public String replaceFrom(CharSequence sequence2, CharSequence replacement) {
            StringBuilder result2 = new StringBuilder(sequence2.length() * replacement.length());
            for (int i2 = 0; i2 < sequence2.length(); ++i2) {
                result2.append(replacement);
            }
            return result2.toString();
        }

        @Override
        public String collapseFrom(CharSequence sequence2, char replacement) {
            return sequence2.length() == 0 ? "" : String.valueOf(replacement);
        }

        @Override
        public String trimFrom(CharSequence sequence2) {
            Preconditions.checkNotNull(sequence2);
            return "";
        }

        @Override
        public int countIn(CharSequence sequence2) {
            return sequence2.length();
        }

        @Override
        public CharMatcher and(CharMatcher other) {
            return Preconditions.checkNotNull(other);
        }

        @Override
        public CharMatcher or(CharMatcher other) {
            Preconditions.checkNotNull(other);
            return this;
        }

        @Override
        public CharMatcher negate() {
            return Any.none();
        }
    }

    @GwtIncompatible
    private static final class BitSetMatcher
    extends NamedFastMatcher {
        private final BitSet table;

        private BitSetMatcher(BitSet table, String description) {
            super(description);
            if (table.length() + 64 < table.size()) {
                table = (BitSet)table.clone();
            }
            this.table = table;
        }

        @Override
        public boolean matches(char c2) {
            return this.table.get(c2);
        }

        @Override
        void setBits(BitSet bitSet) {
            bitSet.or(this.table);
        }
    }

    private static class NegatedFastMatcher
    extends Negated {
        NegatedFastMatcher(CharMatcher original) {
            super(original);
        }

        @Override
        public final CharMatcher precomputed() {
            return this;
        }
    }

    static abstract class NamedFastMatcher
    extends FastMatcher {
        private final String description;

        NamedFastMatcher(String description) {
            this.description = Preconditions.checkNotNull(description);
        }

        @Override
        public final String toString() {
            return this.description;
        }
    }

    static abstract class FastMatcher
    extends CharMatcher {
        FastMatcher() {
        }

        @Override
        public final CharMatcher precomputed() {
            return this;
        }

        @Override
        public CharMatcher negate() {
            return new NegatedFastMatcher(this);
        }
    }
}

