/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.commons;

import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.commons.AnnotationRemapper;
import org.jetbrains.org.objectweb.asm.commons.Remapper;

public class MethodRemapper
extends MethodVisitor {
    protected final Remapper remapper;

    public MethodRemapper(MethodVisitor methodVisitor, Remapper remapper2) {
        this(589824, methodVisitor, remapper2);
    }

    protected MethodRemapper(int api, MethodVisitor methodVisitor, Remapper remapper2) {
        super(api, methodVisitor);
        this.remapper = remapper2;
    }

    public AnnotationVisitor visitAnnotationDefault() {
        AnnotationVisitor annotationVisitor = super.visitAnnotationDefault();
        return annotationVisitor == null ? annotationVisitor : this.createAnnotationRemapper(annotationVisitor);
    }

    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitAnnotation(this.remapper.mapDesc(descriptor2), visible);
        return annotationVisitor == null ? annotationVisitor : this.createAnnotationRemapper(annotationVisitor);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeRef, typePath, this.remapper.mapDesc(descriptor2), visible);
        return annotationVisitor == null ? annotationVisitor : this.createAnnotationRemapper(annotationVisitor);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter2, String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitParameterAnnotation(parameter2, this.remapper.mapDesc(descriptor2), visible);
        return annotationVisitor == null ? annotationVisitor : this.createAnnotationRemapper(annotationVisitor);
    }

    public void visitFrame(int type2, int numLocal, Object[] local, int numStack, Object[] stack) {
        super.visitFrame(type2, numLocal, this.remapFrameTypes(numLocal, local), numStack, this.remapFrameTypes(numStack, stack));
    }

    private Object[] remapFrameTypes(int numTypes, Object[] frameTypes) {
        if (frameTypes == null) {
            return frameTypes;
        }
        Object[] remappedFrameTypes = null;
        for (int i = 0; i < numTypes; ++i) {
            if (!(frameTypes[i] instanceof String)) continue;
            if (remappedFrameTypes == null) {
                remappedFrameTypes = new Object[numTypes];
                System.arraycopy(frameTypes, 0, remappedFrameTypes, 0, numTypes);
            }
            remappedFrameTypes[i] = this.remapper.mapType((String)frameTypes[i]);
        }
        return remappedFrameTypes == null ? frameTypes : remappedFrameTypes;
    }

    public void visitFieldInsn(int opcode, String owner, String name2, String descriptor2) {
        super.visitFieldInsn(opcode, this.remapper.mapType(owner), this.remapper.mapFieldName(owner, name2, descriptor2), this.remapper.mapDesc(descriptor2));
    }

    public void visitMethodInsn(int opcodeAndSource, String owner, String name2, String descriptor2, boolean isInterface) {
        if (this.api < 327680 && (opcodeAndSource & 0x100) == 0) {
            super.visitMethodInsn(opcodeAndSource, owner, name2, descriptor2, isInterface);
            return;
        }
        super.visitMethodInsn(opcodeAndSource, this.remapper.mapType(owner), this.remapper.mapMethodName(owner, name2, descriptor2), this.remapper.mapMethodDesc(descriptor2), isInterface);
    }

    public void visitInvokeDynamicInsn(String name2, String descriptor2, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        Object[] remappedBootstrapMethodArguments = new Object[bootstrapMethodArguments.length];
        for (int i = 0; i < bootstrapMethodArguments.length; ++i) {
            remappedBootstrapMethodArguments[i] = this.remapper.mapValue(bootstrapMethodArguments[i]);
        }
        super.visitInvokeDynamicInsn(this.remapper.mapInvokeDynamicMethodName(name2, descriptor2), this.remapper.mapMethodDesc(descriptor2), (Handle)this.remapper.mapValue(bootstrapMethodHandle), remappedBootstrapMethodArguments);
    }

    public void visitTypeInsn(int opcode, String type2) {
        super.visitTypeInsn(opcode, this.remapper.mapType(type2));
    }

    public void visitLdcInsn(Object value2) {
        super.visitLdcInsn(this.remapper.mapValue(value2));
    }

    public void visitMultiANewArrayInsn(String descriptor2, int numDimensions) {
        super.visitMultiANewArrayInsn(this.remapper.mapDesc(descriptor2), numDimensions);
    }

    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitInsnAnnotation(typeRef, typePath, this.remapper.mapDesc(descriptor2), visible);
        return annotationVisitor == null ? annotationVisitor : this.createAnnotationRemapper(annotationVisitor);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler2, String type2) {
        super.visitTryCatchBlock(start, end, handler2, type2 == null ? null : this.remapper.mapType(type2));
    }

    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitTryCatchAnnotation(typeRef, typePath, this.remapper.mapDesc(descriptor2), visible);
        return annotationVisitor == null ? annotationVisitor : this.createAnnotationRemapper(annotationVisitor);
    }

    public void visitLocalVariable(String name2, String descriptor2, String signature, Label start, Label end, int index2) {
        super.visitLocalVariable(name2, this.remapper.mapDesc(descriptor2), this.remapper.mapSignature(signature, true), start, end, index2);
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index2, String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitLocalVariableAnnotation(typeRef, typePath, start, end, index2, this.remapper.mapDesc(descriptor2), visible);
        return annotationVisitor == null ? annotationVisitor : this.createAnnotationRemapper(annotationVisitor);
    }

    protected AnnotationVisitor createAnnotationRemapper(AnnotationVisitor annotationVisitor) {
        return new AnnotationRemapper(this.api, annotationVisitor, this.remapper);
    }
}

