/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

public class DelegationFieldsInfo {
    private final Type classAsmType;
    private final ClassDescriptor classDescriptor;
    private final GenerationState state;
    private final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final Map<KtDelegatedSuperTypeEntry, Field> fields;

    public DelegationFieldsInfo(@NotNull Type type2, @NotNull ClassDescriptor descriptor2, @NotNull GenerationState state, @NotNull BindingContext context2) {
        if (type2 == null) {
            DelegationFieldsInfo.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            DelegationFieldsInfo.$$$reportNull$$$0(1);
        }
        if (state == null) {
            DelegationFieldsInfo.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            DelegationFieldsInfo.$$$reportNull$$$0(3);
        }
        this.fields = new HashMap<KtDelegatedSuperTypeEntry, Field>();
        this.classAsmType = type2;
        this.classDescriptor = descriptor2;
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.bindingContext = context2;
    }

    @Nullable
    public Field getInfo(KtDelegatedSuperTypeEntry specifier) {
        Field field = this.fields.get(specifier);
        assert (field != null || this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) : "No field for " + specifier.getText();
        return field;
    }

    private void addField(KtDelegatedSuperTypeEntry specifier, PropertyDescriptor propertyDescriptor) {
        this.fields.put(specifier, new Field(this.typeMapper.mapType(propertyDescriptor), propertyDescriptor.getName().asString(), false));
    }

    private void addField(KtDelegatedSuperTypeEntry specifier, Type type2, String name2, String genericSignature) {
        this.fields.put(specifier, new Field(type2, name2, true, genericSignature));
    }

    @NotNull
    public DelegationFieldsInfo getDelegationFieldsInfo(@NotNull List<KtSuperTypeListEntry> delegationSpecifiers) {
        if (delegationSpecifiers == null) {
            DelegationFieldsInfo.$$$reportNull$$$0(4);
        }
        DelegationFieldsInfo result2 = new DelegationFieldsInfo(this.classAsmType, this.classDescriptor, this.state, this.bindingContext);
        int n = 0;
        for (KtSuperTypeListEntry specifier : delegationSpecifiers) {
            KtExpression expression2;
            if (!(specifier instanceof KtDelegatedSuperTypeEntry) || (expression2 = ((KtDelegatedSuperTypeEntry)specifier).getDelegateExpression()) == null) continue;
            PropertyDescriptor propertyDescriptor = CodegenUtil.getDelegatePropertyIfAny(expression2, this.classDescriptor, this.bindingContext);
            if (CodegenUtil.isFinalPropertyWithBackingField(propertyDescriptor, this.bindingContext)) {
                result2.addField((KtDelegatedSuperTypeEntry)specifier, propertyDescriptor);
            } else {
                Type asmType;
                KotlinType expressionType = this.bindingContext.getType(expression2);
                ClassDescriptor superClass = JvmCodegenUtil.getSuperClass(specifier, this.state, this.bindingContext);
                BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.TYPE);
                Type type2 = expressionType != null ? this.typeMapper.mapType(expressionType, sw) : (asmType = superClass != null ? this.typeMapper.mapType(superClass.getDefaultType(), sw) : null);
                if (asmType == null) continue;
                String genericSignature = sw.makeJavaGenericSignature();
                result2.addField((KtDelegatedSuperTypeEntry)specifier, asmType, "$$delegate_" + n, genericSignature);
            }
            ++n;
        }
        DelegationFieldsInfo delegationFieldsInfo = result2;
        if (delegationFieldsInfo == null) {
            DelegationFieldsInfo.$$$reportNull$$$0(5);
        }
        return delegationFieldsInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegationSpecifiers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/DelegationFieldsInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/DelegationFieldsInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegationFieldsInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDelegationFieldsInfo";
                break;
            }
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public class Field {
        public final Type type;
        public final String name;
        public final boolean generateField;
        public final String genericSignature;

        private Field(Type type2, String name2, boolean generateField2, String genericSignature) {
            this.type = type2;
            this.name = name2;
            this.generateField = generateField2;
            this.genericSignature = genericSignature;
        }

        private Field(Type type2, String name2, boolean generateField2) {
            this(type2, name2, generateField2, (String)null);
        }

        @NotNull
        public StackValue getStackValue() {
            StackValue.Field field = StackValue.field(this.type, DelegationFieldsInfo.this.classAsmType, this.name, false, StackValue.none());
            if (field == null) {
                Field.$$$reportNull$$$0(0);
            }
            return field;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/DelegationFieldsInfo$Field", "getStackValue"));
        }
    }
}

