/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.JavaLikeCounterLoopBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.LoopReplacement;
import org.jetbrains.kotlin.backend.common.lower.loops.NumericForLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.NumericHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.UnsignedProgressionType;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrDoWhileLoopImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ<\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00140\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionLoopHeader;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/NumericForLoopHeader;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionHeaderInfo;", "headerInfo", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionHeaderInfo;Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "preferJavaLikeCounterLoop", "", "javaLikeCounterLoopBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/loops/JavaLikeCounterLoopBuilder;", "loopInitStatements", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "getLoopInitStatements", "()Ljava/util/List;", "loopVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "initializeIteration", "loopVariableComponents", "", "", "backendContext", "buildLoop", "Lorg/jetbrains/kotlin/backend/common/lower/loops/LoopReplacement;", "oldLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "newBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ir.backend.common"})
public final class ProgressionLoopHeader
extends NumericForLoopHeader<ProgressionHeaderInfo> {
    private final boolean preferJavaLikeCounterLoop;
    @NotNull
    private final JavaLikeCounterLoopBuilder javaLikeCounterLoopBuilder;
    @NotNull
    private final List<IrStatement> loopInitStatements;
    @Nullable
    private IrVariable loopVariable;

    public ProgressionLoopHeader(@NotNull ProgressionHeaderInfo headerInfo, @NotNull DeclarationIrBuilder builder2, @NotNull CommonBackendContext context2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)headerInfo, (String)"headerInfo");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((NumericHeaderInfo)headerInfo, builder2, context2);
        this.preferJavaLikeCounterLoop = context2.getPreferJavaLikeCounterLoop();
        this.javaLikeCounterLoopBuilder = new JavaLikeCounterLoopBuilder(context2);
        Collection collection = headerInfo.getAdditionalStatements();
        if (headerInfo.isReversed()) {
            Object[] objectArray = new IrVariable[]{this.getLastVariableIfCanCacheLast(), this.getInductionVariable()};
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else {
            Object[] objectArray = new IrVariable[]{this.getInductionVariable(), this.getLastVariableIfCanCacheLast()};
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        }
        this.loopInitStatements = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)list), (Iterable)CollectionsKt.listOfNotNull((Object)this.getStepVariable()));
    }

    @Override
    @NotNull
    public List<IrStatement> getLoopInitStatements() {
        return this.loopInitStatements;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IrStatement> initializeIteration(@Nullable IrVariable loopVariable, @NotNull Map<Integer, ? extends IrVariable> loopVariableComponents, @NotNull DeclarationIrBuilder builder2, @NotNull CommonBackendContext backendContext) {
        IrVariable irVariable;
        Intrinsics.checkNotNullParameter(loopVariableComponents, (String)"loopVariableComponents");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        DeclarationIrBuilder $this$initializeIteration_u24lambda_u242 = builder2;
        boolean bl = false;
        ProgressionLoopHeader progressionLoopHeader = this;
        if (((ProgressionHeaderInfo)this.getHeaderInfo()).getCanOverflow() && loopVariable == null) {
            irVariable = IrBuilderKt.createTmpVariable$default($this$initializeIteration_u24lambda_u242.getScope(), (IrExpression)ExpressionHelpersKt.irGet($this$initializeIteration_u24lambda_u242, this.getInductionVariable()), "loopVariable", true, null, null, 24, null);
        } else {
            IrVariable irVariable2 = loopVariable;
            if (irVariable2 != null) {
                void it;
                IrGetValueImpl irGetValueImpl = ExpressionHelpersKt.irGet($this$initializeIteration_u24lambda_u242, this.getInductionVariable());
                IrVariable irVariable3 = irVariable2;
                ProgressionLoopHeader progressionLoopHeader2 = progressionLoopHeader;
                boolean bl2 = false;
                ProgressionType $this$initializeIteration_u24lambda_u242_u24lambda_u241_u24lambda_u240 = ((ProgressionHeaderInfo)this.getHeaderInfo()).getProgressionType();
                boolean bl3 = false;
                IrExpression irExpression = $this$initializeIteration_u24lambda_u242_u24lambda_u241_u24lambda_u240 instanceof UnsignedProgressionType ? ((UnsignedProgressionType)$this$initializeIteration_u24lambda_u242_u24lambda_u241_u24lambda_u240).asUnsigned((IrExpression)it) : (IrExpression)it;
                progressionLoopHeader = progressionLoopHeader2;
                irVariable3.setInitializer(irExpression);
            }
            irVariable = loopVariable;
        }
        progressionLoopHeader.loopVariable = irVariable;
        Object[] objectArray = new IrStatement[]{this.loopVariable, this.incrementInductionVariable($this$initializeIteration_u24lambda_u242)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @Override
    @NotNull
    public LoopReplacement buildLoop(@NotNull DeclarationIrBuilder builder2, @NotNull IrLoop oldLoop, @Nullable IrExpression newBody) {
        LoopReplacement loopReplacement;
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)oldLoop, (String)"oldLoop");
        DeclarationIrBuilder $this$buildLoop_u24lambda_u246 = builder2;
        boolean bl = false;
        if (((ProgressionHeaderInfo)this.getHeaderInfo()).getCanOverflow() || this.preferJavaLikeCounterLoop && ((ProgressionHeaderInfo)this.getHeaderInfo()).getProgressionType() instanceof UnsignedProgressionType && ((ProgressionHeaderInfo)this.getHeaderInfo()).isLastInclusive()) {
            IrExpression irExpression;
            IrDoWhileLoopImpl irDoWhileLoopImpl;
            IrStatementOrigin newLoopOrigin = this.preferJavaLikeCounterLoop ? this.getContext().getDoWhileCounterLoopOrigin() : oldLoop.getOrigin();
            IrDoWhileLoopImpl $this$buildLoop_u24lambda_u246_u24lambda_u244 = irDoWhileLoopImpl = BuildersKt.IrDoWhileLoopImpl(oldLoop.getStartOffset(), oldLoop.getEndOffset(), oldLoop.getType(), newLoopOrigin);
            boolean bl2 = false;
            ProgressionType $this$buildLoop_u24lambda_u246_u24lambda_u244_u24lambda_u243 = ((ProgressionHeaderInfo)this.getHeaderInfo()).getProgressionType();
            boolean bl3 = false;
            if ($this$buildLoop_u24lambda_u246_u24lambda_u244_u24lambda_u243 instanceof UnsignedProgressionType) {
                UnsignedProgressionType unsignedProgressionType = (UnsignedProgressionType)$this$buildLoop_u24lambda_u246_u24lambda_u244_u24lambda_u243;
                IrBuilderWithScope irBuilderWithScope = $this$buildLoop_u24lambda_u246;
                IrBuilderWithScope irBuilderWithScope2 = $this$buildLoop_u24lambda_u246;
                IrVariable irVariable = this.loopVariable;
                Intrinsics.checkNotNull((Object)irVariable);
                irExpression = unsignedProgressionType.asSigned(IrUtilsKt.irCastIfNeeded(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irVariable), ((UnsignedProgressionType)$this$buildLoop_u24lambda_u246_u24lambda_u244_u24lambda_u243).getUnsignedType()));
            } else {
                IrBuilderWithScope irBuilderWithScope = $this$buildLoop_u24lambda_u246;
                IrBuilderWithScope irBuilderWithScope3 = $this$buildLoop_u24lambda_u246;
                IrVariable irVariable = this.loopVariable;
                Intrinsics.checkNotNull((Object)irVariable);
                irExpression = IrUtilsKt.irCastIfNeeded(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope3, irVariable), IrUtilsKt.getDefaultType($this$buildLoop_u24lambda_u246_u24lambda_u244_u24lambda_u243.getElementClass()));
            }
            IrExpression loopVariableExpression = irExpression;
            $this$buildLoop_u24lambda_u246_u24lambda_u244.setLabel(oldLoop.getLabel());
            $this$buildLoop_u24lambda_u246_u24lambda_u244.setCondition(ExpressionHelpersKt.irNotEquals($this$buildLoop_u24lambda_u246, loopVariableExpression, this.getLastExpression()));
            $this$buildLoop_u24lambda_u246_u24lambda_u244.setBody(newBody);
            IrDoWhileLoopImpl newLoop = irDoWhileLoopImpl;
            if (this.preferJavaLikeCounterLoop) {
                this.javaLikeCounterLoopBuilder.moveInductionVariableUpdateToLoopCondition(newLoop);
            }
            IrExpression loopCondition = this.buildLoopCondition($this$buildLoop_u24lambda_u246);
            loopReplacement = new LoopReplacement(newLoop, LowerUtilsKt.irIfThen($this$buildLoop_u24lambda_u246, loopCondition, newLoop));
        } else if (this.preferJavaLikeCounterLoop && !((ProgressionHeaderInfo)this.getHeaderInfo()).isLastInclusive()) {
            IrExpression newLoopCondition = this.buildLoopCondition($this$buildLoop_u24lambda_u246);
            loopReplacement = this.javaLikeCounterLoopBuilder.buildJavaLikeDoWhileCounterLoop(oldLoop, newLoopCondition, newBody, this.getContext().getDoWhileCounterLoopOrigin());
        } else {
            IrDoWhileLoopImpl newLoop;
            IrDoWhileLoopImpl $this$buildLoop_u24lambda_u246_u24lambda_u245 = newLoop = BuildersKt.IrDoWhileLoopImpl(oldLoop.getStartOffset(), oldLoop.getEndOffset(), oldLoop.getType(), oldLoop.getOrigin());
            boolean bl4 = false;
            $this$buildLoop_u24lambda_u246_u24lambda_u245.setLabel(oldLoop.getLabel());
            $this$buildLoop_u24lambda_u246_u24lambda_u245.setCondition(this.buildLoopCondition($this$buildLoop_u24lambda_u246));
            $this$buildLoop_u24lambda_u246_u24lambda_u245.setBody(newBody);
            IrDoWhileLoopImpl newLoop2 = newLoop;
            IrExpression loopCondition = this.buildLoopCondition($this$buildLoop_u24lambda_u246);
            loopReplacement = new LoopReplacement(newLoop2, LowerUtilsKt.irIfThen($this$buildLoop_u24lambda_u246, loopCondition, newLoop2));
        }
        return loopReplacement;
    }
}

