/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.CollapseSpliterator;
import one.util.streamex.ConstSpliterator;
import one.util.streamex.Internals;
import one.util.streamex.PairPermutationSpliterator;
import one.util.streamex.PrependSpliterator;
import one.util.streamex.RangeBasedSpliterator;
import one.util.streamex.StreamContext;
import one.util.streamex.StreamEx;
import one.util.streamex.TreeSpliterator;
import one.util.streamex.UnknownSizeSpliterator;

public class EntryStream<K, V>
extends AbstractStreamEx<Map.Entry<K, V>, EntryStream<K, V>> {
    EntryStream(Stream<? extends Map.Entry<K, V>> stream, StreamContext context2) {
        super(stream, context2);
    }

    EntryStream(Spliterator<? extends Map.Entry<K, V>> spliterator, StreamContext context2) {
        super(spliterator, context2);
    }

    @Override
    EntryStream<K, V> supply(Stream<Map.Entry<K, V>> stream) {
        return new EntryStream<K, V>(stream, this.context);
    }

    @Override
    EntryStream<K, V> supply(Spliterator<Map.Entry<K, V>> spliterator) {
        return new EntryStream<K, V>(spliterator, this.context);
    }

    static <K, V> Consumer<? super Map.Entry<K, V>> toConsumer(BiConsumer<? super K, ? super V> action) {
        return entry -> action.accept((Object)entry.getKey(), (Object)entry.getValue());
    }

    static <K, V, M extends Map<K, V>> Consumer<? super Map.Entry<K, V>> toMapConsumer(M map) {
        return entry -> EntryStream.addToMap(map, entry.getKey(), Objects.requireNonNull(entry.getValue()));
    }

    BiPredicate<? super Map.Entry<K, V>, ? super Map.Entry<K, V>> equalKeys() {
        return (e1, e2) -> Objects.equals(e1.getKey(), e2.getKey());
    }

    static <K, V> Stream<Map.Entry<K, V>> withValue(Stream<? extends K> s2, V value2) {
        return s2 == null ? null : s2.map((? super T key) -> new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value2));
    }

    static <K, V> Stream<Map.Entry<K, V>> withKey(K key, Stream<? extends V> s2) {
        return s2 == null ? null : s2.map((? super T value2) -> new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value2));
    }

    static <K, V, R> Function<? super Map.Entry<K, V>, ? extends R> toFunction(BiFunction<? super K, ? super V, ? extends R> mapper) {
        return entry -> mapper.apply((Object)entry.getKey(), (Object)entry.getValue());
    }

    public StreamEx<String> join(CharSequence delimiter) {
        return this.map((T entry) -> String.valueOf(entry.getKey()) + delimiter + entry.getValue());
    }

    public StreamEx<String> join(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.map((T entry) -> String.valueOf(prefix) + entry.getKey() + delimiter + entry.getValue() + suffix);
    }

    public <KK> EntryStream<KK, V> flatMapKeys(Function<? super K, ? extends Stream<? extends KK>> mapper) {
        return new EntryStream<K, V>(((Stream)this.stream()).flatMap((? super T e) -> EntryStream.withValue((Stream)mapper.apply((Object)e.getKey()), e.getValue())), this.context);
    }

    public <KK> EntryStream<KK, V> flatMapToKey(BiFunction<? super K, ? super V, ? extends Stream<? extends KK>> mapper) {
        return new EntryStream<K, V>(((Stream)this.stream()).flatMap((? super T e) -> EntryStream.withValue((Stream)mapper.apply((Object)e.getKey(), (Object)e.getValue()), e.getValue())), this.context);
    }

    public <VV> EntryStream<K, VV> flatMapValues(Function<? super V, ? extends Stream<? extends VV>> mapper) {
        return new EntryStream<K, V>(((Stream)this.stream()).flatMap((? super T e) -> EntryStream.withKey(e.getKey(), (Stream)mapper.apply((Object)e.getValue()))), this.context);
    }

    public <VV> EntryStream<K, VV> flatMapToValue(BiFunction<? super K, ? super V, ? extends Stream<? extends VV>> mapper) {
        return new EntryStream<K, V>(((Stream)this.stream()).flatMap((? super T e) -> EntryStream.withKey(e.getKey(), (Stream)mapper.apply((Object)e.getKey(), (Object)e.getValue()))), this.context);
    }

    public <R> StreamEx<R> flatMapKeyValue(BiFunction<? super K, ? super V, ? extends Stream<? extends R>> mapper) {
        return this.flatMap(EntryStream.toFunction(mapper));
    }

    public EntryStream<K, V> append(Map<K, V> map) {
        return (EntryStream)this.appendSpliterator(null, map.entrySet().spliterator());
    }

    public EntryStream<K, V> append(K key, V value2) {
        return (EntryStream)this.appendSpliterator(null, new ConstSpliterator.OfRef<AbstractMap.SimpleImmutableEntry<K, V>>(new AbstractMap.SimpleImmutableEntry<K, V>(key, value2), 1L, true));
    }

    public EntryStream<K, V> append(K k1, V v1, K k2, V v2) {
        Object[] array = new AbstractMap.SimpleImmutableEntry[]{new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2)};
        return (EntryStream)this.appendSpliterator(null, Spliterators.spliterator(array, 16));
    }

    public EntryStream<K, V> append(K k1, V v1, K k2, V v2, K k3, V v3) {
        Object[] array = new AbstractMap.SimpleImmutableEntry[]{new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3)};
        return (EntryStream)this.appendSpliterator(null, Spliterators.spliterator(array, 16));
    }

    public EntryStream<K, V> prepend(Map<K, V> map) {
        return (EntryStream)this.prependSpliterator(null, map.entrySet().spliterator());
    }

    public EntryStream<K, V> prepend(K key, V value2) {
        return this.supply((Spliterator)new PrependSpliterator<AbstractMap.SimpleImmutableEntry<K, V>>(this.spliterator(), new AbstractMap.SimpleImmutableEntry<K, V>(key, value2)));
    }

    public EntryStream<K, V> prepend(K k1, V v1, K k2, V v2) {
        Object[] array = new AbstractMap.SimpleImmutableEntry[]{new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2)};
        return (EntryStream)this.prependSpliterator(null, Spliterators.spliterator(array, 16));
    }

    public EntryStream<K, V> prepend(K k1, V v1, K k2, V v2, K k3, V v3) {
        Object[] array = new AbstractMap.SimpleImmutableEntry[]{new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3)};
        return (EntryStream)this.prependSpliterator(null, Spliterators.spliterator(array, 16));
    }

    public EntryStream<K, V> distinctKeys() {
        return (EntryStream)this.distinct(Map.Entry::getKey);
    }

    public EntryStream<K, V> distinctValues() {
        return (EntryStream)this.distinct(Map.Entry::getValue);
    }

    public <KK> EntryStream<KK, V> mapKeys(Function<? super K, ? extends KK> keyMapper) {
        return new EntryStream<K, V>(((Stream)this.stream()).map((? super T e) -> new AbstractMap.SimpleImmutableEntry(keyMapper.apply((Object)e.getKey()), e.getValue())), this.context);
    }

    public <VV> EntryStream<K, VV> mapValues(Function<? super V, ? extends VV> valueMapper) {
        return new EntryStream<K, V>(((Stream)this.stream()).map((? super T e) -> new AbstractMap.SimpleImmutableEntry(e.getKey(), valueMapper.apply((Object)e.getValue()))), this.context);
    }

    public <R> StreamEx<R> mapKeyValue(BiFunction<? super K, ? super V, ? extends R> mapper) {
        return this.map(EntryStream.toFunction(mapper));
    }

    public <R> StreamEx<R> mapKeyValuePartial(BiFunction<? super K, ? super V, ? extends Optional<? extends R>> mapper) {
        return this.mapPartial(EntryStream.toFunction(mapper));
    }

    public <KK> EntryStream<KK, V> mapToKey(BiFunction<? super K, ? super V, ? extends KK> keyMapper) {
        return new EntryStream<K, V>(((Stream)this.stream()).map((? super T e) -> new AbstractMap.SimpleImmutableEntry(keyMapper.apply((Object)e.getKey(), (Object)e.getValue()), e.getValue())), this.context);
    }

    public <KK> EntryStream<KK, V> mapToKeyPartial(BiFunction<? super K, ? super V, ? extends Optional<? extends KK>> keyMapper) {
        return new EntryStream<K, V>(((Stream)this.stream()).map((? super T e) -> {
            Object mapping = ((Optional)keyMapper.apply((Object)e.getKey(), (Object)e.getValue())).orElse(null);
            return mapping != null ? new AbstractMap.SimpleImmutableEntry(mapping, e.getValue()) : null;
        }).filter(Objects::nonNull), this.context);
    }

    public <VV> EntryStream<K, VV> mapToValue(BiFunction<? super K, ? super V, ? extends VV> valueMapper) {
        return new EntryStream<K, V>(((Stream)this.stream()).map((? super T e) -> new AbstractMap.SimpleImmutableEntry(e.getKey(), valueMapper.apply((Object)e.getKey(), (Object)e.getValue()))), this.context);
    }

    public <VV> EntryStream<K, VV> mapToValuePartial(BiFunction<? super K, ? super V, ? extends Optional<? extends VV>> valueMapper) {
        return new EntryStream<K, V>(((Stream)this.stream()).map((? super T e) -> {
            Object mapping = ((Optional)valueMapper.apply((Object)e.getKey(), (Object)e.getValue())).orElse(null);
            return mapping != null ? new AbstractMap.SimpleImmutableEntry(e.getKey(), mapping) : null;
        }).filter(Objects::nonNull), this.context);
    }

    public EntryStream<V, K> invert() {
        return new EntryStream<K, V>(((Stream)this.stream()).map((? super T e) -> new AbstractMap.SimpleImmutableEntry(e.getValue(), e.getKey())), this.context);
    }

    public EntryStream<K, V> filterKeys(Predicate<? super K> keyPredicate) {
        return (EntryStream)this.filter((T e) -> keyPredicate.test((Object)e.getKey()));
    }

    public EntryStream<K, V> filterValues(Predicate<? super V> valuePredicate) {
        return (EntryStream)this.filter((T e) -> valuePredicate.test((Object)e.getValue()));
    }

    public EntryStream<K, V> filterKeyValue(BiPredicate<? super K, ? super V> predicate) {
        return (EntryStream)this.filter((T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    public boolean anyMatch(BiPredicate<? super K, ? super V> predicate) {
        return this.anyMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    public boolean allMatch(BiPredicate<? super K, ? super V> predicate) {
        return this.allMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    public boolean noneMatch(BiPredicate<? super K, ? super V> predicate) {
        return this.noneMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    public EntryStream<K, V> removeKeys(Predicate<? super K> keyPredicate) {
        return this.filterKeys(keyPredicate.negate());
    }

    public EntryStream<K, V> removeValues(Predicate<? super V> valuePredicate) {
        return this.filterValues(valuePredicate.negate());
    }

    public EntryStream<K, V> removeKeyValue(BiPredicate<? super K, ? super V> predicate) {
        return this.filterKeyValue(predicate.negate());
    }

    public EntryStream<K, V> nonNullKeys() {
        return (EntryStream)this.filter((T e) -> e.getKey() != null);
    }

    public EntryStream<K, V> nonNullValues() {
        return (EntryStream)this.filter((T e) -> e.getValue() != null);
    }

    public <KK> EntryStream<KK, V> selectKeys(Class<KK> clazz) {
        return (EntryStream)this.filter((T e) -> clazz.isInstance(e.getKey()));
    }

    public <VV> EntryStream<K, VV> selectValues(Class<VV> clazz) {
        return (EntryStream)this.filter((T e) -> clazz.isInstance(e.getValue()));
    }

    public EntryStream<K, V> peekKeys(Consumer<? super K> keyAction) {
        return (EntryStream)this.peek((T e) -> keyAction.accept((Object)e.getKey()));
    }

    public EntryStream<K, V> peekValues(Consumer<? super V> valueAction) {
        return (EntryStream)this.peek((T e) -> valueAction.accept((Object)e.getValue()));
    }

    public EntryStream<K, V> peekKeyValue(BiConsumer<? super K, ? super V> action) {
        return (EntryStream)this.peek(EntryStream.toConsumer(action));
    }

    public StreamEx<K> keys() {
        return this.map(Map.Entry::getKey);
    }

    public StreamEx<V> values() {
        return this.map(Map.Entry::getValue);
    }

    public EntryStream<K, List<V>> collapseKeys() {
        return new StreamEx<Internals.PairBox>((Spliterator<Internals.PairBox>)new CollapseSpliterator<Map.Entry, Internals.PairBox>(this.equalKeys(), e -> new Internals.PairBox(e.getKey(), Collections.singletonList(e.getValue())), (pb, e) -> {
            if (!(pb.b instanceof ArrayList)) {
                Object old = ((List)pb.b).get(0);
                pb.b = new ArrayList();
                ((List)pb.b).add(old);
            }
            ((List)pb.b).add(e.getValue());
            return pb;
        }, (pb1, pb2) -> {
            if (!(pb1.b instanceof ArrayList)) {
                Object old = ((List)pb1.b).get(0);
                pb1.b = new ArrayList();
                ((List)pb1.b).add(old);
            }
            ((List)pb1.b).addAll((Collection)pb2.b);
            return pb1;
        }, this.spliterator()), this.context).mapToEntry(pb -> pb.a, pb -> (List)pb.b);
    }

    public EntryStream<K, V> collapseKeys(BinaryOperator<V> merger) {
        BinaryOperator entryMerger = (e1, e2) -> new AbstractMap.SimpleImmutableEntry(e1.getKey(), merger.apply(e1.getValue(), e2.getValue()));
        return new EntryStream<K, V>(new CollapseSpliterator(this.equalKeys(), Function.identity(), entryMerger, entryMerger, this.spliterator()), this.context);
    }

    public <A, R> EntryStream<K, R> collapseKeys(Collector<? super V, A, R> collector2) {
        Supplier supplier = collector2.supplier();
        BiConsumer accumulator = collector2.accumulator();
        BinaryOperator combiner = collector2.combiner();
        Function finisher = collector2.finisher();
        return new StreamEx<Internals.PairBox>((Spliterator<Internals.PairBox>)new CollapseSpliterator<Map.Entry, Internals.PairBox>(this.equalKeys(), e -> {
            Object a = supplier.get();
            accumulator.accept((Object)a, (Object)e.getValue());
            return new Internals.PairBox(e.getKey(), a);
        }, (pb, e) -> {
            accumulator.accept((Object)pb.b, (Object)e.getValue());
            return pb;
        }, (pb1, pb2) -> {
            pb1.b = combiner.apply(pb1.b, pb2.b);
            return pb1;
        }, this.spliterator()), this.context).mapToEntry(pb -> pb.a, pb -> finisher.apply(pb.b));
    }

    public EntryStream<K, V> prefixKeys(BinaryOperator<K> op) {
        return (EntryStream)this.prefix((a, b) -> new AbstractMap.SimpleImmutableEntry(op.apply(a.getKey(), b.getKey()), b.getValue()));
    }

    public EntryStream<K, V> prefixValues(BinaryOperator<V> op) {
        return (EntryStream)this.prefix((a, b) -> new AbstractMap.SimpleImmutableEntry(b.getKey(), op.apply(a.getValue(), b.getValue())));
    }

    public Map<K, V> toMap() {
        AbstractMap map = this.isParallel() ? new ConcurrentHashMap() : new HashMap();
        this.forEach(EntryStream.toMapConsumer(map));
        return map;
    }

    public Map<K, V> toImmutableMap() {
        Map<K, V> map = this.toMap();
        return map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
    }

    public <R> R toMapAndThen(Function<? super Map<K, V>, R> finisher) {
        if (this.context.fjp != null) {
            return (R)this.context.terminate(() -> finisher.apply(this.toMap()));
        }
        return finisher.apply(this.toMap());
    }

    public Map<K, V> toMap(BinaryOperator<V> mergeFunction) {
        Function<Map.Entry, Object> keyMapper = Map.Entry::getKey;
        Function<Map.Entry, Object> valueMapper = Map.Entry::getValue;
        return this.collect(Collectors.toMap(keyMapper, valueMapper, mergeFunction, HashMap::new));
    }

    public <M extends Map<K, V>> M toCustomMap(Supplier<M> mapSupplier) {
        Map map = (Map)mapSupplier.get();
        if (this.isParallel() && !(map instanceof ConcurrentMap)) {
            return (M)this.collect(mapSupplier, (m4, t2) -> EntryStream.addToMap(m4, t2.getKey(), Objects.requireNonNull(t2.getValue())), (m1, m22) -> m22.forEach((? super K k, ? super V v) -> EntryStream.addToMap(m1, k, v)));
        }
        this.forEach(EntryStream.toMapConsumer(map));
        return (M)map;
    }

    public <M extends Map<K, V>> M toCustomMap(BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        Function<Map.Entry, Object> keyMapper = Map.Entry::getKey;
        Function<Map.Entry, Object> valueMapper = Map.Entry::getValue;
        return (M)((Map)this.collect(Collectors.toMap(keyMapper, valueMapper, mergeFunction, mapSupplier)));
    }

    public SortedMap<K, V> toSortedMap() {
        return this.toNavigableMap();
    }

    public SortedMap<K, V> toSortedMap(BinaryOperator<V> mergeFunction) {
        return this.toNavigableMap(mergeFunction);
    }

    public NavigableMap<K, V> toNavigableMap() {
        AbstractMap map = this.isParallel() ? new ConcurrentSkipListMap() : new TreeMap();
        this.forEach(EntryStream.toMapConsumer(map));
        return map;
    }

    public NavigableMap<K, V> toNavigableMap(BinaryOperator<V> mergeFunction) {
        return this.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction, TreeMap::new));
    }

    public <M extends Map<K, V>> M into(M map) {
        Consumer<Map.Entry<K, V>> cons = EntryStream.toMapConsumer(map);
        if (this.isParallel()) {
            if (map instanceof ConcurrentMap) {
                this.forEach(cons);
            } else {
                this.toMap().entrySet().forEach(cons);
            }
        } else {
            this.spliterator().forEachRemaining(cons);
        }
        return map;
    }

    public Map<K, List<V>> grouping() {
        return this.grouping(Collectors.toList());
    }

    public <M extends Map<K, List<V>>> M grouping(Supplier<M> mapSupplier) {
        return this.grouping(mapSupplier, Collectors.toList());
    }

    public <A, D> Map<K, D> grouping(Collector<? super V, A, D> downstream) {
        Function<Map.Entry, Object> keyMapper = Map.Entry::getKey;
        Collector<Map.Entry, ?, D> mapping = Collectors.mapping(Map.Entry::getValue, downstream);
        if (this.isParallel() && downstream.characteristics().contains((Object)Collector.Characteristics.UNORDERED)) {
            return this.collect(Collectors.groupingByConcurrent(keyMapper, mapping));
        }
        return this.collect(Collectors.groupingBy(keyMapper, mapping));
    }

    public <A, D, M extends Map<K, D>> M grouping(Supplier<M> mapSupplier, Collector<? super V, A, D> downstream) {
        Function<Map.Entry, Object> keyMapper = Map.Entry::getKey;
        Collector<Map.Entry, ?, D> mapping = Collectors.mapping(Map.Entry::getValue, downstream);
        if (this.isParallel() && downstream.characteristics().contains((Object)Collector.Characteristics.UNORDERED) && mapSupplier.get() instanceof ConcurrentMap) {
            return (M)((Map)this.collect(Collectors.groupingByConcurrent(keyMapper, mapSupplier, mapping)));
        }
        return (M)((Map)this.collect(Collectors.groupingBy(keyMapper, mapSupplier, mapping)));
    }

    public <C extends Collection<V>> Map<K, C> groupingTo(Supplier<C> collectionFactory) {
        return this.grouping(Collectors.toCollection(collectionFactory));
    }

    public <C extends Collection<V>, M extends Map<K, C>> M groupingTo(Supplier<M> mapSupplier, Supplier<C> collectionFactory) {
        return this.grouping(mapSupplier, Collectors.toCollection(collectionFactory));
    }

    public void forKeyValue(BiConsumer<? super K, ? super V> action) {
        this.forEach(EntryStream.toConsumer(action));
    }

    public static <K, V> EntryStream<K, V> empty() {
        return EntryStream.of(Stream.empty());
    }

    public static <K, V> EntryStream<K, V> of(Stream<? extends Map.Entry<K, V>> stream) {
        if (stream instanceof AbstractStreamEx) {
            AbstractStreamEx ase = (AbstractStreamEx)stream;
            if (ase.spliterator != null) {
                return new EntryStream<K, V>(ase.spliterator(), ase.context);
            }
            return new EntryStream<K, V>((Stream)ase.stream(), ase.context);
        }
        return new EntryStream<K, V>(stream, StreamContext.of(stream));
    }

    public static <K, V> EntryStream<K, V> of(Spliterator<? extends Map.Entry<K, V>> spliterator) {
        return EntryStream.of(StreamSupport.stream(spliterator, false));
    }

    public static <K, V> EntryStream<K, V> of(Iterator<? extends Map.Entry<K, V>> iterator2) {
        return EntryStream.of(new UnknownSizeSpliterator.USOfRef<Map.Entry<K, V>>(iterator2));
    }

    public static <K, V> EntryStream<K, V> of(Map<K, V> map) {
        return EntryStream.of(map.entrySet().stream());
    }

    public static <V> EntryStream<Integer, V> of(List<V> list) {
        return EntryStream.of(new RangeBasedSpliterator.AsEntry<V>(list));
    }

    public static <V> EntryStream<Integer, V> of(V[] array) {
        return EntryStream.of(Arrays.asList(array));
    }

    public static <K, V> EntryStream<K, V> of(K key, V value2) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(key, value2)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3), new AbstractMap.SimpleImmutableEntry<K, V>(k4, v4)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3), new AbstractMap.SimpleImmutableEntry<K, V>(k4, v4), new AbstractMap.SimpleImmutableEntry<K, V>(k5, v5)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3), new AbstractMap.SimpleImmutableEntry<K, V>(k4, v4), new AbstractMap.SimpleImmutableEntry<K, V>(k5, v5), new AbstractMap.SimpleImmutableEntry<K, V>(k6, v6)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3), new AbstractMap.SimpleImmutableEntry<K, V>(k4, v4), new AbstractMap.SimpleImmutableEntry<K, V>(k5, v5), new AbstractMap.SimpleImmutableEntry<K, V>(k6, v6), new AbstractMap.SimpleImmutableEntry<K, V>(k7, v7)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3), new AbstractMap.SimpleImmutableEntry<K, V>(k4, v4), new AbstractMap.SimpleImmutableEntry<K, V>(k5, v5), new AbstractMap.SimpleImmutableEntry<K, V>(k6, v6), new AbstractMap.SimpleImmutableEntry<K, V>(k7, v7), new AbstractMap.SimpleImmutableEntry<K, V>(k8, v8)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3), new AbstractMap.SimpleImmutableEntry<K, V>(k4, v4), new AbstractMap.SimpleImmutableEntry<K, V>(k5, v5), new AbstractMap.SimpleImmutableEntry<K, V>(k6, v6), new AbstractMap.SimpleImmutableEntry<K, V>(k7, v7), new AbstractMap.SimpleImmutableEntry<K, V>(k8, v8), new AbstractMap.SimpleImmutableEntry<K, V>(k9, v9)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3), new AbstractMap.SimpleImmutableEntry<K, V>(k4, v4), new AbstractMap.SimpleImmutableEntry<K, V>(k5, v5), new AbstractMap.SimpleImmutableEntry<K, V>(k6, v6), new AbstractMap.SimpleImmutableEntry<K, V>(k7, v7), new AbstractMap.SimpleImmutableEntry<K, V>(k8, v8), new AbstractMap.SimpleImmutableEntry<K, V>(k9, v9), new AbstractMap.SimpleImmutableEntry<K, V>(k10, v10)));
    }

    public static <K, V> EntryStream<K, V> zip(List<K> keys, List<V> values2) {
        return EntryStream.of(new RangeBasedSpliterator.ZipRef<Object, Object, AbstractMap.SimpleImmutableEntry>(0, Internals.checkLength(keys.size(), values2.size()), AbstractMap.SimpleImmutableEntry::new, keys, values2));
    }

    public static <K, V> EntryStream<K, V> zip(K[] keys, V[] values2) {
        return EntryStream.zip(Arrays.asList(keys), Arrays.asList(values2));
    }

    public static <T> EntryStream<T, T> ofPairs(List<T> list) {
        return EntryStream.of(new PairPermutationSpliterator<Object, AbstractMap.SimpleImmutableEntry>(list, AbstractMap.SimpleImmutableEntry::new));
    }

    public static <T> EntryStream<T, T> ofPairs(T[] array) {
        return EntryStream.ofPairs(Arrays.asList(array));
    }

    public static <T> EntryStream<Integer, T> ofTree(T root, BiFunction<Integer, T, Stream<T>> mapper) {
        TreeSpliterator.Depth<T> spliterator = new TreeSpliterator.Depth<T>(root, mapper, 0);
        return new EntryStream(spliterator, StreamContext.SEQUENTIAL.onClose(spliterator));
    }

    public static <T, TT extends T> EntryStream<Integer, T> ofTree(T root, Class<TT> collectionClass, BiFunction<Integer, TT, Stream<T>> mapper) {
        return EntryStream.ofTree(root, (d, t2) -> collectionClass.isInstance(t2) ? (Stream)mapper.apply((Integer)d, (Object)t2) : null);
    }

    public static <K, V> EntryStream<K, V> generate(Supplier<? extends K> keySupplier, Supplier<? extends V> valueSupplier) {
        return new EntryStream<K, V>(Stream.generate(() -> new AbstractMap.SimpleImmutableEntry(keySupplier.get(), valueSupplier.get())), StreamContext.SEQUENTIAL);
    }
}

