/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableList;

import java.util.Arrays;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.PersistentCollection;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.implementations.immutableList.AbstractPersistentList;
import kotlinx.collections.immutable.implementations.immutableList.ObjectRef;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVectorIterator;
import kotlinx.collections.immutable.implementations.immutableList.SmallPersistentVector;
import kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import kotlinx.collections.immutable.internal.CommonFunctionsKt;
import kotlinx.collections.immutable.internal.ListImplementation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010*\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B5\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0012\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0016J\u0016\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0002\u0010\u0019JG\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ5\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010 \u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010!J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#2\u0006\u0010\u0012\u001a\u00020\tH\u0016J?\u0010$\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010&J3\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010(\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010)JC\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010-J?\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0010\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\t2\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010/J\"\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020302H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0012\u001a\u00020\tH\u0016J=\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010&J;\u00106\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010(\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u00107J\b\u0010(\u001a\u00020\tH\u0002J#\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J?\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\b\u0010:\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010;R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006<"}, d2={"Lkotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "E", "Lkotlinx/collections/immutable/PersistentList;", "Lkotlinx/collections/immutable/implementations/immutableList/AbstractPersistentList;", "root", "", "", "tail", "size", "", "rootShift", "([Ljava/lang/Object;[Ljava/lang/Object;II)V", "[Ljava/lang/Object;", "getSize", "()I", "add", "element", "(Ljava/lang/Object;)Lkotlinx/collections/immutable/PersistentList;", "index", "(ILjava/lang/Object;)Lkotlinx/collections/immutable/PersistentList;", "bufferFor", "(I)[Ljava/lang/Object;", "builder", "Lkotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;", "get", "(I)Ljava/lang/Object;", "insertIntoRoot", "shift", "elementCarry", "Lkotlinx/collections/immutable/implementations/immutableList/ObjectRef;", "([Ljava/lang/Object;IILjava/lang/Object;Lkotlinx/collections/immutable/implementations/immutableList/ObjectRef;)[Ljava/lang/Object;", "insertIntoTail", "tailIndex", "([Ljava/lang/Object;ILjava/lang/Object;)Lkotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "listIterator", "", "pullLastBuffer", "tailCarry", "([Ljava/lang/Object;IILkotlinx/collections/immutable/implementations/immutableList/ObjectRef;)[Ljava/lang/Object;", "pullLastBufferFromRoot", "rootSize", "([Ljava/lang/Object;II)Lkotlinx/collections/immutable/PersistentList;", "pushFilledTail", "filledTail", "newTail", "([Ljava/lang/Object;[Ljava/lang/Object;[Ljava/lang/Object;)Lkotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "pushTail", "([Ljava/lang/Object;I[Ljava/lang/Object;)[Ljava/lang/Object;", "removeAll", "predicate", "Lkotlin/Function1;", "", "removeAt", "removeFromRootAt", "removeFromTailAt", "([Ljava/lang/Object;III)Lkotlinx/collections/immutable/PersistentList;", "set", "setInRoot", "e", "([Ljava/lang/Object;IILjava/lang/Object;)[Ljava/lang/Object;", "kotlinx-collections-immutable"})
public final class PersistentVector<E>
extends AbstractPersistentList<E>
implements PersistentList<E> {
    private final Object[] root;
    private final Object[] tail;
    private final int size;
    private final int rootShift;

    private final int rootSize() {
        return UtilsKt.rootSize(this.size());
    }

    @Override
    @NotNull
    public PersistentList<E> add(E element2) {
        int tailSize = this.size() - this.rootSize();
        if (tailSize < 32) {
            Object[] objectArray = this.tail;
            int n = 32;
            boolean bl = false;
            Object[] objectArray2 = Arrays.copyOf(objectArray, n);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            Object[] newTail = objectArray2;
            newTail[tailSize] = element2;
            return new PersistentVector<E>(this.root, newTail, this.size() + 1, this.rootShift);
        }
        Object[] newTail = UtilsKt.presizedBufferWith(element2);
        return this.pushFilledTail(this.root, this.tail, newTail);
    }

    private final PersistentVector<E> pushFilledTail(Object[] root, Object[] filledTail, Object[] newTail) {
        if (this.size() >> 5 > 1 << this.rootShift) {
            Object[] newRoot = UtilsKt.presizedBufferWith(root);
            int newRootShift = this.rootShift + 5;
            newRoot = this.pushTail(newRoot, newRootShift, filledTail);
            return new PersistentVector<E>(newRoot, newTail, this.size() + 1, newRootShift);
        }
        Object[] newRoot = this.pushTail(root, this.rootShift, filledTail);
        return new PersistentVector<E>(newRoot, newTail, this.size() + 1, this.rootShift);
    }

    private final Object[] pushTail(Object[] root, int shift, Object[] tail) {
        Object[] objectArray;
        int bufferIndex;
        block3: {
            block2: {
                bufferIndex = UtilsKt.indexSegment(this.size() - 1, shift);
                objectArray = root;
                if (root == null) break block2;
                Object[] objectArray2 = objectArray;
                int n = 32;
                boolean bl = false;
                Object[] objectArray3 = Arrays.copyOf(objectArray2, n);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"java.util.Arrays.copyOf(this, newSize)");
                objectArray = objectArray3;
                if (objectArray3 != null) break block3;
            }
            objectArray = new Object[32];
        }
        Object[] newRootNode = objectArray;
        newRootNode[bufferIndex] = shift == 5 ? tail : this.pushTail((Object[])newRootNode[bufferIndex], shift - 5, tail);
        return newRootNode;
    }

    @Override
    @NotNull
    public PersistentList<E> add(int index2, E element2) {
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index2, this.size());
        if (index2 == this.size()) {
            return this.add((Object)element2);
        }
        int rootSize = this.rootSize();
        if (index2 >= rootSize) {
            return this.insertIntoTail(this.root, index2 - rootSize, element2);
        }
        ObjectRef elementCarry = new ObjectRef(null);
        Object[] newRoot = this.insertIntoRoot(this.root, this.rootShift, index2, element2, elementCarry);
        return this.insertIntoTail(newRoot, 0, elementCarry.getValue());
    }

    private final PersistentVector<E> insertIntoTail(Object[] root, int tailIndex, Object element2) {
        int tailSize = this.size() - this.rootSize();
        Object[] objectArray = this.tail;
        int n = 32;
        boolean bl = false;
        Object[] objectArray2 = Arrays.copyOf(objectArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        Object[] newTail = objectArray2;
        if (tailSize < 32) {
            ArraysKt.copyInto((Object[])this.tail, (Object[])newTail, (int)(tailIndex + 1), (int)tailIndex, (int)tailSize);
            newTail[tailIndex] = element2;
            return new PersistentVector<E>(root, newTail, this.size() + 1, this.rootShift);
        }
        Object lastElement = this.tail[31];
        ArraysKt.copyInto((Object[])this.tail, (Object[])newTail, (int)(tailIndex + 1), (int)tailIndex, (int)(tailSize - 1));
        newTail[tailIndex] = element2;
        return this.pushFilledTail(root, newTail, UtilsKt.presizedBufferWith(lastElement));
    }

    /*
     * WARNING - void declaration
     */
    private final Object[] insertIntoRoot(Object[] root, int shift, int index2, Object element2, ObjectRef elementCarry) {
        void i;
        int bufferIndex = UtilsKt.indexSegment(index2, shift);
        if (shift == 0) {
            Object[] objectArray;
            if (bufferIndex == 0) {
                objectArray = new Object[32];
            } else {
                Object[] objectArray2 = root;
                int n = 32;
                boolean bl = false;
                Object[] objectArray3 = Arrays.copyOf(objectArray2, n);
                objectArray = objectArray3;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"java.util.Arrays.copyOf(this, newSize)");
            }
            Object[] newRoot = objectArray;
            ArraysKt.copyInto((Object[])root, (Object[])newRoot, (int)(bufferIndex + 1), (int)bufferIndex, (int)31);
            elementCarry.setValue(root[31]);
            newRoot[bufferIndex] = element2;
            return newRoot;
        }
        Object[] objectArray = root;
        int n = 32;
        int n2 = 0;
        Object[] objectArray4 = Arrays.copyOf(objectArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray4, (String)"java.util.Arrays.copyOf(this, newSize)");
        Object[] newRoot = objectArray4;
        int lowerLevelShift = shift - 5;
        Object object = root[bufferIndex];
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        }
        newRoot[bufferIndex] = this.insertIntoRoot((Object[])object, lowerLevelShift, index2, element2, elementCarry);
        n = bufferIndex + 1;
        n2 = 32;
        while (n < n2 && newRoot[i] != null) {
            Object object2 = root[i];
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            }
            newRoot[i] = this.insertIntoRoot((Object[])object2, lowerLevelShift, 0, elementCarry.getValue(), elementCarry);
            ++i;
        }
        return newRoot;
    }

    @Override
    @NotNull
    public PersistentList<E> removeAt(int index2) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index2, this.size());
        int rootSize = this.rootSize();
        if (index2 >= rootSize) {
            return this.removeFromTailAt(this.root, rootSize, this.rootShift, index2 - rootSize);
        }
        Object[] newRoot = this.removeFromRootAt(this.root, this.rootShift, index2, new ObjectRef(this.tail[0]));
        return this.removeFromTailAt(newRoot, rootSize, this.rootShift, 0);
    }

    private final PersistentList<E> removeFromTailAt(Object[] root, int rootSize, int shift, int index2) {
        int tailSize = this.size() - rootSize;
        CommonFunctionsKt.assert(index2 < tailSize);
        if (tailSize == 1) {
            return this.pullLastBufferFromRoot(root, rootSize, shift);
        }
        Object[] objectArray = this.tail;
        int n = 32;
        boolean bl = false;
        Object[] objectArray2 = Arrays.copyOf(objectArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        Object[] newTail = objectArray2;
        if (index2 < tailSize - 1) {
            ArraysKt.copyInto((Object[])this.tail, (Object[])newTail, (int)index2, (int)(index2 + 1), (int)tailSize);
        }
        newTail[tailSize - 1] = null;
        return new PersistentVector<E>(root, newTail, rootSize + tailSize - 1, shift);
    }

    private final PersistentList<E> pullLastBufferFromRoot(Object[] root, int rootSize, int shift) {
        if (shift == 0) {
            Object[] objectArray;
            if (root.length == 33) {
                Object[] objectArray2 = root;
                int n = 32;
                boolean bl = false;
                Object[] objectArray3 = Arrays.copyOf(objectArray2, n);
                objectArray = objectArray3;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"java.util.Arrays.copyOf(this, newSize)");
            } else {
                objectArray = root;
            }
            Object[] buffer = objectArray;
            return new SmallPersistentVector(buffer);
        }
        ObjectRef tailCarry = new ObjectRef(null);
        Object[] objectArray = this.pullLastBuffer(root, shift, rootSize - 1, tailCarry);
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] newRoot = objectArray;
        Object object = tailCarry.getValue();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        }
        Object[] newTail = (Object[])object;
        if (newRoot[1] == null) {
            Object object2 = newRoot[0];
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            }
            Object[] lowerLevelRoot = (Object[])object2;
            return new PersistentVector<E>(lowerLevelRoot, newTail, rootSize, shift - 5);
        }
        return new PersistentVector<E>(newRoot, newTail, rootSize, shift);
    }

    private final Object[] pullLastBuffer(Object[] root, int shift, int index2, ObjectRef tailCarry) {
        Object[] newBufferAtIndex;
        Object[] objectArray;
        int bufferIndex = UtilsKt.indexSegment(index2, shift);
        if (shift == 5) {
            tailCarry.setValue(root[bufferIndex]);
            objectArray = null;
        } else {
            Object object = root[bufferIndex];
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            }
            objectArray = newBufferAtIndex = this.pullLastBuffer((Object[])object, shift - 5, index2, tailCarry);
        }
        if (newBufferAtIndex == null && bufferIndex == 0) {
            return null;
        }
        Object[] objectArray2 = root;
        int n = 32;
        boolean bl = false;
        Object[] objectArray3 = Arrays.copyOf(objectArray2, n);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"java.util.Arrays.copyOf(this, newSize)");
        Object[] newRoot = objectArray3;
        newRoot[bufferIndex] = newBufferAtIndex;
        return newRoot;
    }

    /*
     * WARNING - void declaration
     */
    private final Object[] removeFromRootAt(Object[] root, int shift, int index2, ObjectRef tailCarry) {
        int bufferIndex = UtilsKt.indexSegment(index2, shift);
        if (shift == 0) {
            Object[] objectArray;
            if (bufferIndex == 0) {
                objectArray = new Object[32];
            } else {
                Object[] objectArray2 = root;
                int n = 32;
                boolean bl = false;
                Object[] objectArray3 = Arrays.copyOf(objectArray2, n);
                objectArray = objectArray3;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"java.util.Arrays.copyOf(this, newSize)");
            }
            Object[] newRoot = objectArray;
            ArraysKt.copyInto((Object[])root, (Object[])newRoot, (int)bufferIndex, (int)(bufferIndex + 1), (int)32);
            newRoot[31] = tailCarry.getValue();
            tailCarry.setValue(root[bufferIndex]);
            return newRoot;
        }
        int bufferLastIndex = 31;
        if (root[bufferLastIndex] == null) {
            bufferLastIndex = UtilsKt.indexSegment(this.rootSize() - 1, shift);
        }
        Object[] objectArray = root;
        int n = 32;
        int n2 = 0;
        Object[] objectArray4 = Arrays.copyOf(objectArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray4, (String)"java.util.Arrays.copyOf(this, newSize)");
        Object[] newRoot = objectArray4;
        int lowerLevelShift = shift - 5;
        n = bufferLastIndex;
        n2 = bufferIndex + 1;
        if (n >= n2) {
            while (true) {
                void i;
                Object object = newRoot[i];
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                }
                newRoot[i] = this.removeFromRootAt((Object[])object, lowerLevelShift, 0, tailCarry);
                if (i == n2) break;
                --i;
            }
        }
        Object object = newRoot[bufferIndex];
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        }
        newRoot[bufferIndex] = this.removeFromRootAt((Object[])object, lowerLevelShift, index2, tailCarry);
        return newRoot;
    }

    @Override
    @NotNull
    public PersistentList<E> removeAll(@NotNull Function1<? super E, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        PersistentCollection.Builder builder2 = this.builder();
        boolean bl = false;
        boolean bl2 = false;
        PersistentCollection.Builder it = builder2;
        boolean bl3 = false;
        ((PersistentVectorBuilder)it).removeAllWithPredicate(predicate);
        return ((PersistentVectorBuilder)builder2).build();
    }

    @Override
    @NotNull
    public PersistentVectorBuilder<E> builder() {
        return new PersistentVectorBuilder(this, this.root, this.tail, this.rootShift);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index2) {
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index2, this.size());
        if (this.tail == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<E>");
        }
        return new PersistentVectorIterator<Object>(this.root, this.tail, index2, this.size(), this.rootShift / 5 + 1);
    }

    private final Object[] bufferFor(int index2) {
        if (this.rootSize() <= index2) {
            return this.tail;
        }
        Object[] buffer = this.root;
        for (int shift = this.rootShift; shift > 0; shift -= 5) {
            Object object = buffer[UtilsKt.indexSegment(index2, shift)];
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            }
            buffer = (Object[])object;
        }
        return buffer;
    }

    @Override
    public E get(int index2) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index2, this.size());
        Object[] buffer = this.bufferFor(index2);
        return (E)buffer[index2 & 0x1F];
    }

    @Override
    @NotNull
    public PersistentList<E> set(int index2, E element2) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index2, this.size());
        if (this.rootSize() <= index2) {
            Object[] objectArray = this.tail;
            int n = 32;
            boolean bl = false;
            Object[] objectArray2 = Arrays.copyOf(objectArray, n);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            Object[] newTail = objectArray2;
            newTail[index2 & 0x1F] = element2;
            return new PersistentVector<E>(this.root, newTail, this.size(), this.rootShift);
        }
        Object[] newRoot = this.setInRoot(this.root, this.rootShift, index2, element2);
        return new PersistentVector<E>(newRoot, this.tail, this.size(), this.rootShift);
    }

    private final Object[] setInRoot(Object[] root, int shift, int index2, Object e) {
        int bufferIndex = UtilsKt.indexSegment(index2, shift);
        Object[] objectArray = root;
        int n = 32;
        boolean bl = false;
        Object[] objectArray2 = Arrays.copyOf(objectArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        Object[] newRoot = objectArray2;
        if (shift == 0) {
            newRoot[bufferIndex] = e;
        } else {
            Object object = newRoot[bufferIndex];
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            }
            newRoot[bufferIndex] = this.setInRoot((Object[])object, shift - 5, index2, e);
        }
        return newRoot;
    }

    public int getSize() {
        return this.size;
    }

    public PersistentVector(@NotNull Object[] root, @NotNull Object[] tail, int size, int rootShift) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)tail, (String)"tail");
        this.root = root;
        this.tail = tail;
        this.size = size;
        this.rootShift = rootShift;
        boolean bl = this.size() > 32;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Trie-based persistent vector should have at least 33 elements, got " + this.size();
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        CommonFunctionsKt.assert(this.size() - UtilsKt.rootSize(this.size()) <= RangesKt.coerceAtMost((int)this.tail.length, (int)32));
    }
}

