/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.Access;
import com.intellij.util.lang.CachePoolImpl;
import com.intellij.util.lang.CharSequenceAccess;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.DirectByteBufferPool;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.StrippedLongArrayList;
import com.intellij.util.lang.Xor16;
import com.intellij.util.lang.Xxh3Impl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileLoader
implements Loader {
    private static final EnumSet<StandardOpenOption> READ_OPTIONS = EnumSet.of(StandardOpenOption.READ);
    private static final EnumSet<StandardOpenOption> WRITE_OPTIONS = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE);
    private static final AtomicInteger totalLoaders = new AtomicInteger();
    private static final AtomicLong totalScanning = new AtomicLong();
    private static final AtomicLong totalSaving = new AtomicLong();
    private static final AtomicLong totalReading = new AtomicLong();
    private static final Boolean doFsActivityLogging = false;
    private static final short indexFileVersion = 24;
    @NotNull
    private final Predicate<? super String> nameFilter;
    @NotNull
    private final Path path;

    FileLoader(@NotNull Path path) {
        if (path == null) {
            FileLoader.$$$reportNull$$$0(0);
        }
        this.path = path;
        this.nameFilter = __ -> true;
    }

    private FileLoader(@NotNull Path path, @NotNull Predicate<? super String> nameFilter) {
        if (path == null) {
            FileLoader.$$$reportNull$$$0(1);
        }
        if (nameFilter == null) {
            FileLoader.$$$reportNull$$$0(2);
        }
        this.path = path;
        this.nameFilter = nameFilter;
    }

    @NotNull
    static FileLoader createCachingFileLoader(Path file2, @Nullable CachePoolImpl cachePool, Predicate<? super Path> cachingCondition, boolean isClassPathIndexEnabled, ClasspathCache cache2) {
        if (cachePool == null) {
            LoaderData data = FileLoader.buildData(file2, isClassPathIndexEnabled);
            FileLoader loader = new FileLoader(file2, data.nameFilter);
            cache2.applyLoaderData(data, loader);
            FileLoader fileLoader = loader;
            if (fileLoader == null) {
                FileLoader.$$$reportNull$$$0(3);
            }
            return fileLoader;
        }
        ClasspathCache.IndexRegistrar data = cachePool.loaderIndexCache.get(file2);
        if (data == null) {
            LoaderData loaderData = FileLoader.buildData(file2, isClassPathIndexEnabled);
            FileLoader loader = new FileLoader(file2, loaderData.nameFilter);
            if (cachingCondition != null && cachingCondition.test(file2)) {
                cachePool.loaderIndexCache.put(file2, loaderData);
            }
            cache2.applyLoaderData(loaderData, loader);
            FileLoader fileLoader = loader;
            if (fileLoader == null) {
                FileLoader.$$$reportNull$$$0(4);
            }
            return fileLoader;
        }
        FileLoader loader = new FileLoader(file2, data.getNameFilter());
        cache2.applyLoaderData(data, loader);
        FileLoader fileLoader = loader;
        if (fileLoader == null) {
            FileLoader.$$$reportNull$$$0(5);
        }
        return fileLoader;
    }

    @Override
    @NotNull
    public Path getPath() {
        Path path = this.path;
        if (path == null) {
            FileLoader.$$$reportNull$$$0(6);
        }
        return path;
    }

    @Override
    public void processResources(@NotNull String dir, @NotNull Predicate<? super String> fileNameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer2) throws IOException {
        if (dir == null) {
            FileLoader.$$$reportNull$$$0(7);
        }
        if (fileNameFilter == null) {
            FileLoader.$$$reportNull$$$0(8);
        }
        if (consumer2 == null) {
            FileLoader.$$$reportNull$$$0(9);
        }
        try (DirectoryStream<Path> paths2 = Files.newDirectoryStream(this.path.resolve(dir));){
            for (Path childPath : paths2) {
                String name2 = this.path.relativize(childPath).toString();
                if (!fileNameFilter.test(name2) || !Files.isRegularFile(childPath, new LinkOption[0])) continue;
                try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(childPath, new OpenOption[0]));){
                    consumer2.accept(name2, stream);
                }
            }
        }
        catch (NoSuchFileException | NotDirectoryException fileSystemException) {
            // empty catch block
        }
    }

    private static void buildPackageAndNameCache(Path startDir, ClasspathCache.LoaderDataBuilder context2, StrippedLongArrayList nameHashes) {
        Path dir;
        ArrayDeque<Path> dirCandidates = new ArrayDeque<Path>();
        dirCandidates.add(startDir);
        int rootDirAbsolutePathLength = startDir.toString().length();
        while ((dir = (Path)dirCandidates.pollFirst()) != null) {
            try {
                DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir);
                try {
                    boolean containsClasses = false;
                    boolean containsResources = false;
                    for (Path file2 : dirStream) {
                        String path = FileLoader.getRelativeResourcePath(file2.toString(), rootDirAbsolutePathLength);
                        long nameHash = Xxh3Impl.hash((Object)path, (Access)CharSequenceAccess.INSTANCE, (int)0, (int)(path.length() * 2), (long)0L);
                        if (path.endsWith(".class")) {
                            nameHashes.add(nameHash);
                            containsClasses = true;
                            continue;
                        }
                        nameHashes.add(nameHash);
                        containsResources = true;
                        if (path.endsWith(".svg") || path.endsWith(".png") || path.endsWith(".xml")) continue;
                        dirCandidates.addLast(file2);
                    }
                    if (!containsClasses && !containsResources) continue;
                    String relativeResourcePath = FileLoader.getRelativeResourcePath(dir.toString(), rootDirAbsolutePathLength);
                    if (containsClasses) {
                        context2.addClassPackage(relativeResourcePath);
                    }
                    if (!containsResources) continue;
                    context2.addResourcePackage(relativeResourcePath);
                }
                finally {
                    if (dirStream == null) continue;
                    dirStream.close();
                }
            }
            catch (NoSuchFileException | NotDirectoryException dirStream) {
            }
            catch (IOException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @NotNull
    private static String getRelativeResourcePath(@NotNull String path, int startPathLength) {
        String relativePath;
        if (path == null) {
            FileLoader.$$$reportNull$$$0(10);
        }
        String string2 = (relativePath = path.substring(startPathLength).replace(File.separatorChar, '/')).startsWith("/") ? relativePath.substring(1) : relativePath;
        if (string2 == null) {
            FileLoader.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @Override
    @Nullable
    public Resource getResource(@NotNull String name2) {
        if (name2 == null) {
            FileLoader.$$$reportNull$$$0(12);
        }
        if (!this.nameFilter.test(name2)) {
            return null;
        }
        Path file2 = this.path.resolve(name2);
        return Files.exists(file2, new LinkOption[0]) ? new FileResource(file2) : null;
    }

    @Override
    @Nullable
    public Class<?> findClass(String fileName2, String className, ClassPath.ClassDataConsumer classConsumer) throws IOException {
        byte[] data;
        if (!this.nameFilter.test(fileName2)) {
            return null;
        }
        Path file2 = this.path.resolve(fileName2);
        try {
            data = Files.readAllBytes(file2);
        }
        catch (NoSuchFileException e2) {
            return null;
        }
        return classConsumer.consumeClassData(className, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static LoaderData readFromIndex(Path index2) {
        long started = System.nanoTime();
        boolean isOk = false;
        int version = -1;
        try (SeekableByteChannel channel = Files.newByteChannel(index2, READ_OPTIONS, new FileAttribute[0]);){
            ByteBuffer buffer = DirectByteBufferPool.DEFAULT_POOL.allocate((int)channel.size());
            try {
                do {
                    channel.read(buffer);
                } while (buffer.hasRemaining());
                buffer.flip();
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                version = buffer.getShort();
                if (version == 24) {
                    long[] classPackageHashes = new long[buffer.getInt()];
                    long[] resourcePackageHashes = new long[buffer.getInt()];
                    LongBuffer longBuffer = buffer.asLongBuffer();
                    longBuffer.get(classPackageHashes);
                    longBuffer.get(resourcePackageHashes);
                    buffer.position(buffer.position() + longBuffer.position() * 8);
                    LoaderData loaderData = new LoaderData(resourcePackageHashes, classPackageHashes, new NameFilter(new Xor16(buffer)));
                    isOk = true;
                    LoaderData loaderData2 = loaderData;
                    return loaderData2;
                }
            }
            finally {
                DirectByteBufferPool.DEFAULT_POOL.release(buffer);
            }
        }
        catch (NoSuchFileException ignore) {
            isOk = true;
        }
        catch (Exception e2) {
            System.err.println("Cannot read classpath index (version=" + version + ", module=" + index2.getParent().getFileName() + ")");
            e2.printStackTrace();
        }
        finally {
            if (!isOk) {
                try {
                    Files.deleteIfExists(index2);
                }
                catch (IOException ignore) {}
            }
            totalReading.addAndGet(System.nanoTime() - started);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveIndex(@NotNull LoaderData data, @NotNull Path indexFile) throws IOException {
        if (data == null) {
            FileLoader.$$$reportNull$$$0(13);
        }
        if (indexFile == null) {
            FileLoader.$$$reportNull$$$0(14);
        }
        long started = System.nanoTime();
        ByteBuffer buffer = DirectByteBufferPool.DEFAULT_POOL.allocate(2 + data.approximateSizeInBytes());
        try {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putShort((short)24);
            data.save(buffer);
            assert (buffer.remaining() == 0);
            buffer.flip();
            try (SeekableByteChannel channel = Files.newByteChannel(indexFile, WRITE_OPTIONS, new FileAttribute[0]);){
                do {
                    channel.write(buffer);
                } while (buffer.hasRemaining());
            }
        }
        finally {
            DirectByteBufferPool.DEFAULT_POOL.release(buffer);
            totalSaving.addAndGet(System.nanoTime() - started);
        }
    }

    @NotNull
    private static LoaderData buildData(@NotNull Path path, boolean isClassPathIndexEnabled) {
        long currentScanningTime;
        if (path == null) {
            FileLoader.$$$reportNull$$$0(15);
        }
        Path indexFile = isClassPathIndexEnabled ? path.resolve("classpath.index") : null;
        LoaderData loaderData = indexFile == null ? null : FileLoader.readFromIndex(indexFile);
        int nsMsFactor = 1000000;
        int currentLoaders = totalLoaders.incrementAndGet();
        if (loaderData == null) {
            long started = System.nanoTime();
            StrippedLongArrayList nameHashes = new StrippedLongArrayList();
            ClasspathCache.LoaderDataBuilder loaderDataBuilder = new ClasspathCache.LoaderDataBuilder();
            FileLoader.buildPackageAndNameCache(path, loaderDataBuilder, nameHashes);
            loaderData = new LoaderData(loaderDataBuilder.resourcePackageHashes.toArray(), loaderDataBuilder.classPackageHashes.toArray(), new NameFilter(Xor16.construct((long[])nameHashes.elements(), (int)0, (int)nameHashes.size())));
            long doneNanos = System.nanoTime() - started;
            currentScanningTime = totalScanning.addAndGet(doneNanos);
            if (doFsActivityLogging.booleanValue()) {
                System.out.println("Scanned: " + path + " for " + doneNanos / (long)nsMsFactor + "ms");
            }
            if (isClassPathIndexEnabled) {
                try {
                    Path tempFile = indexFile.getParent().resolve("classpath.index.tmp");
                    FileLoader.saveIndex(loaderData, tempFile);
                    try {
                        Files.move(tempFile, indexFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (AtomicMoveNotSupportedException e2) {
                        Files.move(tempFile, indexFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        } else {
            currentScanningTime = totalScanning.get();
        }
        if (doFsActivityLogging.booleanValue()) {
            System.out.println("Scanning: " + currentScanningTime / (long)nsMsFactor + "ms, loading: " + totalReading.get() / (long)nsMsFactor + "ms for " + currentLoaders + " loaders");
        }
        LoaderData loaderData2 = loaderData;
        if (loaderData2 == null) {
            FileLoader.$$$reportNull$$$0(16);
        }
        return loaderData2;
    }

    public String toString() {
        return "FileLoader(path=" + this.path + ')';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 16: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameFilter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/FileLoader";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameFilter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/FileLoader";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachingFileLoader";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeResourcePath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildData";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 16: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeResourcePath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveIndex";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildData";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LoaderData
    implements ClasspathCache.IndexRegistrar {
        private final long[] resourcePackageHashes;
        private final long[] classPackageHashes;
        @NotNull
        private final NameFilter nameFilter;

        LoaderData(long[] resourcePackageHashes, long[] classPackageHashes, @NotNull NameFilter nameFilter) {
            if (nameFilter == null) {
                LoaderData.$$$reportNull$$$0(0);
            }
            this.resourcePackageHashes = resourcePackageHashes;
            this.classPackageHashes = classPackageHashes;
            this.nameFilter = nameFilter;
        }

        @Override
        public int classPackageCount() {
            return this.classPackageHashes.length;
        }

        @Override
        public int resourcePackageCount() {
            return this.resourcePackageHashes.length;
        }

        @Override
        @NotNull
        public Predicate<String> getNameFilter() {
            NameFilter nameFilter = this.nameFilter;
            if (nameFilter == null) {
                LoaderData.$$$reportNull$$$0(1);
            }
            return nameFilter;
        }

        @Override
        public long[] classPackages() {
            return this.classPackageHashes;
        }

        @Override
        public long[] resourcePackages() {
            return this.resourcePackageHashes;
        }

        int approximateSizeInBytes() {
            return 8 + this.classPackageHashes.length * 8 + this.resourcePackageHashes.length * 8 + this.nameFilter.filter.sizeInBytes();
        }

        void save(@NotNull ByteBuffer buffer) {
            if (buffer == null) {
                LoaderData.$$$reportNull$$$0(2);
            }
            buffer.putInt(this.classPackageHashes.length);
            buffer.putInt(this.resourcePackageHashes.length);
            LongBuffer longBuffer = buffer.asLongBuffer();
            longBuffer.put(this.classPackageHashes);
            longBuffer.put(this.resourcePackageHashes);
            buffer.position(buffer.position() + longBuffer.position() * 8);
            this.nameFilter.filter.write(buffer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameFilter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/lang/FileLoader$LoaderData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/lang/FileLoader$LoaderData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameFilter";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class NameFilter
    implements Predicate<String> {
        final Xor16 filter;

        NameFilter(Xor16 filter) {
            this.filter = filter;
        }

        @Override
        public boolean test(String name2) {
            if (name2.isEmpty()) {
                return true;
            }
            int lastIndex = name2.length() - 1;
            int end = name2.charAt(lastIndex) == '/' ? lastIndex : name2.length();
            return this.filter.mightContain(Xxh3Impl.hash((Object)name2, (Access)CharSequenceAccess.INSTANCE, (int)0, (int)(end * 2), (long)0L));
        }
    }

    private static final class FileResource
    implements Resource {
        private URL url;
        private final Path file;

        FileResource(@NotNull Path file2) {
            if (file2 == null) {
                FileResource.$$$reportNull$$$0(0);
            }
            this.file = file2;
        }

        @Override
        @NotNull
        public URL getURL() {
            URL result2 = this.url;
            if (result2 == null) {
                try {
                    result2 = this.file.toUri().toURL();
                }
                catch (MalformedURLException e2) {
                    throw new RuntimeException(e2);
                }
                this.url = result2;
            }
            URL uRL = result2;
            if (uRL == null) {
                FileResource.$$$reportNull$$$0(1);
            }
            return uRL;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(Files.newInputStream(this.file, new OpenOption[0]), 32000);
        }

        @Override
        public byte @NotNull [] getBytes() throws IOException {
            byte[] byArray = Files.readAllBytes(this.file);
            if (byArray == null) {
                FileResource.$$$reportNull$$$0(2);
            }
            return byArray;
        }

        public String toString() {
            return this.file.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/lang/FileLoader$FileResource";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/lang/FileLoader$FileResource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getURL";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBytes";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

