/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiTypesUtil {
    private static final Logger LOG = Logger.getInstance(PsiTypesUtil.class);
    @NonNls
    private static final Map<String, String> ourUnboxedTypes = new HashMap<String, String>();
    @NonNls
    private static final Map<String, String> ourBoxedTypes = new HashMap<String, String>();
    @NonNls
    private static final String GET_CLASS_METHOD = "getClass";

    private PsiTypesUtil() {
    }

    public static Object getDefaultValue(PsiType type2) {
        if (!(type2 instanceof PsiPrimitiveType)) {
            return null;
        }
        switch (type2.getCanonicalText()) {
            case "boolean": {
                return false;
            }
            case "byte": {
                return (byte)0;
            }
            case "char": {
                return Character.valueOf('\u0000');
            }
            case "short": {
                return (short)0;
            }
            case "int": {
                return 0;
            }
            case "long": {
                return 0L;
            }
            case "float": {
                return Float.valueOf(0.0f);
            }
            case "double": {
                return 0.0;
            }
        }
        return null;
    }

    @NotNull
    public static String getDefaultValueOfType(@Nullable PsiType type2) {
        return PsiTypesUtil.getDefaultValueOfType(type2, false);
    }

    @NotNull
    public static String getDefaultValueOfType(@Nullable PsiType type2, boolean customDefaultValues) {
        if (type2 instanceof PsiPrimitiveType) {
            return PsiTypes.booleanType().equals(type2) ? "false" : "0";
        }
        if (customDefaultValues) {
            String typeText;
            if (type2 instanceof PsiArrayType) {
                PsiClassType classType;
                int count = type2.getArrayDimensions() - 1;
                PsiType componentType = type2.getDeepComponentType();
                if (componentType instanceof PsiClassType && (classType = (PsiClassType)componentType).resolve() instanceof PsiTypeParameter) {
                    return "null";
                }
                PsiType erasedComponentType = TypeConversionUtil.erasure(componentType);
                StringBuilder buffer = new StringBuilder();
                buffer.append("new");
                buffer.append(" ");
                buffer.append(erasedComponentType.getCanonicalText());
                buffer.append("[0]");
                for (int i2 = 0; i2 < count; ++i2) {
                    buffer.append("[]");
                }
                String string2 = buffer.toString();
                if (string2 == null) {
                    PsiTypesUtil.$$$reportNull$$$0(0);
                }
                return string2;
            }
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type2);
            if (psiClass != null && (typeText = psiClass.getQualifiedName()) != null) {
                switch (typeText) {
                    case "java.util.Optional": 
                    case "java.util.OptionalInt": 
                    case "java.util.OptionalLong": 
                    case "java.util.OptionalDouble": 
                    case "java.util.stream.Stream": 
                    case "java.util.stream.IntStream": 
                    case "java.util.stream.LongStream": 
                    case "java.util.stream.DoubleStream": {
                        String string3 = typeText + ".empty()";
                        if (string3 == null) {
                            PsiTypesUtil.$$$reportNull$$$0(1);
                        }
                        return string3;
                    }
                    case "java.lang.String": {
                        return "\"\"";
                    }
                    case "java.lang.Integer": 
                    case "java.lang.Long": 
                    case "java.lang.Short": 
                    case "java.lang.Byte": {
                        return "0";
                    }
                    case "java.lang.Float": {
                        return "0f";
                    }
                    case "java.lang.Double": {
                        return "0.0";
                    }
                    case "java.util.Set": {
                        return PsiUtil.isAvailable(JavaFeature.COLLECTION_FACTORIES, psiClass) ? "java.util.Set.of()" : "java.util.Collections.emptySet()";
                    }
                    case "java.util.Collection": 
                    case "java.util.List": {
                        return PsiUtil.isAvailable(JavaFeature.COLLECTION_FACTORIES, psiClass) ? "java.util.List.of()" : "java.util.Collections.emptyList()";
                    }
                    case "java.util.Map": {
                        return PsiUtil.isAvailable(JavaFeature.COLLECTION_FACTORIES, psiClass) ? "java.util.Map.of()" : "java.util.Collections.emptyMap()";
                    }
                }
            }
        }
        return "null";
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    @NonNls
    public static String unboxIfPossible(@Nullable @NonNls String type2) {
        if (type2 == null) {
            return null;
        }
        String s2 = ourUnboxedTypes.get(type2);
        return s2 == null ? type2 : s2;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String boxIfPossible(@Nullable String type2) {
        if (type2 == null) {
            return null;
        }
        String s2 = ourBoxedTypes.get(type2);
        return s2 == null ? type2 : s2;
    }

    @Nullable
    public static PsiClass getPsiClass(@Nullable PsiType psiType) {
        return psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
    }

    @NotNull
    public static PsiClassType getClassType(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiTypesUtil.$$$reportNull$$$0(2);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory(psiClass.getProject()).createType(psiClass);
        if (psiClassType == null) {
            PsiTypesUtil.$$$reportNull$$$0(3);
        }
        return psiClassType;
    }

    @Nullable
    public static PsiClassType getLowestUpperBoundClassType(@NotNull PsiDisjunctionType type2) {
        PsiType lub;
        if (type2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(4);
        }
        if ((lub = type2.getLeastUpperBound()) instanceof PsiClassType) {
            return (PsiClassType)lub;
        }
        if (lub instanceof PsiIntersectionType) {
            for (PsiType subType : ((PsiIntersectionType)lub).getConjuncts()) {
                PsiClass aClass;
                if (!(subType instanceof PsiClassType) || (aClass = ((PsiClassType)subType).resolve()) == null || aClass.isInterface()) continue;
                return (PsiClassType)subType;
            }
        }
        return null;
    }

    public static PsiType patchMethodGetClassReturnType(@NotNull PsiMethodReferenceExpression methodExpression, @NotNull PsiMethod method) {
        if (methodExpression == null) {
            PsiTypesUtil.$$$reportNull$$$0(5);
        }
        if (method == null) {
            PsiTypesUtil.$$$reportNull$$$0(6);
        }
        if (PsiTypesUtil.isGetClass(method)) {
            PsiType qualifierType = PsiMethodReferenceUtil.getQualifierType(methodExpression);
            return qualifierType != null ? PsiTypesUtil.createJavaLangClassType(methodExpression, qualifierType, true) : null;
        }
        return null;
    }

    public static PsiType patchMethodGetClassReturnType(@NotNull PsiExpression call2, @NotNull PsiReferenceExpression methodExpression, @NotNull PsiMethod method, @NotNull Condition<? super IElementType> condition, @NotNull LanguageLevel languageLevel) {
        if (call2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(7);
        }
        if (methodExpression == null) {
            PsiTypesUtil.$$$reportNull$$$0(8);
        }
        if (method == null) {
            PsiTypesUtil.$$$reportNull$$$0(9);
        }
        if (condition == null) {
            PsiTypesUtil.$$$reportNull$$$0(10);
        }
        if (languageLevel == null) {
            PsiTypesUtil.$$$reportNull$$$0(11);
        }
        if (JavaFeature.GENERICS.isSufficient(languageLevel) && PsiTypesUtil.isGetClass(method)) {
            PsiExpression qualifier2 = methodExpression.getQualifierExpression();
            PsiType qualifierType = null;
            Project project = call2.getProject();
            if (qualifier2 != null) {
                qualifierType = TypeConversionUtil.erasure(qualifier2.getType());
            } else {
                PsiElement parent2;
                for (parent2 = call2.getContext(); parent2 != null && condition.value(parent2 instanceof StubBasedPsiElement ? ((StubBasedPsiElement)parent2).getElementType() : parent2.getNode().getElementType()); parent2 = parent2.getContext()) {
                }
                if (parent2 != null) {
                    qualifierType = JavaPsiFacade.getElementFactory(project).createType((PsiClass)parent2);
                }
            }
            if (PsiTypes.nullType().equals(qualifierType)) {
                LOG.error("Unexpected null qualifier", new Attachment("expression.txt", call2.getText()));
            }
            return PsiTypesUtil.createJavaLangClassType(methodExpression, qualifierType, true);
        }
        return null;
    }

    public static boolean isGetClass(@NotNull PsiMethod method) {
        if (method == null) {
            PsiTypesUtil.$$$reportNull$$$0(12);
        }
        if (GET_CLASS_METHOD.equals(method.getName())) {
            PsiClass aClass = method.getContainingClass();
            return aClass != null && "java.lang.Object".equals(aClass.getQualifiedName());
        }
        return false;
    }

    @Nullable
    public static PsiType createJavaLangClassType(@NotNull PsiElement context2, @Nullable PsiType qualifierType, boolean captureTopLevelWildcards) {
        if (context2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(13);
        }
        if (qualifierType != null) {
            PsiUtil.ensureValidType(qualifierType);
            JavaPsiFacade facade = JavaPsiFacade.getInstance(context2.getProject());
            PsiClass javaLangClass = facade.findClass("java.lang.Class", context2.getResolveScope());
            if (javaLangClass != null && javaLangClass.getTypeParameters().length == 1) {
                PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY.put(javaLangClass.getTypeParameters()[0], PsiWildcardType.createExtends(context2.getManager(), qualifierType));
                PsiClassType classType = facade.getElementFactory().createType(javaLangClass, substitutor2, PsiUtil.getLanguageLevel(context2));
                return captureTopLevelWildcards ? PsiUtil.captureToplevelWildcards(classType, context2) : classType;
            }
        }
        return null;
    }

    @Nullable
    public static PsiType getExpectedTypeByParent(@NotNull PsiElement element2) {
        PsiElement parent2;
        if (element2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(14);
        }
        if ((parent2 = PsiUtil.skipParenthesizedExprUp(element2.getParent())) instanceof PsiVariable) {
            if (PsiUtil.checkSameExpression(element2, ((PsiVariable)parent2).getInitializer())) {
                PsiTypeElement typeElement = ((PsiVariable)parent2).getTypeElement();
                if (typeElement != null && typeElement.isInferredType()) {
                    return null;
                }
                return ((PsiVariable)parent2).getType();
            }
        } else if (parent2 instanceof PsiAssignmentExpression) {
            if (((PsiAssignmentExpression)parent2).getOperationSign().getTokenType() == JavaTokenType.EQ && PsiUtil.checkSameExpression(element2, ((PsiAssignmentExpression)parent2).getRExpression())) {
                PsiType type2 = ((PsiAssignmentExpression)parent2).getLExpression().getType();
                return !PsiTypes.nullType().equals(type2) ? type2 : null;
            }
        } else if (parent2 instanceof PsiReturnStatement) {
            Object psiElement = PsiTreeUtil.getParentOfType(parent2, PsiLambdaExpression.class, PsiMethod.class);
            if (psiElement instanceof PsiLambdaExpression) {
                return null;
            }
            if (psiElement instanceof PsiMethod) {
                return ((PsiMethod)psiElement).getReturnType();
            }
        } else {
            if (PsiUtil.isCondition(element2, parent2)) {
                return PsiTypes.booleanType();
            }
            if (parent2 instanceof PsiArrayInitializerExpression) {
                PsiElement gParent = parent2.getParent();
                if (gParent instanceof PsiNewExpression) {
                    PsiType type3 = ((PsiNewExpression)gParent).getType();
                    if (type3 instanceof PsiArrayType) {
                        return ((PsiArrayType)type3).getComponentType();
                    }
                } else if (gParent instanceof PsiVariable) {
                    PsiType type4 = ((PsiVariable)gParent).getType();
                    if (type4 instanceof PsiArrayType) {
                        return ((PsiArrayType)type4).getComponentType();
                    }
                } else if (gParent instanceof PsiArrayInitializerExpression) {
                    PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent(parent2);
                    return expectedTypeByParent instanceof PsiArrayType ? ((PsiArrayType)expectedTypeByParent).getComponentType() : null;
                }
            }
        }
        return null;
    }

    @Nullable
    public static PsiType getMethodReturnType(@NotNull PsiElement element2) {
        Object methodOrLambda;
        if (element2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(15);
        }
        return (methodOrLambda = PsiTreeUtil.getParentOfType(element2, PsiMethod.class, PsiLambdaExpression.class)) instanceof PsiMethod ? ((PsiMethod)methodOrLambda).getReturnType() : (methodOrLambda instanceof PsiLambdaExpression ? LambdaUtil.getFunctionalInterfaceReturnType((PsiLambdaExpression)methodOrLambda) : null);
    }

    public static boolean compareTypes(PsiType leftType, PsiType rightType, boolean ignoreEllipsis) {
        if (ignoreEllipsis) {
            if (leftType instanceof PsiEllipsisType) {
                leftType = ((PsiEllipsisType)leftType).toArrayType();
            }
            if (rightType instanceof PsiEllipsisType) {
                rightType = ((PsiEllipsisType)rightType).toArrayType();
            }
        }
        return Comparing.equal(leftType, rightType);
    }

    public static boolean isDenotableType(@Nullable PsiType type2, @NotNull PsiElement context2) {
        if (context2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(16);
        }
        if (type2 == null || type2 instanceof PsiWildcardType) {
            return false;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(context2.getProject());
        try {
            PsiType typeAfterReplacement = elementFactory.createTypeElementFromText(type2.getCanonicalText(), context2).getType();
            return type2.equals(typeAfterReplacement);
        }
        catch (IncorrectOperationException e2) {
            return false;
        }
    }

    public static boolean hasTypeAnnotation(@NotNull PsiType type2) {
        if (type2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(17);
        }
        return type2.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            public Boolean visitType(@NotNull PsiType type2) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return type2.getAnnotations().length > 0;
            }

            @Override
            public Boolean visitClassType(@NotNull PsiClassType classType) {
                if (classType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (((Boolean)super.visitClassType(classType)).booleanValue()) {
                    return true;
                }
                for (PsiType t1 : classType.getParameters()) {
                    if (!t1.accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visitArrayType(@NotNull PsiArrayType arrayType2) {
                if (arrayType2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return (Boolean)super.visitArrayType(arrayType2) != false || arrayType2.getComponentType().accept(this) != false;
            }

            @Override
            public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                if (wildcardType == null) {
                    1.$$$reportNull$$$0(3);
                }
                return (Boolean)super.visitWildcardType(wildcardType) != false || wildcardType.getBound() != null && wildcardType.getBound().accept(this) != false;
            }

            @Override
            public Boolean visitIntersectionType(@NotNull PsiIntersectionType intersectionType) {
                if (intersectionType == null) {
                    1.$$$reportNull$$$0(4);
                }
                for (PsiType t1 : intersectionType.getConjuncts()) {
                    if (!t1.accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visitDisjunctionType(@NotNull PsiDisjunctionType disjunctionType) {
                if (disjunctionType == null) {
                    1.$$$reportNull$$$0(5);
                }
                for (PsiType t1 : disjunctionType.getDisjunctions()) {
                    if (!t1.accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wildcardType";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "intersectionType";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "disjunctionType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/util/PsiTypesUtil$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitWildcardType";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIntersectionType";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDisjunctionType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean hasUnresolvedComponents(@NotNull PsiType type2) {
        if (type2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(18);
        }
        return type2.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitClassType(@NotNull PsiClassType classType) {
                PsiClassType.ClassResolveResult resolveResult;
                PsiClass psiClass;
                if (classType == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((psiClass = (resolveResult = classType.resolveGenerics()).getElement()) == null) {
                    return true;
                }
                PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
                for (PsiTypeParameter param : PsiUtil.typeParametersIterable(psiClass)) {
                    PsiType psiType = substitutor2.substitute(param);
                    if (psiType == null || !psiType.accept(this).booleanValue()) continue;
                    return true;
                }
                return (Boolean)super.visitClassType(classType);
            }

            @Override
            @Nullable
            public Boolean visitArrayType(@NotNull PsiArrayType arrayType2) {
                if (arrayType2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return arrayType2.getComponentType().accept(this);
            }

            @Override
            @NotNull
            public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                PsiType bound;
                if (wildcardType == null) {
                    2.$$$reportNull$$$0(2);
                }
                Boolean bl2 = (bound = wildcardType.getBound()) != null && bound.accept(this) != false;
                if (bl2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                return bl2;
            }

            @Override
            public Boolean visitType(@NotNull PsiType type2) {
                if (type2 == null) {
                    2.$$$reportNull$$$0(4);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string2;
                switch (n2) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 3: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wildcardType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/PsiTypesUtil$2";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/PsiTypesUtil$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitWildcardType";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitClassType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "visitArrayType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitWildcardType";
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "visitType";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @NotNull
    public static PsiType getParameterType(PsiParameter @NotNull [] parameters2, int i2, boolean varargs) {
        PsiParameter parameter2;
        PsiType parameterType;
        if (parameters2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(19);
        }
        if ((parameterType = (parameter2 = parameters2[i2 < parameters2.length ? i2 : parameters2.length - 1]).getType()) instanceof PsiEllipsisType) {
            parameterType = varargs ? ((PsiEllipsisType)parameterType).getComponentType() : ((PsiEllipsisType)parameterType).toArrayType();
        }
        if (!parameterType.isValid()) {
            PsiUtil.ensureValidType(parameterType, "Invalid type of parameter " + parameter2 + " of " + parameter2.getClass());
        }
        PsiType psiType = parameterType;
        if (psiType == null) {
            PsiTypesUtil.$$$reportNull$$$0(20);
        }
        return psiType;
    }

    public static PsiTypeParameter @NotNull [] filterUnusedTypeParameters(PsiTypeParameter @NotNull [] typeParameters2, PsiType ... types2) {
        if (typeParameters2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(21);
        }
        if (types2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(22);
        }
        if (typeParameters2.length == 0) {
            if (PsiTypeParameter.EMPTY_ARRAY == null) {
                PsiTypesUtil.$$$reportNull$$$0(23);
            }
            return PsiTypeParameter.EMPTY_ARRAY;
        }
        TypeParameterSearcher searcher = new TypeParameterSearcher();
        for (PsiType type2 : types2) {
            type2.accept(searcher);
        }
        PsiTypeParameter[] psiTypeParameterArray = searcher.getTypeParameters().toArray(PsiTypeParameter.EMPTY_ARRAY);
        if (psiTypeParameterArray == null) {
            PsiTypesUtil.$$$reportNull$$$0(24);
        }
        return psiTypeParameterArray;
    }

    public static PsiTypeParameter @NotNull [] filterUnusedTypeParameters(@NotNull PsiType superReturnTypeInBaseClassType, PsiTypeParameter @NotNull [] typeParameters2) {
        if (superReturnTypeInBaseClassType == null) {
            PsiTypesUtil.$$$reportNull$$$0(25);
        }
        if (typeParameters2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(26);
        }
        return PsiTypesUtil.filterUnusedTypeParameters(typeParameters2, superReturnTypeInBaseClassType);
    }

    private static boolean isAccessibleAt(@NotNull PsiTypeParameter parameter2, @NotNull PsiElement context2) {
        PsiTypeParameterListOwner owner;
        if (parameter2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(27);
        }
        if (context2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(28);
        }
        if ((owner = parameter2.getOwner()) instanceof PsiMethod) {
            return PsiTreeUtil.isAncestor(owner, context2, false);
        }
        if (owner instanceof PsiClass) {
            return PsiTreeUtil.isAncestor(owner, context2, false) && InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)owner, context2, false, false);
        }
        return false;
    }

    public static boolean allTypeParametersResolved(@NotNull PsiElement context2, @NotNull PsiType targetType) {
        if (context2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(29);
        }
        if (targetType == null) {
            PsiTypesUtil.$$$reportNull$$$0(30);
        }
        TypeParameterSearcher searcher = new TypeParameterSearcher();
        targetType.accept(searcher);
        Set<PsiTypeParameter> parameters2 = searcher.getTypeParameters();
        return ContainerUtil.and(parameters2, parameter2 -> PsiTypesUtil.isAccessibleAt(parameter2, context2));
    }

    @NotNull
    public static PsiType createArrayType(@NotNull PsiType newType, int arrayDim) {
        if (newType == null) {
            PsiTypesUtil.$$$reportNull$$$0(31);
        }
        for (int i2 = 0; i2 < arrayDim; ++i2) {
            newType = newType.createArrayType();
        }
        PsiType psiType = newType;
        if (psiType == null) {
            PsiTypesUtil.$$$reportNull$$$0(32);
        }
        return psiType;
    }

    @Nullable
    public static PsiTypeElement replaceWithExplicitType(PsiTypeElement typeElement) {
        PsiType type2 = typeElement.getType();
        if (!PsiTypesUtil.isDenotableType(type2, typeElement)) {
            return null;
        }
        Project project = typeElement.getProject();
        PsiTypeElement typeElementByExplicitType = JavaPsiFacade.getElementFactory(project).createTypeElement(type2);
        PsiElement explicitTypeElement = typeElement.replace(typeElementByExplicitType);
        explicitTypeElement = JavaCodeStyleManager.getInstance(project).shortenClassReferences(explicitTypeElement);
        return (PsiTypeElement)CodeStyleManager.getInstance(project).reformat(explicitTypeElement);
    }

    public static PsiType getTypeByMethod(@NotNull PsiElement context2, PsiExpressionList argumentList, PsiElement parentMethod, boolean varargs, PsiSubstitutor substitutor2, boolean inferParent) {
        if (context2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(33);
        }
        if (parentMethod instanceof PsiMethod) {
            PsiParameter[] parameters2 = ((PsiMethod)parentMethod).getParameterList().getParameters();
            if (parameters2.length == 0) {
                return null;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (!((PsiMethod)parentMethod).isVarArgs() && parameters2.length != args.length && !inferParent) {
                return null;
            }
            PsiElement arg = context2;
            while (arg.getParent() instanceof PsiParenthesizedExpression) {
                arg = arg.getParent();
            }
            int i2 = ArrayUtilRt.find(args, arg);
            if (i2 < 0) {
                return null;
            }
            PsiType parameterType = substitutor2 != null ? substitutor2.substitute(PsiTypesUtil.getParameterType(parameters2, i2, varargs)) : null;
            boolean isRaw = substitutor2 != null && PsiUtil.isRawSubstitutor((PsiMethod)parentMethod, substitutor2);
            return isRaw ? TypeConversionUtil.erasure(parameterType) : parameterType;
        }
        return null;
    }

    public static boolean mentionsTypeParameters(@Nullable PsiType type2, @NotNull Set<? extends PsiTypeParameter> typeParameters2) {
        if (typeParameters2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(34);
        }
        return PsiTypesUtil.mentionsTypeParametersOrUnboundedWildcard(type2, typeParameters2::contains);
    }

    public static boolean mentionsTypeParameters(@Nullable PsiType type2, @NotNull Predicate<? super PsiTypeParameter> wantedTypeParameter) {
        if (wantedTypeParameter == null) {
            PsiTypesUtil.$$$reportNull$$$0(35);
        }
        return PsiTypesUtil.mentionsTypeParametersOrUnboundedWildcard(type2, wantedTypeParameter);
    }

    public static boolean isUncheckedCall(JavaResolveResult resolveResult) {
        PsiSubstitutor substitutor2;
        PsiMethod method;
        PsiElement element2 = resolveResult.getElement();
        if (element2 instanceof PsiMethod && PsiUtil.isRawSubstitutor(method = (PsiMethod)element2, substitutor2 = resolveResult.getSubstitutor())) {
            for (PsiParameter t2 : method.getParameterList().getParameters()) {
                PsiClass aClass;
                PsiType type2 = t2.getType().getDeepComponentType();
                if (!(type2 instanceof PsiClassType) || !((aClass = ((PsiClassType)type2).resolveGenerics().getElement()) instanceof PsiTypeParameter) && (aClass == null || !PsiUtil.typeParametersIterator(aClass).hasNext() || ((PsiClassType)type2).isRaw())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean mentionsTypeParametersOrUnboundedWildcard(@Nullable PsiType type2, final Predicate<? super PsiTypeParameter> wantedTypeParameter) {
        if (type2 == null) {
            return false;
        }
        return type2.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            public Boolean visitType(@NotNull PsiType type2) {
                if (type2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return false;
            }

            @Override
            public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                PsiType bound;
                if (wildcardType == null) {
                    3.$$$reportNull$$$0(1);
                }
                return (bound = wildcardType.getBound()) != null ? bound.accept(this) : Boolean.valueOf(false);
            }

            @Override
            public Boolean visitClassType(@NotNull PsiClassType classType) {
                PsiClassType.ClassResolveResult result2;
                PsiClass psiClass;
                if (classType == null) {
                    3.$$$reportNull$$$0(2);
                }
                if ((psiClass = (result2 = classType.resolveGenerics()).getElement()) != null) {
                    PsiSubstitutor substitutor2 = result2.getSubstitutor();
                    for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable(psiClass)) {
                        PsiType type2 = substitutor2.substitute(parameter2);
                        if (type2 == null || !type2.accept(this).booleanValue()) continue;
                        return true;
                    }
                }
                return psiClass instanceof PsiTypeParameter && wantedTypeParameter.test((PsiTypeParameter)psiClass);
            }

            @Override
            public Boolean visitIntersectionType(@NotNull PsiIntersectionType intersectionType) {
                if (intersectionType == null) {
                    3.$$$reportNull$$$0(3);
                }
                for (PsiType conjunct : intersectionType.getConjuncts()) {
                    if (!conjunct.accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visitMethodReferenceType(@NotNull PsiMethodReferenceType methodReferenceType) {
                if (methodReferenceType == null) {
                    3.$$$reportNull$$$0(4);
                }
                return false;
            }

            @Override
            public Boolean visitLambdaExpressionType(@NotNull PsiLambdaExpressionType lambdaExpressionType) {
                if (lambdaExpressionType == null) {
                    3.$$$reportNull$$$0(5);
                }
                return false;
            }

            @Override
            public Boolean visitArrayType(@NotNull PsiArrayType arrayType2) {
                if (arrayType2 == null) {
                    3.$$$reportNull$$$0(6);
                }
                return arrayType2.getComponentType().accept(this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wildcardType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "intersectionType";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodReferenceType";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lambdaExpressionType";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/util/PsiTypesUtil$3";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitWildcardType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIntersectionType";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodReferenceType";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpressionType";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Contract(value="null, _ -> false")
    public static boolean classNameEquals(@Nullable PsiType type2, @NotNull String qualifiedClassName) {
        if (qualifiedClassName == null) {
            PsiTypesUtil.$$$reportNull$$$0(36);
        }
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type2;
        String className = classType.getClassName();
        if (className == null || !qualifiedClassName.endsWith(className)) {
            return false;
        }
        PsiClass psiClass = classType.resolve();
        if (psiClass == null) {
            return false;
        }
        return qualifiedClassName.equals(psiClass.getQualifiedName());
    }

    @NotNull
    public static List<? extends PsiClassType> getClassTypeComponents(PsiType type2) {
        if (type2 instanceof PsiClassType) {
            List<PsiClassType> list = Collections.singletonList((PsiClassType)type2);
            if (list == null) {
                PsiTypesUtil.$$$reportNull$$$0(37);
            }
            return list;
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            return PsiTypesUtil.getClassTypeComponents(((PsiCapturedWildcardType)type2).getUpperBound());
        }
        if (type2 instanceof PsiIntersectionType) {
            ArrayList<? extends PsiClassType> classTypes = new ArrayList<PsiClassType>();
            for (PsiType conjunct : ((PsiIntersectionType)type2).getConjuncts()) {
                classTypes.addAll(PsiTypesUtil.getClassTypeComponents(conjunct));
            }
            ArrayList<? extends PsiClassType> arrayList = classTypes;
            if (arrayList == null) {
                PsiTypesUtil.$$$reportNull$$$0(38);
            }
            return arrayList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            PsiTypesUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    static {
        ourUnboxedTypes.put("java.lang.Boolean", "boolean");
        ourUnboxedTypes.put("java.lang.Byte", "byte");
        ourUnboxedTypes.put("java.lang.Short", "short");
        ourUnboxedTypes.put("java.lang.Integer", "int");
        ourUnboxedTypes.put("java.lang.Long", "long");
        ourUnboxedTypes.put("java.lang.Float", "float");
        ourUnboxedTypes.put("java.lang.Double", "double");
        ourUnboxedTypes.put("java.lang.Character", "char");
        ourBoxedTypes.put("boolean", "java.lang.Boolean");
        ourBoxedTypes.put("byte", "java.lang.Byte");
        ourBoxedTypes.put("short", "java.lang.Short");
        ourBoxedTypes.put("int", "java.lang.Integer");
        ourBoxedTypes.put("long", "java.lang.Long");
        ourBoxedTypes.put("float", "java.lang.Float");
        ourBoxedTypes.put("double", "java.lang.Double");
        ourBoxedTypes.put("char", "java.lang.Character");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiTypesUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 13: 
            case 16: 
            case 28: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 21: 
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superReturnTypeInBaseClassType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wantedTypeParameter";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedClassName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueOfType";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiTypesUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUnusedTypeParameters";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayType";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassTypeComponents";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClassType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLowestUpperBoundClassType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "patchMethodGetClassReturnType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isGetClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createJavaLangClassType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypeByParent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMethodReturnType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isDenotableType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeAnnotation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedComponents";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 21: 
            case 22: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "filterUnusedTypeParameters";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleAt";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "allTypeParametersResolved";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createArrayType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByMethod";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "mentionsTypeParameters";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "classNameEquals";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TypeParameterSearcher
    extends PsiTypeVisitor<Boolean> {
        private final Set<PsiTypeParameter> myTypeParams = new HashSet<PsiTypeParameter>();

        @NotNull
        public Set<PsiTypeParameter> getTypeParameters() {
            Set<PsiTypeParameter> set = this.myTypeParams;
            if (set == null) {
                TypeParameterSearcher.$$$reportNull$$$0(0);
            }
            return set;
        }

        @Override
        public Boolean visitType(@NotNull PsiType type2) {
            if (type2 == null) {
                TypeParameterSearcher.$$$reportNull$$$0(1);
            }
            return false;
        }

        @Override
        public Boolean visitArrayType(@NotNull PsiArrayType arrayType2) {
            if (arrayType2 == null) {
                TypeParameterSearcher.$$$reportNull$$$0(2);
            }
            return arrayType2.getComponentType().accept(this);
        }

        @Override
        public Boolean visitClassType(@NotNull PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass aClass;
            if (classType == null) {
                TypeParameterSearcher.$$$reportNull$$$0(3);
            }
            if ((aClass = (resolveResult = classType.resolveGenerics()).getElement()) instanceof PsiTypeParameter) {
                this.myTypeParams.add((PsiTypeParameter)aClass);
            }
            if (aClass != null) {
                PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
                for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable(aClass)) {
                    PsiType psiType = substitutor2.substitute(parameter2);
                    if (psiType == null) continue;
                    psiType.accept(this);
                }
            }
            return false;
        }

        @Override
        public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
            PsiType bound;
            if (wildcardType == null) {
                TypeParameterSearcher.$$$reportNull$$$0(4);
            }
            if ((bound = wildcardType.getBound()) != null) {
                bound.accept(this);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/util/PsiTypesUtil$TypeParameterSearcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wildcardType";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeParameters";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/util/PsiTypesUtil$TypeParameterSearcher";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitType";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitArrayType";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClassType";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitWildcardType";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

