/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.konan.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;
import org.jetbrains.kotlin.resolve.konan.diagnostics.NativeObjCRefinementChecker;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0018\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\rH\u0002J\u0018\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\rH\u0002J8\u0010\u0016\u001a\u00020\u0005*\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeObjCRefinementOverridesChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "declarationToReport", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "objCAnnotations", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "swiftAnnotations", "inheritsRefinedAnnotations", "Lkotlin/Pair;", "", "hasRefinedAnnotations", "reportIncompatibleOverride", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "annotations", "notRefinedSupers", "frontend.native"})
@SourceDebugExtension(value={"SMAP\nNativeObjCRefinementOverridesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeObjCRefinementOverridesChecker.kt\norg/jetbrains/kotlin/resolve/konan/diagnostics/NativeObjCRefinementOverridesChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1863#2,2:110\n1557#2:112\n1628#2,3:113\n1863#2,2:116\n*S KotlinDebug\n*F\n+ 1 NativeObjCRefinementOverridesChecker.kt\norg/jetbrains/kotlin/resolve/konan/diagnostics/NativeObjCRefinementOverridesChecker\n*L\n29#1:110,2\n98#1:112\n98#1:113,3\n102#1:116,2\n*E\n"})
public final class NativeObjCRefinementOverridesChecker
implements DeclarationChecker {
    @NotNull
    public static final NativeObjCRefinementOverridesChecker INSTANCE = new NativeObjCRefinementOverridesChecker();

    private NativeObjCRefinementOverridesChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        Iterable iterable = ((ClassDescriptor)descriptor2).getDefaultType().getMemberScope().getContributedDescriptors(DescriptorKindFilter.ALL, MemberScope.Companion.getALL_NAME_FILTER());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
            boolean bl = false;
            if (!(it instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)it).getKind().isReal()) continue;
            INSTANCE.check(declaration2, (CallableMemberDescriptor)it, context2, CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
    }

    public final void check(@NotNull KtDeclaration declarationToReport, @NotNull CallableMemberDescriptor descriptor2, @NotNull DeclarationCheckerContext context2, @NotNull List<? extends AnnotationDescriptor> objCAnnotations, @NotNull List<? extends AnnotationDescriptor> swiftAnnotations) {
        Intrinsics.checkNotNullParameter((Object)declarationToReport, (String)"declarationToReport");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(objCAnnotations, (String)"objCAnnotations");
        Intrinsics.checkNotNullParameter(swiftAnnotations, (String)"swiftAnnotations");
        if (descriptor2.getOverriddenDescriptors().isEmpty()) {
            return;
        }
        boolean isHiddenFromObjC = !((Collection)objCAnnotations).isEmpty();
        boolean isRefinedInSwift = !((Collection)swiftAnnotations).isEmpty();
        List supersNotHiddenFromObjC = new ArrayList();
        List supersNotRefinedInSwift = new ArrayList();
        for (CallableMemberDescriptor callableMemberDescriptor : descriptor2.getOverriddenDescriptors()) {
            Intrinsics.checkNotNull((Object)callableMemberDescriptor);
            Pair<Boolean, Boolean> pair = this.inheritsRefinedAnnotations(callableMemberDescriptor);
            boolean superIsHiddenFromObjC = (Boolean)pair.component1();
            boolean superIsRefinedInSwift = (Boolean)pair.component2();
            if (superIsHiddenFromObjC) {
                isHiddenFromObjC = true;
            } else {
                supersNotHiddenFromObjC.add(callableMemberDescriptor);
            }
            if (superIsRefinedInSwift) {
                isRefinedInSwift = true;
                continue;
            }
            supersNotRefinedInSwift.add(callableMemberDescriptor);
        }
        if (isHiddenFromObjC && !((Collection)supersNotHiddenFromObjC).isEmpty()) {
            this.reportIncompatibleOverride(context2.getTrace(), declarationToReport, descriptor2, objCAnnotations, supersNotHiddenFromObjC);
        }
        if (isRefinedInSwift && !((Collection)supersNotRefinedInSwift).isEmpty()) {
            this.reportIncompatibleOverride(context2.getTrace(), declarationToReport, descriptor2, swiftAnnotations, supersNotRefinedInSwift);
        }
    }

    private final Pair<Boolean, Boolean> inheritsRefinedAnnotations(CallableMemberDescriptor $this$inheritsRefinedAnnotations) {
        Pair<Boolean, Boolean> pair = this.hasRefinedAnnotations($this$inheritsRefinedAnnotations);
        boolean hasObjC = (Boolean)pair.component1();
        boolean hasSwift = (Boolean)pair.component2();
        if (hasObjC && hasSwift) {
            return TuplesKt.to((Object)true, (Object)true);
        }
        if ($this$inheritsRefinedAnnotations.getOverriddenDescriptors().isEmpty()) {
            return TuplesKt.to((Object)hasObjC, (Object)hasSwift);
        }
        Collection<? extends CallableMemberDescriptor> collection = $this$inheritsRefinedAnnotations.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
        Object object = CollectionsKt.first((Iterable)collection);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        Pair<Boolean, Boolean> pair2 = this.inheritsRefinedAnnotations((CallableMemberDescriptor)object);
        boolean inheritsObjC = (Boolean)pair2.component1();
        boolean inheritsSwift = (Boolean)pair2.component2();
        return TuplesKt.to((Object)(hasObjC || inheritsObjC ? 1 : 0), (Object)(hasSwift || inheritsSwift ? 1 : 0));
    }

    private final Pair<Boolean, Boolean> hasRefinedAnnotations(CallableMemberDescriptor $this$hasRefinedAnnotations) {
        boolean hasObjC = false;
        boolean hasSwift = false;
        for (AnnotationDescriptor annotation : $this$hasRefinedAnnotations.getAnnotations()) {
            Object object = DescriptorUtilsKt.getAnnotationClass(annotation);
            if (object == null || (object = object.getAnnotations()) == null) continue;
            Object annotations2 = object;
            Iterator iterator2 = annotations2.iterator();
            while (iterator2.hasNext()) {
                AnnotationDescriptor metaAnnotation = (AnnotationDescriptor)iterator2.next();
                FqName fqName = metaAnnotation.getFqName();
                if (Intrinsics.areEqual((Object)fqName, (Object)NativeObjCRefinementChecker.INSTANCE.getHidesFromObjCFqName())) {
                    hasObjC = true;
                    break;
                }
                if (!Intrinsics.areEqual((Object)fqName, (Object)NativeObjCRefinementChecker.INSTANCE.getRefinesInSwiftFqName())) continue;
                hasSwift = true;
                break;
            }
            if (!hasObjC || !hasSwift) continue;
            return TuplesKt.to((Object)true, (Object)true);
        }
        return TuplesKt.to((Object)hasObjC, (Object)hasSwift);
    }

    /*
     * WARNING - void declaration
     */
    private final void reportIncompatibleOverride(BindingTrace $this$reportIncompatibleOverride, KtDeclaration declaration2, CallableMemberDescriptor descriptor2, List<? extends AnnotationDescriptor> annotations2, List<? extends CallableMemberDescriptor> notRefinedSupers) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = notRefinedSupers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getContainingDeclaration());
        }
        List containingDeclarations = (List)destination$iv$iv;
        if (annotations2.isEmpty()) {
            $this$reportIncompatibleOverride.report(ErrorsNative.INCOMPATIBLE_OBJC_REFINEMENT_OVERRIDE.on((KtElement)((PsiElement)declaration2), descriptor2, containingDeclarations));
        } else {
            Iterable $this$forEach$iv = annotations2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                boolean bl = false;
                KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(it);
                KtElement reportLocation = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration2;
                $this$reportIncompatibleOverride.report(ErrorsNative.INCOMPATIBLE_OBJC_REFINEMENT_OVERRIDE.on((KtElement)((PsiElement)reportLocation), descriptor2, containingDeclarations));
            }
        }
    }
}

