/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;

public class OverloadResolutionResultsImpl<D extends CallableDescriptor>
implements OverloadResolutionResults<D> {
    private final Collection<MutableResolvedCall<D>> results;
    private final OverloadResolutionResults.Code resultCode;
    private DelegatingBindingTrace trace;
    private Collection<ResolvedCall<D>> allCandidates;

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> success(@NotNull MutableResolvedCall<D> candidate) {
        if (candidate == null) {
            OverloadResolutionResultsImpl.$$$reportNull$$$0(0);
        }
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.SUCCESS, Collections.singleton(candidate));
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> nameNotFound() {
        OverloadResolutionResultsImpl<D> results = new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.NAME_NOT_FOUND, Collections.emptyList());
        results.setAllCandidates(Collections.emptyList());
        return results;
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> singleFailedCandidate(MutableResolvedCall<D> candidate) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH, Collections.singleton(candidate));
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> manyFailedCandidates(Collection<MutableResolvedCall<D>> failedCandidates) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES, failedCandidates);
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> candidatesWithWrongReceiver(Collection<MutableResolvedCall<D>> failedCandidates) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER, failedCandidates);
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> ambiguity(Collection<MutableResolvedCall<D>> candidates2) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.AMBIGUITY, candidates2);
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> incompleteTypeInference(Collection<MutableResolvedCall<D>> candidates2) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE, candidates2);
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> incompleteTypeInference(MutableResolvedCall<D> candidate) {
        return OverloadResolutionResultsImpl.incompleteTypeInference(Collections.singleton(candidate));
    }

    private OverloadResolutionResultsImpl(@NotNull OverloadResolutionResults.Code resultCode, @NotNull Collection<MutableResolvedCall<D>> results) {
        if (resultCode == null) {
            OverloadResolutionResultsImpl.$$$reportNull$$$0(1);
        }
        if (results == null) {
            OverloadResolutionResultsImpl.$$$reportNull$$$0(2);
        }
        this.results = results;
        this.resultCode = resultCode;
    }

    @Override
    @NotNull
    public Collection<MutableResolvedCall<D>> getResultingCalls() {
        Collection<MutableResolvedCall<D>> collection = this.results;
        if (collection == null) {
            OverloadResolutionResultsImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @NotNull
    public MutableResolvedCall<D> getResultingCall() {
        assert (this.isSingleResult());
        MutableResolvedCall<D> mutableResolvedCall = this.results.iterator().next();
        if (mutableResolvedCall == null) {
            OverloadResolutionResultsImpl.$$$reportNull$$$0(4);
        }
        return mutableResolvedCall;
    }

    @Override
    @NotNull
    public D getResultingDescriptor() {
        Object d = this.getResultingCall().getResultingDescriptor();
        if (d == null) {
            OverloadResolutionResultsImpl.$$$reportNull$$$0(5);
        }
        return d;
    }

    @Override
    @NotNull
    public OverloadResolutionResults.Code getResultCode() {
        OverloadResolutionResults.Code code = this.resultCode;
        if (code == null) {
            OverloadResolutionResultsImpl.$$$reportNull$$$0(6);
        }
        return code;
    }

    @Override
    public boolean isSuccess() {
        return this.resultCode.isSuccess();
    }

    @Override
    public boolean isSingleResult() {
        return this.results.size() == 1 && this.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER;
    }

    @Override
    public boolean isNothing() {
        return this.resultCode == OverloadResolutionResults.Code.NAME_NOT_FOUND;
    }

    @Override
    public boolean isAmbiguity() {
        return this.resultCode == OverloadResolutionResults.Code.AMBIGUITY;
    }

    @Override
    public boolean isIncomplete() {
        return this.resultCode == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE;
    }

    public DelegatingBindingTrace getTrace() {
        return this.trace;
    }

    public OverloadResolutionResultsImpl<D> setTrace(DelegatingBindingTrace trace) {
        this.trace = trace;
        return this;
    }

    public void setAllCandidates(@Nullable Collection<ResolvedCall<D>> allCandidates) {
        this.allCandidates = allCandidates;
    }

    @Override
    @Nullable
    public Collection<ResolvedCall<D>> getAllCandidates() {
        return this.allCandidates;
    }

    @NotNull
    public OverloadResolutionResultsImpl<D> changeStatusToSuccess() {
        if (this.getResultCode() == OverloadResolutionResults.Code.SUCCESS) {
            OverloadResolutionResultsImpl overloadResolutionResultsImpl = this;
            if (overloadResolutionResultsImpl == null) {
                OverloadResolutionResultsImpl.$$$reportNull$$$0(7);
            }
            return overloadResolutionResultsImpl;
        }
        assert (this.isSingleResult() && this.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) : "Only incomplete type inference status with one candidate can be changed to success: " + (Object)((Object)this.getResultCode()) + "\n" + this.getResultingCalls();
        OverloadResolutionResultsImpl<D> newResults = new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.SUCCESS, this.getResultingCalls());
        newResults.setAllCandidates(this.getAllCandidates());
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = newResults;
        if (overloadResolutionResultsImpl == null) {
            OverloadResolutionResultsImpl.$$$reportNull$$$0(8);
        }
        return overloadResolutionResultsImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultCode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultingCalls";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultingCall";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultingDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultCode";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "changeStatusToSuccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "success";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

