/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.StackOverflowPreventedException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileTypeFileViewProviders;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class FileManagerImpl
implements FileManager {
    private static final Key<Boolean> IN_COMA = Key.create("IN_COMA");
    private static final Logger LOG = Logger.getInstance(FileManagerImpl.class);
    private final Key<FileViewProvider> myPsiHardRefKey;
    private final PsiManagerImpl myManager;
    private final NotNullLazyValue<? extends FileIndexFacade> myFileIndex;
    private final AtomicReference<ConcurrentMap<VirtualFile, PsiDirectory>> myVFileToPsiDirMap;
    private final AtomicReference<ConcurrentMap<VirtualFile, FileViewProvider>> myVFileToViewProviderMap;
    private final ThreadLocal<Map<VirtualFile, FileViewProvider>> myTempProviders;
    private final MessageBusConnection myConnection;
    private static final VirtualFile NULL = new LightVirtualFile();
    private boolean myProcessingFileTypesChange;

    public FileManagerImpl(@NotNull PsiManagerImpl manager, @NotNull NotNullLazyValue<? extends FileIndexFacade> fileIndex) {
        if (manager == null) {
            FileManagerImpl.$$$reportNull$$$0(0);
        }
        if (fileIndex == null) {
            FileManagerImpl.$$$reportNull$$$0(1);
        }
        this.myPsiHardRefKey = Key.create("HARD_REFERENCE_TO_PSI");
        this.myVFileToPsiDirMap = new AtomicReference();
        this.myVFileToViewProviderMap = new AtomicReference();
        this.myTempProviders = ThreadLocal.withInitial(HashMap::new);
        this.myManager = manager;
        this.myFileIndex = fileIndex;
        this.myConnection = manager.getProject().getMessageBus().connect(manager);
        LowMemoryWatcher.register(this::processQueue, manager);
        this.myConnection.subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            @Override
            public void enteredDumbMode() {
                FileManagerImpl.this.processFileTypesChanged(false);
            }

            @Override
            public void exitDumbMode() {
                FileManagerImpl.this.processFileTypesChanged(false);
            }
        });
    }

    public void processQueue() {
        ConcurrentMap<VirtualFile, FileViewProvider> map = this.myVFileToViewProviderMap.get();
        if (map != null) {
            map.remove(NULL);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public ConcurrentMap<VirtualFile, FileViewProvider> getVFileToViewProviderMap() {
        ConcurrentMap<VirtualFile, FileViewProvider> map = this.myVFileToViewProviderMap.get();
        if (map == null) {
            map = ConcurrencyUtil.cacheOrGet(this.myVFileToViewProviderMap, CollectionFactory.createConcurrentWeakValueMap());
        }
        ConcurrentMap<VirtualFile, FileViewProvider> concurrentMap = map;
        if (concurrentMap == null) {
            FileManagerImpl.$$$reportNull$$$0(2);
        }
        return concurrentMap;
    }

    @NotNull
    private ConcurrentMap<VirtualFile, PsiDirectory> getVFileToPsiDirMap() {
        ConcurrentMap<VirtualFile, PsiDirectory> map = this.myVFileToPsiDirMap.get();
        if (map == null) {
            map = ConcurrencyUtil.cacheOrGet(this.myVFileToPsiDirMap, ContainerUtil.createConcurrentSoftValueMap());
        }
        ConcurrentMap<VirtualFile, PsiDirectory> concurrentMap = map;
        if (concurrentMap == null) {
            FileManagerImpl.$$$reportNull$$$0(3);
        }
        return concurrentMap;
    }

    public static void clearPsiCaches(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(4);
        }
        ((AbstractFileViewProvider)viewProvider).getCachedPsiFiles().forEach(PsiFile::clearCaches);
    }

    public void forceReload(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(5);
        }
        LanguageSubstitutors.cancelReparsing(vFile);
        FileViewProvider viewProvider = this.findCachedViewProvider(vFile);
        if (viewProvider == null) {
            return;
        }
        if (!viewProvider.isEventSystemEnabled()) {
            this.setViewProvider(vFile, null);
            return;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile dir = vFile.getParent();
        PsiDirectory parentDir = dir == null ? null : this.getCachedDirectory(dir);
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        if (parentDir == null) {
            event.setPropertyName("propUnloadedPsi");
            this.myManager.beforePropertyChange(event);
            this.setViewProvider(vFile, null);
            this.myManager.propertyChanged(event);
        } else {
            event.setParent(parentDir);
            this.myManager.beforeChildrenChange(event);
            this.setViewProvider(vFile, null);
            this.myManager.childrenChanged(event);
        }
    }

    public void firePropertyChangedForUnloadedPsi() {
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        event.setPropertyName("propUnloadedPsi");
        this.myManager.beforePropertyChange(event);
        this.myManager.propertyChanged(event);
    }

    public void dispose() {
        this.clearViewProviders();
    }

    @RequiresWriteLock
    private void clearViewProviders() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        DebugUtil.performPsiModification("clearViewProviders", () -> {
            ConcurrentMap<VirtualFile, FileViewProvider> map = this.myVFileToViewProviderMap.get();
            if (map != null) {
                for (FileViewProvider viewProvider : map.values()) {
                    this.markInvalidated(viewProvider);
                }
            }
            this.myVFileToViewProviderMap.set(null);
        });
    }

    @Override
    @TestOnly
    public void cleanupForNextTest() {
        ApplicationManager.getApplication().runWriteAction(this::clearViewProviders);
        this.myVFileToPsiDirMap.set(null);
        this.myManager.dropPsiCaches();
    }

    @Override
    @NotNull
    public FileViewProvider findViewProvider(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(6);
        }
        assert (!vFile.isDirectory());
        FileViewProvider viewProvider = this.findCachedViewProvider(vFile);
        if (viewProvider != null) {
            FileViewProvider fileViewProvider = viewProvider;
            if (fileViewProvider == null) {
                FileManagerImpl.$$$reportNull$$$0(7);
            }
            return fileViewProvider;
        }
        if (vFile instanceof VirtualFileWindow) {
            throw new IllegalStateException("File " + vFile + " is invalid");
        }
        Map<VirtualFile, FileViewProvider> tempMap = this.myTempProviders.get();
        if (tempMap.containsKey(vFile)) {
            FileViewProvider fileViewProvider = Objects.requireNonNull(tempMap.get(vFile), "Recursive file view provider creation");
            if (fileViewProvider == null) {
                FileManagerImpl.$$$reportNull$$$0(8);
            }
            return fileViewProvider;
        }
        viewProvider = this.createFileViewProvider(vFile, !LightVirtualFile.shouldSkipEventSystem(vFile));
        if (vFile instanceof LightVirtualFile) {
            this.checkLightFileHasNoOtherPsi((LightVirtualFile)vFile);
            FileViewProvider fileViewProvider = vFile.putUserDataIfAbsent(this.myPsiHardRefKey, viewProvider);
            if (fileViewProvider == null) {
                FileManagerImpl.$$$reportNull$$$0(9);
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = ConcurrencyUtil.cacheOrGet(this.getVFileToViewProviderMap(), vFile, viewProvider);
        if (fileViewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(10);
        }
        return fileViewProvider;
    }

    private void checkLightFileHasNoOtherPsi(@NotNull LightVirtualFile vFile) {
        Project project;
        FileViewProvider viewProvider;
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(11);
        }
        if ((viewProvider = FileDocumentManager.getInstance().findCachedPsiInAnyProject(vFile)) != null && (project = viewProvider.getManager().getProject()) != this.myManager.getProject()) {
            String psiFiles = viewProvider.getAllFiles().stream().map(f -> f.getClass() + " [" + f.getLanguage() + "]").collect(Collectors.joining(", "));
            LOG.error("Light files should have PSI only in one project, existing=" + viewProvider + " in " + project + ", requested in " + this.myManager.getProject() + "; psiFiles: " + psiFiles);
        }
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile vFile) {
        FileViewProvider viewProvider;
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(12);
        }
        if ((viewProvider = this.getRawCachedViewProvider(vFile)) instanceof AbstractFileViewProvider && viewProvider.getUserData(IN_COMA) != null) {
            Map<VirtualFile, FileViewProvider> tempMap = this.myTempProviders.get();
            FileViewProvider temp = tempMap.get(vFile);
            if (temp != null) {
                return temp;
            }
            if (!this.evaluateValidity((AbstractFileViewProvider)viewProvider)) {
                return null;
            }
        }
        return viewProvider;
    }

    @Nullable
    private FileViewProvider getRawCachedViewProvider(@NotNull VirtualFile vFile) {
        ConcurrentMap<VirtualFile, FileViewProvider> map;
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(13);
        }
        FileViewProvider viewProvider = (map = this.myVFileToViewProviderMap.get()) == null ? null : (FileViewProvider)map.get(vFile);
        return viewProvider == null ? vFile.getUserData(this.myPsiHardRefKey) : viewProvider;
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile vFile, @Nullable FileViewProvider viewProvider) {
        FileViewProvider prev;
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(14);
        }
        if ((prev = this.getRawCachedViewProvider(vFile)) == viewProvider) {
            return;
        }
        if (prev != null) {
            DebugUtil.performPsiModification(null, () -> this.markInvalidated(prev));
        }
        if (viewProvider == null) {
            this.getVFileToViewProviderMap().remove(vFile);
            vFile.putUserData(this.myPsiHardRefKey, null);
        } else if (vFile instanceof LightVirtualFile) {
            this.checkLightFileHasNoOtherPsi((LightVirtualFile)vFile);
            vFile.putUserData(this.myPsiHardRefKey, viewProvider);
        } else {
            this.getVFileToViewProviderMap().put(vFile, viewProvider);
        }
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile vFile, boolean eventSystemEnabled) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(15);
        }
        FileType fileType = vFile.getFileType();
        Language language = LanguageUtil.getLanguageForPsi(this.myManager.getProject(), vFile, fileType);
        FileViewProviderFactory factory2 = language == null ? (FileViewProviderFactory)FileTypeFileViewProviders.INSTANCE.forFileType(fileType) : (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        SingleRootFileViewProvider viewProvider = factory2 == null ? null : factory2.createFileViewProvider(vFile, language, this.myManager, eventSystemEnabled);
        SingleRootFileViewProvider singleRootFileViewProvider = viewProvider == null ? new SingleRootFileViewProvider((PsiManager)this.myManager, vFile, eventSystemEnabled, fileType) : viewProvider;
        if (singleRootFileViewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(16);
        }
        return singleRootFileViewProvider;
    }

    void processFileTypesChanged(boolean clearViewProviders) {
        if (this.myProcessingFileTypesChange) {
            return;
        }
        this.myProcessingFileTypesChange = true;
        DebugUtil.performPsiModification(null, () -> {
            try {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
                    event.setPropertyName("propFileTypes");
                    this.myManager.beforePropertyChange(event);
                    this.possiblyInvalidatePhysicalPsi();
                    if (clearViewProviders) {
                        this.clearViewProviders();
                    }
                    this.myManager.propertyChanged(event);
                });
            }
            finally {
                this.myProcessingFileTypesChange = false;
            }
        });
    }

    void possiblyInvalidatePhysicalPsi() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.removeInvalidDirs();
        for (FileViewProvider viewProvider : this.getVFileToViewProviderMap().values()) {
            FileManagerImpl.markPossiblyInvalidated(viewProvider);
        }
    }

    void dispatchPendingEvents() {
        Project project = this.myManager.getProject();
        if (project.isDisposed()) {
            LOG.error("Project is already disposed: " + project);
        }
        this.myConnection.deliverImmediately();
    }

    @TestOnly
    void checkConsistency() {
        for (Object vFile : new ArrayList(this.getVFileToViewProviderMap().keySet())) {
            this.findCachedViewProvider((VirtualFile)vFile);
        }
        HashMap<VirtualFile, FileViewProvider> fileToViewProvider = new HashMap<VirtualFile, FileViewProvider>(this.getVFileToViewProviderMap());
        this.myVFileToViewProviderMap.set(null);
        for (Map.Entry entry : fileToViewProvider.entrySet()) {
            FileViewProvider viewProvider = (FileViewProvider)entry.getValue();
            VirtualFile vFile = (VirtualFile)entry.getKey();
            LOG.assertTrue(vFile.isValid());
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null || viewProvider == null || !viewProvider.isPhysical()) continue;
            PsiFile psi = viewProvider.getPsi(viewProvider.getBaseLanguage());
            assert (psi != null) : viewProvider + "; " + viewProvider.getBaseLanguage() + "; " + psiFile1;
            assert (psiFile1.getClass().equals(psi.getClass())) : psiFile1 + "; " + psi + "; " + psiFile1.getClass() + "; " + psi.getClass();
        }
        HashMap<VirtualFile, PsiDirectory> fileToPsiDirMap = new HashMap<VirtualFile, PsiDirectory>(this.getVFileToPsiDirMap());
        this.myVFileToPsiDirMap.set(null);
        for (VirtualFile vFile : fileToPsiDirMap.keySet()) {
            LOG.assertTrue(vFile.isValid());
            PsiDirectory psiDir1 = this.findDirectory(vFile);
            LOG.assertTrue(psiDir1 != null);
            VirtualFile parent2 = vFile.getParent();
            if (parent2 == null) continue;
            LOG.assertTrue(this.getVFileToPsiDirMap().get(parent2) != null);
        }
    }

    @Override
    @RequiresReadLock
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (vFile.isDirectory()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("Invalid file: " + vFile);
            return null;
        }
        this.dispatchPendingEvents();
        FileViewProvider viewProvider = this.findViewProvider(vFile);
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            throw new InvalidVirtualFileAccessException(vFile);
        }
        Project project = this.myManager.getProject();
        if (project.isDisposed()) {
            LOG.error("Project is already disposed: " + project);
        }
        this.dispatchPendingEvents();
        return this.getCachedPsiFileInner(vFile);
    }

    @Override
    @Nullable
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        Project project;
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(19);
        }
        if ((project = this.myManager.getProject()).isDisposed()) {
            LOG.error("Access to psi files should not be performed after project disposal: " + project);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("File is not valid:" + vFile);
            return null;
        }
        if (!vFile.isDirectory()) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.findDirectoryImpl(vFile, this.getVFileToPsiDirMap());
    }

    @Nullable
    private PsiDirectory findDirectoryImpl(@NotNull VirtualFile vFile, @NotNull ConcurrentMap<VirtualFile, PsiDirectory> psiDirMap) {
        PsiDirectory psiDir;
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(20);
        }
        if (psiDirMap == null) {
            FileManagerImpl.$$$reportNull$$$0(21);
        }
        if ((psiDir = (PsiDirectory)psiDirMap.get(vFile)) != null) {
            return psiDir;
        }
        if (this.isExcludedOrIgnored(vFile)) {
            return null;
        }
        VirtualFile parent2 = vFile.getParent();
        if (parent2 != null) {
            this.findDirectoryImpl(parent2, psiDirMap);
        }
        psiDir = PsiDirectoryFactory.getInstance(this.myManager.getProject()).createDirectory(vFile);
        return ConcurrencyUtil.cacheOrGet(psiDirMap, vFile, psiDir);
    }

    private boolean isExcludedOrIgnored(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(22);
        }
        if (this.myManager.getProject().isDefault()) {
            return false;
        }
        FileIndexFacade fileIndexFacade = this.myFileIndex.getValue();
        return Registry.is("ide.hide.excluded.files") ? fileIndexFacade.isExcludedFile(vFile) : fileIndexFacade.isUnderIgnored(vFile);
    }

    public PsiDirectory getCachedDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(23);
        }
        return (PsiDirectory)this.getVFileToPsiDirMap().get(vFile);
    }

    void removeFilesAndDirsRecursively(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(24);
        }
        DebugUtil.performPsiModification("removeFilesAndDirsRecursively", () -> VfsUtilCore.visitChildrenRecursively(vFile, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file2.isDirectory()) {
                    FileManagerImpl.this.getVFileToPsiDirMap().remove(file2);
                } else {
                    FileViewProvider viewProvider = (FileViewProvider)FileManagerImpl.this.getVFileToViewProviderMap().remove(file2);
                    if (viewProvider != null) {
                        FileManagerImpl.this.markInvalidated(viewProvider);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl$2", "visitFile"));
            }
        }));
    }

    private void markInvalidated(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(25);
        }
        viewProvider.putUserData(IN_COMA, null);
        ((AbstractFileViewProvider)viewProvider).markInvalidated();
        viewProvider.getVirtualFile().putUserData(this.myPsiHardRefKey, null);
    }

    public static void markPossiblyInvalidated(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(26);
        }
        LOG.assertTrue(!(viewProvider instanceof FreeThreadedFileViewProvider));
        viewProvider.putUserData(IN_COMA, true);
        ((AbstractFileViewProvider)viewProvider).markPossiblyInvalidated();
        FileManagerImpl.clearPsiCaches(viewProvider);
    }

    @Nullable
    PsiFile getCachedPsiFileInner(@NotNull VirtualFile file2) {
        FileViewProvider viewProvider;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(27);
        }
        return (viewProvider = this.findCachedViewProvider(file2)) == null ? null : ((AbstractFileViewProvider)viewProvider).getCachedPsi(viewProvider.getBaseLanguage());
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        ArrayList<PsiFile> files2 = new ArrayList<PsiFile>();
        for (VirtualFile file2 : new ArrayList(this.getVFileToViewProviderMap().keySet())) {
            FileViewProvider viewProvider = this.findCachedViewProvider(file2);
            if (viewProvider == null) continue;
            ContainerUtil.addAllNotNull(files2, ((AbstractFileViewProvider)viewProvider).getCachedPsiFiles());
        }
        ArrayList<PsiFile> arrayList = files2;
        if (arrayList == null) {
            FileManagerImpl.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    private void removeInvalidDirs() {
        this.myVFileToPsiDirMap.set(null);
    }

    void removeInvalidFilesAndDirs(boolean useFind) {
        this.removeInvalidDirs();
        HashMap<VirtualFile, FileViewProvider> fileToPsiFileMap = new HashMap<VirtualFile, FileViewProvider>(this.getVFileToViewProviderMap());
        HashMap<VirtualFile, FileViewProvider> originalFileToPsiFileMap = new HashMap<VirtualFile, FileViewProvider>(this.getVFileToViewProviderMap());
        if (useFind) {
            this.myVFileToViewProviderMap.set(null);
        }
        Iterator iterator2 = fileToPsiFileMap.keySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator2.next();
            if (!vFile.isValid()) {
                iterator2.remove();
                continue;
            }
            FileViewProvider viewProvider = (FileViewProvider)fileToPsiFileMap.get(vFile);
            if (useFind) {
                if (viewProvider == null) {
                    iterator2.remove();
                    continue;
                }
                PsiFile psiFile1 = this.findFile(vFile);
                if (psiFile1 == null) {
                    iterator2.remove();
                    continue;
                }
                if (!FileManagerImpl.areViewProvidersEquivalent(viewProvider, psiFile1.getViewProvider())) {
                    iterator2.remove();
                    continue;
                }
                FileManagerImpl.clearPsiCaches(viewProvider);
                continue;
            }
            if (this.evaluateValidity((AbstractFileViewProvider)viewProvider)) continue;
            iterator2.remove();
        }
        this.myVFileToViewProviderMap.set(null);
        this.getVFileToViewProviderMap().putAll(fileToPsiFileMap);
        this.markInvalidations(originalFileToPsiFileMap);
    }

    static boolean areViewProvidersEquivalent(@NotNull FileViewProvider view1, @NotNull FileViewProvider view2) {
        if (view1 == null) {
            FileManagerImpl.$$$reportNull$$$0(29);
        }
        if (view2 == null) {
            FileManagerImpl.$$$reportNull$$$0(30);
        }
        if (view1.getClass() != view2.getClass() || view1.getFileType() != view2.getFileType()) {
            return false;
        }
        Language baseLanguage = view1.getBaseLanguage();
        if (baseLanguage != view2.getBaseLanguage()) {
            return false;
        }
        if (!view1.getLanguages().equals(view2.getLanguages())) {
            return false;
        }
        PsiFile psi1 = view1.getPsi(baseLanguage);
        PsiFile psi2 = view2.getPsi(baseLanguage);
        if (psi1 == null || psi2 == null) {
            return psi1 == psi2;
        }
        return psi1.getClass() == psi2.getClass();
    }

    private void markInvalidations(@NotNull Map<VirtualFile, FileViewProvider> originalFileToPsiFileMap) {
        if (originalFileToPsiFileMap == null) {
            FileManagerImpl.$$$reportNull$$$0(31);
        }
        if (!originalFileToPsiFileMap.isEmpty()) {
            DebugUtil.performPsiModification(null, () -> {
                for (Map.Entry entry : originalFileToPsiFileMap.entrySet()) {
                    FileViewProvider viewProvider = (FileViewProvider)entry.getValue();
                    if (this.getVFileToViewProviderMap().get(entry.getKey()) == viewProvider) continue;
                    this.markInvalidated(viewProvider);
                }
            });
        }
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            FileManagerImpl.$$$reportNull$$$0(32);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile vFile = psiFile.getVirtualFile();
        assert (vFile != null);
        Document document = FileDocumentManager.getInstance().getCachedDocument(vFile);
        if (document != null) {
            FileDocumentManager.getInstance().reloadFromDisk(document, psiFile.getProject());
        } else {
            this.reloadPsiAfterTextChange(psiFile.getViewProvider(), vFile);
        }
    }

    void reloadPsiAfterTextChange(@NotNull FileViewProvider viewProvider, @NotNull VirtualFile vFile) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(33);
        }
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(34);
        }
        if (!FileManagerImpl.areViewProvidersEquivalent(viewProvider, this.createFileViewProvider(vFile, false))) {
            this.forceReload(vFile);
            return;
        }
        ((AbstractFileViewProvider)viewProvider).onContentReload();
    }

    public boolean evaluateValidity(@NotNull PsiFile file2) {
        AbstractFileViewProvider viewProvider;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(35);
        }
        return this.evaluateValidity(viewProvider = (AbstractFileViewProvider)file2.getViewProvider()) && viewProvider.getCachedPsiFiles().contains(file2);
    }

    private boolean evaluateValidity(@NotNull AbstractFileViewProvider viewProvider) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(36);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile file2 = viewProvider.getVirtualFile();
        if (this.getRawCachedViewProvider(file2) != viewProvider) {
            return false;
        }
        if (viewProvider.getUserData(IN_COMA) == null) {
            return true;
        }
        if (this.shouldResurrect(viewProvider, file2)) {
            viewProvider.putUserData(IN_COMA, null);
            LOG.assertTrue(this.getRawCachedViewProvider(file2) == viewProvider);
            for (PsiFile psiFile : viewProvider.getCachedPsiFiles()) {
                if (psiFile.isValid()) continue;
                LOG.error(new PsiInvalidElementAccessException(psiFile));
            }
            return true;
        }
        this.getVFileToViewProviderMap().remove(file2, viewProvider);
        file2.replace(this.myPsiHardRefKey, viewProvider, null);
        viewProvider.putUserData(IN_COMA, null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldResurrect(@NotNull FileViewProvider viewProvider, @NotNull VirtualFile file2) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(37);
        }
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(38);
        }
        if (!file2.isValid()) {
            return false;
        }
        Map<VirtualFile, FileViewProvider> tempProviders = this.myTempProviders.get();
        if (tempProviders.containsKey(file2)) {
            LOG.error(new StackOverflowPreventedException("isValid leads to endless recursion in " + viewProvider.getClass() + ": " + new ArrayList<Language>(viewProvider.getLanguages())));
        }
        tempProviders.put(file2, null);
        try {
            FileViewProvider recreated = this.createFileViewProvider(file2, true);
            tempProviders.put(file2, recreated);
            boolean bl = FileManagerImpl.areViewProvidersEquivalent(viewProvider, recreated) && ContainerUtil.all(((AbstractFileViewProvider)viewProvider).getCachedPsiFiles(), FileManagerImpl::isValidOriginal);
            return bl;
        }
        finally {
            FileViewProvider temp = tempProviders.remove(file2);
            if (temp != null) {
                DebugUtil.performPsiModification("invalidate temp view provider", ((AbstractFileViewProvider)temp)::markInvalidated);
            }
        }
    }

    private static boolean isValidOriginal(@NotNull PsiFile file2) {
        PsiFile original;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(39);
        }
        return (original = file2.getOriginalFile()) == file2 || original.isValid();
    }

    @ApiStatus.Internal
    @RequiresReadLock
    public PsiFile getFastCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(40);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            throw new InvalidVirtualFileAccessException(vFile);
        }
        Project project = this.myManager.getProject();
        if (project.isDisposed()) {
            LOG.error("Project is already disposed: " + project);
        }
        this.dispatchPendingEvents();
        FileViewProvider viewProvider = this.getRawCachedViewProvider(vFile);
        if (viewProvider == null || viewProvider.getUserData(IN_COMA) != null) {
            return null;
        }
        return ((AbstractFileViewProvider)viewProvider).getCachedPsi(viewProvider.getBaseLanguage());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 28: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/impl/FileManagerImpl";
                break;
            }
            case 4: 
            case 25: 
            case 26: 
            case 33: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirMap";
                break;
            }
            case 27: 
            case 35: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view1";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view2";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFileToPsiFileMap";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/impl/FileManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVFileToViewProviderMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVFileToPsiDirMap";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findViewProvider";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileViewProvider";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCachedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 28: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "clearPsiCaches";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forceReload";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findViewProvider";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkLightFileHasNoOtherPsi";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findCachedViewProvider";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRawCachedViewProvider";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setViewProvider";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFileViewProvider";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsiFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findDirectory";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findDirectoryImpl";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedOrIgnored";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDirectory";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeFilesAndDirsRecursively";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "markInvalidated";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "markPossiblyInvalidated";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsiFileInner";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "areViewProvidersEquivalent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "markInvalidations";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "reloadPsiAfterTextChange";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "evaluateValidity";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "shouldResurrect";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isValidOriginal";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getFastCachedPsiFile";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 28: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

