/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayDeque;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.IrInlinable;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.FunctionReferenceLowering;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrThrowImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;

@PhaseDescription(name="Assertion", prerequisite={FunctionReferenceLowering.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002:\u0001&B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00152\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\u001e\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002J\u0018\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\"\u001a\u00020#*\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010%\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/AssertionLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrTransformer;", "Lorg/jetbrains/kotlin/backend/jvm/lower/AssertionLowering$ClassInfo;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "scopeOwnerStack", "Ljava/util/ArrayDeque;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "data", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitCall", "Lorg/jetbrains/kotlin/ir/IrElement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "checkAssertion", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "assertCondition", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "lambdaArgument", "getAssertionDisabled", "irBuilder", "isAssert", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "ClassInfo", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nAssertionLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssertionLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AssertionLowering\n+ 2 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 3 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,120:1\n383#2,13:121\n98#3,2:134\n*S KotlinDebug\n*F\n+ 1 AssertionLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AssertionLowering\n*L\n102#1:121,13\n102#1:134,2\n*E\n"})
public final class AssertionLowering
extends IrTransformer<ClassInfo>
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final ArrayDeque<IrDeclaration> scopeOwnerStack;

    public AssertionLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.scopeOwnerStack = new ArrayDeque();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.context.getConfig().getAssertionsMode() != JVMAssertionsMode.LEGACY) {
            irFile.transformChildren(this, null);
        }
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable ClassInfo data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        this.scopeOwnerStack.push(declaration2);
        Object result2 = super.visitDeclaration(declaration2, data);
        this.scopeOwnerStack.pop();
        return result2;
    }

    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration2, @Nullable ClassInfo data) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Object object = data;
            if (object == null || (object = ((ClassInfo)object).getTopLevelClass()) == null) {
                object = declaration2;
            }
            ClassInfo info = new ClassInfo(declaration2, (IrClass)object, null, 4, null);
            this.visitDeclaration((IrDeclarationBase)declaration2, info);
            IrField irField = info.getAssertionsDisabledField();
            if (irField == null) break block1;
            IrField it = irField;
            boolean bl = false;
            declaration2.getDeclarations().add(0, it);
        }
        return declaration2;
    }

    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression2, @Nullable ClassInfo data) {
        IrElement irElement;
        IrExpression lambdaArgument;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunction function2 = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (!this.isAssert(function2)) {
            return super.visitCall(expression2, data);
        }
        JVMAssertionsMode mode = this.context.getConfig().getAssertionsMode();
        if (mode == JVMAssertionsMode.ALWAYS_DISABLE) {
            return BuildersKt.IrCompositeImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), this.context.getIrBuiltIns().getUnitType(), null, 8, null);
        }
        DeclarationIrBuilder $this$visitCall_u24lambda_u241 = LowerUtilsKt.createIrBuilder$default(this.context, this.scopeOwnerStack.peek().getSymbol(), 0, 0, 6, null);
        boolean bl = false;
        LowerUtilsKt.at((IrBuilder)$this$visitCall_u24lambda_u241, expression2);
        IrExpression irExpression = expression2.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression);
        IrExpression assertCondition = irExpression;
        IrExpression irExpression2 = lambdaArgument = function2.getValueParameters().size() == 2 ? expression2.getValueArgument(1) : null;
        if (mode == JVMAssertionsMode.ALWAYS_ENABLE) {
            irElement = this.checkAssertion($this$visitCall_u24lambda_u241, assertCondition, lambdaArgument);
        } else {
            if (!(mode == JVMAssertionsMode.JVM && data != null)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            irElement = LowerUtilsKt.irIfThen($this$visitCall_u24lambda_u241, LowerUtilsKt.irNot($this$visitCall_u24lambda_u241, this.getAssertionDisabled($this$visitCall_u24lambda_u241, data)), this.checkAssertion($this$visitCall_u24lambda_u241, assertCondition, lambdaArgument));
        }
        return irElement;
    }

    /*
     * WARNING - void declaration
     */
    private final IrContainerExpression checkAssertion(IrBuilderWithScope $this$checkAssertion, IrExpression assertCondition, IrExpression lambdaArgument) {
        void $this$checkAssertion_u24lambda_u243_u24lambda_u242;
        IrConstructorCall irConstructorCall;
        void this_$iv$iv;
        IrBuilderWithScope $this$irBlock_u24default$iv = $this$checkAssertion;
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$checkAssertion_u24lambda_u243 = this_$iv$iv;
        boolean bl = false;
        IrExpression irExpression = lambdaArgument;
        IrInlinable generator = irExpression != null ? IrInlineUtilsKt.asInlinable(irExpression, (IrStatementsBuilder)$this$checkAssertion_u24lambda_u243) : null;
        IrConstructorSymbol constructor = this.context.getIr().getSymbols().getAssertionErrorConstructor();
        IrConstructorCall irConstructorCall2 = irConstructorCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$checkAssertion_u24lambda_u243, constructor);
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$checkAssertion_u24lambda_u243;
        boolean bl2 = false;
        Object object = generator;
        if (object == null || (object = IrInlineUtilsKt.inline$default((IrInlinable)object, ExpressionHelpersKt.getParent((IrBuilderWithScope)$this$checkAssertion_u24lambda_u243), null, 2, null)) == null) {
            object = ExpressionHelpersKt.irString((IrBuilderWithScope)$this$checkAssertion_u24lambda_u243, "Assertion failed");
        }
        $this$checkAssertion_u24lambda_u243_u24lambda_u242.putValueArgument(0, (IrExpression)object);
        IrThrowImpl throwError = LowerUtilsKt.irThrow(irBuilderWithScope, irConstructorCall);
        $this$checkAssertion_u24lambda_u243.unaryPlus(LowerUtilsKt.irIfThen((IrBuilderWithScope)$this$checkAssertion_u24lambda_u243, LowerUtilsKt.irNot((IrBuilderWithScope)$this$checkAssertion_u24lambda_u243, assertCondition), throwError));
        return this_$iv$iv.doBuild();
    }

    private final IrExpression getAssertionDisabled(IrBuilderWithScope irBuilder, ClassInfo data) {
        if (data.getAssertionsDisabledField() == null) {
            data.setAssertionsDisabledField(JvmIrUtilsKt.buildAssertionsDisabledField(data.getIrClass(), this.context, data.getTopLevelClass()));
        }
        IrField irField = data.getAssertionsDisabledField();
        Intrinsics.checkNotNull((Object)irField);
        return ExpressionHelpersKt.irGetField$default(irBuilder, null, irField, null, 4, null);
    }

    private final boolean isAssert(IrFunction $this$isAssert) {
        return Intrinsics.areEqual((Object)$this$isAssert.getName().asString(), (Object)"assert") && Intrinsics.areEqual((Object)IrUtilsKt.getPackageFragment($this$isAssert).getPackageFqName(), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/AssertionLowering$ClassInfo;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "topLevelClass", "assertionsDisabledField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrField;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getTopLevelClass", "getAssertionsDisabledField", "()Lorg/jetbrains/kotlin/ir/declarations/IrField;", "setAssertionsDisabledField", "(Lorg/jetbrains/kotlin/ir/declarations/IrField;)V", "backend.jvm.lower"})
    public static final class ClassInfo {
        @NotNull
        private final IrClass irClass;
        @NotNull
        private final IrClass topLevelClass;
        @Nullable
        private IrField assertionsDisabledField;

        public ClassInfo(@NotNull IrClass irClass, @NotNull IrClass topLevelClass, @Nullable IrField assertionsDisabledField) {
            Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
            Intrinsics.checkNotNullParameter((Object)topLevelClass, (String)"topLevelClass");
            this.irClass = irClass;
            this.topLevelClass = topLevelClass;
            this.assertionsDisabledField = assertionsDisabledField;
        }

        public /* synthetic */ ClassInfo(IrClass irClass, IrClass irClass2, IrField irField, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                irField = null;
            }
            this(irClass, irClass2, irField);
        }

        @NotNull
        public final IrClass getIrClass() {
            return this.irClass;
        }

        @NotNull
        public final IrClass getTopLevelClass() {
            return this.topLevelClass;
        }

        @Nullable
        public final IrField getAssertionsDisabledField() {
            return this.assertionsDisabledField;
        }

        public final void setAssertionsDisabledField(@Nullable IrField irField) {
            this.assertionsDisabledField = irField;
        }
    }
}

