/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.context;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.AbstractKtDiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirInlineDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.extra.FirAnonymousUnusedParamChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ImplicitReceiverStack;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010?\u001a\u00020\"2\u0006\u0010@\u001a\u00020AH\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0014R\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0014R\u0012\u0010!\u001a\u00020\"X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u0014\u0010$\u001a\u0004\u0018\u00010%X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u0004\u0018\u00010)X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0018\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0012\u00101\u001a\u00020\"X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010#R\u0012\u00103\u001a\u00020\"X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010#R\u0012\u00105\u001a\u00020\"X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010#R\u0011\u00107\u001a\u0002088F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0011\u0010;\u001a\u00020<8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0014\u0010B\u001a\u00020C8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0014\u0010F\u001a\u0004\u0018\u00010GX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010IR\u0016\u0010J\u001a\u0004\u0018\u00010.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\u00a8\u0006M"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticContext;", "<init>", "()V", "sessionHolder", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "getSessionHolder", "()Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "returnTypeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "getReturnTypeCalculator", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "implicitReceiverStack", "Lorg/jetbrains/kotlin/fir/resolve/ImplicitReceiverStack;", "getImplicitReceiverStack", "()Lorg/jetbrains/kotlin/fir/resolve/ImplicitReceiverStack;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getContainingDeclarations", "()Ljava/util/List;", "callsOrAssignments", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "getCallsOrAssignments", "getClassCalls", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "getGetClassCalls", "annotationContainers", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "getAnnotationContainers", "containingElements", "Lorg/jetbrains/kotlin/fir/FirElement;", "getContainingElements", "isContractBody", "", "()Z", "inlineFunctionBodyContext", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext;", "getInlineFunctionBodyContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext;", "lambdaBodyContext", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirAnonymousUnusedParamChecker$LambdaBodyContext;", "getLambdaBodyContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirAnonymousUnusedParamChecker$LambdaBodyContext;", "suppressedDiagnostics", "", "", "getSuppressedDiagnostics", "()Ljava/util/Set;", "allInfosSuppressed", "getAllInfosSuppressed", "allWarningsSuppressed", "getAllWarningsSuppressed", "allErrorsSuppressed", "getAllErrorsSuppressed", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "isDiagnosticSuppressed", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "containingFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getContainingFile", "()Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "containingFilePath", "getContainingFilePath", "()Ljava/lang/String;", "checkers"})
public abstract class CheckerContext
implements DiagnosticContext {
    @NotNull
    public abstract SessionHolder getSessionHolder();

    @NotNull
    public abstract ReturnTypeCalculator getReturnTypeCalculator();

    @NotNull
    public abstract ImplicitReceiverStack getImplicitReceiverStack();

    @NotNull
    public abstract List<FirDeclaration> getContainingDeclarations();

    @NotNull
    public abstract List<FirStatement> getCallsOrAssignments();

    @NotNull
    public abstract List<FirGetClassCall> getGetClassCalls();

    @NotNull
    public abstract List<FirAnnotationContainer> getAnnotationContainers();

    @NotNull
    public abstract List<FirElement> getContainingElements();

    public abstract boolean isContractBody();

    @Nullable
    public abstract FirInlineDeclarationChecker.InlineFunctionBodyContext getInlineFunctionBodyContext();

    @Nullable
    public abstract FirAnonymousUnusedParamChecker.LambdaBodyContext getLambdaBodyContext();

    @NotNull
    public abstract Set<String> getSuppressedDiagnostics();

    public abstract boolean getAllInfosSuppressed();

    public abstract boolean getAllWarningsSuppressed();

    public abstract boolean getAllErrorsSuppressed();

    @NotNull
    public final FirSession getSession() {
        return this.getSessionHolder().getSession();
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.getSessionHolder().getScopeSession();
    }

    @Override
    public boolean isDiagnosticSuppressed(@NotNull KtDiagnostic diagnostic) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        AbstractKtDiagnosticFactory factory2 = diagnostic.getFactory();
        String name2 = factory2.getName();
        if (Intrinsics.areEqual((Object)name2, (Object)FirErrors.INSTANCE.getERROR_SUPPRESSION().getName())) {
            return false;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[factory2.getSeverity().ordinal()]) {
            case 1: {
                bl = this.getAllInfosSuppressed();
                break;
            }
            case 2: {
                bl = this.getAllWarningsSuppressed();
                break;
            }
            case 3: {
                bl = this.getAllErrorsSuppressed();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean suppressedByAll = bl;
        return suppressedByAll || this.getSuppressedDiagnostics().contains(name2);
    }

    @Override
    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        return FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getSession());
    }

    @Nullable
    public abstract FirFile getContainingFile();

    @Override
    @Nullable
    public String getContainingFilePath() {
        Object object = this.getContainingFile();
        return object != null && (object = ((FirFile)object).getSourceFile()) != null ? object.getPath() : null;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            try {
                nArray[Severity.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

