/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.sessions;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaImplementationDetail;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.impl.base.lifetime.KaBaseLifetimeTracker;
import org.jetbrains.kotlin.analysis.api.impl.base.permissions.KaBaseWriteActionStartedChecker;
import org.jetbrains.kotlin.analysis.api.impl.base.sessions.ProhibitedAnalysisException;
import org.jetbrains.kotlin.analysis.api.platform.KaCachedService;
import org.jetbrains.kotlin.analysis.api.platform.lifetime.KotlinLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.platform.permissions.KaAnalysisPermissionChecker;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.psi.KtElement;

@KaImplementationDetail
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010$\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010$\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R!\u0010\u0006\u001a\u00020\u00078BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR!\u0010\u000e\u001a\u00020\u000f8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\r\u0012\u0004\b\u0010\u0010\t\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0014\u001a\u00020\u00158DX\u0085\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\r\u0012\u0004\b\u0016\u0010\t\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/sessions/KaBaseSessionProvider;", "Lorg/jetbrains/kotlin/analysis/api/session/KaSessionProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "permissionChecker", "Lorg/jetbrains/kotlin/analysis/api/platform/permissions/KaAnalysisPermissionChecker;", "getPermissionChecker$annotations", "()V", "getPermissionChecker", "()Lorg/jetbrains/kotlin/analysis/api/platform/permissions/KaAnalysisPermissionChecker;", "permissionChecker$delegate", "Lkotlin/Lazy;", "lifetimeTracker", "Lorg/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker;", "getLifetimeTracker$annotations", "getLifetimeTracker", "()Lorg/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker;", "lifetimeTracker$delegate", "tokenFactory", "Lorg/jetbrains/kotlin/analysis/api/platform/lifetime/KotlinLifetimeTokenFactory;", "getTokenFactory$annotations", "getTokenFactory", "()Lorg/jetbrains/kotlin/analysis/api/platform/lifetime/KotlinLifetimeTokenFactory;", "tokenFactory$delegate", "writeActionStartedChecker", "Lorg/jetbrains/kotlin/analysis/api/impl/base/permissions/KaBaseWriteActionStartedChecker;", "beforeEnteringAnalysis", "", "session", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "useSiteElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "useSiteModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "afterLeavingAnalysis", "analysis-api-impl-base"})
public abstract class KaBaseSessionProvider
extends KaSessionProvider {
    @NotNull
    private final Lazy permissionChecker$delegate;
    @NotNull
    private final Lazy lifetimeTracker$delegate;
    @NotNull
    private final Lazy tokenFactory$delegate;
    @NotNull
    private final KaBaseWriteActionStartedChecker writeActionStartedChecker;

    public KaBaseSessionProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.permissionChecker$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaBaseSessionProvider.permissionChecker_delegate$lambda$0(project));
        this.lifetimeTracker$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaBaseSessionProvider.lifetimeTracker_delegate$lambda$1(project));
        this.tokenFactory$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaBaseSessionProvider.tokenFactory_delegate$lambda$2(project));
        this.writeActionStartedChecker = new KaBaseWriteActionStartedChecker(this);
    }

    private final KaAnalysisPermissionChecker getPermissionChecker() {
        Lazy lazy = this.permissionChecker$delegate;
        return (KaAnalysisPermissionChecker)lazy.getValue();
    }

    @KaCachedService
    private static /* synthetic */ void getPermissionChecker$annotations() {
    }

    private final KaBaseLifetimeTracker getLifetimeTracker() {
        Lazy lazy = this.lifetimeTracker$delegate;
        return (KaBaseLifetimeTracker)lazy.getValue();
    }

    @KaCachedService
    private static /* synthetic */ void getLifetimeTracker$annotations() {
    }

    @NotNull
    protected final KotlinLifetimeTokenFactory getTokenFactory() {
        Lazy lazy = this.tokenFactory$delegate;
        return (KotlinLifetimeTokenFactory)lazy.getValue();
    }

    @KaCachedService
    protected static /* synthetic */ void getTokenFactory$annotations() {
    }

    @Override
    public void beforeEnteringAnalysis(@NotNull KaSession session, @NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteElement, (String)"useSiteElement");
        PsiUtilCore.ensureValid(useSiteElement);
        this.beforeEnteringAnalysis(session);
    }

    @Override
    public void beforeEnteringAnalysis(@NotNull KaSession session, @NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        this.beforeEnteringAnalysis(session);
    }

    private final void beforeEnteringAnalysis(KaSession session) {
        if (!this.getPermissionChecker().isAnalysisAllowed()) {
            throw new ProhibitedAnalysisException("Analysis is not allowed: " + this.getPermissionChecker().getRejectionReason());
        }
        if (DumbService.Companion.isDumb(this.getProject())) {
            throw IndexNotReadyException.create();
        }
        this.getLifetimeTracker().beforeEnteringAnalysis(session);
        this.writeActionStartedChecker.beforeEnteringAnalysis();
    }

    @Override
    public void afterLeavingAnalysis(@NotNull KaSession session, @NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteElement, (String)"useSiteElement");
        this.afterLeavingAnalysis(session);
    }

    @Override
    public void afterLeavingAnalysis(@NotNull KaSession session, @NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        this.afterLeavingAnalysis(session);
    }

    private final void afterLeavingAnalysis(KaSession session) {
        this.writeActionStartedChecker.afterLeavingAnalysis();
        this.getLifetimeTracker().afterLeavingAnalysis(session);
    }

    private static final KaAnalysisPermissionChecker permissionChecker_delegate$lambda$0(Project $project) {
        return KaAnalysisPermissionChecker.Companion.getInstance($project);
    }

    private static final KaBaseLifetimeTracker lifetimeTracker_delegate$lambda$1(Project $project) {
        return KaBaseLifetimeTracker.Companion.getInstance($project);
    }

    private static final KotlinLifetimeTokenFactory tokenFactory_delegate$lambda$2(Project $project) {
        return KotlinLifetimeTokenFactory.Companion.getInstance($project);
    }
}

