/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J>\u0010\u001f\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030!\u0012\u0004\u0012\u00020\u0013\u0018\u00010 *\u00020\"2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u00132\u000e\b\u0002\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0%H\u0002\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkSupertypes", "checkParameterBounds", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRefsOwner;", "visibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "checkTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "checkFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkMemberReceiver", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "memberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "findVisibilityExposure", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "base", "visitedTypes", "", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExposedVisibilityDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExposedVisibilityDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,287:1\n28#2:288\n28#2:289\n28#2:290\n28#2:291\n46#2:292\n28#2:294\n28#2:295\n28#2:296\n1#3:293\n45#4:297\n45#4:298\n*S KotlinDebug\n*F\n+ 1 FirExposedVisibilityDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker\n*L\n46#1:288\n50#1:289\n108#1:290\n128#1:291\n129#1:292\n172#1:294\n200#1:295\n228#1:296\n258#1:297\n259#1:298\n*E\n"})
public final class FirExposedVisibilityDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExposedVisibilityDeclarationChecker INSTANCE = new FirExposedVisibilityDeclarationChecker();

    private FirExposedVisibilityDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirAnonymousFunction) {
            return;
        }
        if (firDeclaration instanceof FirTypeAlias) {
            this.checkTypeAlias((FirTypeAlias)declaration2, reporter, context2);
        } else if (firDeclaration instanceof FirProperty) {
            this.checkProperty((FirProperty)declaration2, reporter, context2);
        } else if (firDeclaration instanceof FirFunction) {
            this.checkFunction((FirFunction)declaration2, reporter, context2);
        } else if (firDeclaration instanceof FirRegularClass) {
            this.checkClass((FirRegularClass)declaration2, reporter, context2);
        }
    }

    private final void checkClass(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        this.checkSupertypes(declaration2, reporter, context2);
        FirTypeParameterRefsOwner firTypeParameterRefsOwner = declaration2;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        this.checkParameterBounds(firTypeParameterRefsOwner, (EffectiveVisibility)object, reporter, context2);
    }

    private final void checkSupertypes(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Object classVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(classVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        List<FirTypeRef> supertypes = declaration2.getSuperTypeRefs();
        boolean isInterface = declaration2.getClassKind() == ClassKind.INTERFACE;
        for (FirTypeRef supertypeRef : supertypes) {
            Pair pair;
            FirRegularClassSymbol classSymbol;
            boolean superIsInterface;
            ConeKotlinType supertype;
            KtSourceElement ktSourceElement = supertypeRef.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.EnumSuperTypeRef.INSTANCE) || ToSymbolUtilsKt.toRegularClassSymbol(supertype = FirTypeUtilsKt.getConeType(supertypeRef), context2.getSession()) == null || (superIsInterface = classSymbol.getClassKind() == ClassKind.INTERFACE) != isInterface || FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, supertype, context2, (EffectiveVisibility)classVisibility, null, 4, null) == null) continue;
            FirBasedSymbol restricting = (FirBasedSymbol)pair.component1();
            EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair.component2();
            KtSourceElement ktSourceElement2 = supertypeRef.getSource();
            if (ktSourceElement2 == null) {
                ktSourceElement2 = declaration2.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement2, isInterface ? FirErrors.INSTANCE.getEXPOSED_SUPER_INTERFACE() : FirErrors.INSTANCE.getEXPOSED_SUPER_CLASS(), classVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
        }
    }

    private final void checkParameterBounds(FirTypeParameterRefsOwner declaration2, EffectiveVisibility visibility, DiagnosticReporter reporter, CheckerContext context2) {
        if (Intrinsics.areEqual((Object)visibility, (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        boolean reportProperError = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ReportExposedTypeForMoreCasesOfTypeParameterBounds);
        KtDiagnosticFactory3<EffectiveVisibility, FirBasedSymbol<?>, EffectiveVisibility> diagnosticForBounds = reportProperError || declaration2 instanceof FirRegularClass ? FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND() : FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND_DEPRECATION_WARNING();
        for (FirTypeParameterRef parameter2 : declaration2.getTypeParameters()) {
            for (FirResolvedTypeRef bound : parameter2.getSymbol().getResolvedBounds()) {
                Pair pair;
                if (FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, bound.getConeType(), context2, visibility, null, 4, null) == null) continue;
                FirBasedSymbol restricting = (FirBasedSymbol)pair.component1();
                EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair.component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), diagnosticForBounds, (Object)visibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
            }
        }
    }

    private final void checkTypeAlias(FirTypeAlias declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Object typeAliasVisibility;
        ConeClassLikeType expandedType = FirDeclarationUtilKt.getExpandedConeType(declaration2);
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(typeAliasVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        this.checkParameterBounds(declaration2, (EffectiveVisibility)typeAliasVisibility, reporter, context2);
        ConeClassLikeType coneClassLikeType = expandedType;
        if (coneClassLikeType == null || (coneClassLikeType = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, coneClassLikeType, context2, (EffectiveVisibility)typeAliasVisibility, null, 4, null)) == null) {
            return;
        }
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType;
        FirBasedSymbol restricting = (FirBasedSymbol)coneClassLikeType2.component1();
        EffectiveVisibility restrictingVisibility = (EffectiveVisibility)coneClassLikeType2.component2();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPOSED_TYPEALIAS_EXPANDED_TYPE(), typeAliasVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
    }

    private final void checkFunction(FirFunction declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        boolean isNonLocal;
        KtSourceElement ktSourceElement = declaration2.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        Object functionVisibility = null;
        Intrinsics.checkNotNull((Object)declaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = functionVisibility = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (declaration2 instanceof FirConstructor) {
            FirMemberDeclaration $this$isFromSealedClass$iv = declaration2;
            boolean $i$f$isFromSealedClass = false;
            if ($this$isFromSealedClass$iv.getStatus().isFromSealedClass()) {
                functionVisibility = EffectiveVisibility.PrivateInClass.INSTANCE;
            }
        }
        boolean bl = isNonLocal = !Intrinsics.areEqual((Object)functionVisibility, (Object)EffectiveVisibility.Local.INSTANCE);
        if (!(declaration2 instanceof FirPropertyAccessor)) {
            EffectiveVisibility restrictingVisibility;
            Pair pair;
            if (isNonLocal && !(declaration2 instanceof FirConstructor) && (pair = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2, (EffectiveVisibility)functionVisibility, null, 4, null)) != null) {
                Pair pair2 = pair;
                boolean bl2 = false;
                FirBasedSymbol restricting = (FirBasedSymbol)pair2.component1();
                restrictingVisibility = (EffectiveVisibility)pair2.component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPOSED_FUNCTION_RETURN_TYPE(), functionVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
            }
            for (FirValueParameter valueParameter2 : declaration2.getValueParameters()) {
                Pair pair3;
                Object propertyVisibility;
                FirProperty property;
                Pair bl2;
                boolean exposureFound = false;
                if (isNonLocal && (bl2 = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(valueParameter2.getReturnTypeRef()), context2, (EffectiveVisibility)functionVisibility, null, 4, null)) != null) {
                    restrictingVisibility = bl2;
                    boolean bl3 = false;
                    FirBasedSymbol restricting = (FirBasedSymbol)restrictingVisibility.component1();
                    EffectiveVisibility restrictingVisibility2 = (EffectiveVisibility)restrictingVisibility.component2();
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)valueParameter2.getSource(), FirErrors.INSTANCE.getEXPOSED_PARAMETER_TYPE(), functionVisibility, (Object)restricting, (Object)restrictingVisibility2, (DiagnosticContext)context2, null, 64, null);
                    exposureFound = true;
                }
                if (exposureFound || ClassMembersKt.getCorrespondingProperty(valueParameter2) == null || property.isLocal()) continue;
                FirMemberDeclaration $this$effectiveVisibility$iv2 = property;
                boolean $i$f$getEffectiveVisibility2 = false;
                FirDeclarationStatus firDeclarationStatus2 = $this$effectiveVisibility$iv2.getStatus();
                Object object2 = firDeclarationStatus2 instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus2 : null;
                if (object2 == null || (object2 = object2.getEffectiveVisibility()) == null) {
                    object2 = EffectiveVisibility.Local.INSTANCE;
                }
                if (Intrinsics.areEqual((Object)(propertyVisibility = object2), (Object)EffectiveVisibility.Local.INSTANCE) || (pair3 = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(property.getReturnTypeRef()), context2, (EffectiveVisibility)propertyVisibility, null, 4, null)) == null) continue;
                firDeclarationStatus2 = pair3;
                boolean bl4 = false;
                FirBasedSymbol restricting = (FirBasedSymbol)firDeclarationStatus2.component1();
                EffectiveVisibility restrictingVisibility3 = (EffectiveVisibility)firDeclarationStatus2.component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)valueParameter2.getSource(), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR(), propertyVisibility, (Object)restricting, (Object)restrictingVisibility3, (DiagnosticContext)context2, null, 64, null);
            }
        }
        if (isNonLocal) {
            FirReceiverParameter firReceiverParameter = declaration2.getReceiverParameter();
            this.checkMemberReceiver(firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, declaration2 instanceof FirCallableDeclaration ? (FirCallableDeclaration)declaration2 : null, reporter, context2);
        }
        this.checkParameterBounds(declaration2, (EffectiveVisibility)functionVisibility, reporter, context2);
    }

    private final void checkProperty(FirProperty declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Object propertyVisibility;
        if (Intrinsics.areEqual((Object)DeclarationAttributesKt.getFromPrimaryConstructor(declaration2), (Object)true)) {
            return;
        }
        if (declaration2.isLocal()) {
            return;
        }
        KtSourceElement ktSourceElement = declaration2.getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.EnumGeneratedDeclaration.INSTANCE)) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(propertyVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE) || Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)FirDeclarationOrigin.ScriptCustomization.ResultProperty.INSTANCE)) {
            return;
        }
        Pair pair = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2, (EffectiveVisibility)propertyVisibility, null, 4, null);
        if (pair != null) {
            firDeclarationStatus = pair;
            boolean bl = false;
            FirBasedSymbol restricting = (FirBasedSymbol)firDeclarationStatus.component1();
            EffectiveVisibility restrictingVisibility = (EffectiveVisibility)firDeclarationStatus.component2();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE(), propertyVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
        }
        FirReceiverParameter firReceiverParameter = declaration2.getReceiverParameter();
        this.checkMemberReceiver(firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, declaration2, reporter, context2);
        this.checkParameterBounds(declaration2, (EffectiveVisibility)propertyVisibility, reporter, context2);
    }

    private final void checkMemberReceiver(FirTypeRef typeRef, FirCallableDeclaration memberDeclaration, DiagnosticReporter reporter, CheckerContext context2) {
        Object memberVisibility;
        if (typeRef == null || memberDeclaration == null) {
            return;
        }
        ConeKotlinType receiverParameterType = FirTypeUtilsKt.getConeType(typeRef);
        FirMemberDeclaration $this$effectiveVisibility$iv = memberDeclaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(memberVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        Pair pair = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, receiverParameterType, context2, (EffectiveVisibility)memberVisibility, null, 4, null);
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        FirBasedSymbol restricting = (FirBasedSymbol)pair2.component1();
        EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair2.component2();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE(), memberVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
    }

    private final Pair<FirBasedSymbol<?>, EffectiveVisibility> findVisibilityExposure(ConeKotlinType $this$findVisibilityExposure, CheckerContext context2, EffectiveVisibility base, Set<ConeKotlinType> visitedTypes) {
        EffectiveVisibility effectiveVisibility;
        EffectiveVisibility effectiveVisibility2;
        boolean $i$f$getEffectiveVisibility;
        FirClassLikeSymbol<?> $this$effectiveVisibility$iv;
        Object object;
        ConeClassLikeType coneClassLikeType;
        if (!visitedTypes.add($this$findVisibilityExposure)) {
            return null;
        }
        ConeKotlinType coneKotlinType = $this$findVisibilityExposure;
        if (coneKotlinType instanceof ConeClassLikeType) {
            coneClassLikeType = (ConeClassLikeType)$this$findVisibilityExposure;
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            object = ((ConeFlexibleType)$this$findVisibilityExposure).getLowerBound();
            coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
            if (coneClassLikeType == null) {
                return null;
            }
        } else {
            return null;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default(type2, context2.getSession(), null, 2, null).getLookupTag(), context2.getSession());
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> classSymbol = firClassLikeSymbol;
        object = classSymbol;
        if (object instanceof FirRegularClassSymbol) {
            $this$effectiveVisibility$iv = classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
        } else if (object instanceof FirTypeAliasSymbol) {
            $this$effectiveVisibility$iv = classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
        } else {
            effectiveVisibility2 = effectiveVisibility = null;
        }
        if (effectiveVisibility != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[effectiveVisibility.relation(base, TypeComponentsKt.getTypeContext(context2.getSession())).ordinal()]) {
                case 1: 
                case 2: {
                    return TuplesKt.to(classSymbol, (Object)effectiveVisibility);
                }
            }
        }
        object = type2.getTypeArguments();
        int n = ((ConeTypeProjection[])object).length;
        for (int i = 0; i < n; ++i) {
            Object it;
            Object object2;
            int index2 = i;
            ConeTypeProjection it2 = object[i];
            ConeTypeProjection coneTypeProjection = it2;
            if (coneTypeProjection instanceof ConeClassLikeType) {
                object2 = this.findVisibilityExposure((ConeKotlinType)it2, context2, base, visitedTypes);
                if (object2 == null) continue;
                it = object2;
                boolean bl = false;
                return it;
            }
            if (coneTypeProjection instanceof ConeKotlinTypeProjection) {
                object2 = this.findVisibilityExposure(((ConeKotlinTypeProjection)it2).getType(), context2, base, visitedTypes);
                if (object2 == null) continue;
                it = object2;
                boolean bl = false;
                return it;
            }
            if (coneTypeProjection instanceof ConeStarProjection) {
                Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
                block20: {
                    Pair<FirBasedSymbol<?>, EffectiveVisibility> pair2;
                    List<FirResolvedTypeRef> list;
                    FirTypeParameterSymbol firTypeParameterSymbol;
                    List<FirTypeParameterSymbol> list2;
                    object2 = ToSymbolUtilsKt.toRegularClassSymbol(type2, context2.getSession());
                    if (object2 == null || (list2 = ((FirClassLikeSymbol)object2).getTypeParameterSymbols()) == null || (firTypeParameterSymbol = (FirTypeParameterSymbol)CollectionsKt.getOrNull(list2, (int)index2)) == null || (list = firTypeParameterSymbol.getResolvedBounds()) == null) continue;
                    for (Pair<FirBasedSymbol<?>, EffectiveVisibility> it3 : (Iterable)list) {
                        boolean bl = false;
                        if ((it3 = INSTANCE.findVisibilityExposure(it3.getConeType(), context2, base, visitedTypes)) == null) continue;
                        pair2 = it3;
                        break block20;
                    }
                    pair2 = pair = null;
                }
                if (pair == null) continue;
                Pair<FirBasedSymbol<?>, EffectiveVisibility> it4 = pair;
                boolean bl = false;
                return it4;
            }
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }

    static /* synthetic */ Pair findVisibilityExposure$default(FirExposedVisibilityDeclarationChecker firExposedVisibilityDeclarationChecker, ConeKotlinType coneKotlinType, CheckerContext checkerContext, EffectiveVisibility effectiveVisibility, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = new LinkedHashSet();
        }
        return firExposedVisibilityDeclarationChecker.findVisibilityExposure(coneKotlinType, checkerContext, effectiveVisibility, set);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectiveVisibility.Permissiveness.values().length];
            try {
                nArray[EffectiveVisibility.Permissiveness.LESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectiveVisibility.Permissiveness.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

