/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.konan.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ResolveUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;
import org.jetbrains.kotlin.resolve.konan.diagnostics.NativeThreadLocalCheckerKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeThreadLocalChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "threadLocalFqName", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.native"})
public final class NativeThreadLocalChecker
implements DeclarationChecker {
    @NotNull
    public static final NativeThreadLocalChecker INSTANCE = new NativeThreadLocalChecker();
    @NotNull
    private static final FqName threadLocalFqName = new FqName("kotlin.native.concurrent.ThreadLocal");

    private NativeThreadLocalChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        NativeThreadLocalCheckerKt.check(this, threadLocalFqName, declaration2, descriptor2, context2, ErrorsNative.INAPPLICABLE_THREAD_LOCAL, (Function1<? super DeclarationDescriptor, Boolean>)((Function1)arg_0 -> NativeThreadLocalChecker.check$lambda$0(descriptor2, context2, declaration2, arg_0)));
        NativeThreadLocalCheckerKt.check(this, threadLocalFqName, declaration2, descriptor2, context2, ErrorsNative.INAPPLICABLE_THREAD_LOCAL_TOP_LEVEL, (Function1<? super DeclarationDescriptor, Boolean>)((Function1)arg_0 -> NativeThreadLocalChecker.check$lambda$1(descriptor2, arg_0)));
    }

    private static final boolean check$lambda$0(DeclarationDescriptor $descriptor, DeclarationCheckerContext $context, KtDeclaration $declaration, DeclarationDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean isVariable = $descriptor instanceof VariableDescriptor;
        boolean hasBackingField2 = $descriptor instanceof PropertyDescriptor && ResolveUtilKt.hasBackingField((PropertyDescriptor)$descriptor, $context.getTrace().getBindingContext());
        boolean hasDelegate = $declaration instanceof KtProperty && ((KtProperty)$declaration).getDelegate() != null;
        return isVariable && (hasBackingField2 || hasDelegate) || $descriptor instanceof ClassDescriptor && ((ClassDescriptor)$descriptor).getKind() == ClassKind.OBJECT;
    }

    private static final boolean check$lambda$1(DeclarationDescriptor $descriptor, DeclarationDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DescriptorUtils.isTopLevelDeclaration($descriptor) || $descriptor instanceof ClassDescriptor && ((ClassDescriptor)$descriptor).getKind() == ClassKind.OBJECT;
    }
}

