/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceData;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.TypeTemplate;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DelegatedTypeSubstitution;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.ClassicTypeCheckerState;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerImpl;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\"H\u0002J\"\u0010&\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+JL\u0010,\u001a\u00020\u00182\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030-26\u0010.\u001a2\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(3\u0012\u0004\u0012\u00020\u00180/H\u0002J\u001c\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030-H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceSupport;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;)V", "getArgumentTypeResolver", "()Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "getExpressionTypingServices", "()Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "value", "Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "callCompleter", "getCallCompleter", "()Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "setCallCompleter", "(Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;)V", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "analyzeBuilderInferenceCall", "", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunction;", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;", "lambdaExpectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "checkExpectedTypeForArgument", "", "expectedType", "checkBuilderInferenceCalls", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "tracingStrategy", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "overloadResults", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "forceInferenceForArguments", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "callback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "argument", "argumentType", "getArgumentTypeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "BuilderInferenceTypeCheckerState", "frontend"})
@SourceDebugExtension(value={"SMAP\nBuilderInferenceUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuilderInferenceUtil.kt\norg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,360:1\n1557#2:361\n1628#2,3:362\n1#3:365\n*S KotlinDebug\n*F\n+ 1 BuilderInferenceUtil.kt\norg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceSupport\n*L\n181#1:361\n181#1:362,3\n*E\n"})
public final class BuilderInferenceSupport {
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    public CallCompleter callCompleter;

    public BuilderInferenceSupport(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull ExpressionTypingServices expressionTypingServices) {
        Intrinsics.checkNotNullParameter((Object)argumentTypeResolver, (String)"argumentTypeResolver");
        Intrinsics.checkNotNullParameter((Object)expressionTypingServices, (String)"expressionTypingServices");
        this.argumentTypeResolver = argumentTypeResolver;
        this.expressionTypingServices = expressionTypingServices;
    }

    @NotNull
    public final ArgumentTypeResolver getArgumentTypeResolver() {
        return this.argumentTypeResolver;
    }

    @NotNull
    public final ExpressionTypingServices getExpressionTypingServices() {
        return this.expressionTypingServices;
    }

    @NotNull
    public final CallCompleter getCallCompleter() {
        CallCompleter callCompleter = this.callCompleter;
        if (callCompleter != null) {
            return callCompleter;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"callCompleter");
        return null;
    }

    @Inject
    public final void setCallCompleter(@NotNull CallCompleter callCompleter) {
        Intrinsics.checkNotNullParameter((Object)callCompleter, (String)"<set-?>");
        this.callCompleter = callCompleter;
    }

    private final LanguageVersionSettings getLanguageVersionSettings() {
        LanguageVersionSettings languageVersionSettings = this.expressionTypingServices.getLanguageVersionSettings();
        Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings, (String)"getLanguageVersionSettings(...)");
        return languageVersionSettings;
    }

    /*
     * WARNING - void declaration
     */
    public final void analyzeBuilderInferenceCall(@NotNull KtFunction functionLiteral, @NotNull ValueArgument valueArgument, @NotNull ConstraintSystem.Builder csBuilder, @NotNull CallCandidateResolutionContext<?> context2, @NotNull KotlinType lambdaExpectedType) {
        Collection<KotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)functionLiteral, (String)"functionLiteral");
        Intrinsics.checkNotNullParameter((Object)valueArgument, (String)"valueArgument");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lambdaExpectedType, (String)"lambdaExpectedType");
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        if (!this.checkExpectedTypeForArgument(lambdaExpectedType)) {
            return;
        }
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(lambdaExpectedType);
        if (kotlinType == null) {
            return;
        }
        KotlinType lambdaReceiverType = kotlinType;
        BuilderInferenceData inferenceData = new BuilderInferenceData();
        ConstraintSystem constraintSystem = csBuilder.build();
        TypeSubstitution typeSubstitution = constraintSystem.getCurrentSubstitutor().getSubstitution();
        DelegatedTypeSubstitution newSubstitution2 = new DelegatedTypeSubstitution(constraintSystem, inferenceData, typeSubstitution){
            final /* synthetic */ ConstraintSystem $constraintSystem;
            final /* synthetic */ BuilderInferenceData $inferenceData;
            {
                this.$constraintSystem = $constraintSystem;
                this.$inferenceData = $inferenceData;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1);
            }

            public TypeProjection get(KotlinType key) {
                Object v1;
                TypeProjection substitutedType;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    TypeProjection typeProjection = substitutedType = super.get(key);
                    if (!Intrinsics.areEqual((Object)(typeProjection != null ? typeProjection.getType() : null), (Object)TypeUtils.DONT_CARE)) {
                        return substitutedType;
                    }
                    Iterable $this$firstOrNull$iv = this.$constraintSystem.getTypeVariables();
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        TypeVariable it = (TypeVariable)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getOriginalTypeParameter().getDefaultType(), (Object)key)) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                TypeVariable typeVariable = v1;
                if (typeVariable == null) {
                    return substitutedType;
                }
                TypeVariable typeVariable2 = typeVariable;
                return TypeUtilsKt.asTypeProjection(this.$inferenceData.getTypeTemplate(typeVariable2));
            }

            public boolean approximateContravariantCapturedTypes() {
                return true;
            }
        };
        KotlinType kotlinType2 = newSubstitution2.buildSubstitutor().substitute(lambdaReceiverType, Variance.INVARIANT);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType newReceiverType = kotlinType2;
        TypeSubstitution typeSubstitution2 = constraintSystem.getCurrentSubstitutor().getSubstitution();
        DelegatedTypeSubstitution approximationSubstitutor2 = new DelegatedTypeSubstitution(typeSubstitution2){
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1);
            }

            public boolean approximateContravariantCapturedTypes() {
                return true;
            }
        };
        KotlinType kotlinType3 = approximationSubstitutor2.buildSubstitutor().substitute(lambdaExpectedType, Variance.IN_VARIANCE);
        if (kotlinType3 == null) {
            return;
        }
        KotlinType approximatedLambdaType = kotlinType3;
        Iterable iterable = FunctionTypesKt.getValueParameterTypesFromFunctionType(approximatedLambdaType);
        List list = CollectionsKt.emptyList();
        KotlinType kotlinType4 = newReceiverType;
        Annotations annotations2 = approximatedLambdaType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = TypeUtilsKt.getBuiltIns(newReceiverType);
        boolean $i$f$map = false;
        void var17_21 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean $i$f$analyzeBuilderInferenceCall$stub_for_inlining = false;
            boolean bl = false;
            collection.add(p0.getType());
        }
        collection = (List)destination$iv$iv;
        SimpleType newExpectedType = FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType4, list, (List<? extends KotlinType>)collection, null, FunctionTypesKt.getReturnTypeFromFunctionType(approximatedLambdaType), true);
        if (CallResolverUtilKt.hasUnknownFunctionParameter(newExpectedType)) {
            return;
        }
        inferenceData.initSystem();
        TemporaryTraceAndCache temporaryForBuilderInference = TemporaryTraceAndCache.create(context2, "trace to infer a type argument using the builder inference", functionLiteral);
        Object Context2 = ((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)context2.replaceExpectedType(newExpectedType)).replaceDataFlowInfo(context2.candidateCall.getDataFlowInfoForArguments().getInfo(valueArgument))).replaceContextDependency(ContextDependency.INDEPENDENT)).replaceTraceAndCache(temporaryForBuilderInference);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"replaceTraceAndCache(...)");
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)Context2;
        this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteral, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, true);
        inferenceData.reportInferenceResult(csBuilder);
    }

    private final boolean checkExpectedTypeForArgument(KotlinType expectedType) {
        return this.getLanguageVersionSettings().supportsFeature(LanguageFeature.ExperimentalBuilderInference) ? FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType) : FunctionTypesKt.isSuspendFunctionType(expectedType);
    }

    public final void checkBuilderInferenceCalls(@NotNull BasicCallResolutionContext context2, @NotNull TracingStrategy tracingStrategy, @NotNull OverloadResolutionResultsImpl<?> overloadResults) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)tracingStrategy, (String)"tracingStrategy");
            Intrinsics.checkNotNullParameter(overloadResults, (String)"overloadResults");
            BuilderInferenceData builderInferenceData = BuilderInferenceUtilKt.access$getBuilderInferenceData(overloadResults);
            if (builderInferenceData == null) {
                return;
            }
            BuilderInferenceData inferenceData = builderInferenceData;
            ResolvedCall resolvedCall2 = overloadResults.getResultingCall();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedCall2, (String)"getResultingCall(...)");
            ResolvedCall resultingCall = resolvedCall2;
            this.forceInferenceForArguments(context2, (Function2<? super ValueArgument, ? super KotlinType, Unit>)((Function2)BuilderInferenceSupport::checkBuilderInferenceCalls$lambda$0));
            this.getCallCompleter().completeCall(context2, overloadResults, tracingStrategy);
            if (!ArgumentMappingKt.isReallySuccess(resultingCall)) {
                return;
            }
            Object d = resultingCall.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(d, (String)"getResultingDescriptor(...)");
            Object resultingDescriptor = d;
            if (!BuilderInferenceUtilKt.isApplicableCallForBuilderInference(resultingDescriptor, this.getLanguageVersionSettings())) {
                inferenceData.badCallHappened();
            }
            this.forceInferenceForArguments(context2, (Function2<? super ValueArgument, ? super KotlinType, Unit>)((Function2)(arg_0, arg_1) -> BuilderInferenceSupport.checkBuilderInferenceCalls$lambda$2((MutableResolvedCall)resultingCall, context2, arg_0, arg_1)));
            ReceiverParameterDescriptor receiverParameterDescriptor = resultingDescriptor.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                return;
            }
            ReceiverParameterDescriptor extensionReceiver2 = receiverParameterDescriptor;
            boolean allowOnlyTrivialConstraintsForReceiver = this.getLanguageVersionSettings().supportsFeature(LanguageFeature.ExperimentalBuilderInference) ? !AnnotationsForResolveUtilsKt.hasBuilderInferenceAnnotation(resultingDescriptor) : false;
            ReceiverValue receiverValue = resultingCall.getExtensionReceiver();
            if (receiverValue == null) break block4;
            ReceiverValue actualReceiver = receiverValue;
            boolean bl = false;
            NewKotlinTypeCheckerImpl $this$checkBuilderInferenceCalls_u24lambda_u244_u24lambda_u243 = NewKotlinTypeChecker.Companion.getDefault();
            boolean bl2 = false;
            $this$checkBuilderInferenceCalls_u24lambda_u244_u24lambda_u243.isSubtypeOf(new BuilderInferenceTypeCheckerState(allowOnlyTrivialConstraintsForReceiver), actualReceiver.getType().unwrap(), extensionReceiver2.getValue().getType().unwrap());
        }
    }

    private final void forceInferenceForArguments(CallResolutionContext<?> context2, Function2<? super ValueArgument, ? super KotlinType, Unit> callback) {
        MutableDataFlowInfoForArguments mutableDataFlowInfoForArguments = context2.dataFlowInfoForArguments;
        Intrinsics.checkNotNullExpressionValue((Object)mutableDataFlowInfoForArguments, (String)"dataFlowInfoForArguments");
        MutableDataFlowInfoForArguments infoForArguments = mutableDataFlowInfoForArguments;
        Call call2 = context2.call;
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"call");
        Call call3 = call2;
        Object Context2 = ((CallResolutionContext)context2.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"replaceExpectedType(...)");
        CallResolutionContext baseContext = (CallResolutionContext)Context2;
        for (ValueArgument valueArgument : call3.getValueArguments()) {
            KotlinType it;
            KtExpression expression2;
            if (valueArgument.getArgumentExpression() == null) continue;
            Object Context3 = baseContext.replaceDataFlowInfo(infoForArguments.getInfo(valueArgument));
            Intrinsics.checkNotNullExpressionValue(Context3, (String)"replaceDataFlowInfo(...)");
            KotlinTypeInfo typeInfoForCall = this.getArgumentTypeInfo(expression2, (CallResolutionContext)Context3);
            if (typeInfoForCall.getType() == null) continue;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)valueArgument);
            callback.invoke((Object)valueArgument, (Object)it);
        }
    }

    private final KotlinTypeInfo getArgumentTypeInfo(KtExpression expression2, CallResolutionContext<?> context2) {
        KtFunction ktFunction = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context2);
        if (ktFunction != null) {
            KtFunction it = ktFunction;
            boolean bl = false;
            KotlinTypeInfo kotlinTypeInfo = this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression2, it, context2, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, false);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo, (String)"getFunctionLiteralTypeInfo(...)");
            return kotlinTypeInfo;
        }
        KtCallableReferenceExpression ktCallableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context2);
        if (ktCallableReferenceExpression != null) {
            KtCallableReferenceExpression it = ktCallableReferenceExpression;
            boolean bl = false;
            KotlinTypeInfo kotlinTypeInfo = this.argumentTypeResolver.getCallableReferenceTypeInfo(expression2, it, context2, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo, (String)"getCallableReferenceTypeInfo(...)");
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, context2);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo, (String)"getTypeInfo(...)");
        return kotlinTypeInfo;
    }

    private static final Unit checkBuilderInferenceCalls$lambda$0(ValueArgument valueArgument, KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)valueArgument, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final Unit checkBuilderInferenceCalls$lambda$2(MutableResolvedCall $resultingCall, BasicCallResolutionContext $context, ValueArgument valueArgument, KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)valueArgument, (String)"valueArgument");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        ArgumentMapping argumentMapping2 = $resultingCall.getArgumentMapping(valueArgument);
        ArgumentMatch argumentMatch = argumentMapping2 instanceof ArgumentMatch ? (ArgumentMatch)argumentMapping2 : null;
        if (argumentMatch == null) {
            return Unit.INSTANCE;
        }
        ArgumentMatch argumentMatch2 = argumentMatch;
        NewKotlinTypeCheckerImpl $this$checkBuilderInferenceCalls_u24lambda_u242_u24lambda_u241 = NewKotlinTypeChecker.Companion.getDefault();
        boolean bl = false;
        KotlinType parameterType = CallResolverUtilKt.getEffectiveExpectedType(argumentMatch2.getValueParameter(), valueArgument, $context);
        $this$checkBuilderInferenceCalls_u24lambda_u242_u24lambda_u241.isSubtypeOf(new BuilderInferenceTypeCheckerState(false), kotlinType.unwrap(), parameterType.unwrap());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceSupport$BuilderInferenceTypeCheckerState;", "Lorg/jetbrains/kotlin/types/checker/ClassicTypeCheckerState;", "allowOnlyTrivialConstraints", "", "<init>", "(Z)V", "addSubtypeConstraint", "subType", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "superType", "isFromNullabilityConstraint", "(Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Z)Ljava/lang/Boolean;", "frontend"})
    private static final class BuilderInferenceTypeCheckerState
    extends ClassicTypeCheckerState {
        private final boolean allowOnlyTrivialConstraints;

        public BuilderInferenceTypeCheckerState(boolean allowOnlyTrivialConstraints) {
            super(true, false, null, null, null, 30, null);
            this.allowOnlyTrivialConstraints = allowOnlyTrivialConstraints;
        }

        @Override
        @Nullable
        public Boolean addSubtypeConstraint(@NotNull KotlinTypeMarker subType, @NotNull KotlinTypeMarker superType, boolean isFromNullabilityConstraint) {
            block3: {
                TypeTemplate typeTemplate;
                Object object;
                Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
                Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
                if (!(subType instanceof UnwrappedType)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                if (!(superType instanceof UnwrappedType)) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                KotlinTypeMarker kotlinTypeMarker = subType;
                TypeTemplate typeTemplate2 = kotlinTypeMarker instanceof TypeTemplate ? (TypeTemplate)kotlinTypeMarker : null;
                if (typeTemplate2 == null) {
                    kotlinTypeMarker = superType;
                    typeTemplate2 = kotlinTypeMarker instanceof TypeTemplate ? (TypeTemplate)kotlinTypeMarker : null;
                }
                if ((object = (typeTemplate = typeTemplate2)) == null || (object = ((TypeTemplate)object).getBuilderInferenceData()) == null) break block3;
                ((BuilderInferenceData)object).addConstraint$frontend((KotlinType)subType, (KotlinType)superType, this.allowOnlyTrivialConstraints);
            }
            return null;
        }
    }
}

