/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirBuiltinsSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirClasspathBuiltinSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirFallbackBuiltinSymbolProvider;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProvider;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J*\u0010\u0017\u001a\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J&\u0010 \u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020!0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J&\u0010\"\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020#0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u0012\u0010$\u001a\u0004\u0018\u00010\u001d2\u0006\u0010%\u001a\u00020\u001dH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirJvmActualizingBuiltinSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "refinedSourceSymbolProviders", "", "kotlinClassFinder", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;Ljava/util/List;Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;)V", "builtinSymbolProvider", "getBuiltinSymbolProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getClassLikeSymbolByClassId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "symbolNamesProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getSymbolNamesProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getTopLevelCallableSymbolsTo", "", "destination", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getPackage", "fqName", "java"})
public final class FirJvmActualizingBuiltinSymbolProvider
extends FirSymbolProvider {
    @NotNull
    private final List<FirSymbolProvider> refinedSourceSymbolProviders;
    @Nullable
    private final KotlinClassFinder kotlinClassFinder;
    @NotNull
    private final FirSymbolProvider builtinSymbolProvider;
    @NotNull
    private final FirSymbolNamesProvider symbolNamesProvider;

    public FirJvmActualizingBuiltinSymbolProvider(@NotNull FirSession session, @NotNull FirKotlinScopeProvider kotlinScopeProvider2, @NotNull List<? extends FirSymbolProvider> refinedSourceSymbolProviders, @Nullable KotlinClassFinder kotlinClassFinder) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)kotlinScopeProvider2, (String)"kotlinScopeProvider");
        Intrinsics.checkNotNullParameter(refinedSourceSymbolProviders, (String)"refinedSourceSymbolProviders");
        super(session);
        this.refinedSourceSymbolProviders = refinedSourceSymbolProviders;
        this.kotlinClassFinder = kotlinClassFinder;
        this.builtinSymbolProvider = this.kotlinClassFinder == null ? (FirSymbolProvider)new FirFallbackBuiltinSymbolProvider(session, FirModuleDataKt.getModuleData(session), kotlinScopeProvider2) : (FirSymbolProvider)new FirBuiltinsSymbolProvider(session, new FirClasspathBuiltinSymbolProvider(session, FirModuleDataKt.getModuleData(session), kotlinScopeProvider2, (Function1<? super FqName, ? extends InputStream>)((Function1)arg_0 -> FirJvmActualizingBuiltinSymbolProvider.builtinSymbolProvider$lambda$0(this, arg_0))), new FirFallbackBuiltinSymbolProvider(session, FirModuleDataKt.getModuleData(session), kotlinScopeProvider2));
        this.symbolNamesProvider = this.builtinSymbolProvider.getSymbolNamesProvider();
    }

    @NotNull
    public final FirSymbolProvider getBuiltinSymbolProvider() {
        return this.builtinSymbolProvider;
    }

    @Nullable
    public FirRegularClassSymbol getClassLikeSymbolByClassId(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        for (FirSymbolProvider symbolProvider : this.refinedSourceSymbolProviders) {
            FirClassLikeSymbol<?> classSymbol;
            if (symbolProvider.getClassLikeSymbolByClassId(classId) == null || !FirHelpersKt.hasAnnotationOrInsideAnnotatedClass((FirBasedSymbol)classSymbol, StandardClassIds.Annotations.INSTANCE.getActualizeByJvmBuiltinProvider(), symbolProvider.getSession())) continue;
            FirClassLikeSymbol<?> firClassLikeSymbol = this.builtinSymbolProvider.getClassLikeSymbolByClassId(classId);
            Intrinsics.checkNotNull(firClassLikeSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol");
            return (FirRegularClassSymbol)firClassLikeSymbol;
        }
        return null;
    }

    @Override
    @NotNull
    public FirSymbolNamesProvider getSymbolNamesProvider() {
        return this.symbolNamesProvider;
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
    }

    @Override
    @Nullable
    public FqName getPackage(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return this.builtinSymbolProvider.getPackage(fqName);
    }

    private static final InputStream builtinSymbolProvider$lambda$0(FirJvmActualizingBuiltinSymbolProvider this$0, FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.kotlinClassFinder.findBuiltInsData(it);
    }
}

