/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.description.LogicOperationKind;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirEvaluatorResult;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirClassReferenceExpression;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirConstChecksKt;
import org.jetbrains.kotlin.fir.expressions.FirEnumEntryDeserializedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionEvaluatorKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirIntegerLiteralOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirLazyExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.PrivateConstantEvaluatorAPI;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationArgumentMappingBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArrayLiteralBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirNamedArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirSpreadArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirVarargArgumentsExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ$\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\u0012\u001a\u00020\u0013*\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u0014\u001a\u00020\u0005*\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J)\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u0016*\u0006\u0012\u0002\b\u00030\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030\u0017H\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator;", "", "<init>", "()V", "evaluatePropertyInitializer", "Lorg/jetbrains/kotlin/fir/FirEvaluatorResult;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "evaluateAnnotationArguments", "", "Lorg/jetbrains/kotlin/name/Name;", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "evaluateExpression", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "canBeEvaluated", "", "evaluate", "visit", "T", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "wasVisited", "EvaluationVisitor", "providers"})
@SourceDebugExtension(value={"SMAP\nFirExpressionEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpressionEvaluator.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,543:1\n44#2:544\n1755#3,3:545\n1246#3,4:550\n462#4:548\n412#4:549\n*S KotlinDebug\n*F\n+ 1 FirExpressionEvaluator.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator\n*L\n44#1:544\n64#1:545,3\n68#1:550,4\n68#1:548\n68#1:549\n*E\n"})
public final class FirExpressionEvaluator {
    @NotNull
    public static final FirExpressionEvaluator INSTANCE = new FirExpressionEvaluator();

    private FirExpressionEvaluator() {
    }

    @Nullable
    public final FirEvaluatorResult evaluatePropertyInitializer(@NotNull FirProperty property, @NotNull FirSession session) {
        ConeKotlinType type2;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FirMemberDeclaration $this$isConst$iv = property;
        boolean $i$f$isConst = false;
        if (!$this$isConst$iv.getStatus().isConst()) {
            return null;
        }
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeTypeOrNull(property.getReturnTypeRef());
        ConeKotlinType coneKotlinType2 = type2 = coneKotlinType != null ? TypeExpansionUtilsKt.fullyExpandedType$default(coneKotlinType, session, null, 2, null) : null;
        if (type2 == null || type2 instanceof ConeErrorType || !FirConstChecksKt.canBeUsedForConstVal(type2)) {
            return null;
        }
        FirExpression initializer = property.getInitializer();
        if (initializer == null || !this.canBeEvaluated(initializer, session)) {
            return null;
        }
        return this.evaluate(initializer, session);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Map<Name, FirEvaluatorResult> evaluateAnnotationArguments(@NotNull FirAnnotation annotation, @NotNull FirSession session) {
        void $this$mapValuesTo$iv$iv;
        boolean bl;
        Map<Name, FirExpression> argumentMapping2;
        block5: {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            argumentMapping2 = annotation.getArgumentMapping().getMapping();
            Iterable $this$any$iv = argumentMapping2.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirExpression expr = (FirExpression)element$iv;
                    boolean bl2 = false;
                    if (!(!INSTANCE.canBeEvaluated(expr, session))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        Map<Name, FirExpression> $this$mapValues$iv = argumentMapping2;
        boolean $i$f$mapValues = false;
        Map<Name, FirExpression> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl3 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl4 = false;
            FirExpression expression2 = (FirExpression)entry2.getValue();
            FirEvaluatorResult firEvaluatorResult = INSTANCE.evaluate(expression2, session);
            map3.put(k, firEvaluatorResult);
        }
        return destination$iv$iv;
    }

    @PrivateConstantEvaluatorAPI
    @Nullable
    public final FirEvaluatorResult evaluateExpression(@NotNull FirExpression expression2, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!this.canBeEvaluated(expression2, session)) {
            return null;
        }
        return this.evaluate(expression2, session);
    }

    private final boolean canBeEvaluated(FirExpression $this$canBeEvaluated, FirSession session) {
        boolean intrinsicConstEvaluation = FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.IntrinsicConstEvaluation);
        if ($this$canBeEvaluated == null || intrinsicConstEvaluation || $this$canBeEvaluated instanceof FirLazyExpression || !FirTypeUtilsKt.isResolved($this$canBeEvaluated)) {
            return false;
        }
        return FirConstChecksKt.canBeEvaluatedAtCompileTime($this$canBeEvaluated, session, false, false);
    }

    private final FirEvaluatorResult evaluate(FirExpression $this$evaluate, FirSession session) {
        EvaluationVisitor visitor2 = new EvaluationVisitor(session);
        return visitor2.evaluate($this$evaluate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T visit(FirCallableSymbol<?> $this$visit, Function0<? extends T> block) {
        Object object = $this$visit.getFir();
        FirProperty firProperty = object instanceof FirProperty ? (FirProperty)object : null;
        if (firProperty == null) {
            return (T)block.invoke();
        }
        FirProperty firProperty2 = firProperty;
        FirEvaluatorResult oldEvaluatedResult = DeclarationAttributesKt.getEvaluatedInitializer(firProperty2);
        DeclarationAttributesKt.setEvaluatedInitializer(firProperty2, FirEvaluatorResult.DuringEvaluation.INSTANCE);
        try {
            object = block.invoke();
            return (T)object;
        }
        finally {
            DeclarationAttributesKt.setEvaluatedInitializer(firProperty2, oldEvaluatedResult);
        }
    }

    private final boolean wasVisited(FirCallableSymbol<?> $this$wasVisited) {
        Object e = $this$wasVisited.getFir();
        FirProperty firProperty = e instanceof FirProperty ? (FirProperty)e : null;
        if (firProperty == null) {
            return false;
        }
        FirProperty firProperty2 = firProperty;
        return Intrinsics.areEqual((Object)DeclarationAttributesKt.getEvaluatedInitializer(firProperty2), (Object)FirEvaluatorResult.DuringEvaluation.INSTANCE);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u001a\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u00102\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u00022\u0006\u00106\u001a\u000201H\u0002J\u001a\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u0002092\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010:\u001a\u00020\u00022\u0006\u0010;\u001a\u00020<2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010=\u001a\u00020\u00022\u0006\u0010>\u001a\u00020?2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010@\u001a\u00020\u00022\u0006\u0010A\u001a\u00020B2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010C\u001a\u00020\u00022\u0006\u0010D\u001a\u00020E2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010F\u001a\u00020\u00022\u0006\u0010G\u001a\u00020H2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010I\u001a\u00020\u00022\u0006\u0010J\u001a\u00020K2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010L\u001a\u00020\u00022\u0006\u0010M\u001a\u00020N2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010O\u001a\u00020\u00022\u0006\u0010P\u001a\u00020Q2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010R\u001a\u00020\u00022\u0006\u0010S\u001a\u00020T2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006U"}, d2={"Lorg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator$EvaluationVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "Lorg/jetbrains/kotlin/fir/FirEvaluatorResult;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "evaluate", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitLiteralExpression", "literalExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "visitResolvedNamedReference", "resolvedNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "visitResolvedQualifier", "resolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "visitGetClassCall", "getClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "visitArgumentList", "argumentList", "Lorg/jetbrains/kotlin/fir/expressions/FirArgumentList;", "visitNamedArgumentExpression", "namedArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "visitArrayLiteral", "arrayLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayLiteral;", "visitVarargArgumentsExpression", "varargArgumentsExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;", "visitSpreadArgumentExpression", "spreadArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirSpreadArgumentExpression;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitNamedFunction", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "visitConstructorCall", "constructorCall", "visitIntegerLiteralOperatorCall", "integerLiteralOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirIntegerLiteralOperatorCall;", "visitComparisonExpression", "comparisonExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "visitEqualityOperatorCall", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "visitBinaryLogicExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "visitStringConcatenationCall", "stringConcatenationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "visitTypeOperatorCall", "typeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "visitEnumEntryDeserializedAccessExpression", "enumEntryDeserializedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirEnumEntryDeserializedAccessExpression;", "visitClassReferenceExpression", "classReferenceExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirClassReferenceExpression;", "visitAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "visitAnnotation", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "providers"})
    @SourceDebugExtension(value={"SMAP\nFirExpressionEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpressionEvaluator.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator$EvaluationVisitor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirEvaluatorResult.kt\norg/jetbrains/kotlin/fir/FirEvaluatorResultKt\n+ 5 FirArgumentListBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArgumentListBuilderKt\n+ 6 FirNamedArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirNamedArgumentExpressionBuilderKt\n+ 7 FirArrayLiteralBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArrayLiteralBuilderKt\n+ 8 FirVarargArgumentsExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirVarargArgumentsExpressionBuilderKt\n+ 9 FirSpreadArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirSpreadArgumentExpressionBuilderKt\n+ 10 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 11 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 12 FirFunctionCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirFunctionCallBuilderKt\n+ 13 FirAnnotationBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnnotationBuilderKt\n+ 14 FirAnnotationArgumentMappingBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnnotationArgumentMappingBuilderKt\n*L\n1#1,543:1\n423#2:544\n1246#3,2:545\n1249#3:551\n1557#3:553\n1628#3,2:554\n1630#3:560\n1557#3:572\n1628#3,2:573\n1630#3:579\n1557#3:590\n1628#3,2:591\n1630#3:597\n1557#3:618\n1628#3,2:619\n1630#3:625\n1557#3:638\n1628#3,2:639\n1630#3:645\n28#4,4:547\n28#4,4:556\n28#4,4:562\n28#4,4:567\n28#4,4:575\n28#4,4:581\n28#4,4:585\n28#4,4:593\n28#4,6:599\n28#4,6:607\n28#4,4:613\n28#4,4:621\n28#4,6:626\n28#4,6:632\n28#4,4:641\n28#4,6:647\n36#5:552\n57#6:561\n47#7:566\n49#8:571\n56#9:580\n43#10:589\n45#10:606\n43#10:617\n45#10:646\n1#11:598\n66#12:605\n69#13,7:653\n35#14:660\n*S KotlinDebug\n*F\n+ 1 FirExpressionEvaluator.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator$EvaluationVisitor\n*L\n134#1:544\n134#1:545,2\n134#1:551\n138#1:553\n138#1:554,2\n138#1:560\n169#1:572\n169#1:573,2\n169#1:579\n231#1:590\n231#1:591,2\n231#1:597\n297#1:618\n297#1:619,2\n297#1:625\n327#1:638\n327#1:639,2\n327#1:645\n134#1:547,4\n138#1:556,4\n147#1:562,4\n159#1:567,4\n169#1:575,4\n178#1:581,4\n204#1:585,4\n232#1:593,4\n254#1:599,6\n268#1:607,6\n284#1:613,4\n298#1:621,4\n315#1:626,6\n316#1:632,6\n328#1:641,4\n336#1:647,6\n136#1:552\n144#1:561\n155#1:566\n165#1:571\n175#1:580\n231#1:589\n267#1:606\n297#1:617\n336#1:646\n255#1:605\n371#1:653,7\n372#1:660\n*E\n"})
    private static final class EvaluationVisitor
    extends FirVisitor {
        @NotNull
        private final FirSession session;

        public EvaluationVisitor(@NotNull FirSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @NotNull
        public final FirEvaluatorResult evaluate(@Nullable FirExpression expression2) {
            Object object = expression2;
            if (object == null || (object = (FirEvaluatorResult)((FirExpression)object).accept(this, null)) == null) {
                object = FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            return object;
        }

        @NotNull
        public FirEvaluatorResult visitElement(@NotNull FirElement element2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            throw new IllegalStateException(("FIR element \"" + Reflection.getOrCreateKotlinClass(element2.getClass()) + "\" is not supported in constant evaluation").toString());
        }

        @NotNull
        public FirEvaluatorResult visitLiteralExpression(@NotNull FirLiteralExpression literalExpression, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)literalExpression, (String)"literalExpression");
            return FirExpressionEvaluatorKt.access$wrap(literalExpression);
        }

        @NotNull
        public FirEvaluatorResult visitResolvedNamedReference(@NotNull FirResolvedNamedReference resolvedNamedReference, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)resolvedNamedReference, (String)"resolvedNamedReference");
            return FirExpressionEvaluatorKt.access$wrap(resolvedNamedReference);
        }

        @NotNull
        public FirEvaluatorResult visitResolvedQualifier(@NotNull FirResolvedQualifier resolvedQualifier, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)resolvedQualifier, (String)"resolvedQualifier");
            return FirExpressionEvaluatorKt.access$wrap(resolvedQualifier);
        }

        @NotNull
        public FirEvaluatorResult visitGetClassCall(@NotNull FirGetClassCall getClassCall, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)getClassCall, (String)"getClassCall");
            return FirExpressionEvaluatorKt.access$wrap(getClassCall);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitArgumentList(@NotNull FirArgumentList argumentList, @Nullable Void data) {
            FirArgumentList firArgumentList;
            Intrinsics.checkNotNullParameter((Object)argumentList, (String)"argumentList");
            if (argumentList instanceof FirResolvedArgumentList) {
                void destination$iv;
                void $this$mapKeysTo$iv;
                Map map = ((FirResolvedArgumentList)argumentList).getMapping();
                Map map2 = new LinkedHashMap();
                FirArgumentList firArgumentList2 = ((FirResolvedArgumentList)argumentList).getOriginalArgumentList();
                boolean $i$f$mapKeysTo = false;
                Iterable $this$associateByTo$iv$iv = $this$mapKeysTo$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it$iv;
                    FirElement firElement;
                    FirExpression it;
                    Map.Entry entry = (Map.Entry)element$iv$iv;
                    void var24_35 = destination$iv;
                    boolean $i$a$-mapKeysTo-FirExpressionEvaluator$EvaluationVisitor$visitArgumentList$22 = false;
                    FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it.getKey());
                    boolean $i$f$unwrapOr = false;
                    FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                    if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                        FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                        boolean bl = false;
                        return it2;
                    }
                    if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                        FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                        if (!(firElement2 instanceof FirExpression)) {
                            firElement2 = null;
                        }
                        firElement = (FirExpression)firElement2;
                    } else {
                        firElement = null;
                    }
                    if ((FirExpression)firElement == null) {
                        return FirEvaluatorResult.NotEvaluated.INSTANCE;
                    }
                    Map.Entry entry2 = (Map.Entry)element$iv$iv;
                    void var18_31 = var24_35;
                    boolean bl = false;
                    Object $i$a$-mapKeysTo-FirExpressionEvaluator$EvaluationVisitor$visitArgumentList$22 = it$iv.getValue();
                    var18_31.put(it, $i$a$-mapKeysTo-FirExpressionEvaluator$EvaluationVisitor$visitArgumentList$22);
                }
                firArgumentList = FirArgumentUtilKt.buildResolvedArgumentList(firArgumentList2, (LinkedHashMap)destination$iv);
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                FirArgumentListBuilder firArgumentListBuilder;
                boolean $i$f$buildArgumentList = false;
                FirArgumentListBuilder $this$visitArgumentList_u24lambda_u244 = firArgumentListBuilder = new FirArgumentListBuilder();
                boolean bl = false;
                $this$visitArgumentList_u24lambda_u244.setSource(argumentList.getSource());
                Iterable $i$f$associateByTo = argumentList.getArguments();
                List<FirExpression> list = $this$visitArgumentList_u24lambda_u244.getArguments();
                boolean $i$f$map = false;
                void it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    FirElement firElement;
                    FirExpression it2 = (FirExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    FirEvaluatorResult $this$unwrapOr$iv = this.evaluate(it2);
                    boolean $i$f$unwrapOr = false;
                    FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                    if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                        FirEvaluatorResult.CompileTimeException it3 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                        boolean bl3 = false;
                        return it3;
                    }
                    if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                        FirElement firElement3 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                        if (!(firElement3 instanceof FirExpression)) {
                            firElement3 = null;
                        }
                        firElement = (FirExpression)firElement3;
                    } else {
                        firElement = null;
                    }
                    FirExpression firExpression = (FirExpression)firElement;
                    if (firExpression == null) {
                        return FirEvaluatorResult.NotEvaluated.INSTANCE;
                    }
                    collection.add(firExpression);
                }
                list.addAll((List)destination$iv$iv);
                firArgumentList = firArgumentListBuilder.build();
            }
            return FirExpressionEvaluatorKt.access$wrap(firArgumentList);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitNamedArgumentExpression(@NotNull FirNamedArgumentExpression namedArgumentExpression, @Nullable Void data) {
            FirElement firElement;
            FirNamedArgumentExpressionBuilder firNamedArgumentExpressionBuilder;
            Intrinsics.checkNotNullParameter((Object)namedArgumentExpression, (String)"namedArgumentExpression");
            boolean $i$f$buildNamedArgumentExpression = false;
            FirNamedArgumentExpressionBuilder $this$visitNamedArgumentExpression_u24lambda_u246 = firNamedArgumentExpressionBuilder = new FirNamedArgumentExpressionBuilder();
            boolean bl = false;
            $this$visitNamedArgumentExpression_u24lambda_u246.setSource(namedArgumentExpression.getSource());
            $this$visitNamedArgumentExpression_u24lambda_u246.getAnnotations().addAll((Collection<FirAnnotation>)namedArgumentExpression.getAnnotations());
            FirEvaluatorResult $this$unwrapOr$iv = this.evaluate(namedArgumentExpression.getExpression());
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                void it;
                FirEvaluatorResult.CompileTimeException compileTimeException = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl2 = false;
                return (FirEvaluatorResult)it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                firElement = (FirExpression)firElement2;
            } else {
                firElement = null;
            }
            FirExpression firExpression = (FirExpression)firElement;
            if (firExpression == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            $this$visitNamedArgumentExpression_u24lambda_u246.setExpression(firExpression);
            $this$visitNamedArgumentExpression_u24lambda_u246.setSpread(namedArgumentExpression.isSpread());
            $this$visitNamedArgumentExpression_u24lambda_u246.setName(namedArgumentExpression.getName());
            return FirExpressionEvaluatorKt.access$wrap(firNamedArgumentExpressionBuilder.build());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitArrayLiteral(@NotNull FirArrayLiteral arrayLiteral, @Nullable Void data) {
            FirElement firElement;
            FirArrayLiteralBuilder firArrayLiteralBuilder;
            Intrinsics.checkNotNullParameter((Object)arrayLiteral, (String)"arrayLiteral");
            boolean $i$f$buildArrayLiteral = false;
            FirArrayLiteralBuilder $this$visitArrayLiteral_u24lambda_u248 = firArrayLiteralBuilder = new FirArrayLiteralBuilder();
            boolean bl = false;
            $this$visitArrayLiteral_u24lambda_u248.setSource(arrayLiteral.getSource());
            $this$visitArrayLiteral_u24lambda_u248.setConeTypeOrNull(arrayLiteral.getConeTypeOrNull());
            $this$visitArrayLiteral_u24lambda_u248.getAnnotations().addAll((Collection<FirAnnotation>)arrayLiteral.getAnnotations());
            FirEvaluatorResult $this$unwrapOr$iv = this.visitArgumentList(arrayLiteral.getArgumentList(), data);
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                void it;
                FirEvaluatorResult.CompileTimeException compileTimeException = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl2 = false;
                return (FirEvaluatorResult)it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement2 instanceof FirArgumentList)) {
                    firElement2 = null;
                }
                firElement = (FirArgumentList)firElement2;
            } else {
                firElement = null;
            }
            FirArgumentList firArgumentList = (FirArgumentList)firElement;
            if (firArgumentList == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            $this$visitArrayLiteral_u24lambda_u248.setArgumentList(firArgumentList);
            return FirExpressionEvaluatorKt.access$wrap(firArrayLiteralBuilder.build());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitVarargArgumentsExpression(@NotNull FirVarargArgumentsExpression varargArgumentsExpression, @Nullable Void data) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            FirVarargArgumentsExpressionBuilder firVarargArgumentsExpressionBuilder;
            Intrinsics.checkNotNullParameter((Object)varargArgumentsExpression, (String)"varargArgumentsExpression");
            boolean $i$f$buildVarargArgumentsExpression = false;
            FirVarargArgumentsExpressionBuilder $this$visitVarargArgumentsExpression_u24lambda_u2411 = firVarargArgumentsExpressionBuilder = new FirVarargArgumentsExpressionBuilder();
            boolean bl = false;
            $this$visitVarargArgumentsExpression_u24lambda_u2411.setSource(varargArgumentsExpression.getSource());
            $this$visitVarargArgumentsExpression_u24lambda_u2411.setConeTypeOrNull(varargArgumentsExpression.getConeTypeOrNull());
            $this$visitVarargArgumentsExpression_u24lambda_u2411.getAnnotations().addAll((Collection<FirAnnotation>)varargArgumentsExpression.getAnnotations());
            Iterable iterable = varargArgumentsExpression.getArguments();
            List<FirExpression> list = $this$visitVarargArgumentsExpression_u24lambda_u2411.getArguments();
            boolean $i$f$map = false;
            void var10_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirElement firElement;
                void it;
                FirExpression firExpression = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it);
                boolean $i$f$unwrapOr = false;
                FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl3 = false;
                    return it2;
                }
                if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement2 instanceof FirExpression)) {
                        firElement2 = null;
                    }
                    firElement = (FirExpression)firElement2;
                } else {
                    firElement = null;
                }
                FirExpression firExpression2 = (FirExpression)firElement;
                if (firExpression2 == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                collection.add(firExpression2);
            }
            list.addAll((List)destination$iv$iv);
            $this$visitVarargArgumentsExpression_u24lambda_u2411.setConeElementTypeOrNull(varargArgumentsExpression.getConeElementTypeOrNull());
            return FirExpressionEvaluatorKt.access$wrap(firVarargArgumentsExpressionBuilder.build());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitSpreadArgumentExpression(@NotNull FirSpreadArgumentExpression spreadArgumentExpression, @Nullable Void data) {
            FirElement firElement;
            FirSpreadArgumentExpressionBuilder firSpreadArgumentExpressionBuilder;
            Intrinsics.checkNotNullParameter((Object)spreadArgumentExpression, (String)"spreadArgumentExpression");
            boolean $i$f$buildSpreadArgumentExpression = false;
            FirSpreadArgumentExpressionBuilder $this$visitSpreadArgumentExpression_u24lambda_u2413 = firSpreadArgumentExpressionBuilder = new FirSpreadArgumentExpressionBuilder();
            boolean bl = false;
            $this$visitSpreadArgumentExpression_u24lambda_u2413.setSource(spreadArgumentExpression.getSource());
            $this$visitSpreadArgumentExpression_u24lambda_u2413.getAnnotations().addAll((Collection<FirAnnotation>)spreadArgumentExpression.getAnnotations());
            FirEvaluatorResult $this$unwrapOr$iv = this.evaluate(spreadArgumentExpression.getExpression());
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                void it;
                FirEvaluatorResult.CompileTimeException compileTimeException = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl2 = false;
                return (FirEvaluatorResult)it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                firElement = (FirExpression)firElement2;
            } else {
                firElement = null;
            }
            FirExpression firExpression = (FirExpression)firElement;
            if (firExpression == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            $this$visitSpreadArgumentExpression_u24lambda_u2413.setExpression(firExpression);
            return FirExpressionEvaluatorKt.access$wrap(firSpreadArgumentExpressionBuilder.build());
        }

        @NotNull
        public FirEvaluatorResult visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression, @Nullable Void data) {
            FirEvaluatorResult firEvaluatorResult;
            Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
            FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(propertyAccessExpression.getCalleeReference(), false, 1, null);
            if (firCallableSymbol == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirCallableSymbol propertySymbol = firCallableSymbol;
            if (INSTANCE.wasVisited(propertySymbol)) {
                return FirEvaluatorResult.RecursionInInitializer.INSTANCE;
            }
            FirCallableSymbol firCallableSymbol2 = propertySymbol;
            if (firCallableSymbol2 instanceof FirPropertySymbol) {
                if (FirExpressionEvaluatorKt.access$isStringLength(((FirPropertySymbol)propertySymbol).getCallableId()) || FirExpressionEvaluatorKt.access$isCharCode(((FirPropertySymbol)propertySymbol).getCallableId())) {
                    FirElement firElement;
                    FirEvaluatorResult receiver = this.evaluate(propertyAccessExpression.getExplicitReceiver());
                    boolean bl = false;
                    FirEvaluatorResult $this$unwrapOr$iv = receiver;
                    boolean $i$f$unwrapOr = false;
                    FirEvaluatorResult firEvaluatorResult2 = $this$unwrapOr$iv;
                    if (firEvaluatorResult2 instanceof FirEvaluatorResult.CompileTimeException) {
                        FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                        boolean bl2 = false;
                        return it;
                    }
                    if (firEvaluatorResult2 instanceof FirEvaluatorResult.Evaluated) {
                        FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                        if (!(firElement2 instanceof FirExpression)) {
                            firElement2 = null;
                        }
                        firElement = (FirExpression)firElement2;
                    } else {
                        firElement = null;
                    }
                    FirExpression firExpression = (FirExpression)firElement;
                    if (firExpression == null) {
                        return FirEvaluatorResult.NotEvaluated.INSTANCE;
                    }
                    FirExpression unaryArg = firExpression;
                    firEvaluatorResult = FirExpressionEvaluatorKt.access$adjustTypeAndConvertToLiteral(FirExpressionEvaluatorKt.access$evaluateUnary(unaryArg, ((FirPropertySymbol)propertySymbol).getCallableId()), propertyAccessExpression);
                } else {
                    firEvaluatorResult = EvaluationVisitor.visitPropertyAccessExpression$evaluateOrCopy(propertySymbol, propertyAccessExpression, this, ((FirProperty)((FirPropertySymbol)propertySymbol).getFir()).getInitializer());
                }
            } else if (firCallableSymbol2 instanceof FirFieldSymbol) {
                firEvaluatorResult = EvaluationVisitor.visitPropertyAccessExpression$evaluateOrCopy(propertySymbol, propertyAccessExpression, this, ((FirField)((FirFieldSymbol)propertySymbol).getFir()).getInitializer());
            } else if (firCallableSymbol2 instanceof FirEnumEntrySymbol) {
                firEvaluatorResult = FirExpressionEvaluatorKt.access$wrap(propertyAccessExpression);
            } else {
                throw new IllegalStateException(("FIR symbol \"" + Reflection.getOrCreateKotlinClass(propertySymbol.getClass()) + "\" is not supported in constant evaluation").toString());
            }
            return firEvaluatorResult;
        }

        @NotNull
        public FirEvaluatorResult visitFunctionCall(@NotNull FirFunctionCall functionCall, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
            FirNamedReference calleeReference = functionCall.getCalleeReference();
            if (!(calleeReference instanceof FirResolvedNamedReference)) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirBasedSymbol<?> symbol2 = ((FirResolvedNamedReference)calleeReference).getResolvedSymbol();
            return symbol2 instanceof FirNamedFunctionSymbol ? this.visitNamedFunction(functionCall, (FirNamedFunctionSymbol)symbol2) : (symbol2 instanceof FirConstructorSymbol ? this.visitConstructorCall(functionCall) : (FirEvaluatorResult)FirEvaluatorResult.NotEvaluated.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        private final FirEvaluatorResult visitNamedFunction(FirFunctionCall functionCall, FirNamedFunctionSymbol symbol2) {
            FirEvaluatorResult firEvaluatorResult;
            void $this$mapTo$iv$iv;
            Object[] objectArray = new FirExpression[]{functionCall.getDispatchReceiver(), functionCall.getExtensionReceiver()};
            List receivers = CollectionsKt.listOfNotNull((Object[])objectArray);
            FirCall $this$arguments$iv = functionCall;
            boolean $i$f$getArguments = false;
            Iterable $this$map$iv = CollectionsKt.plus((Collection)receivers, (Iterable)$this$arguments$iv.getArgumentList().getArguments());
            boolean $i$f$map22 = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirElement firElement;
                void it;
                FirExpression firExpression = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it);
                boolean $i$f$unwrapOr = false;
                FirEvaluatorResult firEvaluatorResult2 = $this$unwrapOr$iv;
                if (firEvaluatorResult2 instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl2 = false;
                    return it2;
                }
                if (firEvaluatorResult2 instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement2 instanceof FirLiteralExpression)) {
                        firElement2 = null;
                    }
                    firElement = (FirLiteralExpression)firElement2;
                } else {
                    firElement = null;
                }
                FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
                if (firLiteralExpression == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                collection.add(firLiteralExpression);
            }
            List evaluatedArgs = (List)destination$iv$iv;
            FirLiteralExpression firLiteralExpression = (FirLiteralExpression)CollectionsKt.getOrNull((List)evaluatedArgs, (int)0);
            if (firLiteralExpression == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirLiteralExpression opr1 = firLiteralExpression;
            Object $i$f$map22 = FirExpressionEvaluatorKt.access$evaluateUnary(opr1, symbol2.getCallableId());
            if ($i$f$map22 != null && (object = FirExpressionEvaluatorKt.access$adjustTypeAndConvertToLiteral($i$f$map22, functionCall)) != null) {
                Object it = object;
                boolean bl = false;
                return it;
            }
            FirLiteralExpression firLiteralExpression2 = (FirLiteralExpression)CollectionsKt.getOrNull((List)evaluatedArgs, (int)1);
            if (firLiteralExpression2 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirLiteralExpression opr2 = firLiteralExpression2;
            object = FirExpressionEvaluatorKt.access$evaluateBinary(opr1, symbol2.getCallableId(), opr2);
            if (object != null && (firEvaluatorResult = FirExpressionEvaluatorKt.access$adjustTypeAndConvertToLiteral(object, functionCall)) != null) {
                FirEvaluatorResult it = firEvaluatorResult;
                boolean bl = false;
                return it;
            }
            return FirEvaluatorResult.NotEvaluated.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private final FirEvaluatorResult visitConstructorCall(FirFunctionCall constructorCall) {
            ConeRigidType type2 = ConeTypeUtilsKt.lowerBoundIfFlexible(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getResolvedType(constructorCall), this.session, null, 2, null));
            FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(type2, this.session);
            if ((firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.ANNOTATION_CLASS) {
                FirElement firElement;
                FirFunctionCallBuilder $this$unwrapOr$iv;
                FirEvaluatorResult firEvaluatorResult = (FirEvaluatorResult)constructorCall.getArgumentList().accept(this, null);
                boolean $i$f$unwrapOr = false;
                FirFunctionCallBuilder firFunctionCallBuilder = $this$unwrapOr$iv;
                if (firFunctionCallBuilder instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)((Object)$this$unwrapOr$iv);
                    boolean bl = false;
                    return it;
                }
                if (firFunctionCallBuilder instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement2 = ((FirEvaluatorResult.Evaluated)((Object)$this$unwrapOr$iv)).getResult();
                    if (!(firElement2 instanceof FirResolvedArgumentList)) {
                        firElement2 = null;
                    }
                    firElement = (FirResolvedArgumentList)firElement2;
                } else {
                    firElement = null;
                }
                FirResolvedArgumentList firResolvedArgumentList = (FirResolvedArgumentList)firElement;
                if (firResolvedArgumentList == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                FirResolvedArgumentList evaluatedArgs = firResolvedArgumentList;
                boolean $i$f$buildFunctionCall = false;
                FirFunctionCallBuilder $this$visitConstructorCall_u24lambda_u2422 = $this$unwrapOr$iv = new FirFunctionCallBuilder();
                boolean bl = false;
                $this$visitConstructorCall_u24lambda_u2422.setConeTypeOrNull(constructorCall.getConeTypeOrNull());
                $this$visitConstructorCall_u24lambda_u2422.getAnnotations().addAll((Collection<FirAnnotation>)constructorCall.getAnnotations());
                $this$visitConstructorCall_u24lambda_u2422.getTypeArguments().addAll((Collection<FirTypeProjection>)constructorCall.getTypeArguments());
                $this$visitConstructorCall_u24lambda_u2422.setSource(constructorCall.getSource());
                $this$visitConstructorCall_u24lambda_u2422.getNonFatalDiagnostics().addAll((Collection<ConeDiagnostic>)constructorCall.getNonFatalDiagnostics());
                $this$visitConstructorCall_u24lambda_u2422.setArgumentList(evaluatedArgs);
                $this$visitConstructorCall_u24lambda_u2422.setCalleeReference(constructorCall.getCalleeReference());
                $this$visitConstructorCall_u24lambda_u2422.setOrigin(constructorCall.getOrigin());
                return FirExpressionEvaluatorKt.access$wrap($this$unwrapOr$iv.build());
            }
            if (ConeBuiltinTypeUtilsKt.isUnsignedType(type2)) {
                Object object;
                FirElement firElement;
                void $this$unwrapOr$iv;
                Object $this$argument$iv = constructorCall;
                boolean $i$f$getArgument = false;
                $this$argument$iv = this.evaluate((FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()));
                boolean $i$f$unwrapOr = false;
                void var7_10 = $this$unwrapOr$iv;
                if (var7_10 instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl = false;
                    return it;
                }
                if (var7_10 instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement3 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement3 instanceof FirLiteralExpression)) {
                        firElement3 = null;
                    }
                    firElement = (FirLiteralExpression)firElement3;
                } else {
                    firElement = null;
                }
                FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
                if (firLiteralExpression == null || (object = firLiteralExpression.getValue()) == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                Object argument = object;
                return FirExpressionEvaluatorKt.access$adjustTypeAndConvertToLiteral(argument, constructorCall);
            }
            return FirEvaluatorResult.NotEvaluated.INSTANCE;
        }

        @NotNull
        public FirEvaluatorResult visitIntegerLiteralOperatorCall(@NotNull FirIntegerLiteralOperatorCall integerLiteralOperatorCall, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)integerLiteralOperatorCall, (String)"integerLiteralOperatorCall");
            return this.visitFunctionCall((FirFunctionCall)integerLiteralOperatorCall, data);
        }

        @NotNull
        public FirEvaluatorResult visitComparisonExpression(@NotNull FirComparisonExpression comparisonExpression, @Nullable Void data) {
            boolean bl;
            FirElement firElement;
            Intrinsics.checkNotNullParameter((Object)comparisonExpression, (String)"comparisonExpression");
            FirEvaluatorResult it = this.visitFunctionCall(comparisonExpression.getCompareToCall(), data);
            boolean bl2 = false;
            FirEvaluatorResult $this$unwrapOr$iv = it;
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl3 = false;
                return it2;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement2 instanceof FirLiteralExpression)) {
                    firElement2 = null;
                }
                firElement = (FirLiteralExpression)firElement2;
            } else {
                firElement = null;
            }
            FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
            Object object = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
            Integer n = object instanceof Integer ? (Integer)object : null;
            if (n == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            int intResult = n;
            switch (WhenMappings.$EnumSwitchMapping$0[comparisonExpression.getOperation().ordinal()]) {
                case 1: {
                    if (intResult < 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (intResult <= 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    if (intResult > 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    if (intResult >= 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unsupported comparison operation type \"" + comparisonExpression.getOperation().name() + '\"').toString());
                }
            }
            boolean compareToResult = bl;
            return FirExpressionEvaluatorKt.access$adjustTypeAndConvertToLiteral(compareToResult, comparisonExpression);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @Nullable Void data) {
            boolean bl;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)equalityOperatorCall, (String)"equalityOperatorCall");
            Object $this$arguments$iv = equalityOperatorCall;
            boolean $i$f$getArguments = false;
            $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirElement firElement;
                void it;
                FirExpression firExpression = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it);
                boolean $i$f$unwrapOr = false;
                FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl3 = false;
                    return it2;
                }
                if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement2 instanceof FirLiteralExpression)) {
                        firElement2 = null;
                    }
                    firElement = (FirLiteralExpression)firElement2;
                } else {
                    firElement = null;
                }
                FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
                if (firLiteralExpression == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                collection.add(firLiteralExpression);
            }
            List evaluatedArgs = (List)destination$iv$iv;
            if (evaluatedArgs.size() != 2) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[equalityOperatorCall.getOperation().ordinal()]) {
                case 5: {
                    bl = Intrinsics.areEqual((Object)((FirLiteralExpression)evaluatedArgs.get(0)).getValue(), (Object)((FirLiteralExpression)evaluatedArgs.get(1)).getValue());
                    break;
                }
                case 6: {
                    if (!Intrinsics.areEqual((Object)((FirLiteralExpression)evaluatedArgs.get(0)).getValue(), (Object)((FirLiteralExpression)evaluatedArgs.get(1)).getValue())) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Operation \"" + (Object)((Object)equalityOperatorCall.getOperation()) + "\" is not supported in compile time evaluation").toString());
                }
            }
            boolean result2 = bl;
            return FirExpressionEvaluatorKt.access$wrap(FirExpressionEvaluatorKt.access$toConstExpression(result2, ConstantValueKind.Boolean.INSTANCE, equalityOperatorCall));
        }

        @NotNull
        public FirEvaluatorResult visitBinaryLogicExpression(@NotNull FirBinaryLogicExpression binaryLogicExpression, @Nullable Void data) {
            boolean bl;
            FirElement firElement;
            FirElement firElement2;
            Intrinsics.checkNotNullParameter((Object)binaryLogicExpression, (String)"binaryLogicExpression");
            FirEvaluatorResult left = this.evaluate(binaryLogicExpression.getLeftOperand());
            FirEvaluatorResult right = this.evaluate(binaryLogicExpression.getRightOperand());
            FirEvaluatorResult $this$unwrapOr$iv = left;
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl2 = false;
                return it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement3 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement3 instanceof FirLiteralExpression)) {
                    firElement3 = null;
                }
                firElement2 = (FirLiteralExpression)firElement3;
            } else {
                firElement2 = null;
            }
            FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement2;
            Object object = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
            Boolean bl3 = object instanceof Boolean ? (Boolean)object : null;
            if (bl3 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            boolean leftBoolean = bl3;
            FirEvaluatorResult $this$unwrapOr$iv2 = right;
            boolean $i$f$unwrapOr2 = false;
            FirEvaluatorResult firEvaluatorResult2 = $this$unwrapOr$iv2;
            if (firEvaluatorResult2 instanceof FirEvaluatorResult.CompileTimeException) {
                FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv2;
                boolean bl4 = false;
                return it;
            }
            if (firEvaluatorResult2 instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement4 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv2).getResult();
                if (!(firElement4 instanceof FirLiteralExpression)) {
                    firElement4 = null;
                }
                firElement = (FirLiteralExpression)firElement4;
            } else {
                firElement = null;
            }
            FirLiteralExpression firLiteralExpression2 = (FirLiteralExpression)firElement;
            Object object2 = firLiteralExpression2 != null ? firLiteralExpression2.getValue() : null;
            Boolean bl5 = object2 instanceof Boolean ? (Boolean)object2 : null;
            if (bl5 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            boolean rightBoolean = bl5;
            switch (WhenMappings.$EnumSwitchMapping$1[binaryLogicExpression.getKind().ordinal()]) {
                case 1: {
                    if (leftBoolean && rightBoolean) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (leftBoolean || rightBoolean) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Boolean logic expression of a kind \"" + (Object)((Object)binaryLogicExpression.getKind()) + "\" is not supported in compile time evaluation").toString());
                }
            }
            boolean result2 = bl;
            return FirExpressionEvaluatorKt.access$wrap(FirExpressionEvaluatorKt.access$toConstExpression(result2, ConstantValueKind.Boolean.INSTANCE, binaryLogicExpression));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitStringConcatenationCall(@NotNull FirStringConcatenationCall stringConcatenationCall, @Nullable Void data) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)stringConcatenationCall, (String)"stringConcatenationCall");
            Iterable $this$map$iv = stringConcatenationCall.getArgumentList().getArguments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirElement firElement;
                void it;
                FirExpression firExpression = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it);
                boolean $i$f$unwrapOr = false;
                FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl2 = false;
                    return it2;
                }
                if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement2 instanceof FirLiteralExpression)) {
                        firElement2 = null;
                    }
                    firElement = (FirLiteralExpression)firElement2;
                } else {
                    firElement = null;
                }
                FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
                if (firLiteralExpression == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                collection.add(firLiteralExpression);
            }
            List strings2 = (List)destination$iv$iv;
            String result2 = CollectionsKt.joinToString$default((Iterable)strings2, (CharSequence)"", null, null, (int)0, null, EvaluationVisitor::visitStringConcatenationCall$lambda$32, (int)30, null);
            return FirExpressionEvaluatorKt.access$wrap(FirExpressionEvaluatorKt.access$toConstExpression(result2, ConstantValueKind.String.INSTANCE, stringConcatenationCall));
        }

        @NotNull
        public FirEvaluatorResult visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @Nullable Void data) {
            FirElement firElement;
            Intrinsics.checkNotNullParameter((Object)typeOperatorCall, (String)"typeOperatorCall");
            if (typeOperatorCall.getOperation() != FirOperation.AS) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirCall $this$argument$iv = typeOperatorCall;
            boolean $i$f$getArgument = false;
            FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()));
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl = false;
                return it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement2 instanceof FirLiteralExpression)) {
                    firElement2 = null;
                }
                firElement = (FirLiteralExpression)firElement2;
            } else {
                firElement = null;
            }
            FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
            if (firLiteralExpression == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirLiteralExpression result2 = firLiteralExpression;
            if (TypeUtilsKt.isSubtypeOf$default(FirTypeUtilsKt.getResolvedType(result2), FirTypeUtilsKt.getResolvedType(typeOperatorCall), this.session, false, 4, null)) {
                return FirExpressionEvaluatorKt.access$wrap(result2);
            }
            return FirExpressionEvaluatorKt.access$wrap(typeOperatorCall);
        }

        @NotNull
        public FirEvaluatorResult visitEnumEntryDeserializedAccessExpression(@NotNull FirEnumEntryDeserializedAccessExpression enumEntryDeserializedAccessExpression, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)enumEntryDeserializedAccessExpression, (String)"enumEntryDeserializedAccessExpression");
            return FirExpressionEvaluatorKt.access$wrap(enumEntryDeserializedAccessExpression);
        }

        @NotNull
        public FirEvaluatorResult visitClassReferenceExpression(@NotNull FirClassReferenceExpression classReferenceExpression, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)classReferenceExpression, (String)"classReferenceExpression");
            return FirExpressionEvaluatorKt.access$wrap(classReferenceExpression);
        }

        @NotNull
        public FirEvaluatorResult visitAnnotationCall(@NotNull FirAnnotationCall annotationCall, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
            return this.visitAnnotation((FirAnnotation)annotationCall, data);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitAnnotation(@NotNull FirAnnotation annotation, @Nullable Void data) {
            void $this$visitAnnotation_u24lambda_u2435_u24lambda_u2434;
            FirAnnotationBuilder firAnnotationBuilder;
            Object object;
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Map<Name, FirExpression> mapping = annotation.getArgumentMapping().getMapping();
            if (mapping.isEmpty()) {
                return FirExpressionEvaluatorKt.access$wrap(annotation);
            }
            Map evaluatedMapping = new LinkedHashMap();
            for (Map.Entry<Name, FirExpression> entry : mapping.entrySet()) {
                Name name2 = entry.getKey();
                FirExpression expression2 = entry.getValue();
                FirEvaluatorResult evaluatedExpression = this.evaluate(expression2);
                if (evaluatedExpression instanceof FirEvaluatorResult.Evaluated) {
                    Map map = evaluatedMapping;
                    FirElement firElement = ((FirEvaluatorResult.Evaluated)evaluatedExpression).getResult();
                    Intrinsics.checkNotNull((Object)firElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    object = (FirExpression)firElement;
                    map.put(name2, object);
                    continue;
                }
                return evaluatedExpression;
            }
            boolean $i$f$buildAnnotationCopy = false;
            FirAnnotationBuilder copyBuilder$iv = new FirAnnotationBuilder();
            copyBuilder$iv.setSource(annotation.getSource());
            copyBuilder$iv.setUseSiteTarget(annotation.getUseSiteTarget());
            copyBuilder$iv.setAnnotationTypeRef(annotation.getAnnotationTypeRef());
            copyBuilder$iv.setArgumentMapping(annotation.getArgumentMapping());
            copyBuilder$iv.getTypeArguments().addAll((Collection<FirTypeProjection>)annotation.getTypeArguments());
            FirAnnotationBuilder $this$visitAnnotation_u24lambda_u2435 = firAnnotationBuilder = copyBuilder$iv;
            boolean bl = false;
            boolean $i$f$buildAnnotationArgumentMapping = false;
            Object object2 = object = new FirAnnotationArgumentMappingBuilder();
            FirAnnotationBuilder firAnnotationBuilder2 = $this$visitAnnotation_u24lambda_u2435;
            boolean bl2 = false;
            $this$visitAnnotation_u24lambda_u2435_u24lambda_u2434.getMapping().putAll(evaluatedMapping);
            firAnnotationBuilder2.setArgumentMapping(((FirAnnotationArgumentMappingBuilder)object).build());
            return FirExpressionEvaluatorKt.access$wrap(firAnnotationBuilder.build());
        }

        private static final FirEvaluatorResult visitPropertyAccessExpression$evaluateOrCopy$lambda$14(FirExpression $initializer, FirPropertyAccessExpression $propertyAccessExpression, EvaluationVisitor this$0) {
            return $initializer instanceof FirLiteralExpression ? FirExpressionEvaluatorKt.access$wrap(FirExpressionEvaluatorKt.access$copy((FirLiteralExpression)$initializer, $propertyAccessExpression)) : this$0.evaluate($initializer);
        }

        private static final FirEvaluatorResult visitPropertyAccessExpression$evaluateOrCopy(FirCallableSymbol<?> propertySymbol, FirPropertyAccessExpression $propertyAccessExpression, EvaluationVisitor this$0, FirExpression initializer) {
            return (FirEvaluatorResult)INSTANCE.visit(propertySymbol, () -> EvaluationVisitor.visitPropertyAccessExpression$evaluateOrCopy$lambda$14(initializer, $propertyAccessExpression, this$0));
        }

        private static final CharSequence visitStringConcatenationCall$lambda$32(FirLiteralExpression it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return String.valueOf(it.getValue());
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[FirOperation.values().length];
                try {
                    nArray[FirOperation.LT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.LT_EQ.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.GT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.GT_EQ.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.EQ.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.NOT_EQ.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[LogicOperationKind.values().length];
                try {
                    nArray[LogicOperationKind.AND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LogicOperationKind.OR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

