/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirScriptSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u00182\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e2\u0006\u0010\u0019\u001a\u00020$H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u0019\u001a\u00020$H\u0016J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "previousProviders", "", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/Map;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "generatedFilesProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl;", "providers", "", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getSymbolProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getFirClassifierByFqName", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getFirClassifierContainerFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "fqName", "getFirClassifierContainerFileIfAny", "getFirCallableContainerFile", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getFirScriptContainerFile", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirScriptSymbol;", "getFirScriptByFilePath", "path", "", "getFirFilesByPackage", "Lorg/jetbrains/kotlin/name/FqName;", "getClassNamesInPackage", "", "Lorg/jetbrains/kotlin/name/Name;", "recordFile", "", "file", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFirProviderWithGeneratedFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirProviderWithGeneratedFiles.kt\norg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1619#2:77\n1863#2:78\n1864#2:80\n1620#2:81\n1368#2:83\n1454#2,5:84\n1454#2,5:89\n1#3:79\n1#3:82\n*S KotlinDebug\n*F\n+ 1 FirProviderWithGeneratedFiles.kt\norg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles\n*L\n34#1:77\n34#1:78\n34#1:80\n34#1:81\n65#1:83\n65#1:84,5\n69#1:89,5\n34#1:79\n*E\n"})
public final class FirProviderWithGeneratedFiles
extends FirProvider {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirProviderImpl generatedFilesProvider;
    @NotNull
    private final List<FirProvider> providers;

    /*
     * WARNING - void declaration
     */
    public FirProviderWithGeneratedFiles(@NotNull FirSession session, @NotNull Map<FirModuleData, FirProviderWithGeneratedFiles> previousProviders) {
        void $this$providers_u24lambda_u241;
        List list;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(previousProviders, (String)"previousProviders");
        this.session = session;
        this.generatedFilesProvider = new FirProviderImpl(this.session, FirKotlinScopeProviderKt.getKotlinScopeProvider(this.session));
        List list2 = list = CollectionsKt.createListBuilder();
        FirProviderWithGeneratedFiles firProviderWithGeneratedFiles = this;
        boolean bl = false;
        $this$providers_u24lambda_u241.add(FirProviderKt.getFirProvider(this.session));
        $this$providers_u24lambda_u241.add(this.generatedFilesProvider);
        Iterable $this$mapNotNullTo$iv = FirModuleDataKt.getModuleData(this.session).getDependsOnDependencies();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirProviderWithGeneratedFiles it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            FirModuleData it = (FirModuleData)element$iv;
            boolean bl3 = false;
            if (previousProviders.get(it) == null) continue;
            boolean bl4 = false;
            ((Collection)$this$providers_u24lambda_u241).add(it$iv);
        }
        Collection cfr_ignored_0 = (Collection)$this$providers_u24lambda_u241;
        firProviderWithGeneratedFiles.providers = CollectionsKt.build((List)list);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public FirSymbolProvider getSymbolProvider() {
        return ((FirProvider)CollectionsKt.first(this.providers)).getSymbolProvider();
    }

    @Override
    @Nullable
    public FirClassLikeDeclaration getFirClassifierByFqName(@NotNull ClassId classId) {
        FirClassLikeDeclaration firClassLikeDeclaration;
        block1: {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            for (FirProvider it : (Iterable)this.providers) {
                boolean bl = false;
                FirClassLikeDeclaration firClassLikeDeclaration2 = it.getFirClassifierByFqName(classId);
                if (firClassLikeDeclaration2 == null) continue;
                firClassLikeDeclaration = firClassLikeDeclaration2;
                break block1;
            }
            firClassLikeDeclaration = null;
        }
        return firClassLikeDeclaration;
    }

    @Override
    @NotNull
    public FirFile getFirClassifierContainerFile(@NotNull ClassId fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        FirFile firFile = this.getFirClassifierContainerFileIfAny(fqName);
        if (firFile == null) {
            throw new IllegalStateException(("Couldn't find container for " + fqName).toString());
        }
        return firFile;
    }

    @Override
    @Nullable
    public FirFile getFirClassifierContainerFileIfAny(@NotNull ClassId fqName) {
        FirFile firFile;
        block1: {
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            for (FirProvider it : (Iterable)this.providers) {
                boolean bl = false;
                FirFile firFile2 = it.getFirClassifierContainerFileIfAny(fqName);
                if (firFile2 == null) continue;
                firFile = firFile2;
                break block1;
            }
            firFile = null;
        }
        return firFile;
    }

    @Override
    @Nullable
    public FirFile getFirCallableContainerFile(@NotNull FirCallableSymbol<?> symbol2) {
        FirFile firFile;
        block1: {
            Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
            for (FirProvider it : (Iterable)this.providers) {
                boolean bl = false;
                FirFile firFile2 = it.getFirCallableContainerFile(symbol2);
                if (firFile2 == null) continue;
                firFile = firFile2;
                break block1;
            }
            firFile = null;
        }
        return firFile;
    }

    @Override
    @Nullable
    public FirFile getFirScriptContainerFile(@NotNull FirScriptSymbol symbol2) {
        FirFile firFile;
        block1: {
            Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
            for (FirProvider it : (Iterable)this.providers) {
                boolean bl = false;
                FirFile firFile2 = it.getFirScriptContainerFile(symbol2);
                if (firFile2 == null) continue;
                firFile = firFile2;
                break block1;
            }
            firFile = null;
        }
        return firFile;
    }

    @Override
    @Nullable
    public FirScriptSymbol getFirScriptByFilePath(@NotNull String path) {
        FirScriptSymbol firScriptSymbol;
        block1: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            for (FirProvider it : (Iterable)this.providers) {
                boolean bl = false;
                FirScriptSymbol firScriptSymbol2 = it.getFirScriptByFilePath(path);
                if (firScriptSymbol2 == null) continue;
                firScriptSymbol = firScriptSymbol2;
                break block1;
            }
            firScriptSymbol = null;
        }
        return firScriptSymbol;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirFile> getFirFilesByPackage(@NotNull FqName fqName) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Iterable $this$flatMap$iv = this.providers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirProvider it = (FirProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFirFilesByPackage(fqName);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Name> getClassNamesInPackage(@NotNull FqName fqName) {
        void var3_3;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Iterable iterable = this.providers;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            FirProvider it = (FirProvider)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getClassNamesInPackage(fqName);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var3_3;
    }

    public final void recordFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.generatedFilesProvider.recordFile(file2);
    }
}

