/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmSynchronizedByValueClassOrPrimitiveChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "synchronizedCallableId", "Lorg/jetbrains/kotlin/name/CallableId;", "lockParameterName", "Lorg/jetbrains/kotlin/name/Name;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmSynchronizedByValueClassOrPrimitiveChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmSynchronizedByValueClassOrPrimitiveChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmSynchronizedByValueClassOrPrimitiveChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,44:1\n57#2,4:45\n*S KotlinDebug\n*F\n+ 1 FirJvmSynchronizedByValueClassOrPrimitiveChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmSynchronizedByValueClassOrPrimitiveChecker\n*L\n35#1:45,4\n*E\n"})
public final class FirJvmSynchronizedByValueClassOrPrimitiveChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirJvmSynchronizedByValueClassOrPrimitiveChecker INSTANCE = new FirJvmSynchronizedByValueClassOrPrimitiveChecker();
    @NotNull
    private static final CallableId synchronizedCallableId;
    @NotNull
    private static final Name lockParameterName;

    private FirJvmSynchronizedByValueClassOrPrimitiveChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol function2 = firCallableSymbol;
        if (!Intrinsics.areEqual((Object)function2.getCallableId(), (Object)synchronizedCallableId)) {
            return;
        }
        FirCall $this$resolvedArgumentMapping$iv = expression2;
        boolean $i$f$getResolvedArgumentMapping = false;
        FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
        Object object = linkedHashMap;
        if (linkedHashMap == null || (object = ((LinkedHashMap)object).entrySet()) == null) {
            return;
        }
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            ConeKotlinType type2;
            Map.Entry entry = (Map.Entry)iterator2.next();
            FirExpression argument = (FirExpression)entry.getKey();
            FirValueParameter parameter2 = (FirValueParameter)entry.getValue();
            if (!Intrinsics.areEqual((Object)parameter2.getName(), (Object)lockParameterName) || !ConeBuiltinTypeUtilsKt.isPrimitive(type2 = FirTypeUtilsKt.getResolvedType(argument)) && !FirHelpersKt.isValueClass(type2, context2.getSession())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)argument.getSource(), FirJvmErrors.INSTANCE.getSYNCHRONIZED_BLOCK_ON_VALUE_CLASS_OR_PRIMITIVE(), (Object)type2, (DiagnosticContext)context2, null, 16, null);
        }
    }

    static {
        FqName fqName = new FqName("kotlin");
        Name name2 = Name.identifier("synchronized");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        synchronizedCallableId = new CallableId(fqName, name2);
        Name name3 = Name.identifier("lock");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        lockParameterName = name3;
    }
}

