/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.TypeUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.utils.DFS;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00100\u000e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00100\u000eH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFiniteBoundRestrictionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "buildTypeEdges", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isInCycle", "", "start", "edges", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirFiniteBoundRestrictionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirFiniteBoundRestrictionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFiniteBoundRestrictionChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ConeTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeTypeUtilsKt\n+ 5 ConeTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeTypeUtilsKt$forEachType$1\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,116:1\n865#2,2:117\n1619#2:119\n1863#2:120\n1864#2:122\n1620#2:123\n1755#2,3:124\n1557#2:127\n1628#2,3:128\n1863#2,2:131\n1863#2,2:156\n1#3:121\n36#4,8:133\n44#4,11:142\n57#4:155\n37#5:141\n13409#6,2:153\n381#7,7:158\n381#7,7:165\n*S KotlinDebug\n*F\n+ 1 FirFiniteBoundRestrictionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFiniteBoundRestrictionChecker\n*L\n41#1:117,2\n51#1:119\n51#1:120\n51#1:122\n51#1:123\n52#1:124,3\n54#1:127\n54#1:128,3\n87#1:131,2\n73#1:156,2\n51#1:121\n65#1:133,8\n65#1:142,11\n65#1:155\n65#1:141\n65#1:153,2\n80#1:158,7\n81#1:165,7\n*E\n"})
public final class FirFiniteBoundRestrictionChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirFiniteBoundRestrictionChecker INSTANCE = new FirFiniteBoundRestrictionChecker();

    private FirFiniteBoundRestrictionChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        boolean bl;
        Set problemSymbols;
        block10: {
            void destination$iv;
            Iterator<FirTypeParameterRef> $this$filterTo$iv;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (declaration2.getTypeParameters().isEmpty()) {
                return;
            }
            Map<ConeKotlinType, Set<ConeKotlinType>> edges = this.buildTypeEdges(declaration2, context2.getSession());
            Iterable iterable = edges.keySet();
            Collection collection = new LinkedHashSet();
            boolean $i$f$filterTo232 = false;
            Iterator iterator2 = $this$filterTo$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv3 = iterator2.next();
                ConeKotlinType it = (ConeKotlinType)element$iv3;
                boolean bl2 = false;
                if (!INSTANCE.isInCycle(it, edges)) continue;
                collection.add(element$iv3);
            }
            Set problemNodes = (Set)collection;
            if (problemNodes.isEmpty()) {
                return;
            }
            for (FirTypeParameterRef firTypeParameterRef : declaration2.getTypeParameters()) {
                if (!problemNodes.remove(FirNestedClassifierScopeKt.toConeType(firTypeParameterRef))) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firTypeParameterRef.getSource(), FirErrors.INSTANCE.getFINITE_BOUNDS_VIOLATION(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            Iterable iterable2 = problemNodes;
            Collection $i$f$filterTo232 = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv = iterable2;
            boolean $i$f$forEach = false;
            Iterator bl2 = $this$forEach$iv$iv.iterator();
            while (bl2.hasNext()) {
                FirTypeParameterSymbol it$iv;
                Object element$iv$iv;
                Object element$iv2 = element$iv$iv = bl2.next();
                boolean bl3 = false;
                ConeKotlinType it = (ConeKotlinType)element$iv2;
                boolean bl4 = false;
                if (ToSymbolUtilsKt.toTypeParameterSymbol(it, context2.getSession()) == null) continue;
                boolean bl5 = false;
                destination$iv.add(it$iv);
            }
            problemSymbols = (Set)destination$iv;
            Iterable iterable3 = problemSymbols;
            boolean $i$f$any = false;
            if (iterable3 instanceof Collection && ((Collection)iterable3).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : iterable3) {
                    FirTypeParameterSymbol it = (FirTypeParameterSymbol)element$iv2;
                    boolean bl6 = false;
                    if (!(it.getSource() != null)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Iterable $this$map$iv = problemSymbols;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameterSymbol bl3 = (FirTypeParameterSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl7 = false;
            collection.add(it.getContainingDeclarationSymbol());
        }
        List list = (List)destination$iv$iv;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getFINITE_BOUNDS_VIOLATION_IN_JAVA(), (Object)list, (DiagnosticContext)context2, null, 16, null);
    }

    private final Map<ConeKotlinType, Set<ConeKotlinType>> buildTypeEdges(FirRegularClass declaration2, FirSession session) {
        Map edges = new LinkedHashMap();
        Set visitedSymbols = new LinkedHashSet();
        Iterable $this$forEach$iv = declaration2.getTypeParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
            boolean bl = false;
            FirFiniteBoundRestrictionChecker.buildTypeEdges$visit(session, visitedSymbols, edges, FirNestedClassifierScopeKt.toConeType(it));
        }
        return edges;
    }

    private final boolean isInCycle(ConeKotlinType start, Map<ConeKotlinType, ? extends Set<? extends ConeKotlinType>> edges) {
        Ref.BooleanRef containsCycle = new Ref.BooleanRef();
        DFS.Neighbors<ConeKotlinType> dfsNeighbors = arg_0 -> FirFiniteBoundRestrictionChecker.isInCycle$lambda$9(edges, arg_0);
        DFS.VisitedWithSet<ConeKotlinType> dfsVisited2 = new DFS.VisitedWithSet<ConeKotlinType>(start, containsCycle){
            final /* synthetic */ ConeKotlinType $start;
            final /* synthetic */ Ref.BooleanRef $containsCycle;
            {
                this.$start = $start;
                this.$containsCycle = $containsCycle;
            }

            public boolean checkAndMarkVisited(ConeKotlinType current) {
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                boolean added = super.checkAndMarkVisited(current);
                if (!added && Intrinsics.areEqual((Object)current, (Object)this.$start)) {
                    this.$containsCycle.element = true;
                }
                return added;
            }
        };
        DFS.AbstractNodeHandler<ConeKotlinType, Unit> dfsHandler2 = new DFS.AbstractNodeHandler<ConeKotlinType, Unit>(){

            public void result() {
            }
        };
        DFS.dfs(CollectionsKt.listOf((Object)start), dfsNeighbors, dfsVisited2, dfsHandler2);
        return containsCycle.element;
    }

    private static final void buildTypeEdges$visit(FirSession $session, Set<FirClassifierSymbol<?>> visitedSymbols, Map<ConeKotlinType, Set<ConeKotlinType>> edges, ConeKotlinType coneType) {
        Set constituentTypes = new LinkedHashSet();
        for (ConeClassLikeType coneClassLikeType : TypeUtilsKt.collectUpperBounds(coneType)) {
            ConeKotlinType $this$forEachType_u24default$iv = coneClassLikeType;
            boolean $i$f$forEachType = false;
            Object[] n = new ConeKotlinType[]{$this$forEachType_u24default$iv};
            List stack$iv = CollectionsKt.mutableListOf((Object[])n);
            while (!((Collection)stack$iv).isEmpty()) {
                ConeKotlinType it;
                ConeKotlinType next$iv;
                Object e = AddToStdlibKt.popLast(stack$iv);
                boolean bl = false;
                it = next$iv = (it = (ConeKotlinType)e);
                boolean bl2 = false;
                constituentTypes.add(it);
                ConeKotlinType coneKotlinType = next$iv;
                if (coneKotlinType instanceof ConeFlexibleType) {
                    stack$iv.add(((ConeFlexibleType)next$iv).getLowerBound());
                    stack$iv.add(((ConeFlexibleType)next$iv).getUpperBound());
                    continue;
                }
                if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                    stack$iv.add(((ConeDefinitelyNotNullType)next$iv).getOriginal());
                    continue;
                }
                if (coneKotlinType instanceof ConeIntersectionType) {
                    stack$iv.addAll(((ConeIntersectionType)next$iv).getIntersectedTypes());
                    continue;
                }
                ConeTypeProjection[] $this$forEach$iv$iv = next$iv.getTypeArguments();
                boolean $i$f$forEach = false;
                int n2 = $this$forEach$iv$iv.length;
                for (int i = 0; i < n2; ++i) {
                    ConeTypeProjection element$iv$iv;
                    ConeTypeProjection it$iv = element$iv$iv = $this$forEach$iv$iv[i];
                    boolean bl3 = false;
                    if (!(it$iv instanceof ConeKotlinTypeProjection)) continue;
                    stack$iv.add(((ConeKotlinTypeProjection)it$iv).getType());
                }
            }
        }
        for (ConeKotlinType coneKotlinType : constituentTypes) {
            FirClassifierSymbol<?> symbol2 = ToSymbolUtilsKt.toSymbol(coneKotlinType, $session);
            FirClassifierSymbol<?> firClassifierSymbol = symbol2;
            if (firClassifierSymbol == null || (firClassifierSymbol = FirHelpersKt.getTypeParameterSymbols((FirBasedSymbol)firClassifierSymbol)) == null) continue;
            FirClassifierSymbol<?> parameters2 = firClassifierSymbol;
            if (visitedSymbols.add(symbol2)) {
                Iterable $this$forEach$iv = (Iterable)((Object)parameters2);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirTypeParameterSymbol it = (FirTypeParameterSymbol)element$iv;
                    boolean bl = false;
                    FirFiniteBoundRestrictionChecker.buildTypeEdges$visit($session, visitedSymbols, edges, FirNestedClassifierScopeKt.toConeType(it));
                }
            }
            if (parameters2.size() != coneKotlinType.getTypeArguments().length) continue;
            int n = ((Collection)((Object)parameters2)).size();
            for (int i = 0; i < n; ++i) {
                Set set;
                Set answer$iv;
                if (coneKotlinType.getTypeArguments()[i].getKind() == ProjectionKind.INVARIANT) continue;
                ConeTypeParameterType parameter2 = FirNestedClassifierScopeKt.toConeType((FirTypeParameterSymbol)parameters2.get(i));
                Map<ConeKotlinType, Set<ConeKotlinType>> $this$getOrPut$iv = edges;
                boolean $i$f$getOrPut = false;
                Set value$iv = $this$getOrPut$iv.get(coneType);
                if (value$iv == null) {
                    boolean bl = false;
                    answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(coneType, answer$iv);
                    set = answer$iv;
                } else {
                    set = value$iv;
                }
                set.add((ConeKotlinType)parameter2);
                $this$getOrPut$iv = edges;
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(parameter2);
                if (value$iv != null) continue;
                boolean bl = false;
                answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(parameter2, answer$iv);
            }
        }
    }

    private static final Iterable isInCycle$lambda$9(Map $edges, ConeKotlinType it) {
        Set set = (Set)$edges.get(it);
        return set != null ? (Iterable)set : (Iterable)CollectionsKt.emptyList();
    }
}

