/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.IndentingPrinter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000e\n\u0002\u0010\u001e\n\u0002\b\n\b\u0016\u0018\u0000 72\u00020\u0001:\u00017B-\b\u0002\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bB\u001d\b\u0016\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\fB)\b\u0017\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\rB\u001d\b\u0016\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0004\b\n\u0010\u000fJ\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J%\u0010\u001d\u001a\u00020\u00002\u0016\u0010\u001e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001f\"\u0004\u0018\u00010\u001cH\u0016\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\u001aH\u0002J%\u0010\"\u001a\u00020\u00002\u0016\u0010\u001e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001f\"\u0004\u0018\u00010\u001cH\u0016\u00a2\u0006\u0002\u0010 J\u0006\u0010#\u001a\u00020\u001aJ#\u0010$\u001a\u00020\u00002\u0016\u0010\u001e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001f\"\u0004\u0018\u00010\u001c\u00a2\u0006\u0002\u0010 J\u0006\u0010\u0016\u001a\u00020\u0000J#\u0010%\u001a\u00020\u00002\u0016\u0010\u001e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001f\"\u0004\u0018\u00010\u001c\u00a2\u0006\u0002\u0010 J\u0010\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\bH\u0016J\b\u0010(\u001a\u00020\u0000H\u0016J\b\u0010)\u001a\u00020\u0000H\u0016J+\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u001c2\u0016\u0010,\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001f\"\u0004\u0018\u00010\u001c\u00a2\u0006\u0002\u0010-J\u001a\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u001c2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030.J\b\u00101\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010/\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0014\u00102\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00104\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/utils/Printer;", "Lorg/jetbrains/kotlin/utils/IndentingPrinter;", "out", "Lkotlin/text/Appendable;", "Ljava/lang/Appendable;", "maxBlankLines", "", "indentUnit", "", "indent", "<init>", "(Ljava/lang/Appendable;ILjava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/Appendable;Ljava/lang/String;)V", "(Ljava/lang/Appendable;ILjava/lang/String;)V", "parent", "(Ljava/lang/Appendable;Lorg/jetbrains/kotlin/utils/Printer;)V", "Ljava/lang/Appendable;", "value", "currentIndent", "getCurrentIndent", "()Ljava/lang/String;", "blankLineCountIncludingCurrent", "withholdIndentOnce", "", "length", "append", "", "o", "", "println", "objects", "", "([Ljava/lang/Object;)Lorg/jetbrains/kotlin/utils/Printer;", "printLineSeparator", "print", "printIndent", "printWithNoIndent", "printlnWithNoIndent", "printlnMultiLine", "s", "pushIndent", "popIndent", "separated", "separator", "items", "(Ljava/lang/Object;[Ljava/lang/Object;)Lorg/jetbrains/kotlin/utils/Printer;", "", "isEmpty", "()Z", "toString", "currentIndentLengthInUnits", "getCurrentIndentLengthInUnits", "()I", "indentUnitLength", "getIndentUnitLength", "Companion", "util.runtime"})
@SourceDebugExtension(value={"SMAP\nPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Printer.kt\norg/jetbrains/kotlin/utils/Printer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public class Printer
implements IndentingPrinter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Appendable out;
    private final int maxBlankLines;
    @NotNull
    private final String indentUnit;
    @NotNull
    private String currentIndent;
    private int blankLineCountIncludingCurrent;
    private boolean withholdIndentOnce;
    private int length;
    @NotNull
    private static final String DEFAULT_INDENTATION_UNIT = "    ";
    @NotNull
    public static final String TWO_SPACE_INDENT = "  ";
    @JvmField
    @NotNull
    public static final String LINE_SEPARATOR;

    private Printer(Appendable out, int maxBlankLines, String indentUnit, String indent) {
        this.out = out;
        this.maxBlankLines = maxBlankLines;
        this.indentUnit = indentUnit;
        this.currentIndent = indent;
    }

    @Override
    @NotNull
    public final String getCurrentIndent() {
        return this.currentIndent;
    }

    public Printer(@NotNull Appendable out, @NotNull String indentUnit) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)indentUnit, (String)"indentUnit");
        this(out, Integer.MAX_VALUE, indentUnit);
    }

    @JvmOverloads
    public Printer(@NotNull Appendable out, int maxBlankLines, @NotNull String indentUnit) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)indentUnit, (String)"indentUnit");
        this(out, maxBlankLines, indentUnit, "");
    }

    public /* synthetic */ Printer(Appendable appendable, int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 4) != 0) {
            string2 = DEFAULT_INDENTATION_UNIT;
        }
        this(appendable, n, string2);
    }

    public Printer(@NotNull Appendable out, @NotNull Printer parent2) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        this(out, parent2.maxBlankLines, parent2.indentUnit, parent2.currentIndent);
    }

    private final void append(Object o) {
        try {
            String string2 = String.valueOf(o);
            this.out.append(string2);
            this.length += string2.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public Printer println(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.print(Arrays.copyOf(objects, objects.length));
        this.printLineSeparator();
        return this;
    }

    private final void printLineSeparator() {
        if (this.blankLineCountIncludingCurrent <= this.maxBlankLines) {
            int n = this.blankLineCountIncludingCurrent;
            this.blankLineCountIncludingCurrent = n + 1;
            this.append(LINE_SEPARATOR);
        }
    }

    @Override
    @NotNull
    public Printer print(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        if (this.withholdIndentOnce) {
            this.withholdIndentOnce = false;
        } else if (!(objects.length == 0)) {
            this.printIndent();
        }
        this.printWithNoIndent(Arrays.copyOf(objects, objects.length));
        return this;
    }

    public final void printIndent() {
        this.append(this.currentIndent);
    }

    @NotNull
    public final Printer printWithNoIndent(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        for (Object object : objects) {
            this.blankLineCountIncludingCurrent = 0;
            this.append(object);
        }
        return this;
    }

    @NotNull
    public final Printer withholdIndentOnce() {
        this.withholdIndentOnce = true;
        return this;
    }

    @NotNull
    public final Printer printlnWithNoIndent(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.printWithNoIndent(Arrays.copyOf(objects, objects.length));
        this.printLineSeparator();
        return this;
    }

    @Override
    @NotNull
    public IndentingPrinter printlnMultiLine(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)StringsKt.replaceIndent((String)s, (String)this.currentIndent)), (CharSequence)"\n", null, null, (int)0, null, Printer::printlnMultiLine$lambda$1, (int)30, null)};
        this.printlnWithNoIndent(objectArray);
        return this;
    }

    @Override
    @NotNull
    public Printer pushIndent() {
        this.currentIndent = this.currentIndent + this.indentUnit;
        return this;
    }

    @Override
    @NotNull
    public Printer popIndent() {
        if (!(this.currentIndent.length() >= this.indentUnit.length())) {
            boolean bl = false;
            String string2 = "No indentation to pop";
            throw new IllegalStateException(string2.toString());
        }
        String string3 = this.currentIndent.substring(this.indentUnit.length());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        this.currentIndent = string3;
        return this;
    }

    @NotNull
    public final Printer separated(@NotNull Object separator, Object ... items) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        int n = items.length;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray;
            if (i > 0) {
                objectArray = new Object[]{separator};
                this.printlnWithNoIndent(objectArray);
            }
            objectArray = new Object[]{items[i]};
            this.printlnWithNoIndent(objectArray);
        }
        return this;
    }

    @NotNull
    public final Printer separated(@NotNull Object separator, @NotNull Collection<?> items) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Iterator<?> iterator2 = items.iterator();
        while (iterator2.hasNext()) {
            Object[] objectArray = new Object[]{iterator2.next()};
            this.printlnWithNoIndent(objectArray);
            if (!iterator2.hasNext()) continue;
            objectArray = new Object[]{separator};
            this.printlnWithNoIndent(objectArray);
        }
        return this;
    }

    public final boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    @NotNull
    public String toString() {
        return this.out.toString();
    }

    @Override
    public int getCurrentIndentLengthInUnits() {
        return this.currentIndent.length() / this.indentUnit.length();
    }

    @Override
    public int getIndentUnitLength() {
        return this.indentUnit.length();
    }

    @JvmOverloads
    public Printer(@NotNull Appendable out, int maxBlankLines) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this(out, maxBlankLines, null, 4, null);
    }

    @JvmOverloads
    public Printer(@NotNull Appendable out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this(out, 0, null, 6, null);
    }

    private static final CharSequence printlnMultiLine$lambda$1(String it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence charSequence2 = it;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = "";
        } else {
            charSequence = charSequence2;
        }
        return charSequence;
    }

    static {
        String string2 = System.getProperty("line.separator");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        LINE_SEPARATOR = string2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/utils/Printer$Companion;", "", "<init>", "()V", "DEFAULT_INDENTATION_UNIT", "", "TWO_SPACE_INDENT", "LINE_SEPARATOR", "util.runtime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

