/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoExtensionsKt;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCase;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCasesKt;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J.\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ.\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\f\u0010\u0014\u001a\u00020\u0005*\u00020\u0015H\u0014J\f\u0010\u000b\u001a\u00020\u0005*\u00020\u0015H\u0014J\f\u0010\u0016\u001a\u00020\u0005*\u00020\u0015H\u0014J\f\u0010\u0017\u001a\u00020\u0005*\u00020\u0015H\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/js/translate/callTranslator/DefaultFunctionCallCase;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallCase;", "<init>", "()V", "nativeSpreadFunWithDispatchOrExtensionReceiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "argumentsInfo", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "functionName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "buildDefaultCallWithDispatchReceiver", "dispatchReceiver", "isNative", "", "hasSpreadOperator", "buildDefaultCallWithoutReceiver", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "noReceivers", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;", "extensionReceiver", "bothReceivers", "js.translator"})
public final class DefaultFunctionCallCase
extends FunctionCallCase {
    @NotNull
    public static final DefaultFunctionCallCase INSTANCE = new DefaultFunctionCallCase();

    private DefaultFunctionCallCase() {
    }

    private final JsExpression nativeSpreadFunWithDispatchOrExtensionReceiver(CallArgumentTranslator.ArgumentsInfo argumentsInfo, JsName functionName) {
        TemporaryConstVariable temporaryConstVariable = argumentsInfo.getCachedReceiver();
        Intrinsics.checkNotNull((Object)temporaryConstVariable);
        TemporaryConstVariable cachedReceiver = temporaryConstVariable;
        JsNameRef jsNameRef = Namer.getFunctionApplyRef(new JsNameRef(functionName, cachedReceiver.assignmentExpression()));
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"getFunctionApplyRef(...)");
        JsNameRef functionCallRef = jsNameRef;
        return new JsInvocation((JsExpression)functionCallRef, argumentsInfo.getTranslateArguments());
    }

    @NotNull
    public final JsExpression buildDefaultCallWithDispatchReceiver(@NotNull CallArgumentTranslator.ArgumentsInfo argumentsInfo, @NotNull JsExpression dispatchReceiver, @NotNull JsName functionName, boolean isNative, boolean hasSpreadOperator) {
        Intrinsics.checkNotNullParameter((Object)argumentsInfo, (String)"argumentsInfo");
        Intrinsics.checkNotNullParameter((Object)dispatchReceiver, (String)"dispatchReceiver");
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        if (isNative && hasSpreadOperator) {
            return this.nativeSpreadFunWithDispatchOrExtensionReceiver(argumentsInfo, functionName);
        }
        return new JsInvocation((JsExpression)JsAstUtils.pureFqn(functionName, dispatchReceiver), argumentsInfo.getTranslateArguments());
    }

    @NotNull
    public final JsExpression buildDefaultCallWithoutReceiver(@NotNull TranslationContext context2, @NotNull CallArgumentTranslator.ArgumentsInfo argumentsInfo, @NotNull CallableDescriptor callableDescriptor, boolean isNative, boolean hasSpreadOperator) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)argumentsInfo, (String)"argumentsInfo");
        Intrinsics.checkNotNullParameter((Object)callableDescriptor, (String)"callableDescriptor");
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference(callableDescriptor, context2);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"translateAsValueReference(...)");
        JsExpression functionRef = jsExpression;
        if (isNative && hasSpreadOperator) {
            JsNameRef jsNameRef = Namer.getFunctionApplyRef(functionRef);
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"getFunctionApplyRef(...)");
            JsNameRef functionCallRef = jsNameRef;
            return new JsInvocation((JsExpression)functionCallRef, argumentsInfo.getTranslateArguments());
        }
        return new JsInvocation(functionRef, argumentsInfo.getTranslateArguments());
    }

    @Override
    @NotNull
    protected JsExpression noReceivers(@NotNull FunctionCallInfo $this$noReceivers) {
        Intrinsics.checkNotNullParameter((Object)$this$noReceivers, (String)"<this>");
        return this.buildDefaultCallWithoutReceiver($this$noReceivers.getContext(), $this$noReceivers.getArgumentsInfo(), CallInfoExtensionsKt.getCallableDescriptor($this$noReceivers), CallInfoExtensionsKt.isNative($this$noReceivers), CallInfoExtensionsKt.hasSpreadOperator($this$noReceivers));
    }

    @Override
    @NotNull
    protected JsExpression dispatchReceiver(@NotNull FunctionCallInfo $this$dispatchReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$dispatchReceiver, (String)"<this>");
        CallArgumentTranslator.ArgumentsInfo argumentsInfo = $this$dispatchReceiver.getArgumentsInfo();
        JsExpression jsExpression = $this$dispatchReceiver.getDispatchReceiver();
        Intrinsics.checkNotNull((Object)jsExpression);
        return this.buildDefaultCallWithDispatchReceiver(argumentsInfo, jsExpression, CallInfoExtensionsKt.getFunctionName($this$dispatchReceiver), CallInfoExtensionsKt.isNative($this$dispatchReceiver), CallInfoExtensionsKt.hasSpreadOperator($this$dispatchReceiver));
    }

    @Override
    @NotNull
    protected JsExpression extensionReceiver(@NotNull FunctionCallInfo $this$extensionReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$extensionReceiver, (String)"<this>");
        if (CallInfoExtensionsKt.isNative($this$extensionReceiver) && CallInfoExtensionsKt.hasSpreadOperator($this$extensionReceiver)) {
            return this.nativeSpreadFunWithDispatchOrExtensionReceiver($this$extensionReceiver.getArgumentsInfo(), CallInfoExtensionsKt.getFunctionName($this$extensionReceiver));
        }
        if (CallInfoExtensionsKt.isNative($this$extensionReceiver)) {
            return new JsInvocation((JsExpression)new JsNameRef(CallInfoExtensionsKt.getFunctionName($this$extensionReceiver), $this$extensionReceiver.getExtensionReceiver()), $this$extensionReceiver.getArgumentsInfo().getTranslateArguments());
        }
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference(CallInfoExtensionsKt.getCallableDescriptor($this$extensionReceiver), $this$extensionReceiver.getContext());
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"translateAsValueReference(...)");
        JsExpression functionRef = jsExpression;
        CallArgumentTranslator.ArgumentsInfo argumentsInfo = $this$extensionReceiver.getArgumentsInfo();
        JsExpression jsExpression2 = $this$extensionReceiver.getExtensionReceiver();
        Intrinsics.checkNotNull((Object)jsExpression2);
        return new JsInvocation(functionRef, FunctionCallCasesKt.argsWithReceiver(argumentsInfo, jsExpression2));
    }

    @Override
    @NotNull
    protected JsExpression bothReceivers(@NotNull FunctionCallInfo $this$bothReceivers) {
        Intrinsics.checkNotNullParameter((Object)$this$bothReceivers, (String)"<this>");
        JsName jsName = CallInfoExtensionsKt.getFunctionName($this$bothReceivers);
        JsExpression jsExpression = $this$bothReceivers.getDispatchReceiver();
        Intrinsics.checkNotNull((Object)jsExpression);
        JsNameRef jsNameRef = JsAstUtils.pureFqn(jsName, jsExpression);
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"pureFqn(...)");
        JsNameRef functionRef = jsNameRef;
        JsExpression jsExpression2 = functionRef;
        CallArgumentTranslator.ArgumentsInfo argumentsInfo = $this$bothReceivers.getArgumentsInfo();
        JsExpression jsExpression3 = $this$bothReceivers.getExtensionReceiver();
        Intrinsics.checkNotNull((Object)jsExpression3);
        return new JsInvocation(jsExpression2, FunctionCallCasesKt.argsWithReceiver(argumentsInfo, jsExpression3));
    }
}

