/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUpperBoundViolatedHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUpperBoundViolatedExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "withSourceRecursive", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUpperBoundViolatedExpressionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUpperBoundViolatedExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUpperBoundViolatedExpressionChecker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n11165#2:98\n11500#2,3:99\n1755#3,3:102\n1#4:105\n*S KotlinDebug\n*F\n+ 1 FirUpperBoundViolatedExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUpperBoundViolatedExpressionChecker\n*L\n48#1:98\n48#1:99,3\n60#1:102,3\n*E\n"})
public final class FirUpperBoundViolatedExpressionChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirUpperBoundViolatedExpressionChecker INSTANCE = new FirUpperBoundViolatedExpressionChecker();

    private FirUpperBoundViolatedExpressionChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        Object typeParameters2;
        List typeArguments2;
        block13: {
            FirCallableSymbol firCallableSymbol;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirReference calleeReference = expression2.getCalleeReference();
            if (calleeReference instanceof FirResolvedErrorReference) {
                if (((FirResolvedErrorReference)calleeReference).getDiagnostic() instanceof ConeInapplicableWrongReceiver) {
                    return;
                }
                firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(calleeReference, false, 1, null);
            } else {
                firCallableSymbol = calleeReference instanceof FirResolvedNamedReference ? FirReferenceUtilsKt.toResolvedCallableSymbol$default(calleeReference, false, 1, null) : null;
            }
            FirCallableSymbol calleeSymbol = firCallableSymbol;
            typeArguments2 = null;
            typeParameters2 = null;
            if (calleeSymbol instanceof FirConstructorSymbol && TypeAliasConstructorsSubstitutingScopeKt.isTypeAliasedConstructor((FirConstructorSymbol)calleeSymbol)) {
                void $this$mapTo$iv$iv;
                ConeKotlinType constructedType = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getResolvedType(expression2), context2.getSession(), null, 2, null);
                ConeTypeProjection[] $this$map$iv = constructedType.getTypeArguments();
                boolean $i$f$map = false;
                ConeTypeProjection[] coneTypeProjectionArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var16_18 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(INSTANCE.withSourceRecursive((ConeTypeProjection)it, expression2));
                }
                typeArguments2 = (List)destination$iv$iv;
                FirClassifierSymbol<?> firClassifierSymbol = TypeUtilsKt.toSymbol(constructedType, context2.getSession());
                Object object = firClassifierSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassifierSymbol : null;
                if (object == null || (object = ((FirClassLikeSymbol)object).getTypeParameterSymbols()) == null) {
                    return;
                }
                typeParameters2 = object;
            } else {
                typeArguments2 = FirUpperBoundViolatedHelpersKt.toTypeArgumentsWithSourceInfo(expression2.getTypeArguments());
                Object object = calleeSymbol;
                if (object == null || (object = ((FirCallableSymbol)object).getTypeParameterSymbols()) == null) {
                    return;
                }
                typeParameters2 = object;
            }
            Iterable $this$any$iv = typeArguments2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeTypeProjection it = (ConeTypeProjection)element$iv;
                    boolean bl3 = false;
                    if (!(!(it instanceof ConeKotlinType))) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        if (typeArguments2.size() != typeParameters2.size()) {
            return;
        }
        ConeSubstitutor substitutor2 = FirUpperBoundViolatedHelpersKt.createSubstitutorForUpperBoundViolationCheck((List<FirTypeParameterSymbol>)typeParameters2, typeArguments2, context2.getSession());
        FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated$default(context2, reporter, (List)typeParameters2, typeArguments2, substitutor2, false, false, 96, null);
    }

    private final ConeTypeProjection withSourceRecursive(ConeTypeProjection $this$withSourceRecursive, FirQualifiedAccessExpression expression2) {
        ConeTypeProjection coneTypeProjection;
        Object v0;
        ConeTypeProjection type2;
        block3: {
            type2 = $this$withSourceRecursive instanceof ConeClassLikeType && !(((ConeClassLikeType)$this$withSourceRecursive).getTypeArguments().length == 0) ? (ConeTypeProjection)TypeUtilsKt.withArguments((ConeKotlinType)$this$withSourceRecursive, (Function1<? super ConeTypeProjection, ? extends ConeTypeProjection>)((Function1)arg_0 -> FirUpperBoundViolatedExpressionChecker.withSourceRecursive$lambda$2(expression2, arg_0))) : $this$withSourceRecursive;
            Iterable iterable = expression2.getTypeArguments();
            for (Object t : iterable) {
                FirTypeProjection it = (FirTypeProjection)t;
                boolean bl = false;
                if (!(FirTypeUtilsKt.toConeTypeProjection(it) == $this$withSourceRecursive)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        FirTypeProjection argument = v0;
        if (argument == null) {
            coneTypeProjection = FirUpperBoundViolatedHelpersKt.withSource(type2, new FirTypeRefSource(null, expression2.getSource()));
        } else {
            FirTypeProjectionWithVariance firTypeProjectionWithVariance = argument instanceof FirTypeProjectionWithVariance ? (FirTypeProjectionWithVariance)argument : null;
            coneTypeProjection = FirUpperBoundViolatedHelpersKt.withSource(type2, new FirTypeRefSource(firTypeProjectionWithVariance != null ? firTypeProjectionWithVariance.getTypeRef() : null, argument.getSource()));
        }
        return coneTypeProjection;
    }

    private static final ConeTypeProjection withSourceRecursive$lambda$2(FirQualifiedAccessExpression $expression, ConeTypeProjection it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.withSourceRecursive(it, $expression);
    }
}

