/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J2\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "representation", "", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "getRepresentation", "(Lorg/jetbrains/kotlin/descriptors/ClassKind;)Ljava/lang/String;", "checkOptInIsEnabled", "element", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkOptInArgumentIsMarker", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "source", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInAnnotationCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInAnnotationCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,134:1\n26#2:135\n43#3:136\n51#4:137\n54#4:138\n*S KotlinDebug\n*F\n+ 1 FirOptInAnnotationCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker\n*L\n39#1:135\n47#1:136\n76#1:137\n80#1:138\n*E\n"})
public final class FirOptInAnnotationCallChecker
extends FirExpressionChecker<FirAnnotationCall> {
    @NotNull
    public static final FirOptInAnnotationCallChecker INSTANCE = new FirOptInAnnotationCallChecker();

    private FirOptInAnnotationCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirAnnotationCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirTypeRef $this$coneTypeSafe$iv = expression2.getAnnotationTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        if ((object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) {
            return;
        }
        Object lookupTag = object;
        ClassId classId = ((ConeClassLikeLookupTag)lookupTag).getClassId();
        boolean isRequiresOptIn = Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID());
        boolean isOptIn = Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getOPT_IN_CLASS_ID());
        boolean isSubclassOptIn = Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID());
        if (isRequiresOptIn || isOptIn) {
            this.checkOptInIsEnabled(expression2.getSource(), context2, reporter);
            if (isOptIn) {
                FirCall $this$arguments$iv = expression2;
                boolean $i$f$getArguments = false;
                List<FirExpression> arguments2 = $this$arguments$iv.getArgumentList().getArguments();
                if (arguments2.isEmpty()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getOPT_IN_WITHOUT_ARGUMENTS(), (DiagnosticContext)context2, null, 8, null);
                } else {
                    FirExpression annotationClasses;
                    FirExpression firExpression = annotationClasses = FirAnnotationUtilsKt.findArgumentByName$default(expression2, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null);
                    List list = firExpression != null ? FirAnnotationHelpersKt.extractClassesFromArgument(firExpression, context2.getSession()) : null;
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    for (FirRegularClassSymbol classSymbol : list) {
                        this.checkOptInArgumentIsMarker(classSymbol, classId, expression2.getSource(), reporter, context2);
                    }
                }
            }
        } else if (isSubclassOptIn) {
            Object object2;
            FirClass declaration2;
            Object annotationClasses = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
            FirClass firClass = declaration2 = annotationClasses instanceof FirClass ? (FirClass)annotationClasses : null;
            if (declaration2 != null) {
                ClassKind kind = declaration2.getClassKind();
                String classKindRepresentation = this.getRepresentation(kind);
                if (kind == ClassKind.ENUM_CLASS || kind == ClassKind.OBJECT || kind == ClassKind.ANNOTATION_CLASS) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getSUBCLASS_OPT_IN_INAPPLICABLE(), (Object)classKindRepresentation, (DiagnosticContext)context2, null, 16, null);
                    return;
                }
                Modality modality = FirHelpersKt.modality(declaration2);
                if (modality == Modality.FINAL || modality == Modality.SEALED) {
                    AbstractKtSourceElement abstractKtSourceElement = expression2.getSource();
                    KtDiagnosticFactory1<String> ktDiagnosticFactory1 = FirErrors.INSTANCE.getSUBCLASS_OPT_IN_INAPPLICABLE();
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = modality.name().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)stringBuilder.append(string2).append(' ').append(classKindRepresentation).toString(), (DiagnosticContext)context2, null, 16, null);
                    return;
                }
                FirMemberDeclaration $this$isFun$iv = declaration2;
                boolean $i$f$isFun = false;
                if ($this$isFun$iv.getStatus().isFun()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getSUBCLASS_OPT_IN_INAPPLICABLE(), (Object)"fun interface", (DiagnosticContext)context2, null, 16, null);
                    return;
                }
                FirClassLikeDeclaration $this$isLocal$iv = declaration2;
                boolean $i$f$isLocal = false;
                if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getSUBCLASS_OPT_IN_INAPPLICABLE(), (Object)("local " + classKindRepresentation), (DiagnosticContext)context2, null, 16, null);
                    return;
                }
            }
            if ((object2 = FirAnnotationUtilsKt.findArgumentByName$default(expression2, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null)) == null || (object2 = FirAnnotationHelpersKt.extractClassFromArgument((FirExpression)object2, context2.getSession())) == null) {
                return;
            }
            Object classSymbol = object2;
            this.checkOptInArgumentIsMarker((FirRegularClassSymbol)classSymbol, classId, expression2.getSource(), reporter, context2);
        }
    }

    private final String getRepresentation(ClassKind $this$representation) {
        String string2;
        if (WhenMappings.$EnumSwitchMapping$0[$this$representation.ordinal()] == 1) {
            string2 = "enum entry";
        } else {
            String string3 = $this$representation.getCodeRepresentation();
            string2 = string3;
            Intrinsics.checkNotNull((Object)string3);
        }
        return string2;
    }

    private final void checkOptInIsEnabled(KtSourceElement element2, CheckerContext context2, DiagnosticReporter reporter) {
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        List<String> optInFqNames = languageVersionSettings.getFlag(AnalysisFlags.getOptIn());
        if (!languageVersionSettings.supportsFeature(LanguageFeature.OptInRelease) && !optInFqNames.contains(OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)element2, FirErrors.INSTANCE.getOPT_IN_IS_NOT_ENABLED(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkOptInArgumentIsMarker(FirRegularClassSymbol classSymbol, ClassId annotationClassId, KtSourceElement source, DiagnosticReporter reporter, CheckerContext context2) {
        FirOptInUsageBaseChecker $this$checkOptInArgumentIsMarker_u24lambda_u240 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        if (FirOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation$default($this$checkOptInArgumentIsMarker_u24lambda_u240, classSymbol, context2.getSession(), null, 2, null) == null) {
            KtDiagnosticFactory1<ClassId> ktDiagnosticFactory1;
            ClassId classId = annotationClassId;
            if (Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getOPT_IN_CLASS_ID())) {
                ktDiagnosticFactory1 = FirErrors.INSTANCE.getOPT_IN_ARGUMENT_IS_NOT_MARKER();
            } else if (Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID())) {
                ktDiagnosticFactory1 = FirErrors.INSTANCE.getSUBCLASS_OPT_ARGUMENT_IS_NOT_MARKER();
            } else {
                return;
            }
            KtDiagnosticFactory1<ClassId> diagnostic = ktDiagnosticFactory1;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, diagnostic, (Object)classSymbol.getClassId(), (DiagnosticContext)context2, null, 16, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

