/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ClassTraversalCache;
import org.jetbrains.kotlin.container.ConstructorInfo;
import org.jetbrains.kotlin.container.DefaultImplementation;
import org.jetbrains.kotlin.container.SetterInfo;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002\u001a\u0014\u0010\u0003\u001a\u00020\u00012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002\u001a\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\t2\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002\u001a\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002\u001a\u001a\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002\u001a\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002\u00a8\u0006\u0013"}, d2={"getInfo", "Lorg/jetbrains/kotlin/container/ClassInfo;", "Ljava/lang/Class;", "traverseClass", "c", "getSetterInfos", "", "Lorg/jetbrains/kotlin/container/SetterInfo;", "getConstructorInfo", "Lorg/jetbrains/kotlin/container/ConstructorInfo;", "collectInterfacesRecursive", "", "type", "Ljava/lang/reflect/Type;", "result", "", "getDefaultImplementation", "klass", "getRegistrations", "container"})
@SourceDebugExtension(value={"SMAP\nCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cache.kt\norg/jetbrains/kotlin/container/CacheKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,129:1\n3829#2:130\n4344#2,2:131\n13409#2,2:133\n1317#3,2:135\n*S KotlinDebug\n*F\n+ 1 Cache.kt\norg/jetbrains/kotlin/container/CacheKt\n*L\n81#1:130\n81#1:131,2\n100#1:133,2\n124#1:135,2\n*E\n"})
public final class CacheKt {
    @NotNull
    public static final ClassInfo getInfo(@NotNull Class<?> $this$getInfo) {
        Intrinsics.checkNotNullParameter($this$getInfo, (String)"<this>");
        return ClassTraversalCache.INSTANCE.getClassInfo($this$getInfo);
    }

    private static final ClassInfo traverseClass(Class<?> c) {
        return new ClassInfo(CacheKt.getConstructorInfo(c), CacheKt.getSetterInfos(c), CacheKt.getRegistrations(c), CacheKt.getDefaultImplementation(c));
    }

    private static final List<SetterInfo> getSetterInfos(Class<?> c) {
        ArrayList<SetterInfo> setterInfos = new ArrayList<SetterInfo>();
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])c.getMethods());
        while (iterator2.hasNext()) {
            Method method = (Method)iterator2.next();
            Iterator iterator3 = ArrayIteratorKt.iterator((Object[])method.getDeclaredAnnotations());
            while (iterator3.hasNext()) {
                Annotation annotation = (Annotation)iterator3.next();
                String string2 = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation)).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string2, (String)".Inject", (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNull((Object)method);
                Type[] typeArray = method.getGenericParameterTypes();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getGenericParameterTypes(...)");
                setterInfos.add(new SetterInfo(method, ArraysKt.toList((Object[])typeArray)));
            }
        }
        return setterInfos;
    }

    /*
     * WARNING - void declaration
     */
    private static final ConstructorInfo getConstructorInfo(Class<?> c) {
        List list;
        void $this$filterTo$iv$iv;
        if (Modifier.isAbstract(c.getModifiers()) || c.isPrimitive()) {
            return null;
        }
        Constructor<?>[] constructorArray = c.getConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getConstructors(...)");
        SpreadBuilder $this$filter$iv = (SpreadBuilder)constructorArray;
        boolean $i$f$filter = false;
        SpreadBuilder spreadBuilder = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Constructor it = (Constructor)element$iv$iv;
            boolean bl = false;
            if (!(Modifier.isPublic(it.getModifiers()) && !it.isSynthetic())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List publicConstructors = (List)destination$iv$iv;
        if (publicConstructors.size() != 1) {
            return null;
        }
        Constructor constructor = (Constructor)CollectionsKt.single((List)publicConstructors);
        if (c.getDeclaringClass() != null && !Modifier.isStatic(c.getModifiers())) {
            spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add(c.getDeclaringClass());
            spreadBuilder.addSpread((Object)constructor.getGenericParameterTypes());
            list = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new Type[spreadBuilder.size()]));
        } else {
            Type[] typeArray = constructor.getGenericParameterTypes();
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getGenericParameterTypes(...)");
            list = ArraysKt.toList((Object[])typeArray);
        }
        List parameterTypes2 = list;
        Intrinsics.checkNotNull((Object)constructor);
        return new ConstructorInfo(constructor, parameterTypes2);
    }

    private static final void collectInterfacesRecursive(Type type2, Set<Type> result2) {
        block1: {
            Type[] klass;
            Type type3;
            Type type4 = type2;
            Object object = type4 instanceof Class ? (Type[])type2 : (type4 instanceof ParameterizedType ? ((type3 = ((ParameterizedType)type2).getRawType()) instanceof Class ? (Class)type3 : null) : null);
            Type[] typeArray = klass = object;
            if (klass == null || (typeArray = typeArray.getGenericInterfaces()) == null) break block1;
            Type[] $this$forEach$iv = typeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Type element$iv;
                Type it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!result2.add(it)) continue;
                CacheKt.collectInterfacesRecursive(it, result2);
            }
        }
    }

    private static final Class<?> getDefaultImplementation(Class<?> klass) {
        DefaultImplementation defaultImplementation = klass.getAnnotation(DefaultImplementation.class);
        return defaultImplementation != null ? defaultImplementation.impl() : null;
    }

    private static final List<Type> getRegistrations(Class<?> klass) {
        ArrayList registrations = new ArrayList();
        Sequence superClasses = SequencesKt.generateSequence(klass, CacheKt::getRegistrations$lambda$2);
        CollectionsKt.addAll((Collection)registrations, (Sequence)superClasses);
        LinkedHashSet interfaces = new LinkedHashSet();
        Sequence $this$forEach$iv = superClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Type it = (Type)element$iv;
            boolean bl = false;
            CacheKt.collectInterfacesRecursive(it, interfaces);
        }
        registrations.addAll(interfaces);
        registrations.remove(Object.class);
        return registrations;
    }

    private static final Type getRegistrations$lambda$2(Type it) {
        Type type2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Type type3 = it;
        if (type3 instanceof Class) {
            type2 = ((Class)it).getGenericSuperclass();
        } else if (type3 instanceof ParameterizedType) {
            Type type4 = ((ParameterizedType)it).getRawType();
            Class clazz = type4 instanceof Class ? (Class)type4 : null;
            type2 = clazz != null ? clazz.getGenericSuperclass() : null;
        } else {
            type2 = null;
        }
        return type2;
    }

    public static final /* synthetic */ ClassInfo access$traverseClass(Class c) {
        return CacheKt.traverseClass(c);
    }
}

