/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InnerClassConstructorCallsLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "innerClassesSupport", "Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ir.backend.common"})
public class InnerClassConstructorCallsLowering
implements BodyLoweringPass {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final InnerClassesSupport innerClassesSupport;

    public InnerClassConstructorCallsLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.innerClassesSupport = this.context.getInnerClassesSupport();
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this){
            final /* synthetic */ InnerClassConstructorCallsLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrExpression visitConstructorCall(IrConstructorCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression == null) {
                    return expression2;
                }
                IrExpression dispatchReceiver = irExpression;
                IrConstructorSymbol callee = expression2.getSymbol();
                IrClass parent2 = IrUtilsKt.getParentAsClass(callee.getOwner());
                if (!parent2.isInner()) {
                    return expression2;
                }
                IrConstructor newCallee = InnerClassConstructorCallsLowering.access$getInnerClassesSupport$p(this.this$0).getInnerClassConstructorWithOuterThisParameter((IrConstructor)callee.getOwner());
                int classTypeParametersCount = expression2.getTypeArgumentsCount() - expression2.getConstructorTypeArgumentsCount();
                IrConstructorCallImpl newCall = IrConstructorCallImpl.Companion.fromSymbolOwner(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), newCallee.getSymbol(), classTypeParametersCount, expression2.getOrigin());
                IrExpressionsKt.copyTypeArgumentsFrom$default(newCall, expression2, 0, 2, null);
                newCall.putValueArgument(0, dispatchReceiver);
                int i = 1;
                int n = CollectionsKt.getLastIndex(newCallee.getValueParameters());
                if (i <= n) {
                    while (true) {
                        newCall.putValueArgument(i, expression2.getValueArgument(i - 1));
                        if (i == n) break;
                        ++i;
                    }
                }
                return newCall;
            }

            public IrExpression visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                IrDelegatingConstructorCallImpl irDelegatingConstructorCallImpl;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression == null) {
                    return expression2;
                }
                IrExpression dispatchReceiver = irExpression;
                IrConstructor classConstructor = (IrConstructor)expression2.getSymbol().getOwner();
                if (!IrUtilsKt.getParentAsClass(classConstructor).isInner()) {
                    return expression2;
                }
                IrConstructor newCallee = InnerClassConstructorCallsLowering.access$getInnerClassesSupport$p(this.this$0).getInnerClassConstructorWithOuterThisParameter(classConstructor);
                IrDelegatingConstructorCallImpl $this$visitDelegatingConstructorCall_u24lambda_u240 = irDelegatingConstructorCallImpl = new IrDelegatingConstructorCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getUnitType(), newCallee.getSymbol(), expression2.getTypeArgumentsCount(), newCallee.getValueParameters().size());
                boolean bl = false;
                IrExpressionsKt.copyTypeArgumentsFrom$default($this$visitDelegatingConstructorCall_u24lambda_u240, expression2, 0, 2, null);
                IrDelegatingConstructorCallImpl newCall = irDelegatingConstructorCallImpl;
                newCall.putValueArgument(0, dispatchReceiver);
                int i = 1;
                int n = CollectionsKt.getLastIndex(newCallee.getValueParameters());
                if (i <= n) {
                    while (true) {
                        newCall.putValueArgument(i, expression2.getValueArgument(i - 1));
                        if (i == n) break;
                        ++i;
                    }
                }
                return newCall;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public IrExpression visitFunctionReference(IrFunctionReference expression2) {
                IrFunctionReferenceImpl newReference;
                IrConstructor irConstructor;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                S s = expression2.getSymbol();
                IrConstructorSymbol irConstructorSymbol = s instanceof IrConstructorSymbol ? (IrConstructorSymbol)s : null;
                if (irConstructorSymbol == null) {
                    return expression2;
                }
                IrConstructorSymbol callee = irConstructorSymbol;
                IrDeclarationParent irDeclarationParent = ((IrConstructor)callee.getOwner()).getParent();
                IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
                if (irClass == null) {
                    return expression2;
                }
                IrClass parent2 = irClass;
                if (!parent2.isInner()) {
                    return expression2;
                }
                IrConstructor newCallee = InnerClassConstructorCallsLowering.access$getInnerClassesSupport$p(this.this$0).getInnerClassConstructorWithOuterThisParameter((IrConstructor)callee.getOwner());
                IrFunctionSymbol irFunctionSymbol = expression2.getReflectionTarget();
                if (irFunctionSymbol != null) {
                    IrFunctionSymbol irFunctionSymbol2 = irFunctionSymbol;
                    InnerClassConstructorCallsLowering innerClassConstructorCallsLowering = this.this$0;
                    IrFunctionSymbol reflectionTarget = irFunctionSymbol2;
                    boolean bl = false;
                    IrFunctionSymbol irFunctionSymbol3 = reflectionTarget;
                    if (irFunctionSymbol3 instanceof IrConstructorSymbol) {
                        irConstructor = InnerClassConstructorCallsLowering.access$getInnerClassesSupport$p(innerClassConstructorCallsLowering).getInnerClassConstructorWithOuterThisParameter((IrConstructor)((IrConstructorSymbol)reflectionTarget).getOwner());
                    } else {
                        if (!(irFunctionSymbol3 instanceof IrSimpleFunctionSymbol)) throw new NoWhenBranchMatchedException();
                        irConstructor = null;
                    }
                } else {
                    irConstructor = null;
                }
                IrConstructor newReflectionTarget = irConstructor;
                IrFunctionReference $this$visitFunctionReference_u24lambda_u242 = expression2;
                boolean bl = false;
                IrConstructor irConstructor2 = newReflectionTarget;
                IrFunctionReferenceImpl it = newReference = new IrFunctionReferenceImpl($this$visitFunctionReference_u24lambda_u242.getStartOffset(), $this$visitFunctionReference_u24lambda_u242.getEndOffset(), $this$visitFunctionReference_u24lambda_u242.getType(), newCallee.getSymbol(), $this$visitFunctionReference_u24lambda_u242.getTypeArgumentsCount(), newCallee.getValueParameters().size(), irConstructor2 != null ? irConstructor2.getSymbol() : null, $this$visitFunctionReference_u24lambda_u242.getOrigin());
                boolean bl2 = false;
                IrExpressionsKt.copyTypeArgumentsFrom$default(it, expression2, 0, 2, null);
                it.setDispatchReceiver(expression2.getDispatchReceiver());
                it.setExtensionReceiver(expression2.getExtensionReceiver());
                int n = expression2.getValueArgumentsCount();
                for (int v = 0; v < n; ++v) {
                    it.putValueArgument(v, expression2.getValueArgument(v));
                }
                return newReference;
            }
        });
    }

    public static final /* synthetic */ InnerClassesSupport access$getInnerClassesSupport$p(InnerClassConstructorCallsLowering $this) {
        return $this.innerClassesSupport;
    }
}

