/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.diagnostics.AbstractKtDiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.InternalDiagnosticFactoryMethod;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.KtLightSimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtOffsetsOnlySimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtPsiSimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtSimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.SimpleKtDiagnosticRenderer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0007R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "Lorg/jetbrains/kotlin/diagnostics/AbstractKtDiagnosticFactory;", "name", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "defaultPositioningStrategy", "Lorg/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;", "psiType", "Lkotlin/reflect/KClass;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;Lorg/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;Lkotlin/reflect/KClass;)V", "ktRenderer", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticRenderer;", "getKtRenderer", "()Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticRenderer;", "on", "Lorg/jetbrains/kotlin/diagnostics/KtSimpleDiagnostic;", "element", "Lorg/jetbrains/kotlin/AbstractKtSourceElement;", "positioningStrategy", "frontend.common"})
public final class KtDiagnosticFactory0
extends AbstractKtDiagnosticFactory {
    @NotNull
    private final KtDiagnosticRenderer ktRenderer;

    public KtDiagnosticFactory0(@NotNull String name2, @NotNull Severity severity, @NotNull AbstractSourceElementPositioningStrategy defaultPositioningStrategy, @NotNull KClass<?> psiType) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter((Object)defaultPositioningStrategy, (String)"defaultPositioningStrategy");
        Intrinsics.checkNotNullParameter(psiType, (String)"psiType");
        super(name2, severity, defaultPositioningStrategy, psiType, null);
        this.ktRenderer = new SimpleKtDiagnosticRenderer("");
    }

    @Override
    @NotNull
    public KtDiagnosticRenderer getKtRenderer() {
        return this.ktRenderer;
    }

    @InternalDiagnosticFactoryMethod
    @NotNull
    public final KtSimpleDiagnostic on(@NotNull AbstractKtSourceElement element2, @Nullable AbstractSourceElementPositioningStrategy positioningStrategy) {
        KtSimpleDiagnostic ktSimpleDiagnostic;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        AbstractKtSourceElement abstractKtSourceElement = element2;
        if (abstractKtSourceElement instanceof KtPsiSourceElement) {
            KtPsiSourceElement ktPsiSourceElement = (KtPsiSourceElement)element2;
            Severity severity = this.getSeverity();
            AbstractSourceElementPositioningStrategy abstractSourceElementPositioningStrategy = positioningStrategy;
            if (abstractSourceElementPositioningStrategy == null) {
                abstractSourceElementPositioningStrategy = this.getDefaultPositioningStrategy();
            }
            ktSimpleDiagnostic = new KtPsiSimpleDiagnostic(ktPsiSourceElement, severity, this, abstractSourceElementPositioningStrategy);
        } else if (abstractKtSourceElement instanceof KtLightSourceElement) {
            KtLightSourceElement ktLightSourceElement = (KtLightSourceElement)element2;
            Severity severity = this.getSeverity();
            AbstractSourceElementPositioningStrategy abstractSourceElementPositioningStrategy = positioningStrategy;
            if (abstractSourceElementPositioningStrategy == null) {
                abstractSourceElementPositioningStrategy = this.getDefaultPositioningStrategy();
            }
            ktSimpleDiagnostic = new KtLightSimpleDiagnostic(ktLightSourceElement, severity, this, abstractSourceElementPositioningStrategy);
        } else {
            Severity severity = this.getSeverity();
            AbstractSourceElementPositioningStrategy abstractSourceElementPositioningStrategy = positioningStrategy;
            if (abstractSourceElementPositioningStrategy == null) {
                abstractSourceElementPositioningStrategy = this.getDefaultPositioningStrategy();
            }
            ktSimpleDiagnostic = new KtOffsetsOnlySimpleDiagnostic(element2, severity, this, abstractSourceElementPositioningStrategy);
        }
        return ktSimpleDiagnostic;
    }
}

