/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.components.KaFirSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KaFirPsiJavaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolProviderByJavaPsi;
import org.jetbrains.kotlin.asJava.KtLightClassMarker;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\fH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirSymbolProviderByJavaPsi;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbolProviderByJavaPsi;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "getNamedClassSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedClassOrObjectSymbol;", "psiClass", "Lcom/intellij/psi/PsiClass;", "isKotlinCompiledClass", "", "getCallableSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "callable", "Lcom/intellij/psi/PsiMember;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKtFirSymbolProviderByJavaPsi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFirSymbolProviderByJavaPsi.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KaFirSymbolProviderByJavaPsi\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,45:1\n1#2:46\n183#3,2:47\n*S KotlinDebug\n*F\n+ 1 KtFirSymbolProviderByJavaPsi.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KaFirSymbolProviderByJavaPsi\n*L\n42#1:47,2\n*E\n"})
public final class KaFirSymbolProviderByJavaPsi
extends KaSymbolProviderByJavaPsi
implements KaFirSessionComponent {
    @NotNull
    private final KaFirSession analysisSession;

    public KaFirSymbolProviderByJavaPsi(@NotNull KaFirSession analysisSession) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        this.analysisSession = analysisSession;
    }

    @Override
    @NotNull
    public KaFirSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @Nullable
    public KaNamedClassOrObjectSymbol getNamedClassSymbol(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        if (psiClass.getQualifiedName() == null) {
            return null;
        }
        if (psiClass instanceof PsiTypeParameter) {
            return null;
        }
        if (psiClass instanceof KtLightClassMarker) {
            return null;
        }
        if (this.isKotlinCompiledClass(psiClass)) {
            return null;
        }
        return new KaFirPsiJavaClassSymbol(psiClass, this.getAnalysisSession());
    }

    private final boolean isKotlinCompiledClass(PsiClass $this$isKotlinCompiledClass) {
        return $this$isKotlinCompiledClass instanceof ClsElementImpl && $this$isKotlinCompiledClass.hasAnnotation(JvmAnnotationNames.METADATA_FQ_NAME.asString());
    }

    @Override
    @Nullable
    public KaCallableSymbol getCallableSymbol(@NotNull PsiMember callable) {
        Object v4;
        block7: {
            Object object;
            block9: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)callable, (String)"callable");
                    if (!(callable instanceof PsiMethod) && !(callable instanceof PsiField)) {
                        return null;
                    }
                    object = ((PsiNamedElement)((Object)callable)).getName();
                    if (object == null) break block8;
                    String p0 = object;
                    boolean bl = false;
                    Name name2 = Name.identifier(p0);
                    object = name2;
                    if (name2 != null) break block9;
                }
                return null;
            }
            Object name3 = object;
            PsiClass psiClass = callable.getContainingClass();
            if (psiClass == null) {
                return null;
            }
            PsiClass containingClass = psiClass;
            KaNamedClassOrObjectSymbol kaNamedClassOrObjectSymbol = this.getNamedClassSymbol(containingClass);
            if (kaNamedClassOrObjectSymbol == null) {
                return null;
            }
            KaNamedClassOrObjectSymbol classSymbol = kaNamedClassOrObjectSymbol;
            KaFirSession $this$getCallableSymbol_u24lambda_u241 = this.getAnalysisSession();
            boolean bl = false;
            Name[] nameArray = new Name[]{name3};
            Sequence<KaCallableSymbol> $this$firstOrNull$iv = $this$getCallableSymbol_u24lambda_u241.getCombinedDeclaredMemberScope(classSymbol).callables(nameArray);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KaCallableSymbol it = (KaCallableSymbol)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getPsi(), (Object)callable)) continue;
                v4 = element$iv;
                break block7;
            }
            v4 = null;
        }
        return v4;
    }
}

