/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\n\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J3\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\b2!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\f0\u0012H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lkotlinx/serialization/json/internal/StringJsonLexer;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "source", "", "(Ljava/lang/String;)V", "getSource", "()Ljava/lang/String;", "canConsumeValue", "", "consumeKeyString", "consumeNextToken", "", "", "expected", "", "consumeStringChunked", "isLenient", "consumeChunk", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "stringChunk", "peekLeadingMatchingValue", "keyToMatch", "prefetchOrEof", "", "position", "skipWhitespaces", "tryConsumeComma", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nStringJsonLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringJsonLexer.kt\nkotlinx/serialization/json/internal/StringJsonLexer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1855#2,2:128\n*S KotlinDebug\n*F\n+ 1 StringJsonLexer.kt\nkotlinx/serialization/json/internal/StringJsonLexer\n*L\n107#1:128,2\n*E\n"})
public final class StringJsonLexer
extends AbstractJsonLexer {
    @NotNull
    private final String source;

    public StringJsonLexer(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
    }

    @Override
    @NotNull
    protected String getSource() {
        return this.source;
    }

    @Override
    public int prefetchOrEof(int position) {
        return position < this.getSource().length() ? position : -1;
    }

    @Override
    public byte consumeNextToken() {
        String source = this.getSource();
        while (this.currentPosition != -1 && this.currentPosition < source.length()) {
            byte by = this.currentPosition;
            this.currentPosition = by + 1;
            char ch = source.charAt(by);
            if ((by = (byte)AbstractJsonLexerKt.charToTokenClass(ch)) == 3) continue;
            return by;
        }
        return 10;
    }

    @Override
    public boolean tryConsumeComma() {
        int current = this.skipWhitespaces();
        if (current == this.getSource().length() || current == -1) {
            return false;
        }
        if (this.getSource().charAt(current) == ',') {
            ++this.currentPosition;
            return true;
        }
        return false;
    }

    @Override
    public boolean canConsumeValue() {
        int current = this.currentPosition;
        if (current == -1) {
            return false;
        }
        while (current < this.getSource().length()) {
            char c = this.getSource().charAt(current);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                ++current;
                continue;
            }
            this.currentPosition = current;
            return this.isValidValueStart(c);
        }
        this.currentPosition = current;
        return false;
    }

    @Override
    public int skipWhitespaces() {
        char c;
        int current = this.currentPosition;
        if (current == -1) {
            return current;
        }
        while (current < this.getSource().length() && ((c = this.getSource().charAt(current)) == ' ' || c == '\n' || c == '\r' || c == '\t')) {
            ++current;
        }
        this.currentPosition = current;
        return current;
    }

    @Override
    public void consumeNextToken(char expected) {
        if (this.currentPosition == -1) {
            this.unexpectedToken(expected);
        }
        String source = this.getSource();
        while (this.currentPosition < source.length()) {
            int n = this.currentPosition;
            this.currentPosition = n + 1;
            char c = source.charAt(n);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') continue;
            if (c == expected) {
                return;
            }
            this.unexpectedToken(expected);
        }
        this.currentPosition = -1;
        this.unexpectedToken(expected);
    }

    @Override
    @NotNull
    public String consumeKeyString() {
        this.consumeNextToken('\"');
        int current = this.currentPosition;
        int closingQuote = StringsKt.indexOf$default((CharSequence)this.getSource(), (char)'\"', (int)current, (boolean)false, (int)4, null);
        if (closingQuote == -1) {
            this.consumeStringLenient();
            this.fail$kotlinx_serialization_json((byte)1, false);
            throw new KotlinNothingValueException();
        }
        for (int i = current; i < closingQuote; ++i) {
            if (this.getSource().charAt(i) != '\\') continue;
            return this.consumeString(this.getSource(), this.currentPosition, i);
        }
        this.currentPosition = closingQuote + 1;
        String string2 = this.getSource().substring(current, closingQuote);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    @Override
    public void consumeStringChunked(boolean isLenient, @NotNull Function1<? super String, Unit> consumeChunk) {
        Intrinsics.checkNotNullParameter(consumeChunk, (String)"consumeChunk");
        Iterable $this$forEach$iv = StringsKt.chunked((CharSequence)(isLenient ? this.consumeStringLenient() : this.consumeString()), (int)16384);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            consumeChunk.invoke(element$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String peekLeadingMatchingValue(@NotNull String keyToMatch, boolean isLenient) {
        Intrinsics.checkNotNullParameter((Object)keyToMatch, (String)"keyToMatch");
        int positionSnapshot = this.currentPosition;
        try {
            if (this.consumeNextToken() != 6) {
                String string2 = null;
                return string2;
            }
            String firstKey = this.peekString(isLenient);
            if (!Intrinsics.areEqual((Object)firstKey, (Object)keyToMatch)) {
                String string3 = null;
                return string3;
            }
            this.discardPeeked();
            if (this.consumeNextToken() != 5) {
                String string4 = null;
                return string4;
            }
            String string5 = this.peekString(isLenient);
            return string5;
        }
        finally {
            this.currentPosition = positionSnapshot;
            this.discardPeeked();
        }
    }
}

