/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DataLoader;
import com.intellij.ide.plugins.PathResolver;
import com.intellij.ide.plugins.PluginXmlPathResolver;
import com.intellij.ide.plugins.ProductLoadingStrategy;
import com.intellij.ide.plugins.RawPluginDescriptor;
import com.intellij.ide.plugins.ReadModuleContext;
import com.intellij.ide.plugins.XmlReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.xml.dom.StaxFactory;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J2\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\fH\u0016J*\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J,\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/plugins/ClassPathXmlPathResolver;", "Lcom/intellij/ide/plugins/PathResolver;", "classLoader", "Ljava/lang/ClassLoader;", "isRunningFromSources", "", "(Ljava/lang/ClassLoader;Z)V", "isFlat", "()Z", "getXmlReader", "Lorg/codehaus/stax2/XMLStreamReader2;", "path", "", "dataLoader", "Lcom/intellij/ide/plugins/DataLoader;", "loadXIncludeReference", "readInto", "Lcom/intellij/ide/plugins/RawPluginDescriptor;", "readContext", "Lcom/intellij/ide/plugins/ReadModuleContext;", "base", "relativePath", "resolveModuleFile", "resolvePath", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nClassPathXmlPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassPathXmlPathResolver.kt\ncom/intellij/ide/plugins/ClassPathXmlPathResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class ClassPathXmlPathResolver
implements PathResolver {
    @NotNull
    private final ClassLoader classLoader;
    private final boolean isRunningFromSources;

    public ClassPathXmlPathResolver(@NotNull ClassLoader classLoader, boolean isRunningFromSources) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        this.classLoader = classLoader;
        this.isRunningFromSources = isRunningFromSources;
    }

    public final boolean isRunningFromSources() {
        return this.isRunningFromSources;
    }

    @Override
    public boolean isFlat() {
        return true;
    }

    @Override
    public boolean loadXIncludeReference(@NotNull RawPluginDescriptor readInto, @NotNull ReadModuleContext readContext, @NotNull DataLoader dataLoader2, @Nullable String base, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)readInto, (String)"readInto");
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String path = PluginXmlPathResolver.Companion.toLoadPath$intellij_platform_core_impl(relativePath, base);
        XMLStreamReader2 reader = null;
        if (this.classLoader instanceof UrlClassLoader) {
            byte[] byArray = ((UrlClassLoader)this.classLoader).getResourceAsBytes(path, true);
            if (byArray == null) {
                return false;
            }
            reader = StaxFactory.createNonCoalescingXmlStreamReader(byArray, ((Object)dataLoader2).toString());
        } else {
            InputStream inputStream = this.classLoader.getResourceAsStream(path);
            if (inputStream == null) {
                return false;
            }
            reader = StaxFactory.createNonCoalescingXmlStreamReader(inputStream, ((Object)dataLoader2).toString());
        }
        XmlReader.readModuleDescriptor(reader, readContext, this, dataLoader2, PluginXmlPathResolver.Companion.getChildBase$intellij_platform_core_impl(base, relativePath), readInto);
        return true;
    }

    @Override
    @NotNull
    public RawPluginDescriptor resolveModuleFile(@NotNull ReadModuleContext readContext, @NotNull DataLoader dataLoader2, @NotNull String path, @Nullable RawPluginDescriptor readInto) {
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        byte[] resource = null;
        if (this.classLoader instanceof UrlClassLoader) {
            resource = ((UrlClassLoader)this.classLoader).getResourceAsBytes(path, true);
        } else {
            InputStream inputStream = this.classLoader.getResourceAsStream(path);
            if (inputStream != null) {
                InputStream it = inputStream;
                boolean bl = false;
                return XmlReader.readModuleDescriptor(it, readContext, (PathResolver)this, dataLoader2, null, readInto, ((Object)dataLoader2).toString());
            }
            resource = null;
        }
        if (resource == null) {
            if (Intrinsics.areEqual((Object)path, (Object)"intellij.profiler.clion")) {
                RawPluginDescriptor descriptor2 = new RawPluginDescriptor();
                descriptor2.package = "com.intellij.profiler.clion";
                return descriptor2;
            }
            Logger logger2 = Logger.getInstance(ClassPathXmlPathResolver.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            Logger logger3 = logger2;
            String moduleName = StringsKt.removeSuffix((String)path, (CharSequence)".xml");
            if (this.isRunningFromSources && StringsKt.startsWith$default((String)path, (String)"intellij.", (boolean)false, (int)2, null) && dataLoader2.getEmptyDescriptorIfCannotResolve()) {
                logger3.trace("Cannot resolve " + path + " (dataLoader=" + dataLoader2 + ", classLoader=" + this.classLoader + "). ");
                RawPluginDescriptor descriptor3 = new RawPluginDescriptor();
                descriptor3.package = "unresolved." + moduleName;
                return descriptor3;
            }
            if (ProductLoadingStrategy.Companion.getStrategy().isOptionalProductModule(moduleName)) {
                RawPluginDescriptor rawPluginDescriptor;
                logger3.debug("Skip module '" + path + "' since its descriptor cannot be found and it's optional");
                RawPluginDescriptor $this$resolveModuleFile_u24lambda_u241 = rawPluginDescriptor = new RawPluginDescriptor();
                boolean bl = false;
                $this$resolveModuleFile_u24lambda_u241.package = "unresolved." + moduleName;
                return rawPluginDescriptor;
            }
            throw new RuntimeException("Cannot resolve " + path + " (dataLoader=" + dataLoader2 + ", classLoader=" + this.classLoader + ')');
        }
        return XmlReader.readModuleDescriptor(resource, readContext, (PathResolver)this, dataLoader2, null, readInto, ((Object)dataLoader2).toString());
    }

    @Override
    @Nullable
    public RawPluginDescriptor resolvePath(@NotNull ReadModuleContext readContext, @NotNull DataLoader dataLoader2, @NotNull String relativePath, @Nullable RawPluginDescriptor readInto) {
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String path = PluginXmlPathResolver.Companion.toLoadPath$intellij_platform_core_impl(relativePath, null);
        XMLStreamReader2 xMLStreamReader2 = this.getXmlReader(this.classLoader, path, dataLoader2);
        if (xMLStreamReader2 == null) {
            return null;
        }
        return XmlReader.readModuleDescriptor(xMLStreamReader2, readContext, this, dataLoader2, null, readInto);
    }

    private final XMLStreamReader2 getXmlReader(ClassLoader classLoader, String path, DataLoader dataLoader2) {
        if (classLoader instanceof UrlClassLoader) {
            byte[] byArray = ((UrlClassLoader)classLoader).getResourceAsBytes(path, true);
            if (byArray == null) {
                return null;
            }
            return StaxFactory.createNonCoalescingXmlStreamReader(byArray, ((Object)dataLoader2).toString());
        }
        InputStream inputStream = classLoader.getResourceAsStream(path);
        if (inputStream == null) {
            return null;
        }
        return StaxFactory.createNonCoalescingXmlStreamReader(inputStream, ((Object)dataLoader2).toString());
    }
}

