/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007J\u001e\u0010\u0019\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u001a\u0010\u001e\u001a\u00020\u00002\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u000b0 J6\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010$\u001a\u00020%2\u0010\b\u0002\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010'H\u0002J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100#2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0006\u0010*\u001a\u00020\u0017J \u0010+\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBoundsImpl;", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds;", "typeVariable", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "(Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;)V", "bounds", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "getBounds", "()Ljava/util/ArrayList;", "<set-?>", "", "isFixed", "()Z", "resultValues", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "getTypeVariable", "()Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "values", "getValues", "()Ljava/util/Collection;", "addBound", "", "bound", "checkOnlyInputTypes", "possibleAnswer", "commonSupertypeForNumberTypes", "numberLowerBounds", "computeValues", "filter", "condition", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;", "filterBounds", "", "kind", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$BoundKind;", "errorValues", "", "getIntersectionOfSupertypes", "types", "setFixed", "tryPossibleAnswer", "frontend"})
@SourceDebugExtension(value={"SMAP\nTypeBoundsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeBoundsImpl.kt\norg/jetbrains/kotlin/resolve/calls/inference/TypeBoundsImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n764#2:207\n855#2,2:208\n764#2:210\n855#2,2:211\n1745#2,3:213\n3183#2,10:216\n764#2:226\n855#2,2:227\n1547#2:229\n1618#2,3:230\n1745#2,3:233\n764#2:236\n855#2,2:237\n*S KotlinDebug\n*F\n+ 1 TypeBoundsImpl.kt\norg/jetbrains/kotlin/resolve/calls/inference/TypeBoundsImpl\n*L\n70#1:207\n70#1:208,2\n84#1:210\n84#1:211,2\n89#1:213,3\n104#1:216,10\n150#1:226\n150#1:227,2\n150#1:229\n150#1:230,3\n152#1:233,3\n155#1:236\n155#1:237,2\n*E\n"})
public final class TypeBoundsImpl
implements TypeBounds {
    @NotNull
    private final TypeVariable typeVariable;
    @NotNull
    private final ArrayList<TypeBounds.Bound> bounds;
    @Nullable
    private Collection<? extends KotlinType> resultValues;
    private boolean isFixed;

    public TypeBoundsImpl(@NotNull TypeVariable typeVariable) {
        Intrinsics.checkNotNullParameter((Object)typeVariable, (String)"typeVariable");
        this.typeVariable = typeVariable;
        this.bounds = new ArrayList();
    }

    @Override
    @NotNull
    public TypeVariable getTypeVariable() {
        return this.typeVariable;
    }

    @NotNull
    public ArrayList<TypeBounds.Bound> getBounds() {
        return this.bounds;
    }

    public final boolean isFixed() {
        return this.isFixed;
    }

    public final void setFixed() {
        this.isFixed = true;
    }

    public final void addBound(@NotNull TypeBounds.Bound bound) {
        Intrinsics.checkNotNullParameter((Object)bound, (String)"bound");
        this.resultValues = null;
        boolean bl = Intrinsics.areEqual((Object)bound.getTypeVariable(), (Object)this.getTypeVariable());
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = bound + " is added for incorrect type variable " + bound.getTypeVariable().getName() + ". Expected: " + this.getTypeVariable().getName();
            throw new AssertionError((Object)string2);
        }
        ((ArrayList)this.getBounds()).add(bound);
    }

    private final Set<KotlinType> filterBounds(Collection<TypeBounds.Bound> bounds2, TypeBounds.BoundKind kind, Collection<KotlinType> errorValues) {
        LinkedHashSet<KotlinType> result2 = new LinkedHashSet<KotlinType>();
        for (TypeBounds.Bound bound : bounds2) {
            if (bound.getKind() != kind) continue;
            if (!ErrorUtils.INSTANCE.containsErrorType(bound.getConstrainingType())) {
                result2.add(bound.getConstrainingType());
                continue;
            }
            Collection<KotlinType> collection = errorValues;
            if (collection == null) continue;
            collection.add(bound.getConstrainingType());
        }
        return result2;
    }

    static /* synthetic */ Set filterBounds$default(TypeBoundsImpl typeBoundsImpl, Collection collection, TypeBounds.BoundKind boundKind, Collection collection2, int n, Object object) {
        if ((n & 4) != 0) {
            collection2 = null;
        }
        return typeBoundsImpl.filterBounds(collection, boundKind, collection2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeBoundsImpl filter(@NotNull Function1<? super ConstraintPosition, Boolean> condition) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        TypeBoundsImpl result2 = new TypeBoundsImpl(this.getTypeVariable());
        Iterable iterable = this.getBounds();
        Collection collection = result2.getBounds();
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TypeBounds.Bound it = (TypeBounds.Bound)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)condition.invoke((Object)it.getPosition())).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ((ArrayList)collection).addAll((List)destination$iv$iv);
        return result2;
    }

    @Override
    @NotNull
    public Collection<KotlinType> getValues() {
        if (this.resultValues == null) {
            this.resultValues = this.computeValues();
        }
        Collection<KotlinType> collection = this.resultValues;
        Intrinsics.checkNotNull(collection);
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KotlinType> computeValues() {
        KotlinType intersectionOfUpperBounds;
        KotlinType superTypeOfAllLowerBounds;
        Object element$iv3;
        boolean hasStrongBound;
        List bounds2;
        LinkedHashSet values2;
        block14: {
            boolean bl;
            void $this$filterTo$iv$iv;
            values2 = new LinkedHashSet();
            Iterable $this$filter$iv = this.getBounds();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TypeBounds.Bound it = (TypeBounds.Bound)element$iv$iv;
                boolean bl2 = false;
                if (!it.isProper()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            bounds2 = (List)destination$iv$iv;
            if (bounds2.isEmpty()) {
                return kotlin.collections.CollectionsKt.emptyList();
            }
            Iterable $this$any$iv = bounds2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    TypeBounds.Bound it = (TypeBounds.Bound)element$iv2;
                    boolean bl3 = false;
                    if (!it.getPosition().isStrong()) continue;
                    bl = true;
                    break block14;
                }
                bl = hasStrongBound = false;
            }
        }
        if (!hasStrongBound) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        Set<KotlinType> exactBounds = this.filterBounds(bounds2, TypeBounds.BoundKind.EXACT_BOUND, values2);
        KotlinType bestFit = FlexibleTypesKt.singleBestRepresentative((Collection<? extends KotlinType>)exactBounds);
        if (bestFit != null && this.tryPossibleAnswer(bounds2, bestFit)) {
            return kotlin.collections.CollectionsKt.listOf((Object)bestFit);
        }
        values2.addAll(exactBounds);
        Iterable $this$partition$iv = this.filterBounds(bounds2, TypeBounds.BoundKind.LOWER_BOUND, values2);
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv3 : $this$partition$iv) {
            KotlinType it = (KotlinType)element$iv3;
            boolean bl = false;
            if (it.getConstructor() instanceof IntegerValueTypeConstructor) {
                first$iv.add(element$iv3);
                continue;
            }
            second$iv.add(element$iv3);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List numberLowerBounds = (List)pair.component1();
        List generalLowerBounds = (List)pair.component2();
        KotlinType superTypeOfLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes(generalLowerBounds);
        if (this.tryPossibleAnswer(bounds2, superTypeOfLowerBounds)) {
            KotlinType kotlinType = superTypeOfLowerBounds;
            Intrinsics.checkNotNull((Object)kotlinType);
            return SetsKt.setOf((Object)kotlinType);
        }
        CollectionsKt.addIfNotNull(values2, superTypeOfLowerBounds);
        KotlinType superTypeOfNumberLowerBounds = this.commonSupertypeForNumberTypes(numberLowerBounds);
        if (this.tryPossibleAnswer(bounds2, superTypeOfNumberLowerBounds)) {
            KotlinType kotlinType = superTypeOfNumberLowerBounds;
            Intrinsics.checkNotNull((Object)kotlinType);
            return SetsKt.setOf((Object)kotlinType);
        }
        CollectionsKt.addIfNotNull(values2, superTypeOfNumberLowerBounds);
        if (superTypeOfLowerBounds != null && superTypeOfNumberLowerBounds != null && this.tryPossibleAnswer(bounds2, superTypeOfAllLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes(kotlin.collections.CollectionsKt.listOf(element$iv3 = new KotlinType[]{superTypeOfLowerBounds, superTypeOfNumberLowerBounds})))) {
            KotlinType kotlinType = superTypeOfAllLowerBounds;
            Intrinsics.checkNotNull((Object)kotlinType);
            return SetsKt.setOf((Object)kotlinType);
        }
        Set<KotlinType> upperBounds2 = this.filterBounds(bounds2, TypeBounds.BoundKind.UPPER_BOUND, values2);
        if (!((Collection)upperBounds2).isEmpty() && (intersectionOfUpperBounds = TypeIntersector.intersectTypes((Collection<KotlinType>)upperBounds2)) != null && this.tryPossibleAnswer(bounds2, intersectionOfUpperBounds)) {
            return SetsKt.setOf((Object)intersectionOfUpperBounds);
        }
        values2.addAll(TypeBoundsImpl.filterBounds$default(this, bounds2, TypeBounds.BoundKind.UPPER_BOUND, null, 4, null));
        if (values2.size() == 1 && this.getTypeVariable().hasOnlyInputTypesAnnotation() && !this.tryPossibleAnswer(bounds2, (KotlinType)kotlin.collections.CollectionsKt.first((Iterable)values2))) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        return values2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkOnlyInputTypes(Collection<TypeBounds.Bound> bounds2, KotlinType possibleAnswer) {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        boolean bl;
        block8: {
            Iterator $this$mapTo$iv$iv;
            void $this$map$iv;
            TypeBounds.Bound it;
            void $this$filterTo$iv$iv2;
            if (!this.getTypeVariable().hasOnlyInputTypesAnnotation()) {
                return true;
            }
            Iterable $this$filter$iv = bounds2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (TypeBounds.Bound)element$iv$iv;
                boolean bl2 = false;
                if (!(it.isProper() && it.getConstrainingType().getConstructor().isDenotable())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv = iterator2.next();
                it = (TypeBounds.Bound)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getConstrainingType());
            }
            Set typesInBoundsSet = kotlin.collections.CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterable $this$any$iv = typesInBoundsSet;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    KotlinType it2 = (KotlinType)element$iv2;
                    boolean bl4 = false;
                    if (!KotlinTypeChecker.DEFAULT.equalTypes(it2, possibleAnswer)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        Iterable $this$filter$iv = TypeBoundsImpl.filterBounds$default(this, bounds2, TypeBounds.BoundKind.LOWER_BOUND, null, 4, null);
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinType it = (KotlinType)element$iv$iv;
            boolean bl5 = false;
            if (!(it.getConstructor() instanceof IntegerValueTypeConstructor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List numberLowerBounds = (List)destination$iv$iv;
        KotlinType superTypeOfNumberLowerBounds = this.commonSupertypeForNumberTypes(numberLowerBounds);
        return Intrinsics.areEqual((Object)possibleAnswer, (Object)superTypeOfNumberLowerBounds);
    }

    private final boolean tryPossibleAnswer(Collection<TypeBounds.Bound> bounds2, KotlinType possibleAnswer) {
        if (possibleAnswer == null) {
            return false;
        }
        if (!possibleAnswer.getConstructor().isDenotable() && !CapturedTypeConstructorKt.isCaptured(possibleAnswer)) {
            return false;
        }
        if (!this.checkOnlyInputTypes(bounds2, possibleAnswer)) {
            return false;
        }
        block5: for (TypeBounds.Bound bound : bounds2) {
            switch (WhenMappings.$EnumSwitchMapping$0[bound.getKind().ordinal()]) {
                case 1: {
                    if (KotlinTypeChecker.DEFAULT.isSubtypeOf(bound.getConstrainingType(), possibleAnswer)) continue block5;
                    return false;
                }
                case 2: {
                    if (KotlinTypeChecker.DEFAULT.isSubtypeOf(possibleAnswer, bound.getConstrainingType())) continue block5;
                    return false;
                }
                case 3: {
                    if (KotlinTypeChecker.DEFAULT.equalTypes(bound.getConstrainingType(), possibleAnswer)) continue block5;
                    return false;
                }
            }
        }
        return true;
    }

    private final KotlinType commonSupertypeForNumberTypes(Collection<? extends KotlinType> numberLowerBounds) {
        if (numberLowerBounds.isEmpty()) {
            return null;
        }
        Set<KotlinType> intersectionOfSupertypes = this.getIntersectionOfSupertypes(numberLowerBounds);
        KotlinType kotlinType = TypeUtils.getDefaultPrimitiveNumberType((Collection<KotlinType>)intersectionOfSupertypes);
        if (kotlinType == null) {
            kotlinType = CommonSupertypes.commonSupertype(numberLowerBounds);
        }
        return kotlinType;
    }

    private final Set<KotlinType> getIntersectionOfSupertypes(Collection<? extends KotlinType> types2) {
        HashSet<KotlinType> upperBounds2 = new HashSet<KotlinType>();
        for (KotlinType kotlinType : types2) {
            Collection<KotlinType> supertypes2;
            Intrinsics.checkNotNullExpressionValue(kotlinType.getConstructor().getSupertypes(), (String)"getSupertypes(...)");
            if (upperBounds2.isEmpty()) {
                upperBounds2.addAll(supertypes2);
                continue;
            }
            upperBounds2.retainAll(supertypes2);
        }
        return upperBounds2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TypeBounds.BoundKind.values().length];
            try {
                nArray[TypeBounds.BoundKind.LOWER_BOUND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeBounds.BoundKind.UPPER_BOUND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeBounds.BoundKind.EXACT_BOUND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

