/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInconsistentTypeParameterHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0002 !B\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0004J \u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001dH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\"#\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterChecker;", "mppKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "classKinds", "", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "check", "", "declaration", "containingDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkBoundUniqueness", "checkConflictingBounds", "checkDynamicBounds", "checkExtensionFunctionTypeBound", "checkFinalUpperBounds", "checkInconsistentTypeParameterBounds", "checkOnlyOneTypeParameterBound", "checkTypeAliasBound", "isRelated", "", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "Lorg/jetbrains/kotlin/types/model/TypeCheckerProviderContext;", "type", "ForExpectClass", "Regular", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$Regular;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirTypeParameterBoundsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,204:1\n40#2:205\n40#2:206\n1853#3,2:207\n1853#3,2:209\n764#3:211\n855#3,2:212\n1853#3,2:214\n1653#3,8:216\n3183#3,10:224\n764#3:234\n855#3,2:235\n764#3:237\n855#3,2:238\n1653#3,8:240\n1853#3,2:248\n1853#3,2:250\n1547#3:252\n1618#3,3:253\n1853#3,2:256\n1853#3:258\n1853#3,2:259\n1854#3:261\n*S KotlinDebug\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker\n*L\n74#1:205\n75#1:206\n77#1:207,2\n85#1:209,2\n99#1:211\n99#1:212,2\n99#1:214,2\n106#1:216,8\n107#1:224,10\n114#1:234\n114#1:235,2\n130#1:237\n130#1:238,2\n131#1:240,8\n133#1:248,2\n141#1:250,2\n162#1:252\n162#1:253,3\n168#1:256,2\n150#1:258\n152#1:259,2\n150#1:261\n*E\n"})
public abstract class FirTypeParameterBoundsChecker
extends FirDeclarationChecker<FirTypeParameter> {
    @NotNull
    private final Set<ClassKind> classKinds;

    private FirTypeParameterBoundsChecker(MppCheckerKind mppKind) {
        super(mppKind);
        ClassKind[] classKindArray = new ClassKind[]{ClassKind.CLASS, ClassKind.ENUM_CLASS, ClassKind.OBJECT};
        this.classKinds = SetsKt.setOf((Object[])classKindArray);
    }

    protected final void check(@NotNull FirTypeParameter declaration2, @NotNull FirDeclaration containingDeclaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)containingDeclaration2, (String)"containingDeclaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (containingDeclaration2 instanceof FirConstructor) {
            return;
        }
        this.checkFinalUpperBounds(declaration2, containingDeclaration2, context2, reporter);
        this.checkExtensionFunctionTypeBound(declaration2, context2, reporter);
        FirMemberDeclaration firMemberDeclaration = containingDeclaration2 instanceof FirMemberDeclaration ? (FirMemberDeclaration)containingDeclaration2 : null;
        if (!(firMemberDeclaration != null ? FirHelpersKt.isInlineOnly(firMemberDeclaration, context2.getSession()) : false)) {
            this.checkOnlyOneTypeParameterBound(declaration2, context2, reporter);
        }
        this.checkBoundUniqueness(declaration2, context2, reporter);
        this.checkConflictingBounds(declaration2, context2, reporter);
        this.checkTypeAliasBound(declaration2, containingDeclaration2, context2, reporter);
        this.checkDynamicBounds(declaration2, context2, reporter);
        this.checkInconsistentTypeParameterBounds(declaration2, context2, reporter);
    }

    private final void checkFinalUpperBounds(FirTypeParameter declaration2, FirDeclaration containingDeclaration2, CheckerContext context2, DiagnosticReporter reporter) {
        boolean $i$f$isOverride;
        FirMemberDeclaration $this$isOverride$iv;
        if (containingDeclaration2 instanceof FirSimpleFunction) {
            $this$isOverride$iv = (FirMemberDeclaration)containingDeclaration2;
            $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                return;
            }
        }
        if (containingDeclaration2 instanceof FirProperty) {
            $this$isOverride$iv = (FirMemberDeclaration)containingDeclaration2;
            $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                return;
            }
        }
        Iterable $this$forEach$iv = declaration2.getSymbol().getResolvedBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirResolvedTypeRef bound = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            if (TypeUtilsKt.canHaveSubtypes(FirTypeUtilsKt.getConeType(bound), context2.getSession())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getFINAL_UPPER_BOUND(), (Object)FirTypeUtilsKt.getConeType(bound), (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkExtensionFunctionTypeBound(FirTypeParameter declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        Iterable $this$forEach$iv = declaration2.getSymbol().getResolvedBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirResolvedTypeRef bound = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            if (!TypeUtilsKt.isExtensionFunctionType(bound, context2.getSession())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getUPPER_BOUND_IS_EXTENSION_FUNCTION_TYPE(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeAliasBound(FirTypeParameter declaration2, FirDeclaration containingDeclaration2, CheckerContext context2, DiagnosticReporter reporter) {
        if (containingDeclaration2 instanceof FirTypeAlias) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = declaration2.getBounds();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirTypeRef it = (FirTypeRef)element$iv$iv;
                boolean bl = false;
                KtSourceElement ktSourceElement = it.getSource();
                if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeRef bound = (FirTypeRef)element$iv;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getBOUND_ON_TYPE_ALIAS_PARAMETER_NOT_ALLOWED(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOnlyOneTypeParameterBound(FirTypeParameter declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        Iterable $this$distinctBy$iv = declaration2.getSymbol().getResolvedBounds();
        boolean $i$f$distinctBy = false;
        HashSet<ConeKotlinType> set$iv = new HashSet<ConeKotlinType>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            FirResolvedTypeRef it = (FirResolvedTypeRef)e$iv;
            boolean bl = false;
            ConeKotlinType key$iv = FirTypeUtilsKt.getConeType(it);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List bounds2 = list$iv;
        Iterable $this$partition$iv = bounds2;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            if (FirTypeUtilsKt.getConeType(it) instanceof ConeTypeParameterType) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List boundWithParam = (List)pair.component1();
        List otherBounds = (List)pair.component2();
        if (boundWithParam.size() > 1 || boundWithParam.size() == 1 && !((Collection)otherBounds).isEmpty()) {
            KtSourceElement ktSourceElement;
            void $this$filterTo$iv$iv;
            SourceNavigator $this$checkOnlyOneTypeParameterBound_u24lambda_u247 = SourceNavigator.Companion.forElement(declaration2);
            boolean bl = false;
            Iterable $this$filter$iv = bounds2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv$iv;
                boolean bl2 = false;
                if (!$this$checkOnlyOneTypeParameterBound_u24lambda_u247.isInTypeConstraint(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set constraintBounds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (bounds2.size() == 2) {
                FirResolvedTypeRef boundDecl;
                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)CollectionsKt.firstOrNull((List)otherBounds);
                if (firResolvedTypeRef == null) {
                    firResolvedTypeRef = (FirResolvedTypeRef)CollectionsKt.last((List)boundWithParam);
                }
                ktSourceElement = constraintBounds.contains(boundDecl = firResolvedTypeRef) ? boundDecl.getSource() : declaration2.getSource();
            } else {
                ktSourceElement = declaration2.getSource();
            }
            KtSourceElement reportOn = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)reportOn, FirErrors.INSTANCE.getBOUNDS_NOT_ALLOWED_IF_BOUNDED_BY_TYPE_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBoundUniqueness(FirTypeParameter declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        FirResolvedTypeRef bound;
        FirResolvedTypeRef it;
        void $this$filterTo$iv$iv;
        Set seenClasses = new LinkedHashSet();
        Iterable $this$filter$iv = declaration2.getSymbol().getResolvedBounds();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FirResolvedTypeRef)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof FirErrorTypeRef))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allNonErrorBounds = (List)destination$iv$iv;
        Iterable $this$distinctBy$iv = allNonErrorBounds;
        boolean $i$f$distinctBy = false;
        HashSet<ClassId> set$iv = new HashSet<ClassId>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            ClassId key$iv;
            it = (FirResolvedTypeRef)e$iv;
            boolean bl = false;
            Object object = FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getConeType(it), context2.getSession());
            if (object == null) {
                object = FirTypeUtilsKt.getConeType(it);
            }
            if (!set$iv.add(key$iv = object)) continue;
            list$iv.add(e$iv);
        }
        List uniqueBounds = list$iv;
        Iterable $this$forEach$iv = uniqueBounds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirRegularClassSymbol symbol2;
            bound = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            if (TypeUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType(bound), context2.getSession()) == null) continue;
            boolean bl2 = false;
            if (!this.classKinds.contains((Object)symbol2.getClassKind()) || !seenClasses.add(symbol2) || seenClasses.size() <= 1) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getONLY_ONE_CLASS_BOUND_ALLOWED(), (DiagnosticContext)context2, null, 8, null);
        }
        $this$forEach$iv = CollectionsKt.minus((Iterable)allNonErrorBounds, (Iterable)uniqueBounds);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            bound = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getREPEATED_BOUND(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConflictingBounds(FirTypeParameter declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        Collection<ConeKotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (declaration2.getBounds().size() < 2) {
            return;
        }
        Iterable iterable = declaration2.getSymbol().getResolvedBounds();
        FirTypeParameterBoundsChecker firTypeParameterBoundsChecker = this;
        CheckerContext checkerContext = context2;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FirTypeUtilsKt.getConeType((FirTypeRef)it));
        }
        collection = (List)destination$iv$iv;
        if (FirTypeParameterBoundsChecker.checkConflictingBounds$anyConflictingTypes(checkerContext, firTypeParameterBoundsChecker, (List<? extends ConeKotlinType>)collection)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getCONFLICTING_UPPER_BOUNDS(), (Object)declaration2.getSymbol(), (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkDynamicBounds(FirTypeParameter declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        Iterable $this$forEach$iv = declaration2.getBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeRef bound = (FirTypeRef)element$iv;
            boolean bl = false;
            if (!(FirTypeUtilsKt.getConeType(bound) instanceof ConeDynamicType)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getDYNAMIC_UPPER_BOUND(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean isRelated(KotlinTypeMarker $this$isRelated, TypeCheckerProviderContext context2, KotlinTypeMarker type2) {
        return TypeUtilsKt.isSubtypeOf($this$isRelated, context2, type2) || FirHelpersKt.isSupertypeOf($this$isRelated, context2, type2);
    }

    private final void checkInconsistentTypeParameterBounds(FirTypeParameter declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        if (declaration2.getBounds().size() <= 1) {
            return;
        }
        List firTypeRefClasses = new ArrayList();
        Set firRegularClassesSet = new LinkedHashSet();
        for (FirResolvedTypeRef bound : declaration2.getSymbol().getResolvedBounds()) {
            FirRegularClassSymbol classSymbol2 = FirHelpersKt.toRegularClassSymbol(bound, context2.getSession());
            if (CollectionsKt.contains((Iterable)firRegularClassesSet, (Object)classSymbol2)) {
                return;
            }
            if (classSymbol2 == null) continue;
            firRegularClassesSet.add(classSymbol2);
            firTypeRefClasses.add(new Pair((Object)bound, (Object)classSymbol2));
        }
        FirInconsistentTypeParameterHelpersKt.checkInconsistentTypeParameters(firTypeRefClasses, context2, reporter, declaration2.getSource(), false);
    }

    private static final boolean checkConflictingBounds$anyConflictingTypes(CheckerContext $context, FirTypeParameterBoundsChecker this$0, List<? extends ConeKotlinType> types2) {
        Iterable $this$forEach$iv = types2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConeKotlinType type2 = (ConeKotlinType)element$iv;
            boolean bl = false;
            if (TypeUtilsKt.canHaveSubtypes(type2, $context.getSession())) continue;
            Iterable $this$forEach$iv2 = types2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ConeKotlinType otherType = (ConeKotlinType)element$iv2;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)type2, (Object)otherType) || this$0.isRelated(type2, TypeComponentsKt.getTypeContext($context.getSession()), otherType)) continue;
                return true;
            }
        }
        return false;
    }

    public /* synthetic */ FirTypeParameterBoundsChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirTypeParameterBoundsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$ForExpectClass\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,204:1\n37#2:205\n*S KotlinDebug\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$ForExpectClass\n*L\n35#1:205\n*E\n"})
    public static final class ForExpectClass
    extends FirTypeParameterBoundsChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull FirTypeParameter declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
            if (firDeclaration == null) {
                return;
            }
            FirDeclaration containingDeclaration2 = firDeclaration;
            FirMemberDeclaration firMemberDeclaration = containingDeclaration2 instanceof FirMemberDeclaration ? (FirMemberDeclaration)containingDeclaration2 : null;
            if (firMemberDeclaration != null) {
                FirMemberDeclaration $this$isExpect$iv = firMemberDeclaration;
                boolean $i$f$isExpect = false;
                bl = $this$isExpect$iv.getStatus().isExpect();
            } else {
                bl = false;
            }
            if (!bl) {
                return;
            }
            this.check(declaration2, containingDeclaration2, context2, reporter);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$Regular;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirTypeParameterBoundsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$Regular\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,204:1\n37#2:205\n*S KotlinDebug\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$Regular\n*L\n27#1:205\n*E\n"})
    public static final class Regular
    extends FirTypeParameterBoundsChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull FirTypeParameter declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
            if (firDeclaration == null) {
                return;
            }
            FirDeclaration containingDeclaration2 = firDeclaration;
            FirMemberDeclaration firMemberDeclaration = containingDeclaration2 instanceof FirMemberDeclaration ? (FirMemberDeclaration)containingDeclaration2 : null;
            if (firMemberDeclaration != null) {
                FirMemberDeclaration $this$isExpect$iv = firMemberDeclaration;
                boolean $i$f$isExpect = false;
                bl = $this$isExpect$iv.getStatus().isExpect();
            } else {
                bl = false;
            }
            if (bl) {
                return;
            }
            this.check(declaration2, containingDeclaration2, context2, reporter);
        }
    }
}

