/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementType;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.KotlinParser;
import org.jetbrains.kotlin.psi.KtCommonFile;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.stubs.elements.KtFileElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0017\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/parsing/KotlinCommonParserDefinition;", "Lcom/intellij/lang/ParserDefinition;", "()V", "createElement", "Lcom/intellij/psi/PsiElement;", "astNode", "Lcom/intellij/lang/ASTNode;", "createFile", "Lcom/intellij/psi/PsiFile;", "fileViewProvider", "Lcom/intellij/psi/FileViewProvider;", "createLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "createParser", "Lcom/intellij/lang/PsiParser;", "getCommentTokens", "Lcom/intellij/psi/tree/TokenSet;", "getFileNodeType", "Lcom/intellij/psi/tree/IFileElementType;", "getStringLiteralElements", "getWhitespaceTokens", "spaceExistanceTypeBetweenTokens", "Lcom/intellij/lang/ParserDefinition$SpaceRequirements;", "left", "right", "psi"})
@SourceDebugExtension(value={"SMAP\nKotlinParserDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinParserDefinition.kt\norg/jetbrains/kotlin/parsing/KotlinCommonParserDefinition\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,125:1\n146#2:126\n146#2:127\n*S KotlinDebug\n*F\n+ 1 KotlinParserDefinition.kt\norg/jetbrains/kotlin/parsing/KotlinCommonParserDefinition\n*L\n95#1:126\n97#1:127\n*E\n"})
public class KotlinCommonParserDefinition
implements ParserDefinition {
    @Override
    @NotNull
    public Lexer createLexer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        return new KotlinLexer();
    }

    @Override
    @NotNull
    public PsiParser createParser(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        return new KotlinParser(project);
    }

    @Override
    @NotNull
    public IFileElementType getFileNodeType() {
        KtFileElementType ktFileElementType = KtFileElementType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue(ktFileElementType, "INSTANCE");
        return ktFileElementType;
    }

    @Override
    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = KtTokens.WHITESPACES;
        Intrinsics.checkNotNullExpressionValue(tokenSet, "WHITESPACES");
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = KtTokens.COMMENTS;
        Intrinsics.checkNotNullExpressionValue(tokenSet, "COMMENTS");
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = KtTokens.STRINGS;
        Intrinsics.checkNotNullExpressionValue(tokenSet, "STRINGS");
        return tokenSet;
    }

    @Override
    @NotNull
    public PsiElement createElement(@NotNull ASTNode astNode) {
        PsiElement psiElement;
        IElementType elementType;
        Intrinsics.checkNotNullParameter(astNode, "astNode");
        IElementType iElementType = astNode.getElementType();
        Intrinsics.checkNotNullExpressionValue(iElementType, "getElementType(...)");
        IElementType iElementType2 = elementType = iElementType;
        if (iElementType2 instanceof KtStubElementType) {
            Object PsiT = ((KtStubElementType)elementType).createPsiFromAst(astNode);
            Intrinsics.checkNotNullExpressionValue(PsiT, "createPsiFromAst(...)");
            psiElement = (PsiElement)PsiT;
        } else if ((Intrinsics.areEqual(iElementType2, KtNodeTypes.TYPE_CODE_FRAGMENT) ? true : Intrinsics.areEqual(iElementType2, KtNodeTypes.EXPRESSION_CODE_FRAGMENT)) ? true : Intrinsics.areEqual(iElementType2, KtNodeTypes.BLOCK_CODE_FRAGMENT)) {
            psiElement = new ASTWrapperPsiElement(astNode);
        } else if (iElementType2 instanceof KDocElementType) {
            PsiElement psiElement2 = ((KDocElementType)elementType).createPsi(astNode);
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue(psiElement2, "createPsi(...)");
        } else if (Intrinsics.areEqual(iElementType2, KDocTokens.MARKDOWN_LINK)) {
            psiElement = new KDocLink(astNode);
        } else {
            KtElement ktElement = ((KtNodeType)elementType).createPsi(astNode);
            Intrinsics.checkNotNullExpressionValue(ktElement, "createPsi(...)");
            psiElement = ktElement;
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider fileViewProvider) {
        Intrinsics.checkNotNullParameter(fileViewProvider, "fileViewProvider");
        return new KtCommonFile(fileViewProvider, false);
    }

    @Override
    @Deprecated(message="Deprecated in Java")
    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(@NotNull ASTNode left, @NotNull ASTNode right) {
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(right, "right");
        IElementType iElementType = right.getElementType();
        Intrinsics.checkNotNullExpressionValue(iElementType, "getElementType(...)");
        IElementType rightTokenType = iElementType;
        if (Intrinsics.areEqual(rightTokenType, KtTokens.GET_KEYWORD) || Intrinsics.areEqual(rightTokenType, KtTokens.SET_KEYWORD)) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        IElementType iElementType2 = left.getElementType();
        Intrinsics.checkNotNullExpressionValue(iElementType2, "getElementType(...)");
        IElementType leftTokenType = iElementType2;
        if (leftTokenType instanceof KtKeywordToken && rightTokenType instanceof KtKeywordToken) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        PsiElement psiElement = right.getPsi();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getPsi(...)");
        PsiElement $this$getNonStrictParentOfType$iv = psiElement;
        boolean $i$f$getNonStrictParentOfType = false;
        KtWhenEntry rightWhenEntry = PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtWhenEntry.class, false);
        if (rightWhenEntry != null) {
            PsiElement psiElement2 = left.getPsi();
            Intrinsics.checkNotNullExpressionValue(psiElement2, "getPsi(...)");
            PsiElement $this$getNonStrictParentOfType$iv2 = psiElement2;
            boolean $i$f$getNonStrictParentOfType2 = false;
            KtWhenEntry leftWhenEntry = PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv2, KtWhenEntry.class, false);
            if (leftWhenEntry != null && !Intrinsics.areEqual(leftWhenEntry, rightWhenEntry) && !Intrinsics.areEqual(leftTokenType, KtTokens.SEMICOLON)) {
                return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
            }
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

