/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.linkage;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReporterWithContext;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.linkage.SignatureClashDetector;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016Je\u0010\u0012\u001a\u00020\u000f\"\b\b\u0002\u0010\u0013*\u00020\u0002\"\b\b\u0003\u0010\u0014*\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00182\u0006\u0010\u0019\u001a\u0002H\u00132\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u001c0\u001bH\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ+\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00028\u00002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00182\u0006\u0010\u0010\u001a\u00020\u0011H$\u00a2\u0006\u0002\u0010\u001fJ\u001b\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00028\u00012\u0006\u0010\"\u001a\u00028\u0000\u00a2\u0006\u0002\u0010#R6\u0010\u0006\u001a*\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b0\u0007j\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/ir/linkage/SignatureClashDetector;", "Signature", "", "Declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "()V", "declarationsBySignature", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "declarationsWithSignature", "", "signature", "(Ljava/lang/Object;)Ljava/util/Set;", "reportErrorsTo", "", "diagnosticReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "reportSignatureClashTo", "Data", "ConflictingDeclaration", "diagnosticFactory", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;", "declarations", "", "data", "reportOnIfSynthetic", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/IrElement;", "(Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;Ljava/util/Collection;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "reportSignatureConflict", "(Ljava/lang/Object;Ljava/util/Collection;Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;)V", "trackDeclaration", "declaration", "rawSignature", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;Ljava/lang/Object;)V", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nSignatureClashDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignatureClashDetector.kt\norg/jetbrains/kotlin/ir/linkage/SignatureClashDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1618#2,2:71\n1620#2:74\n1853#2,2:75\n1#3:73\n*S KotlinDebug\n*F\n+ 1 SignatureClashDetector.kt\norg/jetbrains/kotlin/ir/linkage/SignatureClashDetector\n*L\n63#1:71,2\n63#1:74\n66#1:75,2\n*E\n"})
public abstract class SignatureClashDetector<Signature, Declaration extends IrDeclaration> {
    @NotNull
    private final HashMap<Signature, Set<Declaration>> declarationsBySignature = new LinkedHashMap();

    @NotNull
    protected final Set<Declaration> declarationsWithSignature(@NotNull Signature signature) {
        Intrinsics.checkNotNullParameter(signature, "signature");
        Set<Object> set = this.declarationsBySignature.get(signature);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final void trackDeclaration(@NotNull Declaration declaration2, @NotNull Signature rawSignature) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(rawSignature, "rawSignature");
        this.declarationsBySignature.computeIfAbsent(rawSignature, arg_0 -> SignatureClashDetector.trackDeclaration$lambda$0(trackDeclaration.1.INSTANCE, arg_0)).add(declaration2);
    }

    protected abstract void reportSignatureConflict(@NotNull Signature var1, @NotNull Collection<? extends Declaration> var2, @NotNull IrDiagnosticReporter var3);

    public void reportErrorsTo(@NotNull IrDiagnosticReporter diagnosticReporter) {
        Intrinsics.checkNotNullParameter(diagnosticReporter, "diagnosticReporter");
        for (Map.Entry entry : ((Map)this.declarationsBySignature).entrySet()) {
            Object signature = entry.getKey();
            Set declarations2 = (Set)entry.getValue();
            if (declarations2.size() <= 1) continue;
            this.reportSignatureConflict(signature, declarations2, diagnosticReporter);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final <Data, ConflictingDeclaration extends IrDeclaration> void reportSignatureClashTo(@NotNull IrDiagnosticReporter diagnosticReporter, @NotNull KtDiagnosticFactory1<Data> diagnosticFactory, @NotNull Collection<? extends ConflictingDeclaration> declarations2, @NotNull Data data2, @NotNull Function1<? super ConflictingDeclaration, ? extends IrElement> reportOnIfSynthetic) {
        void $this$forEach$iv;
        Iterable $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(diagnosticReporter, "diagnosticReporter");
        Intrinsics.checkNotNullParameter(diagnosticFactory, "diagnosticFactory");
        Intrinsics.checkNotNullParameter(declarations2, "declarations");
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(reportOnIfSynthetic, "reportOnIfSynthetic");
        boolean $i$f$reportSignatureClashTo = false;
        Iterable iterable = declarations2;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void declaration2;
            void var14_17;
            IrDeclaration irDeclaration2 = (IrDeclaration)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            void it = var14_17 = declaration2;
            boolean bl2 = false;
            Object object = !(it.getStartOffset() < 0) ? var14_17 : null;
            IrElement reportOn = object != null ? (IrElement)object : reportOnIfSynthetic.invoke(declaration2);
            collection.add(diagnosticReporter.at(IrUtilsKt.sourceElement(reportOn), reportOn, IrUtilsKt.getFile((IrDeclaration)declaration2)));
        }
        $this$mapTo$iv = destination$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtDiagnosticReporterWithContext.DiagnosticContextImpl it = (KtDiagnosticReporterWithContext.DiagnosticContextImpl)element$iv;
            boolean bl = false;
            it.report(diagnosticFactory, data2);
        }
    }

    private static final Set trackDeclaration$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Set)$tmp0.invoke(p0);
    }
}

