/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u00020\u00042\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u001b\u001a\u00020\u0004*\u00020\u001cH\u0004J\u0014\u0010\u001d\u001a\u00020\u0004*\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0004j\u0002\b j\u0002\b!j\u0002\b\"\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "", "(Ljava/lang/String;I)V", "canEvaluateBlock", "", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "canEvaluateCallableReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "canEvaluateClassReference", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "canEvaluateComposite", "composite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "canEvaluateEnumValue", "enumEntry", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "canEvaluateExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "canEvaluateFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "canEvaluateFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "mustCheckBodyOf", "isMarkedAsIntrinsicConstEvaluation", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isMarkedWith", "annotation", "Lorg/jetbrains/kotlin/name/FqName;", "FULL", "ONLY_BUILTINS", "ONLY_INTRINSIC_CONST", "ir.interpreter"})
public class EvaluationMode
extends Enum<EvaluationMode> {
    public static final /* enum */ EvaluationMode FULL = new FULL("FULL", 0);
    public static final /* enum */ EvaluationMode ONLY_BUILTINS = new ONLY_BUILTINS("ONLY_BUILTINS", 1);
    public static final /* enum */ EvaluationMode ONLY_INTRINSIC_CONST = new ONLY_INTRINSIC_CONST("ONLY_INTRINSIC_CONST", 2);
    private static final /* synthetic */ EvaluationMode[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private EvaluationMode() {
    }

    public boolean canEvaluateFunction(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return false;
    }

    public boolean canEvaluateEnumValue(@NotNull IrGetEnumValue enumEntry) {
        Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
        return false;
    }

    public boolean canEvaluateFunctionExpression(@NotNull IrFunctionExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return false;
    }

    public boolean canEvaluateCallableReference(@NotNull IrCallableReference<?> reference2) {
        Intrinsics.checkNotNullParameter(reference2, "reference");
        return false;
    }

    public boolean canEvaluateClassReference(@NotNull IrDeclarationReference reference2) {
        Intrinsics.checkNotNullParameter(reference2, "reference");
        return false;
    }

    public boolean canEvaluateBlock(@NotNull IrBlock block) {
        Intrinsics.checkNotNullParameter(block, "block");
        return false;
    }

    public boolean canEvaluateComposite(@NotNull IrComposite composite) {
        Intrinsics.checkNotNullParameter(composite, "composite");
        return Intrinsics.areEqual(composite.getOrigin(), IrStatementOrigin.Companion.getDESTRUCTURING_DECLARATION()) || composite.getOrigin() == null;
    }

    public boolean canEvaluateExpression(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return false;
    }

    public boolean mustCheckBodyOf(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return UtilsKt.getProperty(function2) != null;
    }

    protected final boolean isMarkedAsIntrinsicConstEvaluation(@NotNull IrDeclaration $this$isMarkedAsIntrinsicConstEvaluation) {
        Intrinsics.checkNotNullParameter($this$isMarkedAsIntrinsicConstEvaluation, "<this>");
        return this.isMarkedWith($this$isMarkedAsIntrinsicConstEvaluation, UtilsKt.getIntrinsicConstEvaluationAnnotation());
    }

    protected final boolean isMarkedWith(@NotNull IrDeclaration $this$isMarkedWith, @NotNull FqName annotation2) {
        Intrinsics.checkNotNullParameter($this$isMarkedWith, "<this>");
        Intrinsics.checkNotNullParameter(annotation2, "annotation");
        if ($this$isMarkedWith instanceof IrClass && ((IrClass)$this$isMarkedWith).isCompanion()) {
            return false;
        }
        if (UtilsKt.hasAnnotation($this$isMarkedWith, annotation2)) {
            return true;
        }
        IrDeclarationParent irDeclarationParent = $this$isMarkedWith.getParent();
        IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        return irClass != null ? this.isMarkedWith(irClass, annotation2) : false;
    }

    public static EvaluationMode[] values() {
        return (EvaluationMode[])$VALUES.clone();
    }

    public static EvaluationMode valueOf(String value2) {
        return Enum.valueOf(EvaluationMode.class, value2);
    }

    @NotNull
    public static EnumEntries<EvaluationMode> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ EvaluationMode(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        $VALUES = evaluationModeArray = new EvaluationMode[]{EvaluationMode.FULL, EvaluationMode.ONLY_BUILTINS, EvaluationMode.ONLY_INTRINSIC_CONST};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0014\u0010\u0006\u001a\u00020\u00032\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$FULL;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "canEvaluateBlock", "", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "canEvaluateCallableReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "canEvaluateClassReference", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "canEvaluateComposite", "composite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "canEvaluateEnumValue", "enumEntry", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "canEvaluateExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "canEvaluateFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "canEvaluateFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "mustCheckBodyOf", "ir.interpreter"})
    static final class FULL
    extends EvaluationMode {
        /*
         * WARNING - void declaration
         */
        FULL() {
            void var1_1;
        }

        @Override
        public boolean canEvaluateFunction(@NotNull IrFunction function2) {
            Intrinsics.checkNotNullParameter(function2, "function");
            return true;
        }

        @Override
        public boolean canEvaluateEnumValue(@NotNull IrGetEnumValue enumEntry) {
            Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
            return true;
        }

        @Override
        public boolean canEvaluateFunctionExpression(@NotNull IrFunctionExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            return true;
        }

        @Override
        public boolean canEvaluateCallableReference(@NotNull IrCallableReference<?> reference2) {
            Intrinsics.checkNotNullParameter(reference2, "reference");
            return true;
        }

        @Override
        public boolean canEvaluateClassReference(@NotNull IrDeclarationReference reference2) {
            Intrinsics.checkNotNullParameter(reference2, "reference");
            return true;
        }

        @Override
        public boolean canEvaluateBlock(@NotNull IrBlock block) {
            Intrinsics.checkNotNullParameter(block, "block");
            return true;
        }

        @Override
        public boolean canEvaluateComposite(@NotNull IrComposite composite) {
            Intrinsics.checkNotNullParameter(composite, "composite");
            return true;
        }

        @Override
        public boolean canEvaluateExpression(@NotNull IrExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            return true;
        }

        @Override
        public boolean mustCheckBodyOf(@NotNull IrFunction function2) {
            Intrinsics.checkNotNullParameter(function2, "function");
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0014\u001a\u00020\u000b*\u00020\u0015H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$ONLY_BUILTINS;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "allowedBuiltinExtensionFunctions", "", "", "allowedExtensionFunctions", "allowedMethodsOnPrimitives", "allowedMethodsOnStrings", "allowedOriginsForWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "canEvaluateBlock", "", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "canEvaluateExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "canEvaluateFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "hasUnsignedArgs", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "ir.interpreter"})
    @SourceDebugExtension(value={"SMAP\nEvaluationMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EvaluationMode.kt\norg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$ONLY_BUILTINS\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1547#2:144\n1618#2,3:145\n1745#2,3:149\n1#3:148\n*S KotlinDebug\n*F\n+ 1 EvaluationMode.kt\norg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$ONLY_BUILTINS\n*L\n60#1:144\n60#1:145,3\n96#1:149,3\n*E\n"})
    static final class ONLY_BUILTINS
    extends EvaluationMode {
        @NotNull
        private final Set<String> allowedMethodsOnPrimitives;
        @NotNull
        private final Set<String> allowedMethodsOnStrings;
        @NotNull
        private final Set<String> allowedExtensionFunctions;
        @NotNull
        private final Set<String> allowedBuiltinExtensionFunctions;
        @NotNull
        private final Set<IrStatementOriginImpl> allowedOriginsForWhen;

        /*
         * WARNING - void declaration
         */
        ONLY_BUILTINS() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void var1_1;
            Object object = new String[]{"not", "unaryMinus", "unaryPlus", "inv", "toString", "toChar", "toByte", "toShort", "toInt", "toLong", "toFloat", "toDouble", "equals", "compareTo", "plus", "minus", "times", "div", "rem", "and", "or", "xor", "shl", "shr", "ushr", "less", "lessOrEqual", "greater", "greaterOrEqual"};
            this.allowedMethodsOnPrimitives = SetsKt.setOf(object);
            object = new String[]{"<get-length>", "plus", "get", "compareTo", "equals", "toString"};
            this.allowedMethodsOnStrings = SetsKt.setOf(object);
            object = new String[]{"kotlin.floorDiv", "kotlin.mod", "kotlin.NumbersKt.floorDiv", "kotlin.NumbersKt.mod", "kotlin.<get-code>"};
            this.allowedExtensionFunctions = SetsKt.setOf(object);
            object = new String[]{"less", "lessOrEqual", "greater", "greaterOrEqual", "EQEQ", "ieee754equals", "ANDAND", "OROR"};
            object = CollectionsKt.listOf(object);
            ONLY_BUILTINS oNLY_BUILTINS = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(IrBuiltIns.Companion.getKOTLIN_INTERNAL_IR_FQN().child(Name.identifier((String)it)).asString());
            }
            oNLY_BUILTINS.allowedBuiltinExtensionFunctions = CollectionsKt.toSet((List)destination$iv$iv);
            object = new IrStatementOriginImpl[]{IrStatementOrigin.Companion.getANDAND(), IrStatementOrigin.Companion.getOROR()};
            this.allowedOriginsForWhen = SetsKt.setOf(object);
        }

        @Override
        public boolean canEvaluateFunction(@NotNull IrFunction function2) {
            boolean bl;
            IrClass parent2;
            Intrinsics.checkNotNullParameter(function2, "function");
            if (UtilsKt.isConst(UtilsKt.getProperty(function2))) {
                return true;
            }
            IrType returnType2 = function2.getReturnType();
            if (!(IrTypePredicatesKt.isPrimitiveType$default(returnType2, false, 1, null) || IrTypePredicatesKt.isString(returnType2) || IrTypePredicatesKt.isUnsignedType$default(returnType2, false, 1, null))) {
                return false;
            }
            FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(function2);
            String fqName3 = fqName2 != null ? fqName2.asString() : null;
            IrClass irClass = parent2 = IrUtilsKt.getParentClassOrNull(function2);
            IrSimpleType parentType = irClass != null ? IrUtilsKt.getDefaultType(irClass) : null;
            if (parentType == null) {
                bl = CollectionsKt.contains((Iterable)this.allowedExtensionFunctions, fqName3) || CollectionsKt.contains((Iterable)this.allowedBuiltinExtensionFunctions, fqName3);
            } else if (IrTypePredicatesKt.isPrimitiveType$default(parentType, false, 1, null)) {
                bl = this.allowedMethodsOnPrimitives.contains(function2.getName().asString());
            } else if (IrTypePredicatesKt.isString(parentType)) {
                bl = this.allowedMethodsOnStrings.contains(function2.getName().asString());
            } else if (IrUtilsKt.isObject(parent2)) {
                IrAnnotationContainer irAnnotationContainer = IrUtilsKt.getParentClassOrNull(parent2);
                if (irAnnotationContainer != null && (irAnnotationContainer = IrUtilsKt.getDefaultType(irAnnotationContainer)) != null) {
                    IrAnnotationContainer it = irAnnotationContainer;
                    boolean bl2 = false;
                    bl = IrTypePredicatesKt.isPrimitiveType$default((IrType)it, false, 1, null) || IrTypeUtilsKt.isUnsigned((IrType)it);
                } else {
                    bl = false;
                }
            } else {
                bl = IrTypePredicatesKt.isUnsignedType$default(parentType, false, 1, null) && function2 instanceof IrConstructor ? true : CollectionsKt.contains((Iterable)this.allowedExtensionFunctions, fqName3) || CollectionsKt.contains((Iterable)this.allowedBuiltinExtensionFunctions, fqName3);
            }
            return bl;
        }

        @Override
        public boolean canEvaluateBlock(@NotNull IrBlock block) {
            Intrinsics.checkNotNullParameter(block, "block");
            return block.getStatements().size() == 1;
        }

        @Override
        public boolean canEvaluateExpression(@NotNull IrExpression expression2) {
            boolean bl;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            if (expression2 instanceof IrWhen) {
                bl = CollectionsKt.contains((Iterable)this.allowedOriginsForWhen, ((IrWhen)expression2).getOrigin());
            } else if (!(expression2 instanceof IrCall)) {
                bl = false;
            } else if (this.hasUnsignedArgs((IrCall)expression2)) {
                FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(((IrCall)expression2).getSymbol().getOwner());
                bl = Intrinsics.areEqual(fqName2 != null ? fqName2.asString() : null, "kotlin.String.plus");
            } else {
                bl = true;
            }
            return bl;
        }

        private final boolean hasUnsignedArgs(IrCall $this$hasUnsignedArgs) {
            boolean bl;
            block4: {
                if (org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode$ONLY_BUILTINS.hasUnsignedArgs$hasUnsignedType($this$hasUnsignedArgs.getDispatchReceiver()) || org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode$ONLY_BUILTINS.hasUnsignedArgs$hasUnsignedType($this$hasUnsignedArgs.getExtensionReceiver())) {
                    return true;
                }
                Iterable $this$any$iv = RangesKt.until(0, $this$hasUnsignedArgs.getValueArgumentsCount());
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl2 = false;
                        Object object = $this$hasUnsignedArgs.getValueArgument(it);
                        boolean bl3 = object != null && (object = ((IrExpression)object).getType()) != null ? IrTypeUtilsKt.isUnsigned((IrType)object) : false;
                        if (!bl3) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private static final boolean hasUnsignedArgs$hasUnsignedType(IrExpression $this$hasUnsignedArgs_u24hasUnsignedType) {
            return $this$hasUnsignedArgs_u24hasUnsignedType != null && IrTypeUtilsKt.isUnsigned($this$hasUnsignedArgs_u24hasUnsignedType.getType());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\u0003*\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$ONLY_INTRINSIC_CONST;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "canEvaluateBlock", "", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "canEvaluateExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "canEvaluateFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isCompileTimePropertyAccessor", "ir.interpreter"})
    static final class ONLY_INTRINSIC_CONST
    extends EvaluationMode {
        /*
         * WARNING - void declaration
         */
        ONLY_INTRINSIC_CONST() {
            void var1_1;
        }

        @Override
        public boolean canEvaluateFunction(@NotNull IrFunction function2) {
            Intrinsics.checkNotNullParameter(function2, "function");
            return this.isCompileTimePropertyAccessor(function2) || this.isMarkedAsIntrinsicConstEvaluation(function2);
        }

        private final boolean isCompileTimePropertyAccessor(IrFunction $this$isCompileTimePropertyAccessor) {
            IrDeclarationBase irDeclarationBase = $this$isCompileTimePropertyAccessor;
            if (irDeclarationBase == null || (irDeclarationBase = UtilsKt.getProperty((IrFunction)irDeclarationBase)) == null) {
                return false;
            }
            IrDeclarationBase property = irDeclarationBase;
            return ((IrProperty)property).isConst() || this.isMarkedAsIntrinsicConstEvaluation(property);
        }

        @Override
        public boolean canEvaluateBlock(@NotNull IrBlock block) {
            Intrinsics.checkNotNullParameter(block, "block");
            return Intrinsics.areEqual(block.getOrigin(), IrStatementOrigin.Companion.getWHEN()) || block.getStatements().size() == 1;
        }

        @Override
        public boolean canEvaluateExpression(@NotNull IrExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            return ONLY_BUILTINS.canEvaluateExpression(expression2) || expression2 instanceof IrWhen;
        }
    }
}

