/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirFunctionTypeParameter;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirOuterClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.diagnostics.ConeAmbiguousFunctionTypeKinds;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeUnexpectedTypeArgumentsError;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.resolve.FirQualifierResolver;
import org.jetbrains.kotlin.fir.resolve.FirQualifierResolverKt;
import org.jetbrains.kotlin.fir.resolve.FirTypeResolutionResult;
import org.jetbrains.kotlin.fir.resolve.FirTypeResolver;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeSupplier;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeForbiddenIntersection;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeOuterClassArgumentsRequired;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeTypeArgumentsForOuterClassWhenNestedReferencedError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeTypeArgumentsNotAllowedOnPackageError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedTypeQualifierError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeWrongNumberOfTypeArgumentsError;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.transformers.ScopeClassDeclaration;
import org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapperKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirDynamicTypeRef;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeKindServiceKt;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirIntersectionTypeRef;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeArgumentList;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintSystemError;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002=>B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J$\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012H\u0002J$\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012H\u0002J0\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001d2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u001d2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0002JB\u0010 \u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)H\u0016J2\u0010*\u001a\u00020+2\u0006\u0010\u0007\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010$\u001a\u00020\u000fH\u0002J0\u00101\u001a\u00020.2\u0006\u0010\u0007\u001a\u00020,2\u0006\u0010\"\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020\u000fJ4\u00102\u001a\u0004\u0018\u00010\u0015*\b\u0012\u0004\u0012\u00020\u0013032\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\b\u0010/\u001a\u0004\u0018\u0001002\b\u00104\u001a\u0004\u0018\u000105H\u0002J2\u00106\u001a\u00020\u000f*\b\u0012\u0002\b\u0003\u0018\u00010\u001d2\b\u0010&\u001a\u0004\u0018\u00010'2\f\u00107\u001a\b\u0012\u0004\u0012\u0002000\u00122\u0006\u0010(\u001a\u00020)H\u0002J*\u00108\u001a\n\u0012\u0004\u0012\u00020:\u0018\u000109*\u00020\u001f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\u0006\u0010;\u001a\u00020<H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl;", "Lorg/jetbrains/kotlin/fir/resolve/FirTypeResolver;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "createFunctionType", "Lorg/jetbrains/kotlin/fir/resolve/FirTypeResolutionResult;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "filterOutAmbiguousTypealiases", "", "candidates", "", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeCandidate;", "isPossibleBareType", "", "areBareTypesAllowed", "allTypeArguments", "", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "matchQualifierPartsAndClasses", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "qualifier", "Lorg/jetbrains/kotlin/fir/types/FirQualifierPart;", "resolveLocalClassChain", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "resolveSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "qualifierResolver", "Lorg/jetbrains/kotlin/fir/resolve/FirQualifierResolver;", "resolveType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "scopeClassDeclaration", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopeClassDeclaration;", "isOperandOfIsOperator", "resolveDeprecations", "useSiteFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "supertypeSupplier", "Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "resolveUserType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;", "result", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult;", "topContainer", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "resolveUserTypeToSymbol", "addImplicitTypeArgumentsOrReturnError", "", "substitutor", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "isVisible", "containingDeclarations", "resolveEnumEntrySymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "TypeCandidate", "TypeResolutionResult", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirTypeResolverImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeResolverImpl.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,499:1\n1#2:500\n62#3:501\n60#4:502\n38#4:521\n37#5:503\n288#6,2:504\n1358#6:506\n1444#6,5:507\n1618#6,3:512\n1772#6,4:517\n1547#6:522\n1618#6,3:523\n1547#6:526\n1618#6,3:527\n37#7,2:515\n37#7,2:530\n*S KotlinDebug\n*F\n+ 1 FirTypeResolverImpl.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl\n*L\n181#1:501\n213#1:502\n328#1:521\n213#1:503\n215#1:504,2\n237#1:506\n237#1:507,5\n237#1:512,3\n316#1:517,4\n376#1:522\n376#1:523,3\n378#1:526\n378#1:527,3\n245#1:515,2\n409#1:530,2\n*E\n"})
public final class FirTypeResolverImpl
extends FirTypeResolver {
    @NotNull
    private final FirSession session;

    public FirTypeResolverImpl(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        this.session = session2;
    }

    private final FirBasedSymbol<?> resolveSymbol(FirBasedSymbol<?> symbol2, List<? extends FirQualifierPart> qualifier2, FirQualifierResolver qualifierResolver) {
        FirBasedSymbol firBasedSymbol;
        FirBasedSymbol firBasedSymbol2 = symbol2;
        if (firBasedSymbol2 instanceof FirClassLikeSymbol) {
            if (qualifier2.size() == 1) {
                firBasedSymbol = symbol2;
            } else {
                FirRegularClassSymbol firRegularClassSymbol = this.resolveLocalClassChain((FirClassLikeSymbol)symbol2, qualifier2);
                if (firRegularClassSymbol != null) {
                    firBasedSymbol = firRegularClassSymbol;
                } else {
                    FirClassifierSymbol<?> firClassifierSymbol = qualifierResolver.resolveSymbolWithPrefix(qualifier2, ((FirClassLikeSymbol)symbol2).getClassId());
                    firBasedSymbol = firClassifierSymbol != null ? (FirBasedSymbol)firClassifierSymbol : (FirBasedSymbol)this.resolveEnumEntrySymbol(qualifierResolver, qualifier2, ((FirClassLikeSymbol)symbol2).getClassId());
                }
            }
        } else if (firBasedSymbol2 instanceof FirTypeParameterSymbol) {
            FirBasedSymbol firBasedSymbol3 = symbol2;
            FirTypeParameterSymbol it = (FirTypeParameterSymbol)firBasedSymbol3;
            boolean bl = false;
            firBasedSymbol = qualifier2.size() == 1 ? firBasedSymbol3 : null;
        } else {
            throw new IllegalStateException("!".toString());
        }
        return firBasedSymbol;
    }

    private final boolean isVisible(FirBasedSymbol<?> $this$isVisible, FirFile useSiteFile, List<? extends FirDeclaration> containingDeclarations2, SupertypeSupplier supertypeSupplier) {
        FirBasedSymbol<?> firBasedSymbol = $this$isVisible;
        Object declaration2 = firBasedSymbol != null ? firBasedSymbol.getFir() : null;
        return useSiteFile != null && declaration2 instanceof FirMemberDeclaration ? FirVisibilityChecker.isVisible$default(FirVisibilityCheckerKt.getVisibilityChecker(this.session), (FirMemberDeclaration)declaration2, this.session, useSiteFile, containingDeclarations2, null, false, null, false, supertypeSupplier, 192, null) : true;
    }

    @NotNull
    public final TypeResolutionResult resolveUserTypeToSymbol(@NotNull FirUserTypeRef typeRef, @NotNull ScopeClassDeclaration scopeClassDeclaration, @Nullable FirFile useSiteFile, @NotNull SupertypeSupplier supertypeSupplier, boolean resolveDeprecations) {
        TypeResolutionResult typeResolutionResult;
        FirClassifierSymbol<?> symbol2;
        Intrinsics.checkNotNullParameter(typeRef, "typeRef");
        Intrinsics.checkNotNullParameter(scopeClassDeclaration, "scopeClassDeclaration");
        Intrinsics.checkNotNullParameter(supertypeSupplier, "supertypeSupplier");
        FirQualifierResolver qualifierResolver = FirQualifierResolverKt.getQualifierResolver(this.session);
        Ref.ObjectRef<CandidateApplicability> applicability = new Ref.ObjectRef<CandidateApplicability>();
        Set candidates2 = new LinkedHashSet();
        List<FirQualifierPart> qualifier2 = typeRef.getQualifier();
        Iterable<FirScope> scopes = scopeClassDeclaration.getScopes();
        List<FirDeclaration> containingDeclarations2 = scopeClassDeclaration.getContainingDeclarations();
        for (FirScope scope : scopes) {
            if (applicability.element == CandidateApplicability.RESOLVED) break;
            scope.processClassifiersByNameWithSubstitution(CollectionsKt.first(qualifier2).getName(), new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(this, qualifier2, qualifierResolver, useSiteFile, containingDeclarations2, supertypeSupplier, resolveDeprecations, applicability, candidates2){
                final /* synthetic */ FirTypeResolverImpl this$0;
                final /* synthetic */ List<FirQualifierPart> $qualifier;
                final /* synthetic */ FirQualifierResolver $qualifierResolver;
                final /* synthetic */ FirFile $useSiteFile;
                final /* synthetic */ List<FirDeclaration> $containingDeclarations;
                final /* synthetic */ SupertypeSupplier $supertypeSupplier;
                final /* synthetic */ boolean $resolveDeprecations;
                final /* synthetic */ Ref.ObjectRef<CandidateApplicability> $applicability;
                final /* synthetic */ Set<TypeCandidate> $candidates;
                {
                    this.this$0 = $receiver;
                    this.$qualifier = $qualifier;
                    this.$qualifierResolver = $qualifierResolver;
                    this.$useSiteFile = $useSiteFile;
                    this.$containingDeclarations = $containingDeclarations;
                    this.$supertypeSupplier = $supertypeSupplier;
                    this.$resolveDeprecations = $resolveDeprecations;
                    this.$applicability = $applicability;
                    this.$candidates = $candidates;
                    super(2);
                }

                public final void invoke(FirClassifierSymbol<?> symbol2, ConeSubstitutor substitutorFromScope) {
                    Intrinsics.checkNotNullParameter(symbol2, "symbol");
                    Intrinsics.checkNotNullParameter(substitutorFromScope, "substitutorFromScope");
                    FirBasedSymbol firBasedSymbol = FirTypeResolverImpl.access$resolveSymbol(this.this$0, symbol2, this.$qualifier, this.$qualifierResolver);
                    if (firBasedSymbol == null) {
                        return;
                    }
                    FirBasedSymbol resolvedSymbol = firBasedSymbol;
                    FirTypeResolverImpl.access$resolveUserTypeToSymbol$processCandidate(this.this$0, this.$useSiteFile, this.$containingDeclarations, this.$supertypeSupplier, this.$resolveDeprecations, this.$applicability, this.$candidates, resolvedSymbol, substitutorFromScope);
                }
            });
        }
        if (applicability.element != CandidateApplicability.RESOLVED && (symbol2 = qualifierResolver.resolveSymbol(qualifier2)) != null) {
            FirTypeResolverImpl.resolveUserTypeToSymbol$processCandidate(this, useSiteFile, containingDeclarations2, supertypeSupplier, resolveDeprecations, applicability, candidates2, (FirBasedSymbol)symbol2, null);
        }
        this.filterOutAmbiguousTypealiases(candidates2);
        int candidateCount = candidates2.size();
        if (candidateCount == 1) {
            TypeCandidate candidate2 = (TypeCandidate)CollectionsKt.single(candidates2);
            typeResolutionResult = new TypeResolutionResult.Resolved(candidate2);
        } else if (candidateCount > 1) {
            typeResolutionResult = new TypeResolutionResult.Ambiguity(CollectionsKt.toList(candidates2));
        } else if (candidateCount == 0) {
            typeResolutionResult = TypeResolutionResult.Unresolved.INSTANCE;
        } else {
            throw new IllegalStateException("Unexpected".toString());
        }
        return typeResolutionResult;
    }

    private final void filterOutAmbiguousTypealiases(Set<TypeCandidate> candidates2) {
        if (candidates2.size() <= 1) {
            return;
        }
        Set aliasesToRemove = new LinkedHashSet();
        Map<ClassId, ClassId> classTypealiasesThatDontCauseAmbiguity = FirPlatformClassMapperKt.getPlatformClassMapper(this.session).getClassTypealiasesThatDontCauseAmbiguity();
        for (TypeCandidate candidate2 : candidates2) {
            ClassId it;
            FirBasedSymbol<?> symbol2 = candidate2.getSymbol();
            if (!(symbol2 instanceof FirClassLikeSymbol)) continue;
            if (classTypealiasesThatDontCauseAmbiguity.get(((FirClassLikeSymbol)symbol2).getClassId()) == null) continue;
            boolean bl = false;
            aliasesToRemove.add(it);
        }
        if (!((Collection)aliasesToRemove).isEmpty()) {
            CollectionsKt.removeAll((Iterable)candidates2, (Function1)new Function1<TypeCandidate, Boolean>((Set<ClassId>)aliasesToRemove){
                final /* synthetic */ Set<ClassId> $aliasesToRemove;
                {
                    this.$aliasesToRemove = $aliasesToRemove;
                    super(1);
                }

                public final Boolean invoke(TypeCandidate it) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter(it, "it");
                    FirBasedSymbol<?> firBasedSymbol = it.getSymbol();
                    Object object = firBasedSymbol instanceof FirClassLikeSymbol ? (FirClassLikeSymbol)firBasedSymbol : null;
                    if (object != null && (object = ((FirClassLikeSymbol)object).getClassId()) != null) {
                        Object object2 = object;
                        Set<ClassId> set = this.$aliasesToRemove;
                        Object classId = object2;
                        boolean bl2 = false;
                        bl = set.contains(classId);
                    } else {
                        bl = false;
                    }
                    return bl;
                }
            });
        }
    }

    private final FirRegularClassSymbol resolveLocalClassChain(FirClassLikeSymbol<?> symbol2, List<? extends FirQualifierPart> qualifier2) {
        block3: {
            block2: {
                if (!(symbol2 instanceof FirRegularClassSymbol)) break block2;
                FirClassLikeSymbol<?> $this$isLocal$iv = symbol2;
                boolean $i$f$isLocal = false;
                if ($this$isLocal$iv.getClassId().isLocal()) break block3;
            }
            return null;
        }
        return FirTypeResolverImpl.resolveLocalClassChain$resolveLocalClassChain(qualifier2, (FirRegularClassSymbol)symbol2, 1);
    }

    /*
     * WARNING - void declaration
     */
    private final FirVariableSymbol<FirEnumEntry> resolveEnumEntrySymbol(FirQualifierResolver $this$resolveEnumEntrySymbol, List<? extends FirQualifierPart> qualifier2, ClassId classId) {
        FirEnumEntry enumEntryMatchingLastQualifier;
        Object v2;
        block4: {
            void $this$firstOrNull$iv;
            FirClassifierSymbol<?> firClassifierSymbol = $this$resolveEnumEntrySymbol.resolveSymbolWithPrefix(CollectionsKt.dropLast(qualifier2, 1), classId);
            if (firClassifierSymbol == null) {
                return null;
            }
            FirClassifierSymbol<?> enumClassSymbol = firClassifierSymbol;
            Object e = enumClassSymbol.getFir();
            FirRegularClass firRegularClass = e instanceof FirRegularClass ? (FirRegularClass)e : null;
            if (firRegularClass == null) {
                return null;
            }
            FirRegularClass enumClassFir = firRegularClass;
            FirClass $this$isEnumClass$iv = enumClassFir;
            boolean $i$f$isEnumClass = false;
            Object $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS)) {
                return null;
            }
            $this$isEnumClass$iv$iv = enumClassFir.getDeclarations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirDeclaration it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirEnumEntry && Intrinsics.areEqual(((FirEnumEntry)it).getName(), CollectionsKt.last(qualifier2).getName()))) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        Object var7_7 = v2;
        FirEnumEntry firEnumEntry = enumEntryMatchingLastQualifier = var7_7 instanceof FirEnumEntry ? (FirEnumEntry)var7_7 : null;
        return firEnumEntry != null ? firEnumEntry.getSymbol() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeKotlinType resolveUserType(FirUserTypeRef typeRef, TypeResolutionResult result2, boolean areBareTypesAllowed, FirDeclaration topContainer, boolean isOperandOfIsOperator) {
        ConeTypeProjection[] resultingArguments;
        Object object;
        FirBasedSymbol symbol2;
        block18: {
            block17: {
                void destination$iv;
                ConeDiagnostic $this$mapTo$iv;
                void $this$flatMapTo$iv$iv;
                Pair<Object, Object> pair;
                TypeResolutionResult typeResolutionResult = result2;
                if (typeResolutionResult instanceof TypeResolutionResult.Resolved) {
                    pair = TuplesKt.to(((TypeResolutionResult.Resolved)result2).getTypeCandidate().getSymbol(), ((TypeResolutionResult.Resolved)result2).getTypeCandidate().getSubstitutor());
                } else if (typeResolutionResult instanceof TypeResolutionResult.Ambiguity) {
                    pair = TuplesKt.to(null, null);
                } else if (Intrinsics.areEqual(typeResolutionResult, TypeResolutionResult.Unresolved.INSTANCE)) {
                    pair = TuplesKt.to(null, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Pair<Object, Object> pair2 = pair;
                symbol2 = pair2.component1();
                ConeSubstitutor substitutor2 = pair2.component2();
                List<FirQualifierPart> qualifier2 = typeRef.getQualifier();
                Iterable $this$flatMap$iv = CollectionsKt.reversed((Iterable)qualifier2);
                boolean $i$f$flatMap22 = false;
                Iterable iterable = $this$flatMap$iv;
                Object destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    FirQualifierPart it = (FirQualifierPart)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.getTypeArgumentList().getTypeArguments();
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                Collection $i$f$flatMap22 = new ArrayList();
                boolean $i$f$mapTo = false;
                destination$iv$iv = $this$mapTo$iv.iterator();
                while (destination$iv$iv.hasNext()) {
                    void it;
                    Object item$iv = destination$iv$iv.next();
                    object = (FirTypeProjection)item$iv;
                    void var20_31 = destination$iv;
                    boolean bl = false;
                    var20_31.add(FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)it));
                }
                List allTypeArguments = (List)destination$iv;
                if (symbol2 instanceof FirClassLikeSymbol && !this.isPossibleBareType(areBareTypesAllowed, allTypeArguments)) {
                    $this$mapTo$iv = this.matchQualifierPartsAndClasses((FirClassLikeSymbol)symbol2, qualifier2);
                    if ($this$mapTo$iv != null) {
                        ConeDiagnostic it = $this$mapTo$iv;
                        boolean bl = false;
                        return new ConeErrorType(it, false, null, null, null, 30, null);
                    }
                    $this$mapTo$iv = this.addImplicitTypeArgumentsOrReturnError(allTypeArguments, (FirClassLikeSymbol)symbol2, topContainer, substitutor2);
                    if ($this$mapTo$iv != null) {
                        ConeDiagnostic it = $this$mapTo$iv;
                        boolean bl = false;
                        return new ConeErrorType(it, false, null, null, null, 30, null);
                    }
                }
                Collection $this$toTypedArray$iv = allTypeArguments;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                resultingArguments = thisCollection$iv.toArray(new ConeTypeProjection[0]);
                if (symbol2 == null) break block17;
                if (symbol2 instanceof FirClassifierSymbol) break block18;
            }
            FirBasedSymbol firBasedSymbol = symbol2;
            ConeDiagnostic diagnostic = (firBasedSymbol != null ? firBasedSymbol.getFir() : null) instanceof FirEnumEntry ? (ConeDiagnostic)(isOperandOfIsOperator ? new ConeSimpleDiagnostic("'is' operator can not be applied to an enum entry.", DiagnosticKind.IsEnumEntry) : new ConeSimpleDiagnostic("An enum entry should not be used as a type.", DiagnosticKind.EnumEntryAsType)) : (result2 instanceof TypeResolutionResult.Ambiguity ? (ConeDiagnostic)new ConeAmbiguityError(CollectionsKt.last(typeRef.getQualifier()).getName(), CollectionsKt.first(((TypeResolutionResult.Ambiguity)result2).getTypeCandidates()).getApplicability(), (Collection<? extends AbstractCandidate>)((TypeResolutionResult.Ambiguity)result2).getTypeCandidates()) : (ConeDiagnostic)new ConeUnresolvedTypeQualifierError(typeRef.getQualifier(), typeRef.isMarkedNullable()));
            return new ConeErrorType(diagnostic, false, null, resultingArguments, CopyUtilsKt.computeTypeAttributes$default(typeRef.getAnnotations(), this.session, null, false, true, 6, null), 6, null);
        }
        if (symbol2 instanceof FirTypeParameterSymbol) {
            for (FirQualifierPart part : typeRef.getQualifier()) {
                if (!(!((Collection)part.getTypeArgumentList().getTypeArguments()).isEmpty())) continue;
                return new ConeErrorType(new ConeUnexpectedTypeArgumentsError("Type arguments not allowed for type parameters", part.getTypeArgumentList().getSource()), false, null, resultingArguments, null, 22, null);
            }
        }
        Object object2 = typeRef.getAnnotations();
        FirSession part = this.session;
        object = ((FirClassifierSymbol)symbol2).toLookupTag();
        ConeClassLikeLookupTag coneClassLikeLookupTag = object instanceof ConeClassLikeLookupTag ? (ConeClassLikeLookupTag)object : null;
        boolean thisCollection$iv = coneClassLikeLookupTag != null ? FunctionalTypeUtilsKt.isSomeFunctionType(coneClassLikeLookupTag, this.session) : false;
        Object it = object2 = TypeConstructionUtilsKt.constructType((FirClassifierSymbol)symbol2, resultingArguments, typeRef.isMarkedNullable(), CopyUtilsKt.computeTypeAttributes$default((List)object2, part, null, thisCollection$iv, true, 2, null));
        boolean bl = false;
        ConeClassifierLookupTag lookupTag2 = ((ConeLookupTagBasedType)it).getLookupTag();
        if (lookupTag2 instanceof ConeClassLikeLookupTagImpl && symbol2 instanceof FirClassLikeSymbol) {
            LookupTagUtilsKt.bindSymbolToLookupTag((ConeClassLikeLookupTagImpl)lookupTag2, this.session, (FirClassLikeSymbol)symbol2);
        }
        return (ConeKotlinType)object2;
    }

    private final boolean isPossibleBareType(boolean areBareTypesAllowed, List<? extends ConeTypeProjection> allTypeArguments) {
        return areBareTypesAllowed && allTypeArguments.isEmpty();
    }

    private final ConeDiagnostic matchQualifierPartsAndClasses(FirClassLikeSymbol<?> symbol2, List<? extends FirQualifierPart> qualifier2) {
        FirClassLikeDeclaration currentDeclaration = (FirClassLikeDeclaration)symbol2.getFir();
        boolean areTypeArgumentsAllowed = true;
        for (FirQualifierPart firQualifierPart : CollectionsKt.asReversed(qualifier2)) {
            int desiredTypeParametersCount;
            int n;
            FirTypeArgumentList typeArgumentList = firQualifierPart.getTypeArgumentList();
            int qualifierPartArgsCount = typeArgumentList.getTypeArguments().size();
            if (currentDeclaration == null) {
                if (qualifierPartArgsCount <= 0) break;
                KtSourceElement ktSourceElement = typeArgumentList.getSource();
                Intrinsics.checkNotNull(ktSourceElement);
                return new ConeTypeArgumentsNotAllowedOnPackageError(ktSourceElement);
            }
            Iterable $this$count$iv = currentDeclaration.getTypeParameters();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                    boolean bl = false;
                    if (!(!(it instanceof FirOuterClassTypeParameterRef)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = desiredTypeParametersCount = count$iv;
            }
            if (areTypeArgumentsAllowed) {
                if (desiredTypeParametersCount != qualifierPartArgsCount) {
                    KtSourceElement source = qualifierPartArgsCount == 0 ? firQualifierPart.getSource() : typeArgumentList.getSource();
                    FirClassLikeSymbol<? extends FirClassLikeDeclaration> firClassLikeSymbol = currentDeclaration.getSymbol();
                    KtSourceElement ktSourceElement = source;
                    Intrinsics.checkNotNull(ktSourceElement);
                    return new ConeWrongNumberOfTypeArgumentsError(desiredTypeParametersCount, firClassLikeSymbol, ktSourceElement);
                }
            } else if (qualifierPartArgsCount > 0) {
                KtSourceElement ktSourceElement = typeArgumentList.getSource();
                Intrinsics.checkNotNull(ktSourceElement);
                return new ConeTypeArgumentsForOuterClassWhenNestedReferencedError(ktSourceElement);
            }
            FirMemberDeclaration $this$isInner$iv = currentDeclaration;
            boolean $i$f$isInner = false;
            areTypeArgumentsAllowed = $this$isInner$iv.getStatus().isInner();
            currentDeclaration = DeclarationUtilsKt.getContainingDeclaration(currentDeclaration, this.session);
        }
        return null;
    }

    private final ConeDiagnostic addImplicitTypeArgumentsOrReturnError(List<ConeTypeProjection> $this$addImplicitTypeArgumentsOrReturnError, FirClassLikeSymbol<?> symbol2, FirDeclaration topContainer, ConeSubstitutor substitutor2) {
        int explicitTypeArgumentsNumber = $this$addImplicitTypeArgumentsOrReturnError.size();
        Iterator<FirTypeParameterRef> iterator2 = ((FirClassLikeDeclaration)symbol2.getFir()).getTypeParameters().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int typeParameterIndex = n++;
            FirTypeParameterRef typeParameter = iterator2.next();
            if (typeParameterIndex < explicitTypeArgumentsNumber) continue;
            if (!(typeParameter instanceof FirOuterClassTypeParameterRef) || DeclarationUtilsKt.isValidTypeParameterFromOuterDeclaration(typeParameter.getSymbol(), topContainer, this.session)) {
                ConeKotlinType substituted;
                ConeSubstitutor coneSubstitutor = substitutor2;
                ConeKotlinType coneKotlinType = substituted = coneSubstitutor != null ? coneSubstitutor.substituteOrNull(ResolveUtilsKt.getDefaultType(typeParameter.getSymbol())) : null;
                if (substituted == null) {
                    FirBasedSymbol<?> firBasedSymbol = typeParameter.getSymbol().getContainingDeclarationSymbol();
                    Intrinsics.checkNotNull(firBasedSymbol, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol<*>");
                    return new ConeOuterClassArgumentsRequired((FirClassLikeSymbol)firBasedSymbol);
                }
                $this$addImplicitTypeArgumentsOrReturnError.add(substituted);
                continue;
            }
            FirBasedSymbol<?> firBasedSymbol = typeParameter.getSymbol().getContainingDeclarationSymbol();
            Intrinsics.checkNotNull(firBasedSymbol, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol<*>");
            return new ConeOuterClassArgumentsRequired((FirClassLikeSymbol)firBasedSymbol);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final FirTypeResolutionResult createFunctionType(FirFunctionTypeRef typeRef) {
        void $this$createFunctionType_u24lambda_u2411;
        FunctionTypeKind functionTypeKind;
        Iterable<FirAnnotation> iterable;
        FirFunctionTypeParameter it;
        List<FirAnnotation> list2;
        Object item$iv$iv2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = typeRef.getContextReceiverTypeRefs();
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        List<FirAnnotation> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            FirTypeRef firTypeRef = (FirTypeRef)item$iv$iv2;
            list2 = destination$iv$iv;
            boolean bl = false;
            list2.add((FirAnnotation)((Object)FirTypeUtilsKt.getConeType((FirTypeRef)((Object)it))));
        }
        FirTypeRef firTypeRef = typeRef.getReceiverTypeRef();
        $this$map$iv = typeRef.getParameters();
        list2 = CollectionsKt.plus((Collection)destination$iv$iv, (Iterable)CollectionsKt.listOfNotNull(firTypeRef != null ? FirTypeUtilsKt.getConeType(firTypeRef) : null));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            it = (FirFunctionTypeParameter)item$iv$iv2;
            iterable = destination$iv$iv;
            boolean bl = false;
            iterable.add((FirAnnotation)((Object)LookupTagUtilsKt.withParameterNameAnnotation(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()), it, this.session)));
        }
        List parameters2 = CollectionsKt.plus((Collection)CollectionsKt.plus(list2, (Iterable)destination$iv$iv), (Iterable)CollectionsKt.listOf(FirTypeUtilsKt.getConeType(typeRef.getReturnTypeRef())));
        List<FunctionTypeKind> functionKinds = FirFunctionTypeKindServiceKt.getFunctionTypeService(this.session).extractAllSpecialKindsForFunctionTypeRef(typeRef);
        ConeDiagnostic diagnostic = null;
        switch (functionKinds.size()) {
            case 0: {
                functionTypeKind = FunctionTypeKind.Function.INSTANCE;
                break;
            }
            case 1: {
                functionTypeKind = CollectionsKt.single(functionKinds);
                break;
            }
            default: {
                diagnostic = new ConeAmbiguousFunctionTypeKinds(functionKinds);
                functionTypeKind = FunctionTypeKind.Function.INSTANCE;
            }
        }
        FunctionTypeKind kind = functionTypeKind;
        ClassId classId = kind.numberedClassId(FirTypeUtilsKt.getParametersCount(typeRef));
        List list3 = CollectionsKt.createListBuilder();
        item$iv$iv2 = list3;
        iterable = this.session;
        list2 = typeRef.getAnnotations();
        boolean bl = false;
        if (typeRef.getReceiverTypeRef() != null) {
            $this$createFunctionType_u24lambda_u2411.add(CompilerConeAttributes.ExtensionFunctionType.INSTANCE);
        }
        if (!((Collection)typeRef.getContextReceiverTypeRefs()).isEmpty()) {
            $this$createFunctionType_u24lambda_u2411.add(new CompilerConeAttributes.ContextFunctionTypeParams(typeRef.getContextReceiverTypeRefs().size()));
        }
        Unit unit2 = Unit.INSTANCE;
        ConeAttributes attributes2 = CopyUtilsKt.computeTypeAttributes$default(list2, iterable, CollectionsKt.build(list3), false, true, 4, null);
        Collection $this$toTypedArray$iv = parameters2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new FirTypeResolutionResult(new ConeClassLikeTypeImpl(TypeConstructionUtilsKt.toLookupTag(classId), thisCollection$iv.toArray(new ConeKotlinType[0]), typeRef.isMarkedNullable(), attributes2), diagnostic);
    }

    @Override
    @NotNull
    public FirTypeResolutionResult resolveType(@NotNull FirTypeRef typeRef, @NotNull ScopeClassDeclaration scopeClassDeclaration, boolean areBareTypesAllowed, boolean isOperandOfIsOperator, boolean resolveDeprecations, @Nullable FirFile useSiteFile, @NotNull SupertypeSupplier supertypeSupplier) {
        FirTypeResolutionResult firTypeResolutionResult;
        Intrinsics.checkNotNullParameter(typeRef, "typeRef");
        Intrinsics.checkNotNullParameter(scopeClassDeclaration, "scopeClassDeclaration");
        Intrinsics.checkNotNullParameter(supertypeSupplier, "supertypeSupplier");
        FirTypeRef firTypeRef = typeRef;
        if (firTypeRef instanceof FirResolvedTypeRef) {
            throw new IllegalStateException("Do not resolve, resolved type-refs".toString());
        }
        if (firTypeRef instanceof FirUserTypeRef) {
            TypeResolutionResult result2 = this.resolveUserTypeToSymbol((FirUserTypeRef)typeRef, scopeClassDeclaration, useSiteFile, supertypeSupplier, resolveDeprecations);
            FirUserTypeRef firUserTypeRef = (FirUserTypeRef)typeRef;
            FirDeclaration firDeclaration = scopeClassDeclaration.getTopContainer();
            if (firDeclaration == null) {
                firDeclaration = CollectionsKt.lastOrNull(scopeClassDeclaration.getContainingDeclarations());
            }
            ConeKotlinType resolvedType = this.resolveUserType(firUserTypeRef, result2, areBareTypesAllowed, firDeclaration, isOperandOfIsOperator);
            Object object = result2 instanceof TypeResolutionResult.Resolved ? (TypeResolutionResult.Resolved)result2 : null;
            firTypeResolutionResult = new FirTypeResolutionResult(resolvedType, object != null && (object = ((TypeResolutionResult.Resolved)object).getTypeCandidate()) != null ? ((TypeCandidate)object).getDiagnostic() : null);
        } else if (firTypeRef instanceof FirFunctionTypeRef) {
            firTypeResolutionResult = this.createFunctionType((FirFunctionTypeRef)typeRef);
        } else if (firTypeRef instanceof FirDynamicTypeRef) {
            ConeAttributes attributes2 = CopyUtilsKt.computeTypeAttributes$default(typeRef.getAnnotations(), this.session, null, false, true, 6, null);
            firTypeResolutionResult = new FirTypeResolutionResult(TypeUtilsKt.create(ConeDynamicType.Companion, this.session, attributes2), null);
        } else if (firTypeRef instanceof FirIntersectionTypeRef) {
            ConeKotlinType leftType = FirTypeUtilsKt.getConeType(((FirIntersectionTypeRef)typeRef).getLeftType());
            firTypeResolutionResult = leftType instanceof ConeTypeParameterType ? new FirTypeResolutionResult(new ConeDefinitelyNotNullType((ConeSimpleKotlinType)leftType), null) : new FirTypeResolutionResult(new ConeErrorType(ConeForbiddenIntersection.INSTANCE, false, null, null, null, 30, null), null);
        } else {
            throw new IllegalStateException(UtilsKt.render(typeRef).toString());
        }
        return firTypeResolutionResult;
    }

    private static final void resolveUserTypeToSymbol$processCandidate(FirTypeResolverImpl this$0, FirFile $useSiteFile, List<? extends FirDeclaration> containingDeclarations2, SupertypeSupplier $supertypeSupplier, boolean $resolveDeprecations, Ref.ObjectRef<CandidateApplicability> applicability, Set<TypeCandidate> candidates2, FirBasedSymbol<?> symbol2, ConeSubstitutor substitutor2) {
        ConeDiagnostic diagnostic;
        CandidateApplicability symbolApplicability;
        block7: {
            block6: {
                DeprecationInfo deprecation;
                symbolApplicability = CandidateApplicability.RESOLVED;
                diagnostic = null;
                if (!this$0.isVisible(symbol2, $useSiteFile, containingDeclarations2, $supertypeSupplier)) {
                    symbolApplicability = (CandidateApplicability)((Object)ComparisonsKt.minOf((Comparable)((Object)CandidateApplicability.K2_VISIBILITY_ERROR), (Comparable)((Object)symbolApplicability)));
                    diagnostic = new ConeVisibilityError(symbol2);
                }
                if ($resolveDeprecations && (deprecation = DeprecationUtilsKt.getOwnDeprecation(symbol2, this$0.session, $useSiteFile)) != null && deprecation.getDeprecationLevel() == DeprecationLevelValue.HIDDEN) {
                    symbolApplicability = (CandidateApplicability)((Object)ComparisonsKt.minOf((Comparable)((Object)CandidateApplicability.HIDDEN), (Comparable)((Object)symbolApplicability)));
                    diagnostic = null;
                }
                if (applicability.element == null) break block6;
                Object t = applicability.element;
                Intrinsics.checkNotNull(t);
                if (symbolApplicability.compareTo((Enum)t) <= 0) break block7;
            }
            applicability.element = symbolApplicability;
            candidates2.clear();
        }
        if (symbolApplicability == applicability.element) {
            candidates2.add(new TypeCandidate(symbol2, substitutor2, diagnostic, symbolApplicability));
        }
    }

    private static final FirRegularClassSymbol resolveLocalClassChain$resolveLocalClassChain(List<? extends FirQualifierPart> $qualifier, FirRegularClassSymbol classSymbol2, int qualifierIndex2) {
        if (qualifierIndex2 == $qualifier.size()) {
            return classSymbol2;
        }
        Name qualifierName2 = $qualifier.get(qualifierIndex2).getName();
        for (FirBasedSymbol<?> declarationSymbol : classSymbol2.getDeclarationSymbols()) {
            if (!(declarationSymbol instanceof FirRegularClassSymbol) || !Intrinsics.areEqual(((FirRegularClassSymbol)declarationSymbol).toLookupTag().getName(), qualifierName2)) continue;
            return FirTypeResolverImpl.resolveLocalClassChain$resolveLocalClassChain($qualifier, (FirRegularClassSymbol)declarationSymbol, qualifierIndex2 + 1);
        }
        return null;
    }

    public static final /* synthetic */ FirBasedSymbol access$resolveSymbol(FirTypeResolverImpl $this, FirBasedSymbol symbol2, List qualifier2, FirQualifierResolver qualifierResolver) {
        return $this.resolveSymbol(symbol2, qualifier2, qualifierResolver);
    }

    public static final /* synthetic */ void access$resolveUserTypeToSymbol$processCandidate(FirTypeResolverImpl this$0, FirFile $useSiteFile, List containingDeclarations2, SupertypeSupplier $supertypeSupplier, boolean $resolveDeprecations, Ref.ObjectRef applicability, Set candidates2, FirBasedSymbol symbol2, ConeSubstitutor substitutor2) {
        FirTypeResolverImpl.resolveUserTypeToSymbol$processCandidate(this$0, $useSiteFile, containingDeclarations2, $supertypeSupplier, $resolveDeprecations, applicability, candidates2, symbol2, substitutor2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B-\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0096\u0002J\b\u0010-\u001a\u00020.H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0014R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001bR\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeCandidate;", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractCandidate;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "substitutor", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "applicability", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;)V", "getApplicability", "()Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractCallInfo;", "getCallInfo", "()Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractCallInfo;", "chosenExtensionReceiver", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getChosenExtensionReceiver", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getDiagnostic", "()Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "diagnostics", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionDiagnostic;", "getDiagnostics", "()Ljava/util/List;", "dispatchReceiver", "getDispatchReceiver", "errors", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintSystemError;", "getErrors", "explicitReceiverKind", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;", "getExplicitReceiverKind", "()Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;", "getSubstitutor", "()Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "getSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "equals", "", "other", "", "hashCode", "", "resolve"})
    public static final class TypeCandidate
    extends AbstractCandidate {
        @NotNull
        private final FirBasedSymbol<?> symbol;
        @Nullable
        private final ConeSubstitutor substitutor;
        @Nullable
        private final ConeDiagnostic diagnostic;
        @NotNull
        private final CandidateApplicability applicability;

        public TypeCandidate(@NotNull FirBasedSymbol<?> symbol2, @Nullable ConeSubstitutor substitutor2, @Nullable ConeDiagnostic diagnostic, @NotNull CandidateApplicability applicability) {
            Intrinsics.checkNotNullParameter(symbol2, "symbol");
            Intrinsics.checkNotNullParameter((Object)applicability, "applicability");
            this.symbol = symbol2;
            this.substitutor = substitutor2;
            this.diagnostic = diagnostic;
            this.applicability = applicability;
        }

        @Override
        @NotNull
        public FirBasedSymbol<?> getSymbol() {
            return this.symbol;
        }

        @Nullable
        public final ConeSubstitutor getSubstitutor() {
            return this.substitutor;
        }

        @Nullable
        public final ConeDiagnostic getDiagnostic() {
            return this.diagnostic;
        }

        @Override
        @NotNull
        public CandidateApplicability getApplicability() {
            return this.applicability;
        }

        @Override
        @Nullable
        public FirExpression getDispatchReceiver() {
            return null;
        }

        @Override
        @Nullable
        public FirExpression getChosenExtensionReceiver() {
            return null;
        }

        @Override
        @NotNull
        public ExplicitReceiverKind getExplicitReceiverKind() {
            return ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
        }

        @Override
        @NotNull
        public List<ResolutionDiagnostic> getDiagnostics() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        public List<ConstraintSystemError> getErrors() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        public AbstractCallInfo getCallInfo() {
            AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
            throw null;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypeCandidate)) {
                return false;
            }
            return Intrinsics.areEqual(this.getSymbol(), ((TypeCandidate)other).getSymbol());
        }

        public int hashCode() {
            return this.getSymbol().hashCode();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult;", "", "()V", "Ambiguity", "Resolved", "Unresolved", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult$Ambiguity;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult$Resolved;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult$Unresolved;", "resolve"})
    public static abstract class TypeResolutionResult {
        private TypeResolutionResult() {
        }

        public /* synthetic */ TypeResolutionResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult$Ambiguity;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult;", "typeCandidates", "", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeCandidate;", "(Ljava/util/List;)V", "getTypeCandidates", "()Ljava/util/List;", "resolve"})
        public static final class Ambiguity
        extends TypeResolutionResult {
            @NotNull
            private final List<TypeCandidate> typeCandidates;

            public Ambiguity(@NotNull List<TypeCandidate> typeCandidates) {
                Intrinsics.checkNotNullParameter(typeCandidates, "typeCandidates");
                super(null);
                this.typeCandidates = typeCandidates;
            }

            @NotNull
            public final List<TypeCandidate> getTypeCandidates() {
                return this.typeCandidates;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult$Resolved;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult;", "typeCandidate", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeCandidate;", "(Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeCandidate;)V", "getTypeCandidate", "()Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeCandidate;", "resolve"})
        public static final class Resolved
        extends TypeResolutionResult {
            @NotNull
            private final TypeCandidate typeCandidate;

            public Resolved(@NotNull TypeCandidate typeCandidate) {
                Intrinsics.checkNotNullParameter(typeCandidate, "typeCandidate");
                super(null);
                this.typeCandidate = typeCandidate;
            }

            @NotNull
            public final TypeCandidate getTypeCandidate() {
                return this.typeCandidate;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult$Unresolved;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult;", "()V", "resolve"})
        public static final class Unresolved
        extends TypeResolutionResult {
            @NotNull
            public static final Unresolved INSTANCE = new Unresolved();

            private Unresolved() {
                super(null);
            }
        }
    }
}

