/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.wasm.FirWasmErrors;
import org.jetbrains.kotlin.fir.analysis.wasm.checkers.FirWasmJsCodeHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.name.WebCommonStandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/wasm/checkers/expression/FirWasmJsCodeCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.wasm"})
@SourceDebugExtension(value={"SMAP\nFirWasmJsCodeCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWasmJsCodeCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/expression/FirWasmJsCodeCallChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,84:1\n46#2:85\n43#2:86\n*S KotlinDebug\n*F\n+ 1 FirWasmJsCodeCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/expression/FirWasmJsCodeCallChecker\n*L\n53#1:85\n56#1:86\n*E\n"})
public final class FirWasmJsCodeCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirWasmJsCodeCallChecker INSTANCE = new FirWasmJsCodeCallChecker();

    private FirWasmJsCodeCallChecker() {
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol symbol2 = firCallableSymbol;
        if (!Intrinsics.areEqual(symbol2.getCallableId(), WebCommonStandardClassIds.Callables.Js)) {
            return;
        }
        List<FirDeclaration> containingDeclarations2 = context2.getContainingDeclarations();
        FirDeclaration firDeclaration = CollectionsKt.lastOrNull(containingDeclarations2);
        if (firDeclaration == null) {
            return;
        }
        FirDeclaration containingDeclaration2 = firDeclaration;
        FirDeclaration containingDeclarationOfContainingDeclaration = CollectionsKt.getOrNull(containingDeclarations2, containingDeclarations2.size() - 2);
        boolean isContainingDeclarationTopLevel = containingDeclarationOfContainingDeclaration instanceof FirFile || containingDeclarationOfContainingDeclaration instanceof FirScript;
        KtSourceElement source = expression2.getCalleeReference().getSource();
        if (!isContainingDeclarationTopLevel) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_WRONG_CONTEXT(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        FirDeclaration firDeclaration2 = containingDeclaration2;
        if (firDeclaration2 instanceof FirSimpleFunction) {
            if (!FirWasmJsCodeHelpersKt.hasValidJsCodeBody((FirSimpleFunction)containingDeclaration2)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_WRONG_CONTEXT(), (DiagnosticContext)context2, null, 8, null);
            } else {
                FirMemberDeclaration $this$isSuspend$iv = (FirMemberDeclaration)containingDeclaration2;
                boolean $i$f$isSuspend = false;
                if ($this$isSuspend$iv.getStatus().isSuspend()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_UNSUPPORTED_FUNCTION_KIND(), (Object)"suspend function", (DiagnosticContext)context2, null, 16, null);
                }
                FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)containingDeclaration2;
                boolean $i$f$isInline = false;
                if ($this$isInline$iv.getStatus().isInline()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_UNSUPPORTED_FUNCTION_KIND(), (Object)"inline function", (DiagnosticContext)context2, null, 16, null);
                }
                if (FirDeclarationUtilKt.isExtension((FirCallableDeclaration)containingDeclaration2)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_UNSUPPORTED_FUNCTION_KIND(), (Object)"function with extension receiver", (DiagnosticContext)context2, null, 16, null);
                }
                for (FirValueParameter parameter2 : ((FirSimpleFunction)containingDeclaration2).getValueParameters()) {
                    String string2 = parameter2.getName().getIdentifierOrNullIfSpecial();
                    if (string2 != null ? IdentifierPolicyKt.isValidES5Identifier(string2) : false) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter2.getSource(), FirWasmErrors.INSTANCE.getJSCODE_INVALID_PARAMETER_NAME(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        } else if (firDeclaration2 instanceof FirProperty) {
            if (!FirWasmJsCodeHelpersKt.hasValidJsCodeBody((FirProperty)containingDeclaration2)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_WRONG_CONTEXT(), (DiagnosticContext)context2, null, 8, null);
            }
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_WRONG_CONTEXT(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

