/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0014\u001a\u00020\u0015*\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00160\u0016H\u0002J\u001c\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\r*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u0017*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u0017*\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016*\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameUtilities;", "", "()V", "exactName", "Lorg/jetbrains/kotlin/name/Name;", "objCNameClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "swiftNameName", "checkCallableMember", "", "firTypeScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "memberSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "declarationToReport", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "allNamesEquals", "", "", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameUtilities$ObjCName;", "getFirstBaseSymbol", "getObjCName", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getObjCNames", "ObjCName", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeObjCNameUtilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCNameUtilities.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameUtilities\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1853#2,2:111\n1547#2:114\n1618#2,3:115\n1601#2,9:118\n1853#2:127\n1854#2:129\n1610#2:130\n1#3:113\n1#3:128\n*S KotlinDebug\n*F\n+ 1 FirNativeObjCNameUtilities.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameUtilities\n*L\n40#1:111,2\n79#1:114\n79#1:115,3\n81#1:118,9\n81#1:127\n81#1:129\n81#1:130\n81#1:128\n*E\n"})
public final class FirNativeObjCNameUtilities {
    @NotNull
    public static final FirNativeObjCNameUtilities INSTANCE = new FirNativeObjCNameUtilities();
    @NotNull
    private static final ClassId objCNameClassId = ClassId.Companion.topLevel(new FqName("kotlin.native.ObjCName"));
    @NotNull
    private static final Name swiftNameName;
    @NotNull
    private static final Name exactName;

    private FirNativeObjCNameUtilities() {
    }

    @NotNull
    public final List<ObjCName> getObjCNames(@NotNull FirBasedSymbol<?> $this$getObjCNames, @NotNull FirSession session2) {
        List<ObjCName> list2;
        Intrinsics.checkNotNullParameter($this$getObjCNames, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        if ($this$getObjCNames instanceof FirFunctionSymbol) {
            List<ObjCName> list3;
            List<ObjCName> $this$getObjCNames_u24lambda_u241 = list3 = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$getObjCNames_u24lambda_u241.add(INSTANCE.getObjCName($this$getObjCNames, session2));
            FirResolvedTypeRef firResolvedTypeRef = ((FirFunctionSymbol)$this$getObjCNames).getResolvedReceiverTypeRef();
            $this$getObjCNames_u24lambda_u241.add(firResolvedTypeRef != null ? INSTANCE.getObjCName(firResolvedTypeRef, session2) : null);
            FirReceiverParameter firReceiverParameter = ((FirFunctionSymbol)$this$getObjCNames).getReceiverParameter();
            $this$getObjCNames_u24lambda_u241.add(firReceiverParameter != null ? INSTANCE.getObjCName(firReceiverParameter, session2) : null);
            Iterable $this$forEach$iv = ((FirFunctionSymbol)$this$getObjCNames).getValueParameterSymbols();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                boolean bl2 = false;
                $this$getObjCNames_u24lambda_u241.add(INSTANCE.getObjCName(it, session2));
            }
            list2 = CollectionsKt.build(list3);
        } else {
            list2 = CollectionsKt.listOf(this.getObjCName($this$getObjCNames, session2));
        }
        return list2;
    }

    private final ObjCName getObjCName(FirAnnotationContainer $this$getObjCName, FirSession session2) {
        ObjCName objCName;
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId($this$getObjCName, objCNameClassId, session2);
        if (firAnnotation != null) {
            FirAnnotation p0 = firAnnotation;
            boolean bl = false;
            objCName = new ObjCName(p0);
        } else {
            objCName = null;
        }
        return objCName;
    }

    private final ObjCName getObjCName(FirBasedSymbol<?> $this$getObjCName, FirSession session2) {
        ObjCName objCName;
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId($this$getObjCName, objCNameClassId, session2);
        if (firAnnotation != null) {
            FirAnnotation p0 = firAnnotation;
            boolean bl = false;
            objCName = new ObjCName(p0);
        } else {
            objCName = null;
        }
        return objCName;
    }

    /*
     * WARNING - void declaration
     */
    public final void checkCallableMember(@NotNull FirTypeScope firTypeScope, @NotNull FirCallableSymbol<?> memberSymbol, @NotNull FirDeclaration declarationToReport, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(firTypeScope, "firTypeScope");
        Intrinsics.checkNotNullParameter(memberSymbol, "memberSymbol");
        Intrinsics.checkNotNullParameter(declarationToReport, "declarationToReport");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        List<FirCallableSymbol<?>> overriddenSymbols2 = FirTypeScopeKt.retrieveDirectOverriddenOf(firTypeScope, memberSymbol);
        if (overriddenSymbols2.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = overriddenSymbols2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirCallableSymbol firCallableSymbol = (FirCallableSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.getObjCNames((FirBasedSymbol)INSTANCE.getFirstBaseSymbol((FirCallableSymbol<?>)it, context2), context2.getSession()));
        }
        List objCNames = (List)destination$iv$iv;
        if (!this.allNamesEquals(objCNames)) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = overriddenSymbols2;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirRegularClassSymbol it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
                boolean bl2 = false;
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(it);
                if ((coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, context2.getSession()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List containingDeclarations2 = (List)destination$iv$iv2;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declarationToReport.getSource(), FirNativeErrors.INSTANCE.getINCOMPATIBLE_OBJC_NAME_OVERRIDE(), declarationToReport.getSymbol(), (Object)containingDeclarations2, (DiagnosticContext)context2, null, 32, null);
        }
    }

    private final FirCallableSymbol<?> getFirstBaseSymbol(FirCallableSymbol<?> $this$getFirstBaseSymbol, CheckerContext context2) {
        FirSession session2 = context2.getSession();
        Object object = ClassMembersKt.containingClassLookupTag($this$getFirstBaseSymbol);
        if (object == null || (object = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, session2)) == null || (object = DeclarationUtilsKt.fullyExpandedClass(object, session2)) == null || (object = FirHelpersKt.unsubstitutedScope((FirClassSymbol)object, context2)) == null) {
            return $this$getFirstBaseSymbol;
        }
        Object ownScope = object;
        List<FirCallableSymbol<?>> overriddenMemberSymbols = FirTypeScopeKt.retrieveDirectOverriddenOf((FirTypeScope)ownScope, $this$getFirstBaseSymbol);
        return overriddenMemberSymbols.isEmpty() ? $this$getFirstBaseSymbol : this.getFirstBaseSymbol(CollectionsKt.first(overriddenMemberSymbols), context2);
    }

    private final boolean allNamesEquals(List<? extends List<ObjCName>> $this$allNamesEquals) {
        List<ObjCName> first = $this$allNamesEquals.get(0);
        int n = $this$allNamesEquals.size();
        for (int i = 1; i < n; ++i) {
            if (Intrinsics.areEqual(first, $this$allNamesEquals.get(i))) continue;
            return false;
        }
        return true;
    }

    static {
        Name name2 = Name.identifier("swiftName");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        swiftNameName = name2;
        Name name3 = Name.identifier("exact");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        exactName = name3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameUtilities$ObjCName;", "", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)V", "getAnnotation", "()Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "exact", "", "getExact", "()Z", "name", "", "getName", "()Ljava/lang/String;", "swiftName", "getSwiftName", "equals", "other", "hashCode", "", "checkers.native"})
    public static final class ObjCName {
        @NotNull
        private final FirAnnotation annotation;
        @Nullable
        private final String name;
        @Nullable
        private final String swiftName;
        private final boolean exact;

        public ObjCName(@NotNull FirAnnotation annotation2) {
            Intrinsics.checkNotNullParameter(annotation2, "annotation");
            this.annotation = annotation2;
            this.name = FirAnnotationUtilsKt.getStringArgument(this.annotation, StandardNames.NAME);
            this.swiftName = FirAnnotationUtilsKt.getStringArgument(this.annotation, swiftNameName);
            Boolean bl = FirAnnotationUtilsKt.getBooleanArgument(this.annotation, exactName);
            this.exact = bl != null ? bl : false;
        }

        @NotNull
        public final FirAnnotation getAnnotation() {
            return this.annotation;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getSwiftName() {
            return this.swiftName;
        }

        public final boolean getExact() {
            return this.exact;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ObjCName && Intrinsics.areEqual(this.name, ((ObjCName)other).name) && Intrinsics.areEqual(this.swiftName, ((ObjCName)other).swiftName) && this.exact == ((ObjCName)other).exact;
        }

        public int hashCode() {
            String string2 = this.name;
            int result2 = string2 != null ? string2.hashCode() : 0;
            String string3 = this.swiftName;
            result2 = 31 * result2 + (string3 != null ? string3.hashCode() : 0);
            result2 = 31 * result2 + Boolean.hashCode(this.exact);
            return result2;
        }
    }
}

