/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCNameUtilities;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameOverridesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
public final class FirNativeObjCNameOverridesChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirNativeObjCNameOverridesChecker INSTANCE = new FirNativeObjCNameOverridesChecker();

    private FirNativeObjCNameOverridesChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(declaration2, context2);
        FirContainingNamesAwareScopeKt.processAllFunctions(firTypeScope, (Function1<? super FirNamedFunctionSymbol, Unit>)new Function1<FirNamedFunctionSymbol, Unit>(firTypeScope, declaration2, context2, reporter){
            final /* synthetic */ FirTypeScope $firTypeScope;
            final /* synthetic */ FirClass $declaration;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.$firTypeScope = $firTypeScope;
                this.$declaration = $declaration;
                this.$context = $context;
                this.$reporter = $reporter;
                super(1);
            }

            public final void invoke(FirNamedFunctionSymbol symbol2) {
                Intrinsics.checkNotNullParameter(symbol2, "symbol");
                if (!ClassMembersKt.isIntersectionOverride(symbol2)) {
                    return;
                }
                FirNativeObjCNameUtilities.INSTANCE.checkCallableMember(this.$firTypeScope, symbol2, this.$declaration, this.$context, this.$reporter);
            }
        });
        FirContainingNamesAwareScopeKt.processAllProperties(firTypeScope, new Function1<FirVariableSymbol<?>, Unit>(firTypeScope, declaration2, context2, reporter){
            final /* synthetic */ FirTypeScope $firTypeScope;
            final /* synthetic */ FirClass $declaration;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.$firTypeScope = $firTypeScope;
                this.$declaration = $declaration;
                this.$context = $context;
                this.$reporter = $reporter;
                super(1);
            }

            public final void invoke(FirVariableSymbol<?> symbol2) {
                Intrinsics.checkNotNullParameter(symbol2, "symbol");
                if (!ClassMembersKt.isIntersectionOverride((FirCallableSymbol)symbol2)) {
                    return;
                }
                FirNativeObjCNameUtilities.INSTANCE.checkCallableMember(this.$firTypeScope, (FirCallableSymbol)symbol2, this.$declaration, this.$context, this.$reporter);
            }
        });
    }
}

