/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCNameUtilities;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameCallableChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
public final class FirNativeObjCNameCallableChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirNativeObjCNameCallableChecker INSTANCE = new FirNativeObjCNameCallableChecker();

    private FirNativeObjCNameCallableChecker() {
    }

    @Override
    public void check(@NotNull FirCallableDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirClass containingClass;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(declaration2 instanceof FirSimpleFunction) && !(declaration2 instanceof FirProperty)) {
            return;
        }
        FirDeclaration firDeclaration = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        FirClass firClass = containingClass = firDeclaration instanceof FirClass ? (FirClass)firDeclaration : null;
        if (containingClass != null) {
            FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(containingClass, context2);
            FirNativeObjCNameUtilities.INSTANCE.checkCallableMember(firTypeScope, declaration2.getSymbol(), declaration2, context2, reporter);
        }
    }
}

