/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.web.common.FirWebCommonErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.declaration.FirJsExternalChecker;
import org.jetbrains.kotlin.fir.analysis.web.common.checkers.declaration.FirWebCommonExternalChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyBackingField;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001c\u0010\u001b\u001a\u00020\u00042\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u001f\u001a\u00020\u000e*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!*\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalChecker;", "Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/declaration/FirWebCommonExternalChecker;", "()V", "allowsReporting", "", "Lorg/jetbrains/kotlin/KtSourceElement;", "getAllowsReporting", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "varargElementType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getVarargElementType", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "additionalCheck", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "hasExternalLikeAnnotations", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isDefinedExternallyCallableId", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "isNativeOrEffectivelyExternal", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "reportExternalEnum", "checkEnumEntry", "superInterfaces", "", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsExternalChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsExternalChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,152:1\n1601#2,9:153\n1853#2:162\n1854#2:164\n1610#2:165\n1745#2,3:166\n817#2:170\n845#2,2:171\n764#2:173\n855#2,2:174\n1#3:163\n43#4:169\n*S KotlinDebug\n*F\n+ 1 FirJsExternalChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalChecker\n*L\n52#1:153,9\n52#1:162\n52#1:164\n52#1:165\n53#1:166,3\n140#1:170\n140#1:171,2\n141#1:173\n141#1:174,2\n52#1:163\n58#1:169\n*E\n"})
public final class FirJsExternalChecker
extends FirWebCommonExternalChecker {
    @NotNull
    public static final FirJsExternalChecker INSTANCE = new FirJsExternalChecker();

    private FirJsExternalChecker() {
    }

    @Override
    public boolean isNativeOrEffectivelyExternal(@NotNull FirBasedSymbol<?> symbol2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Intrinsics.checkNotNullParameter(session2, "session");
        return FirJsHelpersKt.isNativeObject(symbol2, session2);
    }

    @Override
    public void reportExternalEnum(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getENUM_CLASS_IN_EXTERNAL_DECLARATION_WARNING(), (DiagnosticContext)context2, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void additionalCheck(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (declaration2 instanceof FirClass && ((FirClass)declaration2).getClassKind() != ClassKind.ANNOTATION_CLASS) {
            boolean bl;
            block11: {
                void $this$mapNotNullTo$iv$iv;
                List superClasses2 = CollectionsKt.toMutableList((Collection)this.superInterfaces((FirClass)declaration2, context2.getSession()));
                ConeClassLikeType coneClassLikeType = FirJsHelpersKt.superClassNotAny((FirClass)declaration2, context2.getSession());
                if (coneClassLikeType != null) {
                    ConeClassLikeType it = coneClassLikeType;
                    boolean bl2 = false;
                    superClasses2.add(it);
                }
                if (((FirClass)declaration2).getClassKind() == ClassKind.ENUM_CLASS || ((FirClass)declaration2).getClassKind() == ClassKind.ENUM_ENTRY) {
                    CollectionsKt.removeAll(superClasses2, (Function1)additionalCheck.2.INSTANCE);
                }
                Iterable $this$mapNotNull$iv = superClasses2;
                boolean $i$f$mapNotNull = false;
                Iterable bl2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FirClassLikeSymbol<?> it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    ConeClassLikeType it = (ConeClassLikeType)element$iv$iv;
                    boolean bl4 = false;
                    if (TypeUtilsKt.toSymbol(it, context2.getSession()) == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List superDeclarations = (List)destination$iv$iv;
                Iterable $this$any$iv = superDeclarations;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirClassLikeSymbol it = (FirClassLikeSymbol)element$iv;
                        boolean bl6 = false;
                        if (!(!FirJsHelpersKt.isNativeObject((FirBasedSymbol)it, context2) && !Intrinsics.areEqual(it.getClassId().asSingleFqName(), StandardNames.FqNames.throwable))) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_TYPE_EXTENDS_NON_EXTERNAL_TYPE(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        if (declaration2 instanceof FirFunction) {
            FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)declaration2;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getStatus().isInline()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirWebCommonErrors.INSTANCE.getINLINE_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        KtDiagnosticFactory0 valueClassInExternalDiagnostic = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowValueClassesInExternals) ? FirJsErrors.INSTANCE.getINLINE_CLASS_IN_EXTERNAL_DECLARATION_WARNING() : FirJsErrors.INSTANCE.getINLINE_CLASS_IN_EXTERNAL_DECLARATION();
        FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf(declaration2, reporter, context2, valueClassInExternalDiagnostic, (Function1<? super ConeKotlinType, Boolean>)new Function1<ConeKotlinType, Boolean>(context2){
            final /* synthetic */ CheckerContext $context;
            {
                this.$context = $context;
                super(1);
            }

            public final Boolean invoke(ConeKotlinType it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return FirHelpersKt.isValueClass(it, this.$context.getSession());
            }
        });
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsEnableExtensionFunctionInExternals)) {
            FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf(declaration2, reporter, context2, FirJsErrors.INSTANCE.getEXTENSION_FUNCTION_IN_EXTERNAL_DECLARATION(), additionalCheck.5.INSTANCE);
        }
        this.checkEnumEntry(declaration2, context2, reporter);
    }

    @Override
    public boolean isDefinedExternallyCallableId(@NotNull CallableId callableId) {
        Intrinsics.checkNotNullParameter(callableId, "callableId");
        return JsStandardClassIds.Callables.definedExternallyPropertyNames.contains(callableId);
    }

    @Override
    public boolean hasExternalLikeAnnotations(@NotNull FirDeclaration declaration2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(session2, "session");
        return FirAnnotationUtilsKt.hasAnnotation(declaration2, JsStandardClassIds.Annotations.JsNative, session2);
    }

    private final boolean getAllowsReporting(KtSourceElement $this$allowsReporting) {
        return !($this$allowsReporting.getKind() instanceof KtFakeSourceElementKind) || Intrinsics.areEqual($this$allowsReporting.getKind(), KtFakeSourceElementKind.PropertyFromParameter.INSTANCE);
    }

    private final ConeKotlinType getVarargElementType(FirValueParameter $this$varargElementType) {
        ConeKotlinType coneKotlinType;
        if (!$this$varargElementType.isVararg()) {
            coneKotlinType = null;
        } else {
            ConeTypeProjection coneTypeProjection = ArraysKt.firstOrNull(FirTypeUtilsKt.getConeType($this$varargElementType.getReturnTypeRef()).getTypeArguments());
            coneKotlinType = coneTypeProjection != null ? ConeTypeProjectionKt.getType(coneTypeProjection) : null;
        }
        return coneKotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ConeClassLikeType> superInterfaces(FirClass $this$superInterfaces, FirSession session2) {
        void $this$filterTo$iv$iv;
        ConeClassLikeType it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = FirDeclarationUtilKt.getSuperConeTypes($this$superInterfaces);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ConeClassLikeType)element$iv$iv;
            boolean bl = false;
            if (ConeBuiltinTypeUtilsKt.isAny(it) || ConeBuiltinTypeUtilsKt.isNullableAny(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ConeClassLikeType)element$iv$iv;
            boolean bl = false;
            FirClassLikeSymbol<?> firClassLikeSymbol = TypeUtilsKt.toSymbol(it, session2);
            if (!((firClassLikeSymbol != null ? FirHelpersKt.getClassKind(firClassLikeSymbol) : null) == ClassKind.INTERFACE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void checkEnumEntry(FirDeclaration $this$checkEnumEntry, CheckerContext context2, DiagnosticReporter reporter) {
        block1: {
            if (!($this$checkEnumEntry instanceof FirEnumEntry)) {
                return;
            }
            FirExpression firExpression2 = ((FirEnumEntry)$this$checkEnumEntry).getInitializer();
            if (firExpression2 == null) break block1;
            FirExpression it = firExpression2;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_ENUM_ENTRY_WITH_BODY(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private static final void additionalCheck$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(Function1<? super ConeKotlinType, Boolean> $condition, DiagnosticReporter $reporter, KtDiagnosticFactory0 $diagnosticFactory, CheckerContext $context, ConeKotlinType type2, KtSourceElement elementToReport) {
        if ($condition.invoke(type2).booleanValue()) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)elementToReport, $diagnosticFactory, (DiagnosticContext)$context, null, 8, null);
        }
    }

    private static final void additionalCheck$reportOnParametersAndReturnTypesIf(FirDeclaration $declaration, DiagnosticReporter $reporter, CheckerContext $context, KtDiagnosticFactory0 diagnosticFactory, Function1<? super ConeKotlinType, Boolean> condition) {
        if (!($declaration instanceof FirCallableDeclaration) || $declaration instanceof FirDefaultPropertyAccessor || $declaration instanceof FirDefaultPropertyBackingField) {
            return;
        }
        KtSourceElement ktSourceElement = ((FirCallableDeclaration)$declaration).getReturnTypeRef().getSource();
        boolean bl = ktSourceElement != null ? INSTANCE.getAllowsReporting(ktSourceElement) : false;
        if (bl) {
            KtSourceElement ktSourceElement2 = ((FirCallableDeclaration)$declaration).getReturnTypeRef().getSource();
            if (ktSourceElement2 != null) {
                KtSourceElement it = ktSourceElement2;
                boolean bl2 = false;
                FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, $reporter, diagnosticFactory, $context, FirTypeUtilsKt.getConeType(((FirCallableDeclaration)$declaration).getReturnTypeRef()), it);
            }
        }
        if (!($declaration instanceof FirFunction)) {
            return;
        }
        for (FirValueParameter parameter2 : ((FirFunction)$declaration).getValueParameters()) {
            KtSourceElement ktParam;
            KtSourceElement ktSourceElement3 = ktParam = parameter2.getSource();
            boolean bl3 = ktSourceElement3 != null ? INSTANCE.getAllowsReporting(ktSourceElement3) : false;
            if (!bl3) continue;
            ConeKotlinType coneKotlinType = INSTANCE.getVarargElementType(parameter2);
            if (coneKotlinType == null) {
                coneKotlinType = FirTypeUtilsKt.getConeType(parameter2.getReturnTypeRef());
            }
            ConeKotlinType typeToCheck = coneKotlinType;
            FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, $reporter, diagnosticFactory, $context, typeToCheck, ktParam);
        }
    }
}

