/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirExpressionSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirCommaInWhenConditionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExpressionSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lcom/intellij/psi/PsiElement;", "()V", "checkCommaInBranchCondition", "", "branch", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenBranch;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkPsiOrLightTree", "element", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "isApplicable", "", "checkers"})
public final class FirCommaInWhenConditionChecker
extends FirExpressionSyntaxChecker<FirWhenExpression, PsiElement> {
    @NotNull
    public static final FirCommaInWhenConditionChecker INSTANCE = new FirCommaInWhenConditionChecker();

    private FirCommaInWhenConditionChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirWhenExpression element2, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter(element2, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        return element2.getSubject() == null;
    }

    @Override
    public void checkPsiOrLightTree(@NotNull FirWhenExpression element2, @NotNull KtSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(element2, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        for (FirWhenBranch branch : element2.getBranches()) {
            if (branch.getCondition() instanceof FirElseIfTrueCondition) continue;
            this.checkCommaInBranchCondition(branch, context2, reporter);
        }
    }

    private final void checkCommaInBranchCondition(FirWhenBranch branch, CheckerContext context2, DiagnosticReporter reporter) {
        KtSourceElement source;
        KtSourceElement ktSourceElement = source = branch.getSource();
        if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getElementType() : null, KtNodeTypes.WHEN_ENTRY)) {
            KtSourceElement ktSourceElement2;
            KtSourceElement ktSourceElement3 = source;
            if (ktSourceElement3 != null) {
                KtSingleValueToken ktSingleValueToken = KtTokens.COMMA;
                Intrinsics.checkNotNullExpressionValue(ktSingleValueToken, "COMMA");
                ktSourceElement2 = FirSourceUtilsKt.getChild$default(ktSourceElement3, ktSingleValueToken, 0, 1, false, 10, null);
            } else {
                ktSourceElement2 = null;
            }
            if (ktSourceElement2 != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMMA_IN_WHEN_CONDITION_WITHOUT_ARGUMENT(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }
}

