/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReifiedTypeParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "areAccessorsInline", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReifiedTypeParameterChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReifiedTypeParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReifiedTypeParameterChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,36:1\n43#2:37\n43#2:38\n43#2:39\n*S KotlinDebug\n*F\n+ 1 FirReifiedTypeParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReifiedTypeParameterChecker\n*L\n21#1:37\n30#1:38\n31#1:39\n*E\n"})
public final class FirReifiedTypeParameterChecker
extends FirDeclarationChecker<FirTypeParameter> {
    @NotNull
    public static final FirReifiedTypeParameterChecker INSTANCE = new FirReifiedTypeParameterChecker();

    private FirReifiedTypeParameterChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirTypeParameter declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block5: {
            FirDeclaration containingDeclaration2;
            block6: {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                if (!declaration2.isReified()) {
                    return;
                }
                FirDeclaration firDeclaration = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
                if (firDeclaration == null) {
                    return;
                }
                containingDeclaration2 = firDeclaration;
                if (containingDeclaration2 instanceof FirRegularClass) break block5;
                if (!(containingDeclaration2 instanceof FirSimpleFunction)) break block6;
                FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)containingDeclaration2;
                boolean $i$f$isInline = false;
                if (!$this$isInline$iv.getStatus().isInline()) break block5;
            }
            if (!(containingDeclaration2 instanceof FirProperty)) return;
            if (this.areAccessorsInline((FirProperty)containingDeclaration2)) return;
        }
        boolean bl = true;
        boolean forbidReified = bl;
        if (!forbidReified) return;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getREIFIED_TYPE_PARAMETER_NO_INLINE(), (DiagnosticContext)context2, null, 8, null);
    }

    private final boolean areAccessorsInline(FirProperty $this$areAccessorsInline) {
        boolean bl;
        boolean $i$f$isInline;
        FirMemberDeclaration $this$isInline$iv;
        FirPropertyAccessor firPropertyAccessor = $this$areAccessorsInline.getGetter();
        if (firPropertyAccessor != null) {
            $this$isInline$iv = firPropertyAccessor;
            $i$f$isInline = false;
            bl = $this$isInline$iv.getStatus().isInline();
        } else {
            bl = false;
        }
        if (!bl) {
            return false;
        }
        if ($this$areAccessorsInline.isVar()) {
            boolean bl2;
            FirPropertyAccessor firPropertyAccessor2 = $this$areAccessorsInline.getSetter();
            if (firPropertyAccessor2 != null) {
                $this$isInline$iv = firPropertyAccessor2;
                $i$f$isInline = false;
                bl2 = $this$isInline$iv.getStatus().isInline();
            } else {
                bl2 = false;
            }
            if (!bl2) {
                return false;
            }
        }
        return true;
    }
}

