/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.FirOverridesBackwardCompatibilityHelperKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirAbstractOverrideChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeprecationsPerUseSite;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverrideFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverridePropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.types.TypeCheckerState;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J<\u0010\u000b\u001a\u00020\u00042\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u0015H\u0002J6\u0010\u0016\u001a\u00020\u00042\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\r2\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J:\u0010\u0019\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u00152\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u001a\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J2\u0010\u001c\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r*\u00020\u001e2\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u0015H\u0002J:\u0010\u001f\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010 \u001a\u00020\u0004*\u00020\n2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010#\u001a\u00020\u0004*\u00020\n2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010$\u001a\u00020\u0004*\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010%\u001a\u00020\u0004*\u00020\n2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010&\u001a\u00020\u0004*\u00020\n2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010'\u001a\u00020\u0004*\u00020\n2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010(\u001a\u00020\u0004*\u00020\n2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010)\u001a\u00020\u0004*\u00020\n2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAbstractOverrideChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkMember", "member", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "containingClass", "typeCheckerState", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "firTypeScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "checkModality", "overriddenSymbols", "", "checkOverriddenExperimentalities", "memberSymbol", "overriddenMemberSymbols", "checkDataClassCopy", "checkDefaultValues", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "checkDeprecation", "checkMutability", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "checkVisibility", "reportCannotChangeAccessPrivilege", "overriding", "overridden", "reportCannotWeakenAccessPrivilege", "reportNothingToOverride", "reportOverridingFinalMember", "reportReturnTypeMismatchOnFunction", "reportTypeMismatchOnProperty", "reportTypeMismatchOnVariable", "reportVarOverriddenByVal", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOverrideChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 6 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,457:1\n13#2:458\n18#2:463\n18#2:483\n25#2:487\n16#2:488\n18#2:515\n18#2:516\n1#3:459\n1#3:480\n1547#4:460\n1618#4,2:461\n1620#4:464\n1043#4:465\n1547#4:466\n1618#4,3:467\n1601#4,9:470\n1853#4:479\n1854#4:481\n1610#4:482\n1745#4,3:484\n288#4:489\n289#4:499\n1358#4:509\n1444#4,5:510\n113#5:490\n106#5,3:491\n97#5:494\n85#5:495\n91#5:497\n110#5:498\n113#5:500\n106#5,3:501\n97#5:504\n85#5:505\n91#5:507\n110#5:508\n39#6:496\n39#6:506\n*S KotlinDebug\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker\n*L\n127#1:458\n149#1:463\n170#1:483\n257#1:487\n267#1:488\n410#1:515\n426#1:516\n165#1:480\n148#1:460\n148#1:461,2\n148#1:464\n150#1:465\n159#1:466\n159#1:467,3\n165#1:470,9\n165#1:479\n165#1:481\n165#1:482\n185#1:484,3\n289#1:489\n289#1:499\n363#1:509\n363#1:510,5\n292#1:490\n292#1:491,3\n292#1:494\n292#1:495\n292#1:497\n292#1:498\n299#1:500\n299#1:501,3\n299#1:504\n299#1:505\n299#1:507\n299#1:508\n292#1:496\n299#1:506\n*E\n"})
public final class FirOverrideChecker
extends FirAbstractOverrideChecker {
    @NotNull
    public static final FirOverrideChecker INSTANCE = new FirOverrideChecker();

    private FirOverrideChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        TypeCheckerState typeCheckerState2 = TypeComponentsKt.getTypeContext(context2.getSession()).newTypeCheckerState(false, false);
        FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(declaration2, context2);
        for (FirDeclaration it : declaration2.getDeclarations()) {
            if (!(it instanceof FirSimpleFunction) && !(it instanceof FirProperty)) continue;
            FirCallableDeclaration callable = (FirCallableDeclaration)it;
            this.checkMember(callable.getSymbol(), declaration2, reporter, typeCheckerState2, firTypeScope, context2);
        }
    }

    private final FirCallableSymbol<?> checkModality(List<? extends FirCallableSymbol<?>> overriddenSymbols2) {
        Iterator<FirCallableSymbol<?>> iterator2 = overriddenSymbols2.iterator();
        while (iterator2.hasNext()) {
            FirCallableSymbol<?> overridden;
            FirCallableSymbol<?> $this$modality$iv = overridden = iterator2.next();
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() != Modality.FINAL) continue;
            return overridden;
        }
        return null;
    }

    private final FirCallableSymbol<?> checkMutability(FirPropertySymbol $this$checkMutability, List<? extends FirCallableSymbol<?>> overriddenSymbols2) {
        Object v2;
        block2: {
            if ($this$checkMutability.isVar()) {
                return null;
            }
            Iterable iterable = overriddenSymbols2;
            for (Object t : iterable) {
                FirCallableSymbol it = (FirCallableSymbol)t;
                boolean bl = false;
                FirPropertySymbol firPropertySymbol = it instanceof FirPropertySymbol ? (FirPropertySymbol)it : null;
                boolean bl2 = firPropertySymbol != null ? firPropertySymbol.isVar() : false;
                if (!bl2) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVisibility(FirCallableSymbol<?> $this$checkVisibility, FirClass containingClass, DiagnosticReporter reporter, List<? extends FirCallableSymbol<?>> overriddenSymbols2, CheckerContext context2) {
        boolean hasVisibleBase;
        block13: {
            boolean bl;
            block15: {
                List<Pair> visibilities;
                block14: {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Collection<FirCallableSymbol> collection;
                    void $this$mapTo$iv$iv;
                    FirCallableSymbol firCallableSymbol;
                    FirClass firClass;
                    DiagnosticReporter diagnosticReporter;
                    Iterator<Pair> $this$sortedBy$iv;
                    Object object;
                    void $this$mapTo$iv$iv2;
                    if (overriddenSymbols2.isEmpty()) {
                        return;
                    }
                    Iterable $this$map$iv = overriddenSymbols2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        FirCallableSymbol firCallableSymbol2 = (FirCallableSymbol)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl2 = false;
                        void $this$visibility$iv = it;
                        boolean $i$f$getVisibility = false;
                        object.add(TuplesKt.to(it, $this$visibility$iv.getResolvedStatus().getVisibility()));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$sortedBy22 = false;
                    visibilities = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator($this$checkVisibility){
                        final /* synthetic */ FirCallableSymbol $this_checkVisibility$inlined;
                        {
                            this.$this_checkVisibility$inlined = firCallableSymbol;
                        }

                        public final int compare(T a, T b) {
                            Pair pair = (Pair)a;
                            boolean bl = false;
                            FirCallableSymbol $this$visibility$iv = this.$this_checkVisibility$inlined;
                            boolean $i$f$getVisibility = false;
                            Integer n = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), (Visibility)pair.getSecond());
                            pair = (Pair)b;
                            Comparable comparable = Integer.valueOf(n != null ? n : Integer.MIN_VALUE);
                            bl = false;
                            $this$visibility$iv = this.$this_checkVisibility$inlined;
                            $i$f$getVisibility = false;
                            Integer n2 = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), (Visibility)pair.getSecond());
                            return ComparisonsKt.compareValues(comparable, n2 != null ? n2 : Integer.MIN_VALUE);
                        }
                    });
                    if (!($this$checkVisibility instanceof FirPropertySymbol)) break block14;
                    FirPropertyAccessorSymbol firPropertyAccessorSymbol = ((FirPropertySymbol)$this$checkVisibility).getGetterSymbol();
                    if (firPropertyAccessorSymbol != null) {
                        void $this$map$iv2;
                        Iterable $i$f$sortedBy22 = overriddenSymbols2;
                        diagnosticReporter = reporter;
                        firClass = containingClass;
                        firCallableSymbol = firPropertyAccessorSymbol;
                        object = this;
                        boolean $i$f$map2 = false;
                        destination$iv$iv = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            FirCallableSymbol bl2 = (FirCallableSymbol)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
                            FirPropertyAccessorSymbol firPropertyAccessorSymbol2 = ((FirPropertySymbol)it).getGetterSymbol();
                            collection.add((FirCallableSymbol)(firPropertyAccessorSymbol2 != null ? (FirCallableSymbol)firPropertyAccessorSymbol2 : it));
                        }
                        collection = (List)destination$iv$iv2;
                        super.checkVisibility(firCallableSymbol, firClass, diagnosticReporter, (List<? extends FirCallableSymbol<?>>)collection, context2);
                    }
                    FirPropertyAccessorSymbol firPropertyAccessorSymbol3 = ((FirPropertySymbol)$this$checkVisibility).getSetterSymbol();
                    if (firPropertyAccessorSymbol3 == null) break block15;
                    Iterable $this$map$iv2 = overriddenSymbols2;
                    diagnosticReporter = reporter;
                    firClass = containingClass;
                    firCallableSymbol = firPropertyAccessorSymbol3;
                    object = this;
                    boolean $i$f$mapNotNull = false;
                    $this$mapTo$iv$iv = $this$mapNotNull$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator it = $this$forEach$iv$iv$iv.iterator();
                    while (it.hasNext()) {
                        FirPropertyAccessorSymbol it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = it.next();
                        boolean bl4 = false;
                        FirCallableSymbol it2 = (FirCallableSymbol)element$iv$iv;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull(it2, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
                        if (((FirPropertySymbol)it2).getSetterSymbol() == null) continue;
                        boolean bl6 = false;
                        destination$iv$iv3.add(it$iv$iv);
                    }
                    collection = (List)destination$iv$iv3;
                    super.checkVisibility(firCallableSymbol, firClass, diagnosticReporter, (List<? extends FirCallableSymbol<?>>)collection, context2);
                    break block15;
                }
                for (Pair $this$mapNotNull$iv : visibilities) {
                    FirCallableSymbol overridden = (FirCallableSymbol)$this$mapNotNull$iv.component1();
                    Visibility overriddenVisibility = (Visibility)$this$mapNotNull$iv.component2();
                    FirCallableSymbol<?> $this$visibility$iv = $this$checkVisibility;
                    boolean $i$f$getVisibility = false;
                    Integer compare = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), overriddenVisibility);
                    if (compare == null) {
                        this.reportCannotChangeAccessPrivilege(reporter, $this$checkVisibility, overridden, context2);
                        break;
                    }
                    if (compare >= 0) continue;
                    this.reportCannotWeakenAccessPrivilege(reporter, $this$checkVisibility, overridden, context2);
                    break;
                }
            }
            if ($this$checkVisibility instanceof FirPropertyAccessorSymbol) {
                return;
            }
            FirFile firFile = context2.getContainingFile();
            if (firFile == null) {
                return;
            }
            FirFile file2 = firFile;
            List<FirClass> containingDeclarations2 = CollectionsKt.plus((Collection)context2.getContainingDeclarations(), containingClass);
            FirVisibilityChecker visibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession());
            Iterable $this$any$iv = overriddenSymbols2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirCallableSymbol it = (FirCallableSymbol)element$iv;
                    boolean bl7 = false;
                    FirLazyDeclarationResolverKt.lazyResolveToPhase(it, FirResolvePhase.STATUS);
                    FirCallableDeclaration fir = (FirCallableDeclaration)it.getFir();
                    if (!FirVisibilityChecker.isVisible$default(visibilityChecker, fir, context2.getSession(), file2, containingDeclarations2, null, false, null, true, null, 352, null)) continue;
                    bl = true;
                    break block13;
                }
                bl = hasVisibleBase = false;
            }
        }
        if (!hasVisibleBase) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkVisibility.getSource(), FirErrors.INSTANCE.getCANNOT_OVERRIDE_INVISIBLE_MEMBER(), $this$checkVisibility, CollectionsKt.first(overriddenSymbols2), (DiagnosticContext)context2, null, 32, null);
        }
    }

    private final void checkDeprecation(FirCallableSymbol<?> $this$checkDeprecation, DiagnosticReporter reporter, List<? extends FirCallableSymbol<?>> overriddenSymbols2, CheckerContext context2) {
        DeprecationsPerUseSite ownDeprecation = $this$checkDeprecation.getDeprecation(FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()));
        if (ownDeprecation == null || ownDeprecation.isNotEmpty()) {
            return;
        }
        for (FirCallableSymbol<?> overriddenSymbol : overriddenSymbols2) {
            Object object;
            DeprecationsPerUseSite deprecationInfoFromOverridden;
            DeprecationInfo deprecationInfo;
            if (overriddenSymbol.getDeprecation(FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession())) == null || (deprecationInfo = deprecationInfoFromOverridden.getAll()) == null && ((object = deprecationInfoFromOverridden.getBySpecificSite()) != null && (object = object.values()) != null ? (DeprecationInfo)CollectionsKt.firstOrNull((Iterable)object) : (deprecationInfo = null)) == null) continue;
            DeprecationInfo deprecationFromOverriddenSymbol = deprecationInfo;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkDeprecation.getSource(), FirErrors.INSTANCE.getOVERRIDE_DEPRECATION(), overriddenSymbol, (Object)deprecationFromOverriddenSymbol, (DiagnosticContext)context2, null, 32, null);
            return;
        }
    }

    private final void checkDefaultValues(FirFunctionSymbol<?> $this$checkDefaultValues, DiagnosticReporter reporter, CheckerContext context2) {
        for (FirValueParameterSymbol valueParameterSymbol : $this$checkDefaultValues.getValueParameterSymbols()) {
            if (!valueParameterSymbol.getHasDefaultValue()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)valueParameterSymbol.getDefaultValueSource(), FirErrors.INSTANCE.getDEFAULT_VALUE_NOT_ALLOWED_IN_OVERRIDE(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkDataClassCopy(FirCallableSymbol<?> $this$checkDataClassCopy, DiagnosticReporter reporter, List<? extends FirCallableSymbol<?>> overriddenMemberSymbols, FirClass containingClass, CheckerContext context2) {
        FirCallableSymbol<?> firCallableSymbol = CollectionsKt.firstOrNull(overriddenMemberSymbols);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol<?> overridden = firCallableSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)overridden, context2.getSession());
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if (firClassSymbol == null) {
            return;
        }
        FirClassSymbol overriddenClass = firClassSymbol;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)containingClass.getSource(), FirErrors.INSTANCE.getDATA_CLASS_OVERRIDE_DEFAULT_VALUES(), $this$checkDataClassCopy, (Object)overriddenClass, (DiagnosticContext)context2, null, 32, null);
    }

    /*
     * Unable to fully structure code
     */
    private final void checkMember(FirCallableSymbol<?> member, FirClass containingClass, DiagnosticReporter reporter, TypeCheckerState typeCheckerState, FirTypeScope firTypeScope, CheckerContext context) {
        block37: {
            block39: {
                block38: {
                    block36: {
                        overriddenMemberSymbols = FirTypeScopeKt.retrieveDirectOverriddenOf(firTypeScope, member);
                        v0 = member;
                        v1 = KtTokens.OVERRIDE_KEYWORD;
                        Intrinsics.checkNotNullExpressionValue(v1, "OVERRIDE_KEYWORD");
                        hasOverrideKeyword = FirKeywordUtilsKt.hasModifier(v0, v1);
                        $this$isOverride$iv = member;
                        $i$f$isOverride = false;
                        if ($this$isOverride$iv.getRawStatus().isOverride() && hasOverrideKeyword) break block37;
                        if (overriddenMemberSymbols.isEmpty() || FirOverridesBackwardCompatibilityHelperKt.getOverridesBackwardCompatibilityHelper(context.getSession()).overrideCanBeOmitted(overriddenMemberSymbols, context)) {
                            return;
                        }
                        v2 = member.getSource();
                        v3 = kind = v2 != null ? v2.getKind() : null;
                        if (kind instanceof KtFakeSourceElementKind.DataClassGeneratedMembers) {
                            block35: {
                                var12_13 = overriddenMemberSymbols;
                                for (T var14_19 : var12_13) {
                                    it = (FirCallableSymbol)var14_19;
                                    $i$a$-find-FirOverrideChecker$checkMember$1 = false;
                                    $this$isFinal$iv = it;
                                    $i$f$isFinal = false;
                                    v4 = $this$isFinal$iv.getResolvedStatus().getModality() == Modality.FINAL;
                                    if (!v4) continue;
                                    v5 = var14_19;
                                    break block35;
                                }
                                v5 = null;
                            }
                            v6 = v5;
                            if (v6 != null) {
                                base = v6;
                                $i$a$-let-FirOverrideChecker$checkMember$2 = false;
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)containingClass.getSource(), FirErrors.INSTANCE.getDATA_CLASS_OVERRIDE_CONFLICT(), member, (Object)base, (DiagnosticContext)context, null, 32, null);
                            }
                            if (Intrinsics.areEqual(member.getName(), StandardNames.DATA_CLASS_COPY)) {
                                this.checkDataClassCopy(member, reporter, overriddenMemberSymbols, containingClass, context);
                            }
                            return;
                        }
                        if (!(kind instanceof KtRealSourceElementKind) && !(kind instanceof KtFakeSourceElementKind.PropertyFromParameter)) {
                            return;
                        }
                        visibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker(context.getSession());
                        v7 = context.getContainingFile();
                        if (v7 == null) {
                            return;
                        }
                        file = v7;
                        containingDeclarations = CollectionsKt.plus((Collection)context.getContainingDeclarations(), containingClass);
                        $this$firstOrNull$iv = overriddenMemberSymbols;
                        $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            it = (FirCallableSymbol)element$iv;
                            $i$a$-firstOrNull-FirOverrideChecker$checkMember$overridden$1 = false;
                            FirLazyDeclarationResolverKt.lazyResolveToPhase(it, FirResolvePhase.STATUS);
                            var21_37 = it;
                            var22_38 = visibilityChecker;
                            $i$f$originalOrSelf = false;
                            $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
                            $i$f$originalOrSelf = false;
                            result$iv$iv = $this$originalOrSelf$iv$iv;
                            while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                                $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                                $i$f$originalIfFakeOverride = false;
                                $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                                $i$f$getOriginalForSubstitutionOverride = false;
                                if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
                                $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
                                $i$f$isSynthetic = false;
                                if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                                // 2 sources

                                {
                                    v8 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
                                } else {
                                    v8 = v9 = null;
                                }
                                if (v8 == null) {
                                    $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                                    $i$f$getBaseForIntersectionOverride = false;
                                    v9 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                                }
                                if (v9 == null) break;
                                result$iv$iv = v9;
                            }
                            v10 = result$iv$iv.getSymbol();
                            if (v10 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
                            }
                            if (!FirVisibilityChecker.isVisible$default(var22_38, (FirMemberDeclaration)v10.getFir(), context.getSession(), file, containingDeclarations, null, false, null, true, null, 352, null)) continue;
                            v11 = element$iv;
                            break block36;
                        }
                        v11 = null;
                    }
                    var14_20 = v11;
                    if (var14_20 == null) break block38;
                    $i$f$firstOrNull = var14_20;
                    $i$f$originalOrSelf = false;
                    $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
                    $i$f$originalOrSelf = false;
                    result$iv$iv = $this$originalOrSelf$iv$iv;
                    while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                        $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                        $i$f$originalIfFakeOverride = false;
                        $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                        $i$f$getOriginalForSubstitutionOverride = false;
                        if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
                        $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
                        $i$f$isSynthetic = false;
                        if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                        // 2 sources

                        {
                            v12 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
                        } else {
                            v12 = v13 = null;
                        }
                        if (v12 == null) {
                            $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                            $i$f$getBaseForIntersectionOverride = false;
                            v13 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                        }
                        if (v13 == null) break;
                        result$iv$iv = v13;
                    }
                    v14 = result$iv$iv.getSymbol();
                    if (v14 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
                    }
                    var15_22 = v14;
                    if (var15_22 != null) break block39;
                }
                return;
            }
            overridden = var15_22;
            v15 = ClassMembersKt.containingClassLookupTag(overridden);
            var16_25 = v15 != null ? LookupTagUtilsKt.toSymbol(v15, context.getSession()) : null;
            v16 = var16_25 instanceof FirRegularClassSymbol != false ? (FirRegularClassSymbol)var16_25 : null;
            if (v16 == null) {
                return;
            }
            originalContainingClassSymbol = v16;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)member.getSource(), FirErrors.INSTANCE.getVIRTUAL_MEMBER_HIDDEN(), member, (Object)originalContainingClassSymbol, (DiagnosticContext)context, null, 32, null);
            return;
        }
        if (overriddenMemberSymbols.isEmpty()) {
            this.reportNothingToOverride(reporter, member, context);
            return;
        }
        this.checkOverriddenExperimentalities(member, overriddenMemberSymbols, context, reporter);
        v17 = this.checkModality(overriddenMemberSymbols);
        if (v17 != null) {
            it = v17;
            $i$a$-let-FirOverrideChecker$checkMember$3 = false;
            FirOverrideChecker.INSTANCE.reportOverridingFinalMember(reporter, member, it, context);
        }
        if (member instanceof FirPropertySymbol) {
            v18 = this.checkMutability((FirPropertySymbol)member, overriddenMemberSymbols);
            if (v18 != null) {
                it = v18;
                $i$a$-let-FirOverrideChecker$checkMember$4 = false;
                FirOverrideChecker.INSTANCE.reportVarOverriddenByVal(reporter, member, it, context);
            }
        }
        this.checkVisibility(member, containingClass, reporter, overriddenMemberSymbols, context);
        this.checkDeprecation(member, reporter, overriddenMemberSymbols, context);
        if (member instanceof FirFunctionSymbol) {
            this.checkDefaultValues((FirFunctionSymbol)member, reporter, context);
        }
        v19 = this.checkReturnType(member, overriddenMemberSymbols, typeCheckerState, context);
        if (v19 == null) {
            return;
        }
        restriction = v19;
        var10_12 = member;
        if (var10_12 instanceof FirNamedFunctionSymbol) {
            this.reportReturnTypeMismatchOnFunction(reporter, member, restriction, context);
        } else if (var10_12 instanceof FirPropertySymbol) {
            if (((FirPropertySymbol)member).isVar()) {
                this.reportTypeMismatchOnVariable(reporter, member, restriction, context);
            } else {
                this.reportTypeMismatchOnProperty(reporter, member, restriction, context);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOverriddenExperimentalities(FirCallableSymbol<?> memberSymbol, List<? extends FirCallableSymbol<?>> overriddenMemberSymbols, CheckerContext context2, DiagnosticReporter reporter) {
        void $this$flatMapTo$iv$iv;
        FirOptInUsageBaseChecker $this$checkOverriddenExperimentalities_u24lambda_u2412 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        Set overriddenExperimentalities = new LinkedHashSet();
        FirSession session2 = context2.getSession();
        Iterable $this$flatMap$iv = overriddenMemberSymbols;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            boolean bl2 = false;
            FirCallableSymbol firCallableSymbol = it;
            Iterable list$iv$iv = firCallableSymbol instanceof FirIntersectionOverridePropertySymbol ? ((FirIntersectionOverridePropertySymbol)it).getIntersections() : (firCallableSymbol instanceof FirIntersectionOverrideFunctionSymbol ? ((FirIntersectionOverrideFunctionSymbol)it).getIntersections() : (Collection<FirCallableSymbol<Object>>)CollectionsKt.listOf(it));
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List overriddenSymbolsWithUnwrappedIntersectionOverrides = (List)destination$iv$iv;
        for (FirCallableSymbol overriddenMemberSymbol : overriddenSymbolsWithUnwrappedIntersectionOverrides) {
            $this$checkOverriddenExperimentalities_u24lambda_u2412.loadExperimentalitiesFromAnnotationTo(overriddenMemberSymbol, session2, overriddenExperimentalities);
        }
        $this$checkOverriddenExperimentalities_u24lambda_u2412.reportNotAcceptedOverrideExperimentalities(overriddenExperimentalities, memberSymbol, context2, reporter);
    }

    private final void reportNothingToOverride(DiagnosticReporter $this$reportNothingToOverride, FirCallableSymbol<?> declaration2, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportNothingToOverride, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getNOTHING_TO_OVERRIDE(), declaration2, (DiagnosticContext)context2, null, 16, null);
    }

    private final void reportOverridingFinalMember(DiagnosticReporter $this$reportOverridingFinalMember, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        block0: {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
            if (coneClassLikeLookupTag == null) break block0;
            ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default($this$reportOverridingFinalMember, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getOVERRIDING_FINAL_MEMBER(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context2, null, 32, null);
        }
    }

    private final void reportVarOverriddenByVal(DiagnosticReporter $this$reportVarOverriddenByVal, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportVarOverriddenByVal, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getVAR_OVERRIDDEN_BY_VAL(), overriding, overridden, (DiagnosticContext)context2, null, 32, null);
    }

    private final void reportCannotWeakenAccessPrivilege(DiagnosticReporter $this$reportCannotWeakenAccessPrivilege, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirCallableSymbol<?> $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportCannotWeakenAccessPrivilege, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getCANNOT_WEAKEN_ACCESS_PRIVILEGE(), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context2, null, 64, null);
    }

    private final void reportCannotChangeAccessPrivilege(DiagnosticReporter $this$reportCannotChangeAccessPrivilege, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirCallableSymbol<?> $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportCannotChangeAccessPrivilege, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getCANNOT_CHANGE_ACCESS_PRIVILEGE(), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context2, null, 64, null);
    }

    private final void reportReturnTypeMismatchOnFunction(DiagnosticReporter $this$reportReturnTypeMismatchOnFunction, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportReturnTypeMismatchOnFunction, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context2, null, 32, null);
    }

    private final void reportTypeMismatchOnProperty(DiagnosticReporter $this$reportTypeMismatchOnProperty, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportTypeMismatchOnProperty, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context2, null, 32, null);
    }

    private final void reportTypeMismatchOnVariable(DiagnosticReporter $this$reportTypeMismatchOnVariable, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportTypeMismatchOnVariable, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getVAR_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context2, null, 32, null);
    }
}

