/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirMissingDependencyClassProxy;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u00032\u00020\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMissingDependencyClassForParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirMissingDependencyClassForParameterChecker
extends FirDeclarationChecker<FirValueParameter>
implements FirMissingDependencyClassProxy {
    @NotNull
    public static final FirMissingDependencyClassForParameterChecker INSTANCE = new FirMissingDependencyClassForParameterChecker();

    private FirMissingDependencyClassForParameterChecker() {
    }

    @Override
    public void check(@NotNull FirValueParameter declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirFunctionSymbol<?> containingFunctionSymbol = declaration2.getContainingFunctionSymbol();
        if (!(containingFunctionSymbol instanceof FirAnonymousFunctionSymbol) || !((FirAnonymousFunctionSymbol)containingFunctionSymbol).isLambda()) {
            return;
        }
        Set missingTypes = new LinkedHashSet();
        this.considerType(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), missingTypes, context2);
        this.reportMissingTypes(declaration2.getSource(), missingTypes, context2, reporter, true);
    }
}

