/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirImportsChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirDeprecationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.declarations.ImplicitReceiverUtilsKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.ImportUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageResolutionResult;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\u0011\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002JA\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0018\b\u0004\u0010\u001d\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f\u0012\u0004\u0012\u00020 0\u001eH\u0082\bJ\u001c\u0010!\u001a\u00020\u0018*\u00020\"2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J0\u0010#\u001a\u00020 *\u00020\"2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020 0\u001eH\u0002J\u0018\u0010&\u001a\u00020 *\u0006\u0012\u0002\b\u00030'2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010(\u001a\u0004\u0018\u00010\"*\u00020)2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010*\u001a\u00020 *\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAllUnderFromEnumEntry", "import", "Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "checkAllUnderFromObject", "checkCanBeImported", "checkConflictingImports", "imports", "", "checkImportApiStatus", "checkOperatorRename", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "getImportStatus", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "scopes", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "name", "Lorg/jetbrains/kotlin/name/Name;", "isApplicable", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "", "getImportStatusOfCallableMembers", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "hasFunction", "predicate", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "isVisible", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "resolveToClass", "Lorg/jetbrains/kotlin/name/ClassId;", "resolvesToClass", "ImportStatus", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirImportsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirImportsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 6 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,329:1\n297#1,21:374\n297#1,19:395\n316#1,2:415\n1853#2,2:330\n1745#2,3:334\n817#2:346\n845#2,2:347\n1475#2:349\n1500#2,3:350\n1503#2,3:360\n764#2:363\n855#2,2:364\n1853#2:366\n1853#2,2:367\n1854#2:369\n1745#2,2:370\n1747#2:373\n75#3:332\n26#3:372\n24#3:414\n37#4:333\n46#4:337\n21#5:338\n45#6,7:339\n372#7,7:353\n1#8:417\n*S KotlinDebug\n*F\n+ 1 FirImportsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker\n*L\n273#1:374,21\n287#1:395,19\n287#1:415,2\n41#1:330,2\n65#1:334,3\n193#1:346\n193#1:347,2\n195#1:349\n195#1:350,3\n195#1:360,3\n197#1:363\n197#1:364,2\n198#1:366\n199#1:367,2\n198#1:369\n214#1:370,2\n214#1:373\n65#1:332\n215#1:372\n287#1:414\n65#1:333\n79#1:337\n169#1:338\n188#1:339,7\n195#1:353,7\n*E\n"})
public final class FirImportsChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirImportsChecker INSTANCE = new FirImportsChecker();

    private FirImportsChecker() {
    }

    @Override
    public void check(@NotNull FirFile declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Iterable $this$forEach$iv = declaration2.getImports();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirImport firImport = (FirImport)element$iv;
            boolean bl = false;
            Object object = firImport.getSource();
            if (object != null && (object = ((KtSourceElement)object).getKind()) != null ? ((KtSourceElementKind)object).getShouldSkipErrorTypeReporting() : false) continue;
            if (firImport.isAllUnder()) {
                if (firImport instanceof FirResolvedImport) {
                    INSTANCE.checkAllUnderFromObject(firImport, context2, reporter);
                } else {
                    INSTANCE.checkAllUnderFromEnumEntry(firImport, context2, reporter);
                }
            } else {
                INSTANCE.checkCanBeImported(firImport, context2, reporter);
                if (firImport instanceof FirResolvedImport) {
                    INSTANCE.checkOperatorRename((FirResolvedImport)firImport, context2, reporter);
                }
            }
            INSTANCE.checkImportApiStatus(firImport, context2, reporter);
        }
        this.checkConflictingImports(declaration2.getImports(), context2, reporter);
    }

    private final void checkAllUnderFromEnumEntry(FirImport firImport, CheckerContext context2, DiagnosticReporter reporter) {
        FqName fqName2 = firImport.getImportedFqName();
        if (fqName2 == null) {
            return;
        }
        FqName fqName3 = fqName2;
        if (fqName3.isRoot() || fqName3.parent().isRoot()) {
            return;
        }
        FqName fqName4 = fqName3.parent();
        Intrinsics.checkNotNullExpressionValue(fqName4, "parent(...)");
        ClassId classId = ClassId.Companion.topLevel(fqName4);
        FirRegularClassSymbol firRegularClassSymbol = this.resolveToClass(classId, context2);
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol classSymbol2 = firRegularClassSymbol;
        FirClassSymbol $this$isEnumClass$iv = classSymbol2;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        boolean bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
        if (bl) {
            boolean bl2;
            block8: {
                Iterable $this$any$iv = DeclarationUtilsKt.collectEnumEntries(classSymbol2);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirEnumEntrySymbol it = (FirEnumEntrySymbol)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it.getCallableId().getCallableName(), fqName3.shortName())) continue;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getCANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON(), (Object)classSymbol2.getClassId().getShortClassName(), (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    private final void checkAllUnderFromObject(FirImport firImport, CheckerContext context2, DiagnosticReporter reporter) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        FqName fqName2 = firImport.getImportedFqName();
        if (fqName2 == null) {
            return;
        }
        FqName fqName3 = fqName2;
        if (fqName3.isRoot()) {
            return;
        }
        PackageResolutionResult resolutionResult = ImportUtilsKt.resolveToPackageOrClass(FirSymbolProviderKt.getSymbolProvider(context2.getSession()), fqName3);
        if (resolutionResult instanceof PackageResolutionResult.PackageOrClass) {
            firClassLikeSymbol = ((PackageResolutionResult.PackageOrClass)resolutionResult).getClassSymbol();
            if (firClassLikeSymbol == null) {
                return;
            }
        } else {
            if (resolutionResult instanceof PackageResolutionResult.Error) {
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        FirClassLikeSymbol<?> classLike = firClassLikeSymbol;
        FirRegularClassSymbol classSymbol2 = DeclarationUtilsKt.fullyExpandedClass(classLike, context2.getSession());
        if (classSymbol2 != null) {
            ClassKind $this$isObject$iv = classSymbol2.getClassKind();
            boolean $i$f$isObject = false;
            if ($this$isObject$iv == ClassKind.OBJECT) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getCANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON(), (Object)classSymbol2.getClassId().getShortClassName(), (DiagnosticContext)context2, null, 16, null);
            }
        }
        if (!this.isVisible((FirBasedSymbol)classLike, context2)) {
            KtSourceElement ktSourceElement = FirSourceUtilsKt.getLastImportedFqNameSegmentSource(firImport);
            if (ktSourceElement == null) {
                throw new IllegalStateException(("" + '`' + firImport.getSource() + "` does not contain `" + fqName3 + '`').toString());
            }
            KtSourceElement source = ktSourceElement;
            reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic((FirBasedSymbol)classLike, source), context2);
        }
    }

    private final void checkCanBeImported(FirImport firImport, CheckerContext context2, DiagnosticReporter reporter) {
        ClassId parentClassId;
        Name importedName;
        FqName importedFqName;
        block21: {
            block20: {
                FqName fqName2 = firImport.getImportedFqName();
                if (fqName2 == null) {
                    return;
                }
                importedFqName = fqName2;
                Name name2 = importedFqName.shortName();
                Intrinsics.checkNotNullExpressionValue(name2, "shortName(...)");
                importedName = name2;
                if (importedName.isSpecial()) break block20;
                String string2 = importedName.getIdentifier();
                Intrinsics.checkNotNullExpressionValue(string2, "getIdentifier(...)");
                if (!(((CharSequence)string2).length() == 0)) break block21;
            }
            return;
        }
        FirSymbolProvider symbolProvider = FirSymbolProviderKt.getSymbolProvider(context2.getSession());
        FirResolvedImport firResolvedImport = firImport instanceof FirResolvedImport ? (FirResolvedImport)firImport : null;
        ClassId classId = parentClassId = firResolvedImport != null ? firResolvedImport.getResolvedParentClassId() : null;
        if (parentClassId != null) {
            FirRegularClassSymbol firRegularClassSymbol = this.resolveToClass(parentClassId, context2);
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol parentClassSymbol = firRegularClassSymbol;
            FirImportsChecker.checkCanBeImported$reportInvisibleParentClasses(context2, firImport, reporter, parentClassSymbol, 1);
            ImportStatus status2 = this.getImportStatusOfCallableMembers(parentClassSymbol, context2, importedName);
            if (Intrinsics.areEqual(status2, ImportStatus.OK.INSTANCE)) {
                return;
            }
            if (status2 instanceof ImportStatus.Invisible) {
                KtSourceElement source = FirSourceUtilsKt.getSourceForImportSegment(firImport, 0);
                reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic((FirBasedSymbol)((ImportStatus.Invisible)status2).getSymbol(), source), context2);
            } else {
                ClassId classId2 = parentClassSymbol.getClassId().createNestedClassId(importedName);
                if (symbolProvider.getClassLikeSymbolByClassId(classId2) != null) {
                    return;
                }
                if (Intrinsics.areEqual(status2, ImportStatus.Unresolved.INSTANCE)) {
                    AbstractKtSourceElement abstractKtSourceElement = firImport.getSource();
                    KtDiagnosticFactory1<String> ktDiagnosticFactory1 = FirErrors.INSTANCE.getUNRESOLVED_IMPORT();
                    String string3 = importedName.asString();
                    Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)string3, (DiagnosticContext)context2, null, 16, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getCANNOT_BE_IMPORTED(), (Object)importedName, (DiagnosticContext)context2, null, 16, null);
                }
            }
            return;
        }
        FirBasedSymbol resolvedDeclaration = null;
        FirRegularClassSymbol firRegularClassSymbol = this.resolveToClass(ClassId.Companion.topLevel(importedFqName), context2);
        if (firRegularClassSymbol != null) {
            FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol;
            boolean bl = false;
            resolvedDeclaration = firRegularClassSymbol2;
            if (INSTANCE.isVisible(firRegularClassSymbol2, context2)) {
                return;
            }
        }
        FqName fqName3 = importedFqName.parent();
        Intrinsics.checkNotNullExpressionValue(fqName3, "parent(...)");
        List<FirCallableSymbol<?>> topLevelCallableSymbol = symbolProvider.getTopLevelCallableSymbols(fqName3, importedName);
        for (FirCallableSymbol<?> firCallableSymbol : topLevelCallableSymbol) {
            if (this.isVisible((FirBasedSymbol)firCallableSymbol, context2)) {
                return;
            }
            if (resolvedDeclaration != null) continue;
            resolvedDeclaration = firCallableSymbol;
        }
        FirBasedSymbol firBasedSymbol = resolvedDeclaration;
        if (firBasedSymbol != null) {
            FirBasedSymbol it = firBasedSymbol;
            boolean bl = false;
            KtSourceElement ktSourceElement = FirSourceUtilsKt.getSourceForImportSegment(firImport, 0);
            if (ktSourceElement == null) {
                ktSourceElement = firImport.getSource();
            }
            KtSourceElement source = ktSourceElement;
            reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic(it, source), context2);
            return;
        }
        if (symbolProvider.getPackage(importedFqName) != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getPACKAGE_CANNOT_BE_IMPORTED(), (DiagnosticContext)context2, null, 8, null);
        } else {
            AbstractKtSourceElement abstractKtSourceElement = firImport.getSource();
            KtDiagnosticFactory1<String> ktDiagnosticFactory1 = FirErrors.INSTANCE.getUNRESOLVED_IMPORT();
            String string4 = importedName.asString();
            Intrinsics.checkNotNullExpressionValue(string4, "asString(...)");
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)string4, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final boolean isVisible(FirBasedSymbol<?> $this$isVisible, CheckerContext context2) {
        FirMemberDeclaration fir;
        FirFile firFile = context2.getContainingFile();
        if (firFile == null) {
            return false;
        }
        FirFile useSiteFile = firFile;
        FirMemberDeclaration firMemberDeclaration = FirDeclarationUtilKt.asMemberDeclarationResolvedTo($this$isVisible, FirResolvePhase.STATUS);
        if (firMemberDeclaration == null) {
            return false;
        }
        FirMemberDeclaration $this$visibility$iv = fir = firMemberDeclaration;
        boolean $i$f$getVisibility = false;
        Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
        if (!Intrinsics.areEqual(visibility2, Visibilities.Unknown.INSTANCE) && !visibility2.mustCheckInImports()) {
            return true;
        }
        if (Intrinsics.areEqual(visibility2, Visibilities.Private.INSTANCE) || Intrinsics.areEqual(visibility2, Visibilities.PrivateToThis.INSTANCE)) {
            return Intrinsics.areEqual(useSiteFile, FirProviderUtilsKt.getContainingFile(FirProviderKt.getFirProvider(context2.getSession()), $this$isVisible));
        }
        return FirVisibilityChecker.isVisible$default(FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession()), fir, context2.getSession(), useSiteFile, CollectionsKt.emptyList(), null, false, null, true, null, 352, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkConflictingImports(List<? extends FirImport> imports, CheckerContext context, DiagnosticReporter reporter) {
        var5_4 = imports;
        $i$f$filterIsInstanceWithChecker = false;
        result$iv = new ArrayList<E>();
        for (T element$iv : $this$filterIsInstanceWithChecker$iv) {
            if (!(element$iv instanceof FirResolvedImport)) continue;
            import = (FirResolvedImport)element$iv;
            $i$a$-filterIsInstanceWithChecker-FirImportsChecker$checkConflictingImports$interestingImports$1 = false;
            if (import.isAllUnder()) ** GOTO lbl-1000
            v0 = import.getSource();
            if (v0 != null && (v0 = v0.getKind()) != null ? v0.getShouldSkipErrorTypeReporting() : false) ** GOTO lbl-1000
            v1 = import.getImportedName();
            if (v1 != null && (v1 = (var12_18 = v1.getIdentifierOrNullIfSpecial())) != null) {
                Intrinsics.checkNotNull(v1);
                v2 = ((CharSequence)var12_18).length() > 0;
            } else {
                v2 = false;
            }
            if (v2 && FirImportsChecker.INSTANCE.resolvesToClass((FirResolvedImport)import, context)) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            ((Collection)result$iv).add(element$iv);
        }
        $this$filterIsInstanceWithChecker$iv = result$iv;
        $i$f$filterNot = false;
        result$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (E element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (FirResolvedImport)element$iv$iv;
            $i$a$-filterNot-FirImportsChecker$checkConflictingImports$interestingImports$2 = false;
            var14_22 = it.getSource();
            v4 = var14_22 instanceof KtFakeSourceElement != false ? (KtFakeSourceElement)var14_22 : null;
            if (Intrinsics.areEqual(v4 != null ? v4.getKind() : null, KtFakeSourceElementKind.ImplicitImport.INSTANCE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        interestingImports = (List)destination$iv$iv;
        $this$filterNot$iv = interestingImports;
        $i$f$groupBy = false;
        $this$filterNotTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$groupByTo = false;
        for (T element$iv$iv : $this$groupByTo$iv$iv) {
            it = (FirResolvedImport)element$iv$iv;
            $i$a$-groupBy-FirImportsChecker$checkConflictingImports$1 = false;
            v5 = it.getAliasName();
            if (v5 == null) {
                v6 = it.getImportedName();
                v5 = v6;
                Intrinsics.checkNotNull(v6);
            }
            key$iv$iv = v5;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                answer$iv$iv$iv = new ArrayList<E>();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                v7 /* !! */  = answer$iv$iv$iv;
            } else {
                v7 /* !! */  = value$iv$iv$iv;
            }
            list$iv$iv = (List)v7 /* !! */ ;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv.values();
        $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            $i$a$-filter-FirImportsChecker$checkConflictingImports$2 = false;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            conflicts = (List)element$iv;
            $i$a$-forEach-FirImportsChecker$checkConflictingImports$3 = false;
            $this$forEach$iv = conflicts;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (FirResolvedImport)element$iv;
                $i$a$-forEach-FirImportsChecker$checkConflictingImports$3$1 = false;
                v8 = it.getSource();
                v9 = FirErrors.INSTANCE.getCONFLICTING_IMPORT();
                v10 = it.getImportedName();
                Intrinsics.checkNotNull(v10);
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, v8, v9, (Object)v10, (DiagnosticContext)context, null, 16, null);
            }
        }
    }

    private final void checkOperatorRename(FirResolvedImport firResolvedImport, CheckerContext context2, DiagnosticReporter reporter) {
        boolean illegalRename2;
        block10: {
            boolean bl;
            Name name2 = firResolvedImport.getAliasName();
            if (name2 == null) {
                return;
            }
            Name alias = name2;
            Name name3 = firResolvedImport.getImportedName();
            if (name3 == null) {
                return;
            }
            Name importedName = name3;
            if (!OperatorConventions.isConventionName(alias)) {
                return;
            }
            ClassId classId = firResolvedImport.getResolvedParentClassId();
            if (classId != null) {
                FirRegularClassSymbol firRegularClassSymbol = this.resolveToClass(classId, context2);
                if (firRegularClassSymbol == null) {
                    return;
                }
                FirRegularClassSymbol classFir = firRegularClassSymbol;
                bl = classFir.getClassKind().isSingleton() && this.hasFunction(classFir, context2, importedName, checkOperatorRename.illegalRename.1.INSTANCE);
            } else {
                Iterable $this$any$iv = FirSymbolProviderKt.getSymbolProvider(context2.getSession()).getTopLevelFunctionSymbols(firResolvedImport.getPackageFqName(), importedName);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirNamedFunctionSymbol it = (FirNamedFunctionSymbol)element$iv;
                        boolean bl2 = false;
                        FirCallableSymbol $this$isOperator$iv = it;
                        boolean $i$f$isOperator = false;
                        if (!$this$isOperator$iv.getResolvedStatus().isOperator()) continue;
                        bl = true;
                        break block10;
                    }
                    bl = illegalRename2 = false;
                }
            }
        }
        if (illegalRename2) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firResolvedImport.getSource(), FirErrors.INSTANCE.getOPERATOR_RENAMED_ON_IMPORT(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean resolvesToClass(FirResolvedImport $this$resolvesToClass, CheckerContext context2) {
        if ($this$resolvesToClass.getResolvedParentClassId() != null) {
            if ($this$resolvesToClass.isAllUnder()) {
                return true;
            }
            ClassId classId = $this$resolvesToClass.getResolvedParentClassId();
            Intrinsics.checkNotNull(classId);
            ClassId parentClass = classId;
            FqName fqName2 = $this$resolvesToClass.getRelativeParentClassName();
            if (fqName2 == null) {
                return false;
            }
            FqName relativeClassName = fqName2;
            Name name2 = $this$resolvesToClass.getImportedName();
            if (name2 == null) {
                return false;
            }
            Name importedName = name2;
            FqName fqName3 = parentClass.getPackageFqName();
            FqName fqName4 = relativeClassName.child(importedName);
            Intrinsics.checkNotNullExpressionValue(fqName4, "child(...)");
            ClassId innerClassId = new ClassId(fqName3, fqName4, false);
            return this.resolveToClass(innerClassId, context2) != null;
        }
        FqName fqName5 = $this$resolvesToClass.getImportedFqName();
        if (fqName5 == null) {
            return false;
        }
        FqName importedFqName = fqName5;
        if (importedFqName.isRoot()) {
            return false;
        }
        ClassId importedClassId = ClassId.Companion.topLevel(importedFqName);
        return this.resolveToClass(importedClassId, context2) != null;
    }

    private final FirRegularClassSymbol resolveToClass(ClassId $this$resolveToClass, CheckerContext context2) {
        FirRegularClassSymbol firRegularClassSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByClassId($this$resolveToClass);
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> classSymbol2 = firClassLikeSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol2 = classSymbol2;
        if (firClassLikeSymbol2 instanceof FirRegularClassSymbol) {
            firRegularClassSymbol = (FirRegularClassSymbol)classSymbol2;
        } else if (firClassLikeSymbol2 instanceof FirTypeAliasSymbol) {
            firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass(classSymbol2, context2.getSession());
        } else if (firClassLikeSymbol2 instanceof FirAnonymousObjectSymbol) {
            firRegularClassSymbol = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return firRegularClassSymbol;
    }

    private final boolean hasFunction(FirRegularClassSymbol $this$hasFunction, CheckerContext context2, Name name2, Function1<? super FirNamedFunctionSymbol, Boolean> predicate) {
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirDeclaredMemberScopeProviderKt.declaredMemberScope(context2.getSession(), $this$hasFunction, null).processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)new Function1<FirNamedFunctionSymbol, Unit>(result2, predicate){
            final /* synthetic */ Ref.BooleanRef $result;
            final /* synthetic */ Function1<FirNamedFunctionSymbol, Boolean> $predicate;
            {
                this.$result = $result;
                this.$predicate = $predicate;
                super(1);
            }

            public final void invoke(FirNamedFunctionSymbol sym) {
                Intrinsics.checkNotNullParameter(sym, "sym");
                if (!this.$result.element) {
                    this.$result.element = this.$predicate.invoke(sym);
                }
            }
        });
        return result2.element;
    }

    private final ImportStatus getImportStatusOfCallableMembers(FirRegularClassSymbol $this$getImportStatusOfCallableMembers, CheckerContext context2, Name name2) {
        ImportStatus importStatus;
        block16: {
            if ($this$getImportStatusOfCallableMembers.getClassKind().isSingleton()) {
                boolean bl;
                FirContainingNamesAwareScope[] firContainingNamesAwareScopeArray = new FirContainingNamesAwareScope[]{FirDeclaredMemberScopeProviderKt.declaredMemberScope(context2.getSession(), $this$getImportStatusOfCallableMembers, null), FirHelpersKt.unsubstitutedScope($this$getImportStatusOfCallableMembers, context2)};
                List<FirContainingNamesAwareScope> scopes = CollectionsKt.listOf(firContainingNamesAwareScopeArray);
                FirImportsChecker this_$iv = this;
                boolean $i$f$getImportStatus = false;
                Ref.BooleanRef found$iv = new Ref.BooleanRef();
                Ref.ObjectRef symbol$iv = new Ref.ObjectRef();
                for (FirContainingNamesAwareScope scope$iv : scopes) {
                    scope$iv.processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)new Function1<FirNamedFunctionSymbol, Unit>(context2, found$iv, symbol$iv){
                        final /* synthetic */ CheckerContext $context;
                        final /* synthetic */ Ref.BooleanRef $found;
                        final /* synthetic */ Ref.ObjectRef $symbol;
                        {
                            this.$context = $context;
                            this.$found = $found;
                            this.$symbol = $symbol;
                            super(1);
                        }

                        public final void invoke(FirNamedFunctionSymbol sym) {
                            Intrinsics.checkNotNullParameter(sym, "sym");
                            if (FirImportsChecker.access$isVisible(FirImportsChecker.INSTANCE, sym, this.$context)) {
                                FirCallableSymbol it = sym;
                                boolean bl = false;
                                if (true) {
                                    this.$found.element = true;
                                }
                            }
                            this.$symbol.element = sym;
                        }
                    });
                    if (found$iv.element) {
                        importStatus = ImportStatus.OK.INSTANCE;
                    } else {
                        scope$iv.processPropertiesByName(name2, new Function1<FirVariableSymbol<?>, Unit>(context2, found$iv, symbol$iv){
                            final /* synthetic */ CheckerContext $context;
                            final /* synthetic */ Ref.BooleanRef $found;
                            final /* synthetic */ Ref.ObjectRef $symbol;
                            {
                                this.$context = $context;
                                this.$found = $found;
                                this.$symbol = $symbol;
                                super(1);
                            }

                            public final void invoke(FirVariableSymbol<?> sym) {
                                Intrinsics.checkNotNullParameter(sym, "sym");
                                if (FirImportsChecker.access$isVisible(FirImportsChecker.INSTANCE, sym, this.$context)) {
                                    FirCallableSymbol it = sym;
                                    boolean bl = false;
                                    if (true) {
                                        this.$found.element = true;
                                    }
                                }
                                this.$symbol.element = sym;
                            }
                        });
                        if (!found$iv.element) continue;
                        importStatus = ImportStatus.OK.INSTANCE;
                    }
                    break block16;
                }
                FirCallableSymbol firCallableSymbol = (FirCallableSymbol)symbol$iv.element;
                if (firCallableSymbol != null) {
                    FirCallableSymbol it = firCallableSymbol;
                    boolean bl2 = false;
                    bl = true;
                } else {
                    bl = false;
                }
                if (bl) {
                    Object t = symbol$iv.element;
                    Intrinsics.checkNotNull(t);
                    importStatus = new ImportStatus.Invisible((FirCallableSymbol)t);
                } else {
                    importStatus = symbol$iv.element != null ? (ImportStatus)ImportStatus.CannotBeImported.INSTANCE : (ImportStatus)ImportStatus.Unresolved.INSTANCE;
                }
            } else {
                boolean bl;
                Object this_$iv = new FirContainingNamesAwareScope[]{FirDeclaredMemberScopeProviderKt.declaredMemberScope(context2.getSession(), $this$getImportStatusOfCallableMembers, null), ImplicitReceiverUtilsKt.staticScope($this$getImportStatusOfCallableMembers, context2.getSessionHolder()), FirHelpersKt.unsubstitutedScope($this$getImportStatusOfCallableMembers, context2)};
                List<FirContainingNamesAwareScope> scopes = CollectionsKt.listOfNotNull(this_$iv);
                this_$iv = this;
                boolean $i$f$getImportStatus = false;
                Ref.BooleanRef found$iv = new Ref.BooleanRef();
                Ref.ObjectRef symbol$iv = new Ref.ObjectRef();
                for (FirContainingNamesAwareScope scope$iv : scopes) {
                    scope$iv.processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)new Function1<FirNamedFunctionSymbol, Unit>(context2, found$iv, symbol$iv){
                        final /* synthetic */ CheckerContext $context;
                        final /* synthetic */ Ref.BooleanRef $found;
                        final /* synthetic */ Ref.ObjectRef $symbol;
                        {
                            this.$context = $context;
                            this.$found = $found;
                            this.$symbol = $symbol;
                            super(1);
                        }

                        public final void invoke(FirNamedFunctionSymbol sym) {
                            Intrinsics.checkNotNullParameter(sym, "sym");
                            if (FirImportsChecker.access$isVisible(FirImportsChecker.INSTANCE, sym, this.$context)) {
                                FirCallableSymbol it = sym;
                                boolean bl = false;
                                FirCallableSymbol $this$isStatic$iv = it;
                                boolean $i$f$isStatic = false;
                                if ($this$isStatic$iv.getRawStatus().isStatic()) {
                                    this.$found.element = true;
                                }
                            }
                            this.$symbol.element = sym;
                        }
                    });
                    if (found$iv.element) {
                        importStatus = ImportStatus.OK.INSTANCE;
                    } else {
                        scope$iv.processPropertiesByName(name2, new Function1<FirVariableSymbol<?>, Unit>(context2, found$iv, symbol$iv){
                            final /* synthetic */ CheckerContext $context;
                            final /* synthetic */ Ref.BooleanRef $found;
                            final /* synthetic */ Ref.ObjectRef $symbol;
                            {
                                this.$context = $context;
                                this.$found = $found;
                                this.$symbol = $symbol;
                                super(1);
                            }

                            public final void invoke(FirVariableSymbol<?> sym) {
                                Intrinsics.checkNotNullParameter(sym, "sym");
                                if (FirImportsChecker.access$isVisible(FirImportsChecker.INSTANCE, sym, this.$context)) {
                                    FirCallableSymbol it = sym;
                                    boolean bl = false;
                                    FirCallableSymbol $this$isStatic$iv = it;
                                    boolean $i$f$isStatic = false;
                                    if ($this$isStatic$iv.getRawStatus().isStatic()) {
                                        this.$found.element = true;
                                    }
                                }
                                this.$symbol.element = sym;
                            }
                        });
                        if (!found$iv.element) continue;
                        importStatus = ImportStatus.OK.INSTANCE;
                    }
                    break block16;
                }
                FirCallableSymbol firCallableSymbol = (FirCallableSymbol)symbol$iv.element;
                if (firCallableSymbol != null) {
                    FirCallableSymbol it = firCallableSymbol;
                    boolean bl3 = false;
                    FirCallableSymbol $this$isStatic$iv = it;
                    boolean $i$f$isStatic = false;
                    bl = $this$isStatic$iv.getRawStatus().isStatic();
                } else {
                    bl = false;
                }
                if (bl) {
                    Object t = symbol$iv.element;
                    Intrinsics.checkNotNull(t);
                    importStatus = new ImportStatus.Invisible((FirCallableSymbol)t);
                } else {
                    importStatus = symbol$iv.element != null ? (ImportStatus)ImportStatus.CannotBeImported.INSTANCE : (ImportStatus)ImportStatus.Unresolved.INSTANCE;
                }
            }
        }
        return importStatus;
    }

    private final ImportStatus getImportStatus(List<? extends FirContainingNamesAwareScope> scopes, CheckerContext context2, Name name2, Function1<? super FirCallableSymbol<?>, Boolean> isApplicable) {
        ImportStatus importStatus;
        boolean $i$f$getImportStatus = false;
        Ref.BooleanRef found = new Ref.BooleanRef();
        Ref.ObjectRef symbol2 = new Ref.ObjectRef();
        for (FirContainingNamesAwareScope firContainingNamesAwareScope : scopes) {
            firContainingNamesAwareScope.processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)new Function1<FirNamedFunctionSymbol, Unit>(context2, isApplicable, found, symbol2){
                final /* synthetic */ CheckerContext $context;
                final /* synthetic */ Function1<FirCallableSymbol<?>, Boolean> $isApplicable;
                final /* synthetic */ Ref.BooleanRef $found;
                final /* synthetic */ Ref.ObjectRef<FirCallableSymbol<?>> $symbol;
                {
                    this.$context = $context;
                    this.$isApplicable = $isApplicable;
                    this.$found = $found;
                    this.$symbol = $symbol;
                    super(1);
                }

                public final void invoke(FirNamedFunctionSymbol sym) {
                    Intrinsics.checkNotNullParameter(sym, "sym");
                    if (FirImportsChecker.access$isVisible(FirImportsChecker.INSTANCE, sym, this.$context) && this.$isApplicable.invoke(sym).booleanValue()) {
                        this.$found.element = true;
                    }
                    this.$symbol.element = sym;
                }
            });
            if (found.element) {
                return ImportStatus.OK.INSTANCE;
            }
            firContainingNamesAwareScope.processPropertiesByName(name2, new Function1<FirVariableSymbol<?>, Unit>(context2, isApplicable, found, symbol2){
                final /* synthetic */ CheckerContext $context;
                final /* synthetic */ Function1<FirCallableSymbol<?>, Boolean> $isApplicable;
                final /* synthetic */ Ref.BooleanRef $found;
                final /* synthetic */ Ref.ObjectRef<FirCallableSymbol<?>> $symbol;
                {
                    this.$context = $context;
                    this.$isApplicable = $isApplicable;
                    this.$found = $found;
                    this.$symbol = $symbol;
                    super(1);
                }

                public final void invoke(FirVariableSymbol<?> sym) {
                    Intrinsics.checkNotNullParameter(sym, "sym");
                    if (FirImportsChecker.access$isVisible(FirImportsChecker.INSTANCE, sym, this.$context) && this.$isApplicable.invoke(sym).booleanValue()) {
                        this.$found.element = true;
                    }
                    this.$symbol.element = sym;
                }
            });
            if (!found.element) continue;
            return ImportStatus.OK.INSTANCE;
        }
        FirCallableSymbol firCallableSymbol = (FirCallableSymbol)symbol2.element;
        boolean bl = firCallableSymbol != null ? isApplicable.invoke(firCallableSymbol).booleanValue() : false;
        if (bl) {
            Object t = symbol2.element;
            Intrinsics.checkNotNull(t);
            importStatus = new ImportStatus.Invisible((FirCallableSymbol)t);
        } else {
            importStatus = symbol2.element != null ? (ImportStatus)ImportStatus.CannotBeImported.INSTANCE : (ImportStatus)ImportStatus.Unresolved.INSTANCE;
        }
        return importStatus;
    }

    private final void checkImportApiStatus(FirImport firImport, CheckerContext context2, DiagnosticReporter reporter) {
        FqName importedFqName;
        block7: {
            block6: {
                FqName fqName2 = firImport.getImportedFqName();
                if (fqName2 == null) {
                    return;
                }
                importedFqName = fqName2;
                if (importedFqName.isRoot()) break block6;
                String string2 = importedFqName.shortName().asString();
                Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
                if (!(((CharSequence)string2).length() == 0)) break block7;
            }
            return;
        }
        Object object = firImport instanceof FirResolvedImport ? (FirResolvedImport)firImport : null;
        if (object == null || (object = ((FirResolvedImport)object).getResolvedParentClassId()) == null) {
            object = ClassId.Companion.topLevel(importedFqName);
        }
        Object classId = object;
        FirClassifierSymbol<?> firClassifierSymbol = FirSymbolProviderKt.toSymbol((ClassId)classId, context2.getSession());
        if (firClassifierSymbol == null) {
            return;
        }
        FirClassifierSymbol<?> symbol2 = firClassifierSymbol;
        FirDeprecationChecker.reportApiStatusIfNeeded$checkers$default(FirDeprecationChecker.INSTANCE, firImport.getSource(), symbol2, context2, reporter, null, 16, null);
    }

    private static final void checkCanBeImported$reportInvisibleParentClasses(CheckerContext $context, FirImport $import, DiagnosticReporter $reporter, FirRegularClassSymbol classSymbol2, int depth) {
        block1: {
            Object object;
            if (!INSTANCE.isVisible(classSymbol2, $context)) {
                KtSourceElement source = FirSourceUtilsKt.getSourceForImportSegment($import, depth);
                $reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic(classSymbol2, source), $context);
            }
            if ((object = classSymbol2.getClassId().getOuterClassId()) == null || (object = INSTANCE.resolveToClass((ClassId)object, $context)) == null) break block1;
            Object it = object;
            boolean bl = false;
            FirImportsChecker.checkCanBeImported$reportInvisibleParentClasses($context, $import, $reporter, (FirRegularClassSymbol)it, depth + 1);
        }
    }

    public static final /* synthetic */ boolean access$isVisible(FirImportsChecker $this, FirBasedSymbol $receiver, CheckerContext context2) {
        return $this.isVisible($receiver, context2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "", "()V", "CannotBeImported", "Invisible", "OK", "Unresolved", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$CannotBeImported;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$Invisible;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$OK;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$Unresolved;", "checkers"})
    private static abstract class ImportStatus {
        private ImportStatus() {
        }

        public /* synthetic */ ImportStatus(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$CannotBeImported;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "checkers"})
        public static final class CannotBeImported
        extends ImportStatus {
            @NotNull
            public static final CannotBeImported INSTANCE = new CannotBeImported();

            private CannotBeImported() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "CannotBeImported";
            }

            public int hashCode() {
                return 1558473421;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CannotBeImported)) {
                    return false;
                }
                CannotBeImported cfr_ignored_0 = (CannotBeImported)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u0017\u0010\b\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$Invisible;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V", "getSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "checkers"})
        public static final class Invisible
        extends ImportStatus {
            @NotNull
            private final FirCallableSymbol<?> symbol;

            public Invisible(@NotNull FirCallableSymbol<?> symbol2) {
                Intrinsics.checkNotNullParameter(symbol2, "symbol");
                super(null);
                this.symbol = symbol2;
            }

            @NotNull
            public final FirCallableSymbol<?> getSymbol() {
                return this.symbol;
            }

            @NotNull
            public final FirCallableSymbol<?> component1() {
                return this.symbol;
            }

            @NotNull
            public final Invisible copy(@NotNull FirCallableSymbol<?> symbol2) {
                Intrinsics.checkNotNullParameter(symbol2, "symbol");
                return new Invisible(symbol2);
            }

            public static /* synthetic */ Invisible copy$default(Invisible invisible, FirCallableSymbol firCallableSymbol, int n, Object object) {
                if ((n & 1) != 0) {
                    firCallableSymbol = invisible.symbol;
                }
                return invisible.copy(firCallableSymbol);
            }

            @NotNull
            public String toString() {
                return "Invisible(symbol=" + this.symbol + ')';
            }

            public int hashCode() {
                return this.symbol.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Invisible)) {
                    return false;
                }
                Invisible invisible = (Invisible)other;
                return Intrinsics.areEqual(this.symbol, invisible.symbol);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$OK;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "checkers"})
        public static final class OK
        extends ImportStatus {
            @NotNull
            public static final OK INSTANCE = new OK();

            private OK() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "OK";
            }

            public int hashCode() {
                return -1967623169;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof OK)) {
                    return false;
                }
                OK cfr_ignored_0 = (OK)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$Unresolved;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "checkers"})
        public static final class Unresolved
        extends ImportStatus {
            @NotNull
            public static final Unresolved INSTANCE = new Unresolved();

            private Unresolved() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Unresolved";
            }

            public int hashCode() {
                return -1417964332;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unresolved)) {
                    return false;
                }
                Unresolved cfr_ignored_0 = (Unresolved)other;
                return true;
            }
        }
    }
}

